/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.disy.commons.core.asynchronous.AsynchronousDroppingJobProcessor;
import net.disy.commons.core.asynchronous.IJobProcessor;
import net.disy.commons.core.exception.IExceptionHandler;
import net.disy.commons.core.list.IListModel;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.predicate.AcceptAllPredicate;
import net.disy.commons.core.predicate.IPredicate;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.core.util.ArrayUtilities;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.ObjectUtilities;

public class AsynchronousFilteredListModel<T>
extends AbstractChangeableModel
implements IListModel<T> {
    private final IListModel<T> listModel;
    private IPredicate<T> filter = new AcceptAllPredicate();
    private Object[] filteredObjects = new Object[0];
    private boolean filteringFinished = false;
    private final AsynchronousDroppingJobProcessor<IPredicate<T>> jobProcessor = new AsynchronousDroppingJobProcessor(new IJobProcessor<IPredicate<T>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(ICancelable cancelable, IPredicate<T> processingFilter) throws InterruptedException {
            ArrayList filteredValues = new ArrayList();
            for (int i = 0; i < AsynchronousFilteredListModel.this.listModel.getItemCount(); ++i) {
                ProgressUtilities.checkInterrupted(cancelable);
                Object value = AsynchronousFilteredListModel.this.listModel.getItem(i);
                if (!processingFilter.evaluate(value)) continue;
                filteredValues.add(value);
            }
            Object object = AsynchronousFilteredListModel.this.getMutex();
            synchronized (object) {
                AsynchronousFilteredListModel.this.filter = processingFilter;
                AsynchronousFilteredListModel.access$302(AsynchronousFilteredListModel.this, filteredValues.toArray());
                AsynchronousFilteredListModel.this.fireChangeEvent();
                AsynchronousFilteredListModel.this.filteringFinished = true;
                AsynchronousFilteredListModel.this.getMutex().notifyAll();
            }
        }
    }, new IExceptionHandler(){

        @Override
        public void handle(Throwable exception) {
            throw new RuntimeException(exception);
        }
    });

    public AsynchronousFilteredListModel(IListModel<T> listModel) {
        Ensure.ensureArgumentNotNull(listModel);
        this.listModel = listModel;
        IChangeListener changeListener = new IChangeListener(){

            @Override
            public void stateChanged() {
                AsynchronousFilteredListModel.this.startFiltering(AsynchronousFilteredListModel.this.filter);
            }
        };
        listModel.addChangeListener(changeListener);
        this.startFiltering(this.filter);
        this.waitForFilteringFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFilteringFinished() {
        Object object = this.getMutex();
        synchronized (object) {
            while (!this.hasFinishedFiltering()) {
                try {
                    this.getMutex().wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemCount() {
        Object object = this.getMutex();
        synchronized (object) {
            return this.filteredObjects.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getItem(int index) {
        Object object = this.getMutex();
        synchronized (object) {
            return (T)this.filteredObjects[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getItemList() {
        Object object = this.getMutex();
        synchronized (object) {
            return Arrays.asList(this.filteredObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(IPredicate<T> filter) {
        Object object = this.getMutex();
        synchronized (object) {
            this.startFiltering(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFiltering(IPredicate<T> withFilter) {
        Object object = this.getMutex();
        synchronized (object) {
            this.filteringFinished = false;
            this.jobProcessor.startJob(withFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFinishedFiltering() {
        Object object = this.getMutex();
        synchronized (object) {
            return this.filteringFinished;
        }
    }

    public BooleanModel getBusyModel() {
        return this.jobProcessor.getBusyModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(final Object value) {
        Object object = this.getMutex();
        synchronized (object) {
            return ArrayUtilities.indexOf(this.filteredObjects, new IPredicate<Object>(){

                @Override
                public boolean evaluate(Object object) {
                    return ObjectUtilities.equals(object, value);
                }
            });
        }
    }

    static /* synthetic */ Object[] access$302(AsynchronousFilteredListModel x0, Object[] x1) {
        x0.filteredObjects = x1;
        return x1;
    }
}

