/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine;

import de.jave.figlet.engine.IFigDriver;
import de.jave.figlet.engine.processing.IFigletJob;
import de.jave.lib.job.IResultConsumer;
import de.jave.lib.job.IWarningCollector;
import net.disy.commons.core.asynchronous.IJobProcessor;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.core.util.Ensure;

public class FigConversionJobProcessor
implements IJobProcessor<IFigletJob> {
    private final IWarningCollector warner;
    private final IFigDriver figDriver;
    private final IResultConsumer resultConsumer;

    public FigConversionJobProcessor(IFigDriver figDriver, IResultConsumer resultConsumer, IWarningCollector warner) {
        Ensure.ensureArgumentNotNull(warner);
        Ensure.ensureArgumentNotNull(figDriver);
        this.warner = warner;
        this.resultConsumer = resultConsumer;
        this.figDriver = figDriver;
    }

    @Override
    public void process(ICancelable cancelable, IFigletJob job) throws InterruptedException {
        String t;
        try {
            this.warner.clear();
            t = this.figDriver.figletize(job);
        }
        catch (Exception e) {
            ProgressUtilities.checkInterrupted(cancelable);
            if (this.warner != null) {
                this.warner.addWarning("Error with FIGML! " + e.toString());
            }
            e.printStackTrace();
            t = e.toString();
        }
        this.resultConsumer.putResult(t);
    }
}

