/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmPixelPlateOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmPixelPlateOptionsPanel;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public class Image2AsciiAlgorithmPixelPlate
extends Image2AsciiAlgorithm {
    private final AlgorithmPixelPlateOptionsModel optionsModel = new AlgorithmPixelPlateOptionsModel();

    @Override
    public IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getName() {
        return "B/W";
    }

    @Override
    public void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    @Override
    public void setSpecialChars(String specialCharacters) {
    }

    @Override
    public IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmPixelPlateOptionsPanel(this.optionsModel);
    }

    @Override
    public int getVerticalPixelsPerChar() {
        return this.optionsModel.getPixelPlateMode().getRasterY();
    }

    @Override
    public int getHorizontalPixelsPerChar() {
        return this.optionsModel.getPixelPlateMode().getRasterX();
    }

    @Override
    public boolean isMonochromeImageRequired() {
        return true;
    }

    @Override
    public CharacterPlate convert(IValueRaster raster, IProgressMonitor progressMonitor, ICancelable cancelable) throws InterruptedException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        progressMonitor.beginTask("Converting...", height);
        PixelPlate plate = new PixelPlate(0, 0, width / this.getHorizontalPixelsPerChar(), height / this.getVerticalPixelsPerChar());
        plate.setMode(this.optionsModel.getPixelPlateMode());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (raster.getValueAt(x, y) != 0) continue;
                plate.set(x, y);
            }
            progressMonitor.worked(1);
        }
        CharacterPlate result = plate.getResult();
        result.replace('\u0000', ' ');
        return result;
    }
}

