/*
 * Decompiled with CFR 0.152.
 */
package cib.cad;

import cib.cad.Instance;
import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

public class MacOsInstance
extends CmdAdapter {
    private static final String START_CMD_NAME = "$MacOsInstanceStartCmd";
    private static String s_handleOpenFile = null;
    private static InputDeviceAdapter s_inputDevice = null;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        MacOsInstance startCmd = new MacOsInstance();
        String[] extArgs = new String[args.length + 2];
        int i = 0;
        while (i < args.length) {
            extArgs[i] = args[i];
            ++i;
        }
        extArgs[extArgs.length - 2] = "-C";
        extArgs[extArgs.length - 1] = "$MacOsInstanceStartCmd;";
        final Kernel krnl = Instance.createKernel(extArgs);
        krnl.addCmd(START_CMD_NAME, startCmd.getClass());
        Application app = Application.getApplication();
        app.setAboutHandler(new AboutHandler(){

            public void handleAbout(AppEvent.AboutEvent e) {
                if (s_inputDevice.isEnabled()) {
                    s_inputDevice.fireInput("info;");
                }
            }
        });
        app.setOpenFileHandler(new OpenFilesHandler(){

            public void openFiles(AppEvent.OpenFilesEvent e) {
                List fileList = e.getFiles();
                if (fileList.isEmpty()) {
                    return;
                }
                if (fileList.size() != 1) {
                    System.err.println("Cannot open more than one file simultanously. Opening the first file instead.");
                }
                File file = (File)fileList.get(0);
                System.out.println("Open file " + file.getPath());
                if (s_inputDevice == null) {
                    s_handleOpenFile = file.getPath();
                } else if (s_inputDevice.isEnabled()) {
                    s_inputDevice.fireInput("macroload " + file.getPath() + ";");
                } else {
                    System.err.println("Cannot load while command is running");
                }
            }
        });
        app.setPreferencesHandler(new PreferencesHandler(){

            public void handlePreferences(AppEvent.PreferencesEvent e) {
                if (s_inputDevice.isEnabled()) {
                    s_inputDevice.fireInput("prefs;");
                }
            }
        });
        app.setPrintFileHandler(new PrintFilesHandler(){

            public void printFiles(AppEvent.PrintFilesEvent e) {
                if (s_inputDevice.isEnabled()) {
                    s_inputDevice.fireInput("print;");
                }
            }
        });
        app.setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse r) {
                if (!krnl.databaseChanged()) {
                    r.performQuit();
                } else {
                    if (s_inputDevice.isEnabled()) {
                        s_inputDevice.fireInput("exit;");
                    }
                    r.cancelQuit();
                }
            }
        });
        krnl.begin();
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        krnl.removeCmd(START_CMD_NAME);
        if (s_handleOpenFile != null) {
            File file = new File(s_handleOpenFile);
            try {
                Kernel.DatabaseInputStream in = new Kernel.DatabaseInputStream(new FileInputStream(file));
                krnl.loadDatabase(in);
            }
            catch (IOException e) {
                System.err.println(e);
                return;
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
                return;
            }
            krnl.setDatabasePathname(file.getAbsolutePath());
            System.out.println("Database " + s_handleOpenFile + " successfully loaded");
        }
        s_inputDevice = new InputDeviceAdapter();
        krnl.getUserInterface().addInputDevice(s_inputDevice);
    }
}

