/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.att.DefaultFillPaint;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Path2D;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;

public class AddDINAttributes
implements Cmd {
    final String[] m_lw = new String[]{"WIDTH_25", "WIDTH_35", "WIDTH_50", "WIDTH_70", "WIDTH_100"};
    final String[] m_lp = new String[]{"SOLID", "DASHED", "DOTTED_DASHED", "DOTTED"};
    final String[] m_paints = new String[]{"BLACK", "BLUE", "CYAN", "DARK_GREY", "GREY", "GREEN", "LIGHT_GREY", "MAGENTA", "ORANGE", "PINK", "RED", "WHITE", "YELLOW"};
    final String[] m_hatches = new String[]{"CONCRETE_REINFORCED", "CONCRETE_PLAIN", "MASONRY", "INSULATION", "CONCRETE_REINFORCED_2", "CONCRETE_PLAIN_2", "MASONRY_2"};
    final String[] m_ff = new String[]{"SANSSERIF", "SERIF", "ARIAL", "COURIER", "ISO"};
    final String[] m_ts = new String[]{"SIZE_25", "SIZE_35", "SIZE_50", "SIZE_70"};
    final String[] m_vis = new String[]{"VISIBLE", "INVISIBLE"};
    final String[] m_mut = new String[]{"MUTABLE", "IMMUTABLE"};
    private String m_toString = null;
    private Map<String, Double> m_lwMap = new HashMap<String, Double>();
    private Map<String, double[]> m_lpMap = new HashMap<String, double[]>();
    private Map<String, Paint> m_dpMap = new HashMap<String, Paint>();
    private Map<String, Paint> m_fpMap = new HashMap<String, Paint>();
    private Map<String, String> m_ffMap = new HashMap<String, String>();
    private Map<String, Double> m_tsMap = new HashMap<String, Double>();
    private Map<String, Boolean> m_visMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> m_modMap = new HashMap<String, Boolean>();

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        AttributeManager ns = AttributeManager.getAttributeManager();
        this.saveAttributes(ns);
        this.addAttributes(ns);
        this.m_toString = Messages.getString("db.att.AddDINAttributes.36");
        System.out.println(this);
        ((Kernel)context).getUserInterface().repaintUserInterface();
    }

    @Override
    public void undoCmd(Object context) {
        AttributeManager ns = AttributeManager.getAttributeManager();
        this.restoreAttributes(ns);
        ((Kernel)context).getUserInterface().repaintUserInterface();
    }

    @Override
    public void redoCmd(Object context) {
        AttributeManager ns = AttributeManager.getAttributeManager();
        this.addAttributes(ns);
        ((Kernel)context).getUserInterface().repaintUserInterface();
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void addAttributes(AttributeManager ns) {
        ns.addLineWidth(this.m_lw[0], 0.25);
        ns.addLineWidth(this.m_lw[1], 0.35);
        ns.addLineWidth(this.m_lw[2], 0.5);
        ns.addLineWidth(this.m_lw[3], 0.7);
        ns.addLineWidth(this.m_lw[4], 1.0);
        ns.addLinePattern(this.m_lp[0], null);
        ns.addLinePattern(this.m_lp[1], new double[]{5.0, 2.1});
        ns.addLinePattern(this.m_lp[2], new double[]{5.0, 1.0, 0.1, 1.0});
        ns.addLinePattern(this.m_lp[3], new double[]{0.1, 1.0});
        ns.addDrawPaint(this.m_paints[0], Color.BLACK);
        ns.addDrawPaint(this.m_paints[1], Color.BLUE);
        ns.addDrawPaint(this.m_paints[2], Color.CYAN);
        ns.addDrawPaint(this.m_paints[3], Color.DARK_GRAY);
        ns.addDrawPaint(this.m_paints[4], Color.GRAY);
        ns.addDrawPaint(this.m_paints[5], Color.GREEN);
        ns.addDrawPaint(this.m_paints[6], Color.LIGHT_GRAY);
        ns.addDrawPaint(this.m_paints[7], Color.MAGENTA);
        ns.addDrawPaint(this.m_paints[8], Color.ORANGE);
        ns.addDrawPaint(this.m_paints[9], Color.PINK);
        ns.addDrawPaint(this.m_paints[10], Color.RED);
        ns.addDrawPaint(this.m_paints[11], Color.WHITE);
        ns.addDrawPaint(this.m_paints[12], Color.YELLOW);
        ns.addFillPaint(this.m_paints[0], Color.BLACK);
        ns.addFillPaint(this.m_paints[1], Color.BLUE);
        ns.addFillPaint(this.m_paints[2], Color.CYAN);
        ns.addFillPaint(this.m_paints[3], Color.DARK_GRAY);
        ns.addFillPaint(this.m_paints[4], Color.GRAY);
        ns.addFillPaint(this.m_paints[5], Color.GREEN);
        ns.addFillPaint(this.m_paints[6], Color.LIGHT_GRAY);
        ns.addFillPaint(this.m_paints[7], Color.MAGENTA);
        ns.addFillPaint(this.m_paints[8], Color.ORANGE);
        ns.addFillPaint(this.m_paints[9], Color.PINK);
        ns.addFillPaint(this.m_paints[10], Color.RED);
        ns.addFillPaint(this.m_paints[11], Color.WHITE);
        ns.addFillPaint(this.m_paints[12], Color.YELLOW);
        DefaultFillPaint dfp = new DefaultFillPaint(null, 10.0, 10.0);
        dfp.add(this.getTop45(), this.getStrich());
        dfp.add(this.getMiddleTop45(), this.getVoll());
        dfp.add(this.getMiddle45(), this.getStrich());
        dfp.add(this.getMiddleBottom45(), this.getVoll());
        dfp.add(this.getBottom45(), this.getStrich());
        ns.addFillPaint(this.m_hatches[0], dfp);
        dfp = new DefaultFillPaint(null, 10.0, 10.0);
        dfp.add(this.getTop45(), this.getStrich());
        dfp.add(this.getMiddleTop45(), this.getStrich());
        dfp.add(this.getMiddle45(), this.getStrich());
        dfp.add(this.getMiddleBottom45(), this.getStrich());
        dfp.add(this.getBottom45(), this.getStrich());
        ns.addFillPaint(this.m_hatches[1], dfp);
        dfp = new DefaultFillPaint(null, 10.0, 10.0);
        dfp.add(this.getTop45(), this.getVoll());
        dfp.add(this.getMiddleTop45(), this.getVoll());
        dfp.add(this.getMiddle45(), this.getVoll());
        dfp.add(this.getMiddleBottom45(), this.getVoll());
        dfp.add(this.getBottom45(), this.getVoll());
        ns.addFillPaint(this.m_hatches[2], dfp);
        dfp = new DefaultFillPaint(null, 10.0, 10.0);
        dfp.add(this.getTop45(), this.getVoll());
        dfp.add(this.getMiddleTopTop45(), this.getVoll());
        dfp.add(this.getMiddleTop45(), this.getVoll());
        dfp.add(this.getMiddleMiddleTop45(), this.getVoll());
        dfp.add(this.getMiddle45(), this.getVoll());
        dfp.add(this.getMiddleMiddleBottom45(), this.getVoll());
        dfp.add(this.getMiddleBottom45(), this.getVoll());
        dfp.add(this.getMiddleBottomBottom45(), this.getVoll());
        dfp.add(this.getBottom45(), this.getVoll());
        dfp.add(this.getTop135(), this.getVoll());
        dfp.add(this.getMiddleTopTop135(), this.getVoll());
        dfp.add(this.getMiddleTop135(), this.getVoll());
        dfp.add(this.getMiddleMiddleTop135(), this.getVoll());
        dfp.add(this.getMiddle135(), this.getVoll());
        dfp.add(this.getMiddleMiddleBottom135(), this.getVoll());
        dfp.add(this.getMiddleBottom135(), this.getVoll());
        dfp.add(this.getMiddleBottomBottom135(), this.getVoll());
        dfp.add(this.getBottom45(), this.getVoll());
        ns.addFillPaint(this.m_hatches[3], dfp);
        dfp = new DefaultFillPaint(null, 10.0, 10.0);
        dfp.add(this.getTop135(), this.getStrich());
        dfp.add(this.getMiddleTop135(), this.getVoll());
        dfp.add(this.getMiddle135(), this.getStrich());
        dfp.add(this.getMiddleBottom135(), this.getVoll());
        dfp.add(this.getBottom135(), this.getStrich());
        ns.addFillPaint(this.m_hatches[4], dfp);
        dfp = new DefaultFillPaint(null, 10.0, 10.0);
        dfp.add(this.getTop135(), this.getStrich());
        dfp.add(this.getMiddleTop135(), this.getStrich());
        dfp.add(this.getMiddle135(), this.getStrich());
        dfp.add(this.getMiddleBottom135(), this.getStrich());
        dfp.add(this.getBottom135(), this.getStrich());
        ns.addFillPaint(this.m_hatches[5], dfp);
        dfp = new DefaultFillPaint(null, 10.0, 10.0);
        dfp.add(this.getTop135(), this.getVoll());
        dfp.add(this.getMiddleTop135(), this.getVoll());
        dfp.add(this.getMiddle135(), this.getVoll());
        dfp.add(this.getMiddleBottom135(), this.getVoll());
        dfp.add(this.getBottom135(), this.getVoll());
        ns.addFillPaint(this.m_hatches[6], dfp);
        ns.addFontFamily(this.m_ff[0], "sansserif");
        ns.addFontFamily(this.m_ff[1], "serif");
        if (ns.fontFamilyDefined("arial")) {
            ns.addFontFamily(this.m_ff[2], "arial");
        } else {
            ns.addFontFamily(this.m_ff[2], "sansserif");
        }
        if (ns.fontFamilyDefined("courier new")) {
            ns.addFontFamily(this.m_ff[3], "courier new");
        } else {
            ns.addFontFamily(this.m_ff[3], "monospaced");
        }
        if (ns.fontFamilyDefined("isocpeur")) {
            ns.addFontFamily(this.m_ff[4], "isocpeur");
        } else {
            ns.addFontFamily(this.m_ff[4], "sansserif");
        }
        ns.addTextSize(this.m_ts[0], 2.5);
        ns.addTextSize(this.m_ts[1], 3.5);
        ns.addTextSize(this.m_ts[2], 5.0);
        ns.addTextSize(this.m_ts[3], 7.0);
        ns.addVisibility(this.m_vis[0], true);
        ns.addVisibility(this.m_vis[1], false);
        ns.addMutability(this.m_mut[0], true);
        ns.addMutability(this.m_mut[1], false);
    }

    private void saveAttributes(AttributeManager ns) {
        int i = 0;
        while (i < 5) {
            try {
                this.m_lwMap.put(this.m_lw[i], new Double(ns.getLineWidth(this.m_lw[i])));
            }
            catch (IllegalArgumentException e) {
                this.m_lwMap.remove(this.m_lw[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            try {
                this.m_lpMap.put(this.m_lp[i], ns.getLinePattern(this.m_lp[i]));
            }
            catch (IllegalArgumentException e) {
                this.m_lpMap.remove(this.m_lp[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            try {
                this.m_dpMap.put(this.m_paints[i], ns.getDrawPaint(this.m_paints[i]));
            }
            catch (IllegalArgumentException e) {
                this.m_dpMap.remove(this.m_paints[i]);
            }
            try {
                this.m_fpMap.put(this.m_paints[i], ns.getFillPaint(this.m_paints[i]));
            }
            catch (IllegalArgumentException e) {
                this.m_fpMap.remove(this.m_paints[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            try {
                this.m_fpMap.put(this.m_hatches[i], ns.getFillPaint(this.m_hatches[i]));
            }
            catch (IllegalArgumentException e) {
                this.m_fpMap.remove(this.m_hatches[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            try {
                this.m_ffMap.put(this.m_ff[i], ns.getFontFamily(this.m_ff[i]));
            }
            catch (IllegalArgumentException e) {
                this.m_ffMap.remove(this.m_ff[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            try {
                this.m_tsMap.put(this.m_ts[i], new Double(ns.getTextSize(this.m_ts[i])));
            }
            catch (IllegalArgumentException e) {
                this.m_tsMap.remove(this.m_ts[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            try {
                this.m_visMap.put(this.m_vis[i], new Boolean(ns.getVisibility(this.m_vis[i])));
            }
            catch (IllegalArgumentException e) {
                this.m_visMap.remove(this.m_vis[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            try {
                this.m_modMap.put(this.m_mut[i], new Boolean(ns.getMutability(this.m_mut[i])));
            }
            catch (IllegalArgumentException e) {
                this.m_modMap.remove(this.m_mut[i]);
            }
            ++i;
        }
    }

    private void restoreAttributes(AttributeManager ns) {
        Boolean b;
        Object d;
        int i = 0;
        while (i < 5) {
            d = this.m_lwMap.get(this.m_lw[i]);
            if (d == null) {
                ns.removeLineWidth(this.m_lw[i]);
            } else {
                ns.addLineWidth(this.m_lw[i], (Double)d);
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            d = this.m_lpMap.get(this.m_lp[i]);
            if (d == null) {
                if (!this.m_lpMap.containsKey(this.m_lp[i])) {
                    ns.removeLinePattern(this.m_lp[i]);
                }
            } else {
                ns.addLinePattern(this.m_lp[i], (double[])d);
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            Paint dp = this.m_dpMap.get(this.m_paints[i]);
            if (dp == null) {
                ns.removeDrawPaint(this.m_paints[i]);
            } else {
                ns.addDrawPaint(this.m_paints[i], dp);
            }
            Paint fp = this.m_fpMap.get(this.m_paints[i]);
            if (fp == null) {
                ns.removeFillPaint(this.m_paints[i]);
            } else {
                ns.addFillPaint(this.m_paints[i], fp);
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            Paint fp = this.m_fpMap.get(this.m_hatches[i]);
            if (fp == null) {
                ns.removeFillPaint(this.m_hatches[i]);
            } else {
                ns.addFillPaint(this.m_hatches[i], fp);
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            String f = this.m_ffMap.get(this.m_ff[i]);
            if (f == null) {
                ns.removeFontFamily(this.m_ff[i]);
            } else {
                ns.addFontFamily(this.m_ff[i], f);
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            d = this.m_tsMap.get(this.m_ts[i]);
            if (d == null) {
                ns.removeTextSize(this.m_ts[i]);
            } else {
                ns.addTextSize(this.m_ts[i], (Double)d);
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            b = this.m_visMap.get(this.m_vis[i]);
            if (b == null) {
                ns.removeVisibility(this.m_vis[i]);
            } else {
                ns.addVisibility(this.m_vis[i], b);
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            b = this.m_modMap.get(this.m_mut[i]);
            if (b == null) {
                ns.removeMutability(this.m_mut[i]);
            } else {
                ns.addMutability(this.m_mut[i], b);
            }
            ++i;
        }
    }

    private Path2D getMiddle45() {
        Path2D path = new Path2D();
        path.moveTo(11.0, 11.0);
        path.lineTo(-1.0, -1.0);
        return path;
    }

    private Path2D getTop45() {
        Path2D path = new Path2D();
        path.moveTo(1.0, 11.0);
        path.lineTo(-1.0, 9.0);
        return path;
    }

    private Path2D getBottom45() {
        Path2D path = new Path2D();
        path.moveTo(11.0, 1.0);
        path.lineTo(9.0, -1.0);
        return path;
    }

    private Path2D getMiddleTop45() {
        Path2D path = new Path2D();
        path.moveTo(6.0, 11.0);
        path.lineTo(-1.0, 4.0);
        return path;
    }

    private Path2D getMiddleBottom45() {
        Path2D path = new Path2D();
        path.moveTo(11.0, 6.0);
        path.lineTo(4.0, -1.0);
        return path;
    }

    private Path2D getMiddle135() {
        Path2D path = new Path2D();
        path.moveTo(-1.0, 11.0);
        path.lineTo(11.0, -1.0);
        return path;
    }

    private Path2D getTop135() {
        Path2D path = new Path2D();
        path.moveTo(9.0, 11.0);
        path.lineTo(11.0, 9.0);
        return path;
    }

    private Path2D getBottom135() {
        Path2D path = new Path2D();
        path.moveTo(-1.0, 1.0);
        path.lineTo(1.0, -1.0);
        return path;
    }

    private Path2D getMiddleTop135() {
        Path2D path = new Path2D();
        path.moveTo(4.0, 11.0);
        path.lineTo(11.0, 4.0);
        return path;
    }

    private Path2D getMiddleBottom135() {
        Path2D path = new Path2D();
        path.moveTo(-1.0, 6.0);
        path.lineTo(6.0, -1.0);
        return path;
    }

    private Path2D getMiddleMiddleTop45() {
        Path2D path = new Path2D();
        path.moveTo(-1.0, 1.5);
        path.lineTo(8.5, 11.0);
        return path;
    }

    private Path2D getMiddleTopTop45() {
        Path2D path = new Path2D();
        path.moveTo(-1.0, 6.5);
        path.lineTo(3.5, 11.0);
        return path;
    }

    private Path2D getMiddleMiddleBottom45() {
        Path2D path = new Path2D();
        path.moveTo(1.5, -1.0);
        path.lineTo(11.0, 8.5);
        return path;
    }

    private Path2D getMiddleBottomBottom45() {
        Path2D path = new Path2D();
        path.moveTo(6.5, -1.0);
        path.lineTo(11.0, 3.5);
        return path;
    }

    private Path2D getMiddleMiddleTop135() {
        Path2D path = new Path2D();
        path.moveTo(11.0, 1.5);
        path.lineTo(1.5, 11.0);
        return path;
    }

    private Path2D getMiddleTopTop135() {
        Path2D path = new Path2D();
        path.moveTo(11.0, 6.5);
        path.lineTo(6.5, 11.0);
        return path;
    }

    private Path2D getMiddleMiddleBottom135() {
        Path2D path = new Path2D();
        path.moveTo(8.5, -1.0);
        path.lineTo(-1.0, 8.5);
        return path;
    }

    private Path2D getMiddleBottomBottom135() {
        Path2D path = new Path2D();
        path.moveTo(3.5, -1.0);
        path.lineTo(-1.0, 3.5);
        return path;
    }

    private Attributes getStrich() {
        Attributes tuple = new Attributes();
        tuple.set("WIDTH_25", "DASHED", "BLACK", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT");
        return tuple;
    }

    private Attributes getVoll() {
        Attributes tuple = new Attributes();
        tuple.set("WIDTH_25", "SOLID", "BLACK", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT");
        return tuple;
    }
}

