/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.SelObject;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SelFontFamily
extends SelObject {
    public SelFontFamily(Kernel krnl) {
        super(krnl);
        this.setPrompt(Messages.getString("db.att.SelFontFamily.0"));
    }

    @Override
    protected Map<String, String> locNameMap() {
        AttributeManager am = AttributeManager.getAttributeManager();
        Set<String> names = am.getFontFamilies();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            String locName = am.getLocalizedFontFamilyName(name);
            map.put(locName, name);
        }
        return map;
    }

    @Override
    protected String locDefaultName() {
        return Messages.getString("db.att.Attribute.FontFamily.Name.DEFAULT");
    }

    @Override
    protected boolean attributeExists(String attr) {
        return AttributeManager.getAttributeManager().containsFontFamily(attr);
    }

    @Override
    protected String extractAttribute(Component c) {
        return c.getAttributes().getFontFamily();
    }
}

