/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.util.AttributedShape;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ComponentGeneralPath
extends ComponentAdapter
implements Shape {
    private static final long serialVersionUID = 0L;
    private transient GeneralPath m_generalPath = null;
    private static final int END_OF_COMPONENT = -1;
    private static final AffineTransform IDENTITY = new AffineTransform();

    public ComponentGeneralPath() {
        this.m_generalPath = new GeneralPath();
    }

    public ComponentGeneralPath(int rule) {
        this.m_generalPath = new GeneralPath(rule);
    }

    public ComponentGeneralPath(int rule, int initialCapacity) {
        this.m_generalPath = new GeneralPath(rule, initialCapacity);
    }

    public ComponentGeneralPath(Shape s) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        this.m_generalPath = new GeneralPath(u2w.createTransformedShape(s));
    }

    @Override
    public Object clone() {
        ComponentGeneralPath comp = (ComponentGeneralPath)super.clone();
        comp.m_generalPath = (GeneralPath)this.m_generalPath.clone();
        return comp;
    }

    @Override
    public void assign(Component rhs) {
        ComponentGeneralPath rhsComp = (ComponentGeneralPath)rhs;
        this.m_generalPath = (GeneralPath)rhsComp.m_generalPath.clone();
        super.assign(rhs);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.m_generalPath.getWindingRule());
        float[] coord = new float[6];
        PathIterator it = this.m_generalPath.getPathIterator(null);
        while (!it.isDone()) {
            int seg = it.currentSegment(coord);
            out.writeInt(seg);
            int nCoord = 0;
            switch (seg) {
                case 0: 
                case 1: {
                    nCoord = 2;
                    break;
                }
                case 2: {
                    nCoord = 4;
                    break;
                }
                case 3: {
                    nCoord = 6;
                    break;
                }
                case 4: {
                    nCoord = 0;
                    break;
                }
                default: {
                    throw new Error("Unexpected segment type");
                }
            }
            int i = 0;
            while (i < nCoord) {
                out.writeFloat(coord[i]);
                ++i;
            }
            it.next();
        }
        out.writeInt(-1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int rule = in.readInt();
        this.m_generalPath = new GeneralPath(rule);
        block8: while (true) {
            int seg = in.readInt();
            switch (seg) {
                case 0: {
                    this.m_generalPath.moveTo(in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 1: {
                    this.m_generalPath.lineTo(in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 2: {
                    this.m_generalPath.quadTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 3: {
                    this.m_generalPath.curveTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 4: {
                    this.m_generalPath.closePath();
                    continue block8;
                }
                case -1: {
                    return;
                }
            }
            break;
        }
        throw new Error("Unexpected segment type");
    }

    public void append(PathIterator pi, boolean connect) {
        throw new UnsupportedOperationException();
    }

    public void append(Shape s, boolean connect) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        this.m_generalPath.append(u2w.createTransformedShape(s), connect);
        this._notifyWasChanged();
    }

    public void closePath() {
        this.m_generalPath.closePath();
        this._notifyWasChanged();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrame(x, y, w, h);
        return this.contains(r);
    }

    @Override
    public boolean contains(Point2D p) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double pt = new Point2D.Double();
        u2w.transform(p, pt);
        return this.m_generalPath.contains(pt);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p1 = new Point2D.Double(r.getMinX(), r.getMinY());
        Point2D.Double p2 = new Point2D.Double(r.getMaxX(), r.getMaxY());
        Point2D.Double p1t = new Point2D.Double();
        Point2D.Double p2t = new Point2D.Double();
        u2w.transform(p1, p1t);
        u2w.transform(p2, p2t);
        Rectangle2D.Double rt = new Rectangle2D.Double();
        rt.setFrameFromDiagonal(p1t, p2t);
        return this.m_generalPath.contains(r);
    }

    public Shape createTransformedShape(AffineTransform at) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = cs.getWorldToUserTransform();
        if (at != null) {
            trf.preConcatenate(at);
        }
        return this.m_generalPath.createTransformedShape(trf);
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        Point2D.Double p3 = new Point2D.Double(x3, y3);
        Point2D.Double p1t = new Point2D.Double();
        Point2D.Double p2t = new Point2D.Double();
        Point2D.Double p3t = new Point2D.Double();
        u2w.transform(p1, p1t);
        u2w.transform(p2, p2t);
        u2w.transform(p3, p3t);
        this.m_generalPath.curveTo((float)((Point2D)p1t).getX(), (float)((Point2D)p1t).getY(), (float)((Point2D)p2t).getX(), (float)((Point2D)p2t).getY(), (float)((Point2D)p3t).getX(), (float)((Point2D)p3t).getY());
        this._notifyWasChanged();
    }

    @Override
    public Rectangle getBounds() {
        Shape uShape = this.createTransformedShape(IDENTITY);
        return uShape.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        Shape uShape = this.createTransformedShape(IDENTITY);
        return uShape.getBounds2D();
    }

    public Point2D getCurrentPoint() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D p = this.m_generalPath.getCurrentPoint();
        Point2D.Double pt = new Point2D.Double();
        return w2u.transform(p, pt);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = cs.getWorldToUserTransform();
        if (at != null) {
            trf.preConcatenate(at);
        }
        return this.m_generalPath.getPathIterator(trf);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = cs.getWorldToUserTransform();
        if (at != null) {
            trf.preConcatenate(at);
        }
        return this.m_generalPath.getPathIterator(trf, flatness);
    }

    public int getWindingRule() {
        return this.m_generalPath.getWindingRule();
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        Shape uShape = this.createTransformedShape(IDENTITY);
        return uShape.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        Shape uShape = this.createTransformedShape(IDENTITY);
        return uShape.intersects(r);
    }

    public void lineTo(double x, double y) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D.Double pt = new Point2D.Double();
        u2w.transform(p, pt);
        this.m_generalPath.lineTo((float)((Point2D)pt).getX(), (float)((Point2D)pt).getY());
        this._notifyWasChanged();
    }

    public void moveTo(double x, double y) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D.Double pt = new Point2D.Double();
        u2w.transform(p, pt);
        this.m_generalPath.moveTo((float)((Point2D)pt).getX(), (float)((Point2D)pt).getY());
        this._notifyWasChanged();
    }

    public void quadTo(double x1, double y1, double x2, double y2) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        Point2D.Double p1t = new Point2D.Double();
        Point2D.Double p2t = new Point2D.Double();
        u2w.transform(p1, p1t);
        u2w.transform(p2, p2t);
        this.m_generalPath.quadTo((float)((Point2D)p1t).getX(), (float)((Point2D)p1t).getY(), (float)((Point2D)p2t).getX(), (float)((Point2D)p2t).getY());
        this._notifyWasChanged();
    }

    public void reset() {
        this.m_generalPath.reset();
        this._notifyWasChanged();
    }

    public void setWindingRule(int rule) {
        this.m_generalPath.setWindingRule(rule);
        this._notifyWasChanged();
    }

    public void transform(AffineTransform at) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = cs.getWorldToUserTransform();
        trf.preConcatenate(at);
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_generalPath.transform(trf);
        this._notifyWasChanged();
    }

    @Override
    public void transformBy(AffineTransform trf) {
        this.transform(trf);
        this._notifyWasChanged();
    }

    private AttributedShape getShape() {
        return this._attributeShape(new AttributedShape(this));
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return NamedListIteratorAdapter.singletonNamedListIterator(this.getShape());
    }

    @Override
    public boolean hasControlPoint(int name) {
        int n = this.getPoints().size();
        return name >= 0 && name < n;
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        List<Point2D.Double> pnts = this.getPoints();
        if (name >= pnts.size()) {
            throw new IllegalArgumentException();
        }
        return pnts.get(name);
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        System.err.println("Not yet implemented");
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return ComponentGeneralPath.this.getPoints().size();
            }

            @Override
            protected Point2D _get(int index) {
                List pnts = ComponentGeneralPath.this.getPoints();
                if (index >= pnts.size()) {
                    throw new IllegalArgumentException();
                }
                return (Point2D)pnts.get(index);
            }

            @Override
            protected void _set(int index, Point2D p) {
                System.err.println("Not yet implemented");
            }
        };
    }

    private List<Point2D.Double> getPoints() {
        double[] crds = new double[6];
        ArrayList<Point2D.Double> pnts = new ArrayList<Point2D.Double>();
        PathIterator pit = this.getPathIterator(null);
        while (!pit.isDone()) {
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: {
                    pnts.add(new Point2D.Double(crds[0], crds[1]));
                    break;
                }
                case 1: {
                    pnts.add(new Point2D.Double(crds[0], crds[1]));
                    break;
                }
                case 2: {
                    pnts.add(new Point2D.Double(crds[0], crds[1]));
                    pnts.add(new Point2D.Double(crds[2], crds[3]));
                    break;
                }
                case 3: {
                    pnts.add(new Point2D.Double(crds[0], crds[1]));
                    pnts.add(new Point2D.Double(crds[2], crds[3]));
                    pnts.add(new Point2D.Double(crds[4], crds[5]));
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new Error("  Unexpected segment type");
                }
            }
            pit.next();
        }
        return pnts;
    }
}

