/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.AddableFeatures;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.comp.ComponentDimSingle;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.comp.Group;
import cib.cad.db.feature.Feature;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.NameSpace;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.binding.DefaultBindingModel;
import cib.util.coll.CollUtilities;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.coll.ObservableSet;
import cib.util.coll.SwappableList;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ComponentGroup
extends ComponentAdapter
implements Group,
AddableFeatures {
    private static final long serialVersionUID = 1L;
    public static final int PLACEMENT_CTRL_POINT_ON = 1;
    public static final int COMPONENT_CTRL_POINTS_ON = 2;
    private ObservableSet<Component> m_components;
    private BindingModel<Component> m_bindingModel;
    private SwappableList<Component> m_componentList;
    private List<Feature> m_addedFeatures;
    private double m_plpX = 0.0;
    private double m_plpY = 0.0;
    private int m_configuration = 0;
    private transient List<AttributedShape> t_shapes = new ArrayList<AttributedShape>();
    private transient List<AttributedText> t_texts = new ArrayList<AttributedText>();
    private transient List<AttributedImage> t_images = new ArrayList<AttributedImage>();
    private transient List<Point2D> t_controlPoints = new ArrayList<Point2D>();
    private transient double t_naturalUnitsPerWorldUnit = 0.0;
    private transient double t_scale = 0.0;
    private transient AffineTransform t_ucsTransform = new AffineTransform();

    public ComponentGroup() {
        this._init();
        this.setPlacementPoint(new Point2D.Double(0.0, 0.0));
    }

    public ComponentGroup(int configuration) {
        this.m_configuration = configuration;
        this._init();
        this.setPlacementPoint(new Point2D.Double(0.0, 0.0));
    }

    public ComponentGroup(Set<Component> comps, BindingModel<Component> bindingModel) {
        this._init();
        this.m_components.addAll(comps);
        this.m_bindingModel.putAll(bindingModel);
        this.setPlacementPoint(new Point2D.Double(0.0, 0.0));
    }

    private void _init() {
        NameSpace nameSpace = NameSpace.getInstance();
        this.m_components = CollUtilities.observableSet(CollUtilities.namedElementsSet(new HashSet(), nameSpace));
        this.m_components.addListener(new ObservableSet.Listener<Component>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void wasAdded(Component o) {
                ComponentGroup.this._notifyWasChanged();
            }

            @Override
            public void wasChanged(Component o) {
                ComponentGroup.this._notifyWasChanged();
            }

            @Override
            public void wasRemoved(Component o) {
                if (o instanceof Feature) {
                    ComponentGroup.this.m_addedFeatures.remove((Feature)((Object)o));
                }
                ComponentGroup.this._notifyWasChanged();
            }

            @Override
            public void wasCloned(Component src, Component dst) {
            }
        });
        this.m_bindingModel = new DefaultBindingModel<Component>();
        this.m_componentList = CollUtilities.orderedSet(this.m_components);
        this.m_addedFeatures = new ArrayList<Feature>();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.t_shapes = new ArrayList<AttributedShape>();
        this.t_texts = new ArrayList<AttributedText>();
        this.t_images = new ArrayList<AttributedImage>();
        this.t_controlPoints = new ArrayList<Point2D>();
    }

    @Override
    public ObservableSet<Component> getComponentSet() {
        return this.m_components;
    }

    @Override
    public BindingModel<Component> getBindingModel() {
        return this.m_bindingModel;
    }

    @Override
    public SwappableList<Component> getComponentList() {
        return this.m_componentList;
    }

    @Override
    public boolean isUngroupable() {
        return false;
    }

    @Override
    public Object clone() {
        ObservableSet<Component> sv_m_components = this.m_components;
        this.m_components = null;
        BindingModel<Component> sv_m_bindingModel = this.m_bindingModel;
        this.m_bindingModel = null;
        SwappableList<Component> sv_m_componentList = this.m_componentList;
        this.m_componentList = null;
        ComponentGroup dst = (ComponentGroup)super.clone();
        this.m_components = sv_m_components;
        this.m_bindingModel = sv_m_bindingModel;
        this.m_componentList = sv_m_componentList;
        dst._init();
        dst.t_shapes = new ArrayList<AttributedShape>();
        dst.t_texts = new ArrayList<AttributedText>();
        dst.t_images = new ArrayList<AttributedImage>();
        dst.t_controlPoints = new ArrayList<Point2D>();
        HashMap<Component, Object> clones = new HashMap<Component, Object>();
        for (Component part : this.m_components) {
            Component clonedPart = (Component)part.clone();
            dst.m_components.add(clonedPart);
            clones.put(part, clonedPart);
        }
        Collection bindings = this.m_bindingModel.values();
        for (Binding binding : bindings) {
            Binding clonedBinding = (Binding)binding.clone();
            Set bindingObjects = clonedBinding.getBindingObjects();
            for (Component bindingObject : bindingObjects) {
                Component clonedBindingObject = (Component)clones.get(bindingObject);
                dst.m_bindingModel.replaceBindingObject(clonedBinding, bindingObject, clonedBindingObject);
            }
            Component boundObject = (Component)binding.getBoundObject();
            Component clonedBoundObject = (Component)clones.get(boundObject);
            dst.m_bindingModel.put(clonedBoundObject, clonedBinding);
        }
        int n = this.m_componentList.size();
        int i = 0;
        while (i < n) {
            dst.m_componentList.set(i, (Component)clones.get(this.m_componentList.get(i)));
            ++i;
        }
        for (Feature feature : this.m_addedFeatures) {
            if (feature instanceof Component) {
                Component clonedFeature = (Component)clones.get(feature);
                if (dst.m_addedFeatures.contains(clonedFeature)) continue;
                dst.m_addedFeatures.add((Feature)((Object)clonedFeature));
                continue;
            }
            dst.m_addedFeatures.add((Feature)feature.clone());
        }
        return dst;
    }

    @Override
    public void assign(Component rhs) {
        ComponentGroup rhsComp = (ComponentGroup)rhs;
        this.m_plpX = rhsComp.m_plpX;
        this.m_plpY = rhsComp.m_plpY;
        this.m_configuration = rhsComp.m_configuration;
        this.t_shapes.clear();
        this.t_texts.clear();
        this.t_images.clear();
        this.t_controlPoints.clear();
        int n = this.m_componentList.size();
        if (n != rhsComp.m_componentList.size()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < n) {
            ((Component)this.m_componentList.get(i)).assign((Component)rhsComp.m_componentList.get(i));
            ++i;
        }
        this.m_addedFeatures.clear();
        for (Feature feature : rhsComp.m_addedFeatures) {
            if (feature instanceof Component) continue;
            this.m_addedFeatures.add((Feature)feature.clone());
        }
        super.assign(rhs);
    }

    @Override
    public synchronized void transformBy(AffineTransform mat) {
        for (Component comp : this.m_components) {
            comp.transformBy(mat);
        }
        Point2D plp = this.getPlacementPoint();
        mat.transform(plp, plp);
        this.setPlacementPoint(plp);
        this._notifyWasChanged();
    }

    public synchronized void setPlacementPoint(Point2D plp) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D plpW = u2w.transform(plp, new Point2D.Double());
        this.m_plpX = plpW.getX();
        this.m_plpY = plpW.getY();
        this._notifyWasChanged();
    }

    public Point2D getPlacementPoint() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double plp = new Point2D.Double(this.m_plpX, this.m_plpY);
        return w2u.transform(plp, plp);
    }

    public int getConfiguration() {
        return this.m_configuration;
    }

    public synchronized void setConfiguration(int configuration) {
        this.m_configuration = configuration;
        this._notifyWasChanged();
    }

    private synchronized void _update() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double naturalUnitsPerWorldUnit = cs.getNaturalUnitsPerWorldUnit();
        double scale = cs.getScale();
        AffineTransform ucsTransform = cs.getUserCrdTransform();
        if (naturalUnitsPerWorldUnit != this.t_naturalUnitsPerWorldUnit || scale != this.t_scale || !this.t_ucsTransform.equals(ucsTransform)) {
            this.t_naturalUnitsPerWorldUnit = naturalUnitsPerWorldUnit;
            this.t_scale = scale;
            this.t_ucsTransform = ucsTransform;
            this.t_shapes.clear();
            this.t_texts.clear();
            this.t_images.clear();
            this.t_controlPoints.clear();
        }
        this.__updateShapes();
        this.__updateTexts();
        this.__updateControlPoints();
        this.__updateImages();
    }

    private void __updateShapes() {
        if (this.t_shapes.isEmpty()) {
            for (Component comp : this.m_componentList) {
                NamedListIterator<AttributedShape> it = comp.shapeIterator();
                while (it.hasNext()) {
                    AttributedShape as = (AttributedShape)it.next();
                    this._attributeShape(as, comp.getAttributes());
                    this.t_shapes.add(as);
                }
            }
        }
    }

    @Override
    public AttributedShape getShape(int name) throws IllegalArgumentException {
        this._update();
        if (name >= 0 && name < this.t_shapes.size()) {
            return (AttributedShape)this.t_shapes.get(name).clone();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        this._update();
        return new NamedListIteratorAdapter<AttributedShape>(){

            @Override
            protected int _size() {
                return ComponentGroup.this.t_shapes.size();
            }

            @Override
            protected AttributedShape _get(int index) {
                return (AttributedShape)((AttributedShape)ComponentGroup.this.t_shapes.get(index)).clone();
            }
        };
    }

    protected AttributedShape _attributeShape(AttributedShape as, Attributes compAttributes) {
        String fillPaint;
        String drawPaint;
        String linePattern;
        String lineWidth;
        AttributeManager atm = AttributeManager.getAttributeManager();
        Attributes attributes = this.getAttributes();
        if (attributes == null) {
            attributes = new Attributes();
        }
        if (!(lineWidth = attributes.getLineWidth()).equals("DEFAULT")) {
            Stroke stroke = as.getStroke();
            Stroke s = atm.getModelStroke(lineWidth, "DEFAULT");
            if (stroke instanceof BasicStroke && s instanceof BasicStroke) {
                BasicStroke _stroke = (BasicStroke)stroke;
                BasicStroke _s = (BasicStroke)s;
                as.setStroke(new BasicStroke(_s.getLineWidth(), _stroke.getEndCap(), _stroke.getLineJoin(), _stroke.getMiterLimit(), _stroke.getDashArray(), _stroke.getDashPhase()));
            }
        }
        if (!(linePattern = attributes.getLinePattern()).equals("DEFAULT")) {
            Stroke stroke = as.getStroke();
            Stroke s = atm.getModelStroke("DEFAULT", linePattern);
            if (stroke instanceof BasicStroke && s instanceof BasicStroke) {
                BasicStroke _stroke = (BasicStroke)stroke;
                BasicStroke _s = (BasicStroke)s;
                as.setStroke(new BasicStroke(_stroke.getLineWidth(), _stroke.getEndCap(), _stroke.getLineJoin(), _s.getMiterLimit(), _s.getDashArray(), _s.getDashPhase()));
            }
        }
        if (!(drawPaint = attributes.getDrawPaint()).equals("DEFAULT")) {
            as.setDrawPaint(atm.getDrawPaint(drawPaint));
        }
        if (!(fillPaint = attributes.getFillPaint()).equals("DEFAULT")) {
            as.setFillPaint(atm.getModelFillPaint(fillPaint));
        }
        return as;
    }

    private void __updateTexts() {
        if (this.t_texts.isEmpty()) {
            for (Component comp : this.m_componentList) {
                NamedListIterator<AttributedText> it = comp.textIterator();
                while (it.hasNext()) {
                    AttributedText at = (AttributedText)it.next();
                    this._attributeText(at, comp.getAttributes());
                    this.t_texts.add(at);
                }
            }
        }
    }

    @Override
    public AttributedText getText(int name) throws IllegalArgumentException {
        this._update();
        if (name >= 0 && name < this.t_texts.size()) {
            return (AttributedText)this.t_texts.get(name).clone();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NamedListIterator<AttributedText> textIterator() {
        this._update();
        return new NamedListIteratorAdapter<AttributedText>(){

            @Override
            protected int _size() {
                return ComponentGroup.this.t_texts.size();
            }

            @Override
            protected AttributedText _get(int index) {
                return (AttributedText)((AttributedText)ComponentGroup.this.t_texts.get(index)).clone();
            }
        };
    }

    protected AttributedText _attributeText(AttributedText text, Attributes compAttributes) {
        String drawPaint;
        AttributedCharacterIterator aci;
        String fontFamily;
        String textSize;
        AttributedString as = text.getAttributedString();
        AttributeManager atm = AttributeManager.getAttributeManager();
        Attributes attributes = this.getAttributes();
        if (attributes == null) {
            attributes = new Attributes();
        }
        if (compAttributes == null) {
            compAttributes = new Attributes();
        }
        if ((textSize = attributes.getTextSize()).equals("DEFAULT")) {
            textSize = compAttributes.getTextSize();
        }
        if ((fontFamily = attributes.getFontFamily()).equals("DEFAULT")) {
            fontFamily = compAttributes.getFontFamily();
        }
        if ((aci = as.getIterator()).getRunLimit() != 0) {
            as.addAttribute(TextAttribute.SIZE, new Float(atm.getModelTextSize(textSize)));
            as.addAttribute(TextAttribute.FAMILY, atm.getFontFamily(fontFamily));
        }
        if ((drawPaint = attributes.getDrawPaint()).equals("DEFAULT")) {
            drawPaint = compAttributes.getDrawPaint();
        }
        text.setDrawPaint(atm.getDrawPaint(drawPaint));
        String fillPaint = attributes.getFillPaint();
        if (fillPaint.equals("DEFAULT")) {
            fillPaint = compAttributes.getFillPaint();
        }
        text.setFillPaint(atm.getFillPaint(fillPaint));
        return text;
    }

    private void __updateImages() {
        if (this.t_images.isEmpty()) {
            for (Component comp : this.m_componentList) {
                NamedListIterator<AttributedImage> it = comp.imageIterator();
                while (it.hasNext()) {
                    this.t_images.add((AttributedImage)it.next());
                }
            }
        }
    }

    @Override
    public AttributedImage getImage(int name) throws IllegalArgumentException {
        this._update();
        if (name >= 0 && name < this.t_images.size()) {
            return this.t_images.get(name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NamedListIterator<AttributedImage> imageIterator() {
        this._update();
        return new NamedListIteratorAdapter<AttributedImage>(){

            @Override
            protected int _size() {
                return ComponentGroup.this.t_images.size();
            }

            @Override
            protected AttributedImage _get(int index) {
                return (AttributedImage)ComponentGroup.this.t_images.get(index);
            }
        };
    }

    private void __updateControlPoints() {
        if (this.t_controlPoints.isEmpty()) {
            if ((this.m_configuration & 1) != 0) {
                this.t_controlPoints.add(this.getPlacementPoint());
            }
            if ((this.m_configuration & 2) != 0) {
                for (Component comp : this.m_componentList) {
                    NamedListIterator<Point2D> it = comp.controlPointIterator();
                    while (it.hasNext()) {
                        int name = it.nextName();
                        Point2D pnt = (Point2D)it.next();
                        if (comp instanceof CtrlSegments) {
                            int type = ((CtrlSegments)comp).getCtrlType(name);
                            if (type != 2 && (type & 0x40) == 0) continue;
                            this.t_controlPoints.add(pnt);
                            continue;
                        }
                        if (comp instanceof ComponentDimSingle) continue;
                        this.t_controlPoints.add(pnt);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasControlPoint(int name) {
        this._update();
        return name >= 0 && name < this.t_controlPoints.size();
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        this._update();
        if (!this.hasControlPoint(name)) {
            throw new IllegalArgumentException();
        }
        return (Point2D)this.t_controlPoints.get(name).clone();
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        this._update();
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return ComponentGroup.this.t_controlPoints.size();
            }

            @Override
            protected Point2D _get(int index) {
                return (Point2D)((Point2D)ComponentGroup.this.t_controlPoints.get(index)).clone();
            }
        };
    }

    @Override
    public boolean hasFeature(String name) {
        for (Feature feature : this.m_addedFeatures) {
            if (!feature.getName().equals(name)) continue;
            return true;
        }
        return super.hasFeature(name);
    }

    @Override
    public Feature getFeature(String name) {
        for (Feature feature : this.m_addedFeatures) {
            if (!feature.getName().equals(name)) continue;
            return feature instanceof Component ? feature : (Feature)feature.clone();
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(Feature feature) {
        String name = feature.getName();
        int index = 0;
        while (index < this.m_addedFeatures.size()) {
            Feature f = this.m_addedFeatures.get(index);
            if (name.equals(f.getName())) {
                if (!(feature instanceof Component)) {
                    this.m_addedFeatures.set(index, (Feature)feature.clone());
                }
                return;
            }
            ++index;
        }
        super.setFeature(feature);
    }

    @Override
    public boolean isAddedFeature(String name) {
        if (!this.hasFeature(name)) {
            return false;
        }
        Feature feature = this.getFeature(name);
        return this.m_addedFeatures.contains(feature);
    }

    @Override
    public void addFeature(Feature feature) throws IllegalArgumentException {
        if (this.hasFeature(feature.getName())) {
            throw new IllegalArgumentException();
        }
        if (this.m_components.contains(feature)) {
            throw new IllegalArgumentException();
        }
        if (feature instanceof Component) {
            this.m_addedFeatures.add(feature);
            this.m_components.add((Component)((Object)feature));
        } else {
            this.m_addedFeatures.add((Feature)feature.clone());
        }
    }

    @Override
    public void removeFeature(String name) throws IllegalArgumentException {
        if (!this.hasFeature(name)) {
            throw new IllegalArgumentException();
        }
        Feature feature = this.getFeature(name);
        this.m_addedFeatures.remove(feature);
        if (feature instanceof Component) {
            this.m_components.remove(feature);
        }
    }

    @Override
    public void swapFeatures(String name1, String name2) {
        if (name1.equals(name2)) {
            return;
        }
        int index1 = -1;
        int index2 = -1;
        int n = this.m_addedFeatures.size();
        int i = 0;
        while (i < n) {
            Feature feature = this.m_addedFeatures.get(i);
            String name = feature.getName();
            if (name.equals(name1)) {
                index1 = i;
            }
            if (name.equals(name2)) {
                index2 = i;
            }
            ++i;
        }
        if (index1 >= 0 && index2 >= 0) {
            Feature fi = this.m_addedFeatures.get(index1);
            Feature fj = this.m_addedFeatures.get(index2);
            this.m_addedFeatures.set(index1, fj);
            this.m_addedFeatures.set(index2, fi);
        }
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itAddedFeatures = this.m_addedFeatures.iterator();
        final Iterator<Feature> itBase = super.featureIterator();
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() || itAddedFeatures.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itAddedFeatures.hasNext()) {
                    return (Feature)itAddedFeatures.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void _notifyWasChanged() {
        this.t_shapes.clear();
        this.t_texts.clear();
        this.t_images.clear();
        this.t_controlPoints.clear();
        super._notifyWasChanged();
    }
}

