/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.feature.AngleFeature;
import cib.cad.db.feature.BooleanFeature;
import cib.cad.db.feature.ChoiceFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.Point2DFeature;
import cib.cad.db.feature.StringFeature;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Vector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ComponentTitleBlock
extends ComponentAdapter {
    private static final AffineTransform FLIP_X = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
    private static final long serialVersionUID = 1L;
    private int m_subVersion = 1;
    private String m_drawersName = null;
    private String m_drawingDate = null;
    private String m_proversName = null;
    private String m_provingDate = null;
    private String m_title = null;
    private String m_page = null;
    private String m_company = null;
    private double m_x = 0.0;
    private double m_y = 0.0;
    private boolean m_drawPaper = true;
    private boolean m_rotated = false;
    private String m_proven = "Gepr\u221a\u00baft";
    private String m_drawn = "Gezeichnet";
    private String m_date = "Datum";
    private String m_name = "Name";
    private int m_format = 4;
    private double m_angle = 0.0;
    private boolean m_flipX = false;
    private static double l = 0.0;
    private static double l1 = 0.0;
    private static double l2 = 0.0;
    private static double l3 = 0.0;
    private static double l5 = 0.0;
    private static double l4 = 0.0;
    private static double h = 0.0;
    private static double h1 = 0.0;
    private static double h2 = 0.0;
    private static double ml = 0.0;
    private static double mr = 0.0;
    private static double mt = 0.0;
    private static double mb = 0.0;
    private static double d = 0.0;
    private static double h4 = 0.0;
    private static double hp = 0.0;
    private static final double W1 = 0.7;
    private static final double W2 = 0.35;
    private static final double S0 = 2.5;
    private static final double S1 = 3.5;
    private static final double S2 = 5.0;
    private static final double S3 = 7.0;
    private static final String PLACEHOLDER = "%";
    private static final String SCALE = "M 1:%";
    public static final int DINA0 = 0;
    public static final int DINA1 = 1;
    public static final int DINA2 = 2;
    public static final int DINA3 = 3;
    public static final int DINA4 = 4;
    protected static final int DINA5 = 5;
    protected static final int DINA6 = 6;
    public static final List<String> FORMATS = new ArrayList<String>();
    public static final List<String> ORIENTATIONS = new ArrayList<String>();
    private static final double[] PAPER_WIDTH;
    private static final double[] PAPER_HEIGHT;
    private static double pw;
    private static double ph;
    private static final String[] FEATURE_NAMES;
    private static final String[] SUPER_FEATURE_NAMES;

    static {
        FORMATS.add("DINA0");
        FORMATS.add("DINA1");
        FORMATS.add("DINA2");
        FORMATS.add("DINA3");
        FORMATS.add("DINA4");
        ORIENTATIONS.add("PORTRAIT");
        ORIENTATIONS.add("LANDSCAPE");
        PAPER_WIDTH = new double[]{1189.0, 841.0, 594.0, 420.0, 210.0, 148.0, 105.0};
        PAPER_HEIGHT = new double[]{841.0, 594.0, 420.0, 297.0, 297.0, 210.0, 148.0};
        pw = 0.0;
        ph = 0.0;
        FEATURE_NAMES = new String[]{"TITLE_BLOCK.DRAWERS_NAME", "TITLE_BLOCK.DRAWING_DATE", "TITLE_BLOCK.PROVERS_NAME", "TITLE_BLOCK.PROVING_DATE", "TITLE_BLOCK.TITLE", "TITLE_BLOCK.NUMBER", "TITLE_BLOCK.COMPANY", "GEOMETRY.POINT_2D", "GEOMETRY.ANGLE", "TITLE_BLOCK.FORMAT", "TITLE_BLOCK.ORIENTATION", "TITLE_BLOCK.DRAW_PAPER", "TITLE_BLOCK.TAG_REVIEWED", "TITLE_BLOCK.TAG_DRAWN", "TITLE_BLOCK.TAG_DATE", "TITLE_BLOCK.TAG_NAME", "GEOMETRY.FLIP_X_AXIS"};
        SUPER_FEATURE_NAMES = new String[]{"GENERAL.VISIBILITY"};
    }

    public ComponentTitleBlock() {
        this.setInsertPoint(0.0, 0.0);
        this.setAngle(0.0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.m_subVersion == 0) {
            Point2D.Double p = new Point2D.Double(this.m_x, this.m_y);
            CoordSpace cs = CoordSpace.getCoordSpace();
            AffineTransform u2w = cs.getUserToWorldTransform();
            u2w.transform(p, p);
            this.m_x = ((Point2D)p).getX();
            this.m_y = ((Point2D)p).getY();
            this.m_subVersion = 1;
        }
    }

    @Override
    public void assign(Component rhs) {
        ComponentTitleBlock rhsComp = (ComponentTitleBlock)rhs;
        this.m_drawersName = rhsComp.m_drawersName;
        this.m_drawingDate = rhsComp.m_drawingDate;
        this.m_proversName = rhsComp.m_proversName;
        this.m_provingDate = rhsComp.m_provingDate;
        this.m_title = rhsComp.m_title;
        this.m_page = rhsComp.m_page;
        this.m_company = rhsComp.m_company;
        this.m_x = rhsComp.m_x;
        this.m_y = rhsComp.m_y;
        this.m_drawPaper = rhsComp.m_drawPaper;
        this.m_rotated = rhsComp.m_rotated;
        this.m_proven = rhsComp.m_proven;
        this.m_drawn = rhsComp.m_drawn;
        this.m_date = rhsComp.m_date;
        this.m_name = rhsComp.m_name;
        this.m_format = rhsComp.m_format;
        this.m_angle = rhsComp.m_angle;
        this.m_flipX = rhsComp.m_flipX;
        super.assign(rhs);
    }

    public boolean isPaperDrawn() {
        return this.m_drawPaper;
    }

    public void setPaperDrawn(boolean drawPaper) {
        this.m_drawPaper = drawPaper;
        this._notifyWasChanged();
    }

    public String getReviewedTag() {
        return this.m_proven == null ? "Gepr\u221a\u00baft" : this.m_proven;
    }

    public void setReviewedTag(String p) {
        this.m_proven = p;
        this._notifyWasChanged();
    }

    public String getDrawnTag() {
        return this.m_drawn == null ? "Gezeichnet" : this.m_drawn;
    }

    public void setDrawnTag(String p) {
        this.m_drawn = p;
        this._notifyWasChanged();
    }

    public String getDateTag() {
        return this.m_date == null ? "Datum" : this.m_date;
    }

    public void setDateTag(String p) {
        this.m_date = p;
        this._notifyWasChanged();
    }

    public String getNameTag() {
        return this.m_name == null ? "Name" : this.m_name;
    }

    public void setNameTag(String p) {
        this.m_name = p;
        this._notifyWasChanged();
    }

    public String getCompany() {
        return this.m_company;
    }

    public void setCompany(String company) {
        this.m_company = company;
        this._notifyWasChanged();
    }

    public String getDrawersName() {
        return this.m_drawersName;
    }

    public void setDrawersName(String drawersName) {
        this.m_drawersName = drawersName;
        this._notifyWasChanged();
    }

    public String getDrawingDate() {
        return this.m_drawingDate;
    }

    public void setDrawingDate(String drawingDate) {
        this.m_drawingDate = drawingDate;
        this._notifyWasChanged();
    }

    public Point2D getInsertPoint() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double p = new Point2D.Double(this.m_x, this.m_y);
        w2u.transform(p, p);
        return p;
    }

    public void setInsertPoint(double x, double y) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p = new Point2D.Double(x, y);
        u2w.transform(p, p);
        this.m_x = ((Point2D)p).getX();
        this.m_y = ((Point2D)p).getY();
        this._notifyWasChanged();
    }

    public void setInsertPoint(Point2D p) {
        this.setInsertPoint(p.getX(), p.getY());
    }

    public double getAngle() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        return cs.angleToUser(this.m_angle);
    }

    public void setAngle(double angle) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        this.m_angle = cs.angleToWorld(angle);
        this._notifyWasChanged();
    }

    public boolean getFlipX() {
        return this.m_flipX;
    }

    public void setFlipX(boolean flipX) {
        this.m_flipX = flipX;
        this._notifyWasChanged();
    }

    public String getPage() {
        return this.m_page;
    }

    public void setPage(String page) {
        this.m_page = page;
        this._notifyWasChanged();
    }

    public String getProversName() {
        return this.m_proversName;
    }

    public void setProversName(String proversName) {
        this.m_proversName = proversName;
        this._notifyWasChanged();
    }

    public String getProvingDate() {
        return this.m_provingDate;
    }

    public void setProvingDate(String provingDate) {
        this.m_provingDate = provingDate;
        this._notifyWasChanged();
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
        this._notifyWasChanged();
    }

    public void setFormat(String format) throws IllegalArgumentException {
        String _format = format.replaceAll("DINA", "");
        try {
            this.m_format = Integer.parseInt(_format);
            this._notifyWasChanged();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("'" + format + "' is not a legal paper format.");
        }
    }

    public String getFormat() {
        return "DINA" + this.m_format;
    }

    public void setRotated(boolean rotated) {
        this.m_rotated = rotated;
        this._notifyWasChanged();
    }

    public boolean isRotated() {
        return this.m_rotated;
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return new _NamedListIterator<AttributedShape>(this._getShapes());
    }

    @Override
    public NamedListIterator<AttributedText> textIterator() {
        return new _NamedListIterator<AttributedText>(this._getTexts());
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new _ControlPointIterator();
    }

    @Override
    public void transformBy(AffineTransform mat) {
        Point2D o = this.getInsertPoint();
        Vector2D vx = new Vector2D(1.0, 0.0);
        double angle = this.getAngle();
        vx.rotate(angle);
        vx.add(o);
        Point2D ot = mat.transform(o, new Point2D.Double());
        Vector2D vxt = (Vector2D)mat.transform(vx, new Vector2D());
        this.setInsertPoint(ot);
        angle = Math.atan2(vxt.getY() - ot.getY(), vxt.getX() - ot.getX());
        this.setAngle(angle);
        boolean flip = (mat.getType() & 0x40) != 0;
        this.setFlipX(flip ^ this.getFlipX());
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < SUPER_FEATURE_NAMES.length) {
            if (name.equals(SUPER_FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            return new StringFeature(FEATURE_NAMES[0], this.getDrawersName());
        }
        if (name.equals(FEATURE_NAMES[1])) {
            return new StringFeature(FEATURE_NAMES[1], this.getDrawingDate());
        }
        if (name.equals(FEATURE_NAMES[2])) {
            return new StringFeature(FEATURE_NAMES[2], this.getProversName());
        }
        if (name.equals(FEATURE_NAMES[3])) {
            return new StringFeature(FEATURE_NAMES[3], this.getProvingDate());
        }
        if (name.equals(FEATURE_NAMES[4])) {
            return new StringFeature(FEATURE_NAMES[4], this.getTitle());
        }
        if (name.equals(FEATURE_NAMES[5])) {
            return new StringFeature(FEATURE_NAMES[5], this.getPage());
        }
        if (name.equals(FEATURE_NAMES[6])) {
            return new StringFeature(FEATURE_NAMES[6], this.getCompany());
        }
        if (name.equals(FEATURE_NAMES[7])) {
            return new Point2DFeature(FEATURE_NAMES[7], this.getInsertPoint());
        }
        if (name.equals(FEATURE_NAMES[8])) {
            return new AngleFeature(FEATURE_NAMES[8], this.getAngle());
        }
        if (name.equals(FEATURE_NAMES[9])) {
            return new ChoiceFeature(FEATURE_NAMES[9], FORMATS, this.getFormat());
        }
        if (name.equals(FEATURE_NAMES[10])) {
            return new ChoiceFeature(FEATURE_NAMES[10], ORIENTATIONS, this.isRotated() ? "LANDSCAPE" : "PORTRAIT");
        }
        if (name.equals(FEATURE_NAMES[11])) {
            return new BooleanFeature(FEATURE_NAMES[11], this.isPaperDrawn());
        }
        if (name.equals(FEATURE_NAMES[12])) {
            return new StringFeature(FEATURE_NAMES[12], this.getReviewedTag());
        }
        if (name.equals(FEATURE_NAMES[13])) {
            return new StringFeature(FEATURE_NAMES[13], this.getDrawnTag());
        }
        if (name.equals(FEATURE_NAMES[14])) {
            return new StringFeature(FEATURE_NAMES[14], this.getDateTag());
        }
        if (name.equals(FEATURE_NAMES[15])) {
            return new StringFeature(FEATURE_NAMES[15], this.getNameTag());
        }
        if (name.equals(FEATURE_NAMES[16])) {
            return new BooleanFeature(FEATURE_NAMES[16], this.getFlipX());
        }
        if (name.equals(SUPER_FEATURE_NAMES[0])) {
            return super.getFeature(name);
        }
        throw new IllegalArgumentException("No feature " + name);
    }

    @Override
    public void setFeature(Feature feature) {
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            this.setDrawersName(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[1])) {
            this.setDrawingDate(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[2])) {
            this.setProversName(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[3])) {
            this.setProvingDate(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[4])) {
            this.setTitle(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[5])) {
            this.setPage(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[6])) {
            this.setCompany(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[7])) {
            this.setInsertPoint((Point2D)feature.getValue());
        } else if (feature.getName().equals(FEATURE_NAMES[8])) {
            this.setAngle(((AngleFeature)feature).getAngle());
        } else if (feature.getName().equals(FEATURE_NAMES[9])) {
            this.setFormat(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[10])) {
            this.setRotated(feature.valueToString().equals("LANDSCAPE"));
        } else if (feature.getName().equals(FEATURE_NAMES[11])) {
            this.setPaperDrawn(((BooleanFeature)feature).getBoolean());
        } else if (feature.getName().equals(FEATURE_NAMES[12])) {
            this.setReviewedTag(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[13])) {
            this.setDrawnTag(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[14])) {
            this.setDateTag(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[15])) {
            this.setNameTag(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[16])) {
            this.setFlipX(((BooleanFeature)feature).getBoolean());
        } else if (feature.getName().equals(SUPER_FEATURE_NAMES[0])) {
            super.setFeature(feature);
        } else {
            throw new IllegalArgumentException("Feature not contained");
        }
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itThis = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentTitleBlock.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final Iterator<Feature> itBase = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < SUPER_FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentTitleBlock.this.getFeature(SUPER_FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() | itThis.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itThis.hasNext()) {
                    return (Feature)itThis.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private AttributedShape[] _getShapes() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = cs.getScale();
        double unit = scale / cs.getMillimetersPerNaturalUnit();
        this._calculateParameters(unit);
        double x = this.getInsertPoint().getX();
        double y = this.getInsertPoint().getY();
        double xmin = x + l + mr - pw;
        Path2D.Double path1 = new Path2D.Double();
        this._addRect(path1, x, y, l, h);
        this._addLine(path1, x, y + h1, x + l, y + h1);
        this._addLine(path1, x + l1, y, x + l1, y + h1);
        this._addLine(path1, x + l - l4 - l5, y + h1, x + l - l4 - l5, y + h);
        this._addLine(path1, x + l - l5, y, x + l - l5, y + h1);
        if (this.m_drawPaper) {
            this._addLine(path1, x, y, xmin + ml, y);
            this._addLine(path1, xmin + ml, y, xmin + ml, y + ph - mt - mb);
            this._addLine(path1, xmin + ml, y + ph - mt - mb, x + l, y + ph - mt - mb);
            this._addLine(path1, x + l, y + h, x + l, y + ph - mt - mb);
        }
        Path2D.Double path2 = new Path2D.Double();
        this._addLine(path2, x, y + h - h2, x + l - l4 - l5, y + h - h2);
        this._addLine(path2, x, y + h1 + h2, x + l - l4 - l5, y + h1 + h2);
        this._addLine(path2, x + l1, y + h1, x + l1, y + h);
        this._addLine(path2, x + l1 + l2, y + h1, x + l1 + l2, y + h);
        if (this.m_drawPaper) {
            this._addRect(path2, xmin, y - mb, pw, ph);
            this._addCirc(path2, xmin + ml / 2.0 - d / 2.0, y + hp - h4 / 2.0, d);
            this._addCirc(path2, xmin + ml / 2.0 - d / 2.0, y + hp + h4 / 2.0, d);
            this._addLine(path2, xmin, y + hp, xmin + 0.75 * ml, y + hp);
        }
        double angle = this.getAngle();
        if (this.m_rotated) {
            angle -= 1.5707963267948966;
        }
        AffineTransform at = new AffineTransform();
        Point2D p = this.getInsertPoint();
        at.rotate(angle, p.getX(), p.getY());
        if (this.m_flipX) {
            at.translate(p.getX(), p.getY());
            at.concatenate(FLIP_X);
            at.translate(-p.getX(), -p.getY());
        }
        ((Path2D)path1).transform(at);
        ((Path2D)path2).transform(at);
        return new AttributedShape[]{this._attributeShape(new AttributedShape(path1), 0.7), this._attributeShape(new AttributedShape(path2), 0.35)};
    }

    private AttributedText[] _getTexts() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double iScale = cs.getScale();
        double unit = iScale / cs.getMillimetersPerNaturalUnit();
        String scl = SCALE.replaceAll(PLACEHOLDER, "" + iScale);
        if (scl.endsWith(".0")) {
            scl = scl.substring(0, scl.length() - 2);
        }
        this._calculateParameters(unit);
        double x = this.getInsertPoint().getX();
        double y = this.getInsertPoint().getY();
        return new AttributedText[]{this._attributeText(this.getDateTag(), x + l1, y + h1 + 2.0 * h2, x + l1 + l2, y + h1 + 3.0 * h2, 3.5), this._attributeText(this.getNameTag(), x + l1 + l2, y + h1 + 2.0 * h2, x + l1 + l2 + l3, y + h1 + 3.0 * h2, 3.5), this._attributeText(this.getDrawnTag(), x, y + h1 + h2, x + l1, y + h1 + 2.0 * h2, 3.5), this._attributeText(this.getDrawingDate(), x + l1, y + h1 + h2, x + l1 + l2, y + h1 + 2.0 * h2, 3.5), this._attributeText(this.getDrawersName(), x + l1 + l2, y + h1 + h2, x + l1 + l2 + l3, y + h1 + 2.0 * h2, 3.5), this._attributeText(this.getReviewedTag(), x, y + h1, x + l1, y + h1 + h2, 3.5), this._attributeText(this.getProvingDate(), x + l1, y + h1, x + l1 + l2, y + h1 + h2, 3.5), this._attributeText(this.getProversName(), x + l1 + l2, y + h1, x + l1 + l2 + l3, y + h1 + h2, 3.5), this._attributeText(this.getCompany(), x + l - l4 - l5, y + h1, x + l, y + h1 + 3.0 * h2, 5.0), this._attributeText(scl, x, y, x + l1, y + h1, 5.0), this._attributeText(this.getTitle(), x + l1, y, x + l - l5, y + h1, 7.0), this._attributeText(this.getPage(), x + l - l5, y, x + l, y + h1, 7.0), this._attributeText("cademia.org", x + l - 0.7 * unit, y + 0.7 * unit, x + l - 0.7 * unit, y + 0.7 * unit, 2.5, 11)};
    }

    private void _calculateParameters(double unit) {
        l = 183.0 * unit;
        l1 = 35.0 * unit;
        l2 = 35.0 * unit;
        l3 = 35.0 * unit;
        l5 = 35.0 * unit;
        l4 = l - (l1 + l2 + l3 + l5);
        h = 40.0 * unit;
        h1 = 19.0 * unit;
        h2 = 7.0 * unit;
        ml = 20.0 * unit;
        mr = 7.0 * unit;
        mt = 7.0 * unit;
        mb = 15.0 * unit;
        ph = PAPER_HEIGHT[this.m_format] * unit;
        d = 5.0 * unit;
        h4 = 80.0 * unit;
        hp = 148.5 * unit - mb;
        pw = PAPER_WIDTH[this.m_format] * unit;
    }

    private void _addRect(Path2D path, double x, double y, double l, double h) {
        path.append(new Rectangle2D.Double(x, y, l, h), false);
    }

    private void _addLine(Path2D path, double x1, double y1, double x2, double y2) {
        path.append(new Line2D.Double(x1, y1, x2, y2), false);
    }

    private void _addCirc(Path2D path, double x, double y, double d) {
        path.append(new Ellipse2D.Double(x, y, d, d), false);
    }

    private AttributedText _attributeText(String text, double x1, double y1, double x2, double y2, double sizeMM) {
        return this._attributeText(text, x1, y1, x2, y2, sizeMM, 4);
    }

    private AttributedText _attributeText(String text, double x1, double y1, double x2, double y2, double sizeMM, int just) {
        if (text == null || "".equals(text)) {
            text = " ";
        }
        AttributedString as = new AttributedString(text);
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = cs.getScale();
        double PT_PER_IN = 72.0;
        double IN_PER_M = 39.37;
        as.addAttribute(TextAttribute.SIZE, new Double(sizeMM * (scale *= 2834.64 / cs.getMillimetersPerNaturalUnit())));
        as.addAttribute(TextAttribute.FAMILY, "sansserif");
        double angle = this.getAngle();
        if (this.m_rotated) {
            angle -= 1.5707963267948966;
        }
        Point2D.Double p = new Point2D.Double(0.5 * (x1 + x2), 0.5 * (y1 + y2));
        Point2D pp = this.getInsertPoint();
        AffineTransform rot = AffineTransform.getRotateInstance(angle, pp.getX(), pp.getY());
        if (this.m_flipX) {
            rot.translate(pp.getX(), pp.getY());
            rot.concatenate(FLIP_X);
            rot.translate(-pp.getX(), -pp.getY());
        }
        rot.transform(p, p);
        AffineTransform at = AffineTransform.getTranslateInstance(((Point2D)p).getX(), ((Point2D)p).getY());
        at.rotate(angle);
        if (this.m_flipX) {
            at.concatenate(FLIP_X);
        }
        AttributedText t = new AttributedText(as, at);
        t.setJustification(just);
        t.setDrawPaint(Color.BLACK);
        t.setFillPaint(Color.BLACK);
        return t;
    }

    private AttributedShape _attributeShape(AttributedShape as, double widthMM) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double mmPerNU = cs.getMillimetersPerNaturalUnit();
        double scale = cs.getScale();
        double width = widthMM * scale / mmPerNU;
        BasicStroke stroke = new BasicStroke((float)width);
        as.setStroke(stroke);
        as.setDrawPaint(Color.BLACK);
        as.setFillPaint(null);
        return as;
    }

    private class _ControlPointIterator
    extends NamedListIteratorAdapter<Point2D> {
        private _ControlPointIterator() {
        }

        @Override
        protected int _size() {
            return 1;
        }

        @Override
        protected Point2D _get(int index) {
            this._checkIndex(index);
            return ComponentTitleBlock.this.getInsertPoint();
        }

        @Override
        protected void _set(int index, Point2D p) {
            this._checkIndex(index);
            this._checkValue(p);
            ComponentTitleBlock.this.setInsertPoint(p);
        }

        private void _checkIndex(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Illegal index '" + index + "'.");
            }
        }

        private void _checkValue(Point2D value) {
            if (value == null) {
                throw new IllegalArgumentException("Insert point must not be null.");
            }
            if (!(value instanceof Point2D)) {
                throw new IllegalArgumentException("Value must be instance of Point2D.");
            }
        }
    }

    private static class _NamedListIterator<E>
    extends NamedListIteratorAdapter<E> {
        private E[] m_obj = null;

        private _NamedListIterator(E[] obj) {
            this.m_obj = obj;
        }

        @Override
        protected int _size() {
            return this.m_obj.length;
        }

        @Override
        protected E _get(int index) {
            return this.m_obj[index];
        }
    }
}

