/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.AddableFeatures;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentGroup;
import cib.cad.db.comp.ComponentText2D;
import cib.cad.db.comp.ComponentText2DFeature;
import cib.cad.ext.dxf.ImportArc;
import cib.cad.ext.dxf.ImportAttributes;
import cib.cad.ext.dxf.ImportCircle;
import cib.cad.ext.dxf.ImportEllipse;
import cib.cad.ext.dxf.ImportHatch;
import cib.cad.ext.dxf.ImportLType;
import cib.cad.ext.dxf.ImportLWPolyline;
import cib.cad.ext.dxf.ImportLayer;
import cib.cad.ext.dxf.ImportLine;
import cib.cad.ext.dxf.ImportMText;
import cib.cad.ext.dxf.ImportPolyline;
import cib.cad.ext.dxf.ImportSolid;
import cib.cad.ext.dxf.ImportStyle;
import cib.cad.ext.dxf.ImportText;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.dxf.AttributesAdapter;
import cib.util.dxf.ContentHandlerAdapter;
import cib.util.dxf.DXFReader;
import cib.util.dxf.GroupCode;
import cib.util.dxf.ObjectCoordinateSystem;
import cib.util.dxf.QuitDXFParserException;
import cib.util.dxf.interpreter.ParseException;
import cib.util.geo.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DXFImporter {
    private static final AffineTransform FLIP_X = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
    private double m_mmPerNaturalUnit = Double.NaN;
    private Map<String, Integer> m_transferredElements = new HashMap<String, Integer>();
    private Map<String, Integer> m_notTransferredElements = new HashMap<String, Integer>();

    public DXFImporter() {
    }

    public DXFImporter(double mm) {
        this.m_mmPerNaturalUnit = mm;
    }

    public void setMillimetersPerNaturalUnit(double mm) {
        this.m_mmPerNaturalUnit = mm;
    }

    public double getMillimetersPerNaturalUnit() {
        return this.m_mmPerNaturalUnit;
    }

    public void importFromFile(File file) throws IOException, QuitDXFParserException, ParseException {
        final Kernel krnl = Kernel.getInstance();
        DXFReader myDXFReader = new DXFReader();
        myDXFReader.addContentHandler(new ContentHandlerAdapter(){
            private String m_section = null;
            private Map<String, cib.util.dxf.Attributes> m_styles = new HashMap<String, cib.util.dxf.Attributes>();
            private int m_insertRecursionDepth = 0;
            private AffineTransform m_insertTransform = new AffineTransform();
            private ComponentGroup m_insertGroup = null;
            private int m_insertColumnCount = 0;
            private int m_insertRowCount = 0;
            private Vector2D m_insertVecX = new Vector2D();
            private Vector2D m_insertVecY = new Vector2D();
            private String m_currentBlockName = null;
            private Map<String, List<cib.util.dxf.Attributes>> m_blocks = new HashMap<String, List<cib.util.dxf.Attributes>>();
            private Stack<String> m_seqName = new Stack();
            private boolean m_containsLayout = false;
            private boolean m_importLayout = false;
            private double m_linetypeScale = 1.0;
            private List<cib.util.dxf.Attributes> m_polylineAttributes = new ArrayList<cib.util.dxf.Attributes>();

            @Override
            public void startSection(String section) {
                this.m_section = section;
            }

            @Override
            public void endSection(String section) {
                if (section.equals("HEADER") && this.m_containsLayout) {
                    this.m_importLayout = krnl.readYesNo(Messages.getString("ext.dxf.ImportDXF.11"), 19);
                }
            }

            @Override
            public void startBlock(String name, cib.util.dxf.Attributes atts) {
                this.m_currentBlockName = atts.getValue(GroupCode.GC2);
                ArrayList<cib.util.dxf.Attributes> listOfAtts = new ArrayList<cib.util.dxf.Attributes>();
                listOfAtts.add(atts);
                this.m_blocks.put(this.m_currentBlockName, listOfAtts);
            }

            @Override
            public void endBlock(String name, cib.util.dxf.Attributes atts) {
            }

            @Override
            public void startElement(String name, cib.util.dxf.Attributes atts) {
                if (this.m_section.equals("HEADER")) {
                    if (name.equals("$TILEMODE")) {
                        this.m_containsLayout = atts.getIntValue(GroupCode.GC70) == 0;
                    } else if (name.equals("$LTSCALE")) {
                        this.m_linetypeScale = atts.getDoubleValue(GroupCode.GC40);
                    }
                } else if (this.m_section.equals("TABLES")) {
                    if (name.startsWith("STYLE@")) {
                        try {
                            String styleName = ImportStyle.create(krnl, atts);
                            this.m_styles.put(styleName, atts);
                        }
                        catch (CmdAbortedException e) {
                            throw new QuitDXFParserException();
                        }
                    } else if (name.startsWith("LTYPE@")) {
                        ImportLType.create(krnl, atts, this.m_linetypeScale);
                    } else if (name.startsWith("LAYER@")) {
                        ImportLayer.create(krnl, atts);
                    }
                } else if (this.m_section.equals("BLOCKS")) {
                    List<cib.util.dxf.Attributes> attrList = this.m_blocks.get(this.m_currentBlockName);
                    attrList.add(atts);
                } else if (this.m_section.equals("ENTITIES")) {
                    if (!this.m_importLayout) {
                        boolean paperSpaceEntity;
                        boolean bl = paperSpaceEntity = 1 == atts.getIntValue(GroupCode.GC67, 0);
                        if (paperSpaceEntity) {
                            return;
                        }
                    }
                    Database db = krnl.getDatabase();
                    ObservableSet<Component> cmpSet = db.getComponentSet();
                    NameSpace ns = db.getNameSpace();
                    String type = atts.getValue(GroupCode.GC0);
                    if (type.equals("ARC")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportArc.create(krnl, atts);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("ATTDEF")) {
                        int val70 = atts.getIntValue(GroupCode.GC70);
                        if ((val70 & 1) == 0 && (val70 & 2) != 0) {
                            DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                            ComponentText2D comp = ImportText.create(krnl, atts, this.m_styles);
                            comp.transformBy(this.m_insertTransform);
                            if (!ns.containsName(name)) {
                                ns.put(comp, name);
                            }
                            cmpSet.add(comp);
                            ImportAttributes.apply(krnl, comp, atts);
                        }
                    } else if (type.equals("ATTRIB")) {
                        if ((1 & atts.getIntValue(GroupCode.GC70)) == 0) {
                            ComponentGroup af;
                            DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                            ComponentText2D comp = ImportText.create(krnl, atts, this.m_styles);
                            comp.transformBy(this.m_insertTransform);
                            if (!ns.containsName(name)) {
                                ns.put(comp, name);
                            }
                            cmpSet.add(comp);
                            ImportAttributes.apply(krnl, comp, atts);
                            if (this.m_insertGroup != null && this.m_insertGroup instanceof AddableFeatures && !(af = this.m_insertGroup).hasFeature(name)) {
                                cmpSet.remove(comp);
                                ComponentText2DFeature feature = new ComponentText2DFeature(name, comp.getAttributedString(), comp.getTransform());
                                af.addFeature(feature);
                            }
                        }
                    } else if (type.equals("CIRCLE")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportCircle.create(krnl, atts);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("ELLIPSE")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportEllipse.create(krnl, atts);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("HATCH")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportHatch.create(krnl, atts);
                        String fill = comp.getAttributes().getFillPaint();
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                        Attributes attr = comp.getAttributes();
                        attr.setFillPaint(fill);
                        comp.setAttributes(attr);
                    } else if (type.equals("LINE")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportLine.create(krnl, atts);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("LWPOLYLINE")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportLWPolyline.create(krnl, atts);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("POLYLINE")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        this.m_polylineAttributes.clear();
                        this.m_polylineAttributes.add(atts);
                    } else if (type.equals("VERTEX")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        this.m_polylineAttributes.add(atts);
                    } else if (type.equals("SOLID")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportSolid.create(krnl, atts);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("TEXT")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        ComponentText2D comp = ImportText.create(krnl, atts, this.m_styles);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("MTEXT")) {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        Component comp = ImportMText.create(krnl, atts, this.m_styles);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                    } else if (type.equals("INSERT")) {
                        double y;
                        double x;
                        boolean flipped;
                        ++this.m_insertRecursionDepth;
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        String blockName = atts.getValue(GroupCode.GC2);
                        List<cib.util.dxf.Attributes> listOfAtts = this.m_blocks.get(blockName);
                        if (listOfAtts == null) {
                            throw new QuitDXFParserException(String.valueOf(Messages.getString("ext.dxf.DXFImporter.10")) + blockName);
                        }
                        AffineTransform previousInsertTransform = new AffineTransform(this.m_insertTransform);
                        cib.util.dxf.Attributes blockAtts = listOfAtts.get(0);
                        double basex = blockAtts.getDoubleValue(GroupCode.GC10);
                        double basey = blockAtts.getDoubleValue(GroupCode.GC20);
                        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
                        double _tx = atts.getDoubleValue(GroupCode.GC10);
                        double _ty = atts.getDoubleValue(GroupCode.GC20);
                        double _tz = atts.getDoubleValue(GroupCode.GC30, 0.0);
                        double tx = ocs.getXinWCS(_tx, _ty, _tz);
                        double ty = ocs.getYinWCS(_tx, _ty, _tz);
                        double sx = atts.getDoubleValue(GroupCode.GC41, 1.0);
                        double sy = atts.getDoubleValue(GroupCode.GC42, 1.0);
                        double theta = Math.toRadians(atts.getDoubleValue(GroupCode.GC50, 0.0));
                        boolean bl = flipped = ocs.getZinWCS(0.0, 0.0, 1.0) < 0.0;
                        if (flipped) {
                            x = ocs.getXinWCS(-1.0, 0.0, 0.0);
                            y = ocs.getYinWCS(-1.0, 0.0, 0.0);
                            Vector2D minusXVec = new Vector2D(-1.0, 0.0);
                            double locTheta = minusXVec.getAngleCCW(new Vector2D(x, y));
                            theta = -theta + locTheta;
                        } else {
                            x = ocs.getXinWCS(1.0, 0.0, 0.0);
                            y = ocs.getYinWCS(1.0, 0.0, 0.0);
                            double locTheta = Vector2D.X_UNIT.getAngleCCW(new Vector2D(x, y));
                            theta += locTheta;
                        }
                        AffineTransform mat = new AffineTransform();
                        mat.translate(tx, ty);
                        mat.rotate(theta);
                        mat.scale(sx, sy);
                        if (flipped) {
                            mat.concatenate(FLIP_X);
                        }
                        mat.translate(-basex, -basey);
                        this.m_insertGroup = new ComponentGroup(1);
                        this.m_insertGroup.setPlacementPoint(new Point2D.Double(tx, ty));
                        cmpSet.add(this.m_insertGroup);
                        krnl.openGroup(this.m_insertGroup, true);
                        this.m_insertTransform.concatenate(mat);
                        this.m_insertColumnCount = Math.max(1, atts.getIntValue(GroupCode.GC70, 1));
                        this.m_insertRowCount = Math.max(1, atts.getIntValue(GroupCode.GC71, 1));
                        double columnSpacing = atts.getDoubleValue(GroupCode.GC44, 0.0);
                        double rowSpacing = atts.getDoubleValue(GroupCode.GC45, 0.0);
                        Point2D.Double origin = new Point2D.Double();
                        Point2D.Double pntX = new Point2D.Double(columnSpacing / sx, 0.0);
                        Point2D.Double pntY = new Point2D.Double(0.0, rowSpacing / sy);
                        this.m_insertTransform.transform(origin, origin);
                        this.m_insertTransform.transform(pntX, pntX);
                        this.m_insertTransform.transform(pntY, pntY);
                        this.m_insertVecX.setLocation(origin, pntX);
                        this.m_insertVecY.setLocation(origin, pntY);
                        int n = listOfAtts.size();
                        int i = 1;
                        while (i < n) {
                            cib.util.dxf.Attributes _atts = listOfAtts.get(i);
                            String _type = _atts.getValue(GroupCode.GC0);
                            String val5 = _atts.getValue(GroupCode.GC5, null);
                            String entityName = String.valueOf(_type) + "@" + val5;
                            if (_type.equals("POLYLINE")) {
                                this.m_seqName.push(entityName);
                                this.startElement(entityName, _atts);
                            } else if (_type.equals("INSERT")) {
                                if (_atts.valueExists(GroupCode.GC66)) {
                                    String val66 = _atts.getValue(GroupCode.GC66);
                                    if (val66.endsWith("1")) {
                                        this.m_seqName.push(entityName);
                                        this.startElement(entityName, _atts);
                                    } else {
                                        this.startElement(entityName, _atts);
                                        this.endElement(entityName);
                                    }
                                } else {
                                    this.startElement(entityName, _atts);
                                    this.endElement(entityName);
                                }
                            } else if (_type.equals("SEQEND")) {
                                if (this.m_seqName.isEmpty()) {
                                    throw new AssertionError((Object)"Unexpected SEQEND in Block");
                                }
                                String seqName = this.m_seqName.pop();
                                this.endElement(seqName);
                            } else {
                                this.startElement(entityName, _atts);
                                this.endElement(entityName);
                            }
                            ++i;
                        }
                        this.m_insertTransform.setTransform(previousInsertTransform);
                        --this.m_insertRecursionDepth;
                        krnl.closeGroup();
                    } else if (type.equals("DIMENSION")) {
                        ++this.m_insertRecursionDepth;
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_transferredElements, type);
                        String blockName = atts.getValue(GroupCode.GC2);
                        List<cib.util.dxf.Attributes> listOfAtts = this.m_blocks.get(blockName);
                        AffineTransform previousInsertTransform = (AffineTransform)this.m_insertTransform.clone();
                        cib.util.dxf.Attributes blockAtts = listOfAtts.get(0);
                        double basex = blockAtts.getDoubleValue(GroupCode.GC10);
                        double basey = blockAtts.getDoubleValue(GroupCode.GC20);
                        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
                        double _tx = atts.getDoubleValue(GroupCode.GC12, 0.0);
                        double _ty = atts.getDoubleValue(GroupCode.GC22, 0.0);
                        double _tz = atts.getDoubleValue(GroupCode.GC32, 0.0);
                        double tx = ocs.getXinWCS(_tx, _ty, _tz);
                        double ty = ocs.getYinWCS(_tx, _ty, _tz);
                        AffineTransform mat = new AffineTransform();
                        mat.translate(tx, ty);
                        mat.translate(-basex, -basey);
                        this.m_insertTransform.concatenate(mat);
                        int n = listOfAtts.size();
                        int i = 1;
                        while (i < n) {
                            cib.util.dxf.Attributes _atts = listOfAtts.get(i);
                            String _type = _atts.getValue(GroupCode.GC0);
                            String val5 = _atts.getValue(GroupCode.GC5, null);
                            String entityName = String.valueOf(_type) + "@" + val5 + "@" + blockName;
                            this.startElement(entityName, _atts);
                            ++i;
                        }
                        this.m_insertTransform = previousInsertTransform;
                        --this.m_insertRecursionDepth;
                    } else {
                        DXFImporter.this.incTypeCount(DXFImporter.this.m_notTransferredElements, type);
                    }
                }
            }

            @Override
            public void endElement(String name) {
                if (this.m_section.equals("BLOCKS")) {
                    if (name.startsWith("POLYLINE")) {
                        List<cib.util.dxf.Attributes> attrList = this.m_blocks.get(this.m_currentBlockName);
                        AttributesAdapter attr = new AttributesAdapter();
                        attr.add(GroupCode.GC0, "SEQEND");
                        attrList.add(attr);
                    }
                } else if (this.m_section.equals("ENTITIES")) {
                    if (name.startsWith("POLYLINE")) {
                        Database db = krnl.getDatabase();
                        ObservableSet<Component> cmpSet = db.getComponentSet();
                        NameSpace ns = db.getNameSpace();
                        if (this.m_polylineAttributes.size() < 1) {
                            return;
                        }
                        cib.util.dxf.Attributes atts = this.m_polylineAttributes.get(0);
                        Component comp = ImportPolyline.create(krnl, this.m_polylineAttributes);
                        comp.transformBy(this.m_insertTransform);
                        if (!ns.containsName(name)) {
                            ns.put(comp, name);
                        }
                        cmpSet.add(comp);
                        ImportAttributes.apply(krnl, comp, atts);
                        this.m_polylineAttributes.clear();
                    } else if (name.startsWith("INSERT")) {
                        Database db = krnl.getDatabase();
                        ObservableSet<Component> cmpSet = db.getComponentSet();
                        int ix = 0;
                        while (ix < this.m_insertColumnCount) {
                            Component compRow = this.m_insertGroup;
                            if (ix > 0) {
                                compRow = (Component)this.m_insertGroup.clone();
                                AffineTransform mat = AffineTransform.getTranslateInstance((double)ix * this.m_insertVecX.x, (double)ix * this.m_insertVecX.y);
                                compRow.transformBy(mat);
                                cmpSet.add(compRow);
                            }
                            int iy = 1;
                            while (iy < this.m_insertRowCount) {
                                Component compColumn = (Component)compRow.clone();
                                AffineTransform mat = AffineTransform.getTranslateInstance((double)iy * this.m_insertVecY.x, (double)iy * this.m_insertVecY.y);
                                compColumn.transformBy(mat);
                                cmpSet.add(compColumn);
                                ++iy;
                            }
                            ++ix;
                        }
                        this.m_insertGroup = null;
                    }
                }
            }
        });
        CoordSpace cs = CoordSpace.getCoordSpace();
        double mmPerNaturalUnit = cs.getMillimetersPerNaturalUnit();
        if (!Double.isNaN(this.m_mmPerNaturalUnit)) {
            cs.setMillimetersPerNaturalUnit(this.m_mmPerNaturalUnit, null, true);
        }
        AttributeManager am = AttributeManager.getAttributeManager();
        Attributes svDefAttributes = am.getDefaultAttributes();
        am.setDefaultAttributes(new Attributes());
        try {
            FileInputStream myStream = null;
            InputStreamReader myReader = null;
            myStream = new FileInputStream(file);
            myReader = new InputStreamReader((InputStream)myStream, "ISO-8859-1");
            myDXFReader.parse(myReader);
        }
        finally {
            am.setDefaultAttributes(svDefAttributes);
            if (!Double.isNaN(this.m_mmPerNaturalUnit)) {
                cs.setMillimetersPerNaturalUnit(mmPerNaturalUnit, null, true);
            }
        }
    }

    public Map<String, Integer> getImportedInstanceCounts() {
        return this.m_transferredElements;
    }

    public Map<String, Integer> getUnimportableInstanceCounts() {
        return this.m_notTransferredElements;
    }

    private void incTypeCount(Map<String, Integer> map, String type) {
        Integer i = map.get(type);
        int n = i == null ? 0 : i;
        map.put(type, new Integer(++n));
    }
}

