/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;

public class ImportEllipse {
    public static Component create(Kernel krnl, Attributes atts) {
        double ctrX = atts.getDoubleValue(GroupCode.GC10);
        double ctrY = atts.getDoubleValue(GroupCode.GC20);
        double majorAxisX = atts.getDoubleValue(GroupCode.GC11);
        double majorAxisY = atts.getDoubleValue(GroupCode.GC21);
        double axisRatio = atts.getDoubleValue(GroupCode.GC40);
        double startParameter = atts.getDoubleValue(GroupCode.GC41, 0.0);
        double endParameter = atts.getDoubleValue(GroupCode.GC42, Math.PI * 2);
        double startAngle = Math.toDegrees(startParameter);
        double sweepAngle = Math.toDegrees(endParameter) - startAngle;
        double w2 = Math.sqrt(majorAxisX * majorAxisX + majorAxisY * majorAxisY);
        double h2 = w2 * axisRatio;
        Arc2D.Double arc = new Arc2D.Double(ctrX - w2, ctrY - h2, w2 + w2, h2 + h2, -startAngle, -sweepAngle, 0);
        ComponentPath2D comp = new ComponentPath2D();
        AffineTransform trf = AffineTransform.getTranslateInstance(-ctrX, -ctrY);
        double theta = Math.atan2(majorAxisY, majorAxisX);
        trf.preConcatenate(AffineTransform.getRotateInstance(theta));
        trf.preConcatenate(AffineTransform.getTranslateInstance(ctrX, ctrY));
        double[] crds = new double[6];
        PathIterator pit = arc.getPathIterator(trf);
        while (!pit.isDone()) {
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: {
                    comp.moveTo(crds[0], crds[1]);
                    break;
                }
                case 1: {
                    comp.lineTo(crds[0], crds[1]);
                    break;
                }
                case 2: {
                    comp.quadTo(crds[0], crds[1], crds[2], crds[3]);
                    break;
                }
                case 3: {
                    comp.cubicTo(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                    break;
                }
                case 4: {
                    comp.close();
                    break;
                }
                default: {
                    throw new InternalError(Messages.getString("ext.dxf.ImportEllipse.0"));
                }
            }
            pit.next();
        }
        return comp;
    }
}

