/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.DefaultFillPaint;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.dxf.Attributes;
import cib.util.dxf.ColorNumber;
import cib.util.dxf.GroupCode;
import cib.util.dxf.ObjectCoordinateSystem;
import cib.util.geo.Geo2D;
import cib.util.geo.Path2D;
import cib.util.geo.Vector2D;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class ImportHatch {
    public static Component create(Kernel krnl, Attributes atts) {
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        AttributeManager atm = db.getAttributeManager();
        ComponentPath2D comp = new ComponentPath2D();
        cib.cad.db.att.Attributes attr = comp.getAttributes();
        if (attr == null) {
            attr = new cib.cad.db.att.Attributes();
        }
        Paint fillPaint = Color.LIGHT_GRAY;
        String fillPaintName = atts.getValue(GroupCode.GC2);
        if (atts.getIntValue(GroupCode.GC70) == 0) {
            cib.cad.db.att.Attributes attributes = new cib.cad.db.att.Attributes();
            attributes.set("DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT", "DEFAULT");
            DefaultFillPaint fp = new DefaultFillPaint(null, 5.0, 5.0);
            Path2D path = new Path2D();
            path.moveTo(0.0, 0.0);
            path.lineTo(5.0, 5.0);
            fp.add(path, attributes);
            path = new Path2D();
            path.moveTo(0.0, -5.0);
            path.lineTo(10.0, 5.0);
            fp.add(path, attributes);
            path = new Path2D();
            path.moveTo(-5.0, 0.0);
            path.lineTo(5.0, 10.0);
            fp.add(path, attributes);
            fillPaint = fp;
        } else {
            int colorNumber;
            cib.cad.db.att.Attributes layerAttr;
            String layerName = atts.getValue(GroupCode.GC8);
            Layer layer = (Layer)ns.getObject(layerName);
            if (layer != null && (layerAttr = layer.getAttributes()) != null) {
                String drawPaintName = layerAttr.getDrawPaint();
                fillPaint = atm.getDrawPaint(drawPaintName);
                fillPaintName = drawPaintName;
            }
            if (atts.valueExists(GroupCode.GC62) && (colorNumber = atts.getIntValue(GroupCode.GC62)) > 0 && colorNumber < 256) {
                fillPaintName = "COLOR_" + colorNumber;
                fillPaint = ColorNumber.valueOf(fillPaintName).toColor();
            }
        }
        if (!atm.containsFillPaint(fillPaintName)) {
            atm.addFillPaint(fillPaintName, fillPaint);
        }
        attr.setFillPaint(fillPaintName);
        int iLoop = 0;
        int i = 0;
        while (i < atts.size()) {
            if (atts.getGroupCodeAt(i) == GroupCode.GC91) {
                int nLoops = atts.getIntValueAt(i);
                ++i;
                while (i < atts.size() && iLoop < nLoops) {
                    if (atts.getGroupCodeAt(i) == GroupCode.GC92) {
                        int boundaryPathType = atts.getIntValueAt(i);
                        boolean isPolyline = (boundaryPathType & 2) != 0;
                        i = isPolyline ? ImportHatch.addBoundaryFromPolyline(i, comp, atts) : ImportHatch.addBoundaryFromSegments(i, comp, atts);
                        ++iLoop;
                    }
                    ++i;
                }
            }
            ++i;
        }
        comp.setAttributes(attr);
        return comp;
    }

    private static int addBoundaryFromPolyline(int i, ComponentPath2D comp, Attributes atts) {
        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
        double elevation = atts.getDoubleValue(GroupCode.GC30, 0.0);
        boolean hasBulge = false;
        boolean isClosed = false;
        int nVertices = 0;
        while (i < atts.size() && atts.getGroupCodeAt(i) != GroupCode.GC10) {
            if (atts.getGroupCodeAt(i) == GroupCode.GC72) {
                boolean bl = hasBulge = atts.getIntValueAt(i) == 1;
            }
            if (atts.getGroupCodeAt(i) == GroupCode.GC73) {
                boolean bl = isClosed = atts.getIntValueAt(i) == 1;
            }
            if (atts.getGroupCodeAt(i) == GroupCode.GC93) {
                nVertices = atts.getIntValueAt(i);
            }
            ++i;
        }
        double firstX = Double.NaN;
        double firstY = Double.NaN;
        double lastX = Double.NaN;
        double lastY = Double.NaN;
        double lastBulge = Double.NaN;
        int iVertex = 0;
        while (i < atts.size() && iVertex < nVertices) {
            if (atts.getGroupCodeAt(i) == GroupCode.GC10) {
                double bulge;
                double _x = atts.getDoubleValueAt(i);
                if (atts.getGroupCodeAt(i + 1) != GroupCode.GC20) {
                    throw new InternalError(Messages.getString("ext.dxf.ImportHatch.9"));
                }
                double _y = atts.getDoubleValueAt(++i);
                double x = ocs.getXinWCS(_x, _y, elevation);
                double y = ocs.getYinWCS(_x, _y, elevation);
                double d = bulge = hasBulge && atts.getGroupCodeAt(i + 1) == GroupCode.GC42 ? atts.getDoubleValueAt(++i) : 0.0;
                if (Double.isNaN(lastX)) {
                    comp.moveTo(x, y);
                    firstX = x;
                    firstY = y;
                } else if (Math.abs(lastBulge) < Geo2D.getEps()) {
                    comp.lineTo(x, y);
                } else {
                    double dx = x - lastX;
                    double dy = y - lastY;
                    double l = Math.sqrt(dx * dx + dy * dy);
                    if (l > 10.0 * Geo2D.getEps()) {
                        double h = 0.5 * lastBulge * l;
                        Vector2D v12 = new Vector2D(lastX, lastY, x, y);
                        Vector2D vp = new Vector2D(v12);
                        vp.normalize();
                        vp.right();
                        v12.scaleBy(0.5);
                        vp.scaleBy(h);
                        v12.add(vp);
                        comp.arcTo(lastX + v12.x, lastY + v12.y, x, y);
                    }
                }
                lastX = x;
                lastY = y;
                lastBulge = bulge;
            }
            ++i;
            ++iVertex;
        }
        if (isClosed && !Double.isNaN(firstX)) {
            comp.lineTo(firstX, firstY);
        }
        return i;
    }

    private static int addBoundaryFromSegments(int i, ComponentPath2D comp, Attributes atts) {
        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
        double elevation = atts.getDoubleValue(GroupCode.GC30, 0.0);
        int nEdges = 0;
        while (i < atts.size() && atts.getGroupCodeAt(i) != GroupCode.GC72) {
            if (atts.getGroupCodeAt(i) == GroupCode.GC93) {
                nEdges = atts.getIntValueAt(i);
            }
            ++i;
        }
        int iEdge = 0;
        while (i < atts.size() && iEdge < nEdges) {
            if (atts.getGroupCodeAt(i) == GroupCode.GC72) {
                ++iEdge;
                switch (atts.getIntValueAt(i)) {
                    case 1: {
                        double _x1 = atts.getDoubleValueAt(++i);
                        double _y1 = atts.getDoubleValueAt(++i);
                        double _x2 = atts.getDoubleValueAt(++i);
                        double _y2 = atts.getDoubleValueAt(++i);
                        double x1 = ocs.getXinWCS(_x1, _y1, elevation);
                        double y1 = ocs.getYinWCS(_x1, _y1, elevation);
                        double x2 = ocs.getXinWCS(_x2, _y2, elevation);
                        double y2 = ocs.getYinWCS(_x2, _y2, elevation);
                        ImportHatch._moveTo(comp, x1, y1);
                        comp.lineTo(x2, y2);
                        break;
                    }
                    case 2: {
                        double sweepAngle;
                        double cx = atts.getDoubleValueAt(++i);
                        double cy = atts.getDoubleValueAt(++i);
                        double radius = atts.getDoubleValueAt(++i);
                        double startAngle = atts.getDoubleValueAt(++i);
                        double endAngle = atts.getDoubleValueAt(++i);
                        boolean isCCW = atts.getIntValueAt(++i) != 0;
                        double[] wcrds = new double[3];
                        ocs.toWCS(cx, cy, elevation, wcrds);
                        cx = wcrds[0];
                        cy = wcrds[1];
                        if (isCCW) {
                            sweepAngle = endAngle - startAngle;
                            while (sweepAngle <= 0.0) {
                                sweepAngle += 360.0;
                            }
                        } else {
                            startAngle = -startAngle;
                            sweepAngle = -endAngle - startAngle;
                            while (sweepAngle >= 0.0) {
                                sweepAngle -= 360.0;
                            }
                        }
                        Vector2D va = new Vector2D(Math.toRadians(startAngle));
                        double ax = cx + radius * va.x;
                        double ay = cy + radius * va.y;
                        Vector2D ve = new Vector2D(Math.toRadians(startAngle + sweepAngle));
                        double ex = cx + radius * ve.x;
                        double ey = cy + radius * ve.y;
                        Vector2D varc = new Vector2D(Math.toRadians(startAngle + 0.5 * sweepAngle));
                        double arcx = cx + radius * varc.x;
                        double arcy = cy + radius * varc.y;
                        ImportHatch._moveTo(comp, ax, ay);
                        comp.arcTo(arcx, arcy, ex, ey);
                        break;
                    }
                    case 3: {
                        double sweepAngle;
                        double ctrX = atts.getDoubleValueAt(++i);
                        double ctrY = atts.getDoubleValueAt(++i);
                        double majorAxisX = atts.getDoubleValueAt(++i);
                        double majorAxisY = atts.getDoubleValueAt(++i);
                        double axisRatio = atts.getDoubleValueAt(++i);
                        double startAngle = atts.getDoubleValueAt(++i);
                        double endAngle = atts.getDoubleValueAt(++i);
                        boolean isCCW = atts.getIntValueAt(++i) != 0;
                        double[] wcrds = new double[3];
                        ocs.toWCS(ctrX, ctrY, elevation, wcrds);
                        ctrX = wcrds[0];
                        ctrY = wcrds[1];
                        ocs.toWCS(majorAxisX, majorAxisY, elevation, wcrds);
                        majorAxisX = wcrds[0];
                        majorAxisY = wcrds[1];
                        double w2 = Math.sqrt(majorAxisX * majorAxisX + majorAxisY * majorAxisY);
                        double h2 = w2 * axisRatio;
                        if (isCCW) {
                            sweepAngle = endAngle - startAngle;
                            while (sweepAngle <= 0.0) {
                                sweepAngle += 360.0;
                            }
                        } else {
                            startAngle = -startAngle;
                            sweepAngle = -endAngle - startAngle;
                            while (sweepAngle >= 0.0) {
                                sweepAngle -= 360.0;
                            }
                        }
                        Arc2D.Double arc = new Arc2D.Double(ctrX - w2, ctrY - h2, w2 + w2, h2 + h2, -startAngle, -sweepAngle, 0);
                        AffineTransform trf = AffineTransform.getTranslateInstance(-ctrX, -ctrY);
                        double theta = Math.atan2(majorAxisY, majorAxisX);
                        trf.preConcatenate(AffineTransform.getRotateInstance(theta));
                        trf.preConcatenate(AffineTransform.getTranslateInstance(ctrX, ctrY));
                        double[] crds = new double[6];
                        PathIterator pit = arc.getPathIterator(trf);
                        while (!pit.isDone()) {
                            int seg = pit.currentSegment(crds);
                            switch (seg) {
                                case 0: {
                                    comp.moveTo(crds[0], crds[1]);
                                    break;
                                }
                                case 3: {
                                    comp.cubicTo(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                                    break;
                                }
                                default: {
                                    throw new InternalError(Messages.getString("ext.dxf.ImportHatch.10"));
                                }
                            }
                            pit.next();
                        }
                        break;
                    }
                    case 4: {
                        int degree = atts.getIntValueAt(++i);
                        int rational = atts.getIntValueAt(++i);
                        int periodic = atts.getIntValueAt(++i);
                        int nKnots = atts.getIntValueAt(++i);
                        int nControlPoints = atts.getIntValueAt(++i);
                        double[] knotValues = new double[nKnots];
                        int j = 0;
                        while (j < nKnots) {
                            knotValues[j] = atts.getDoubleValueAt(++i);
                            ++j;
                        }
                        double[] ctrlPointsX = new double[nControlPoints];
                        double[] ctrlPointsY = new double[nControlPoints];
                        double[] weights = new double[nControlPoints];
                        int j2 = 0;
                        while (j2 < nControlPoints) {
                            ctrlPointsX[j2] = atts.getDoubleValueAt(++i);
                            ctrlPointsY[j2] = atts.getDoubleValueAt(++i);
                            weights[j2] = GroupCode.GC42 == atts.getGroupCodeAt(i + 1) ? atts.getDoubleValueAt(++i) : 1.0;
                            ++j2;
                        }
                        System.out.println(Messages.getString("ext.dxf.ImportHatch.11"));
                    }
                }
            }
            ++i;
        }
        return i;
    }

    private static void _moveTo(ComponentPath2D comp, double x, double y) {
        Point2D ep = comp.getEndVertexLocation();
        if (ep == null || !Geo2D.equality(ep.getX(), ep.getY(), x, y)) {
            comp.moveTo(x, y);
        }
    }
}

