/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;
import cib.util.dxf.ObjectCoordinateSystem;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;

public class ImportLWPolyline {
    public static Component create(Kernel krnl, Attributes atts) {
        ComponentPath2D comp = new ComponentPath2D();
        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
        double elevation = atts.getDoubleValue(GroupCode.GC38, 0.0);
        double lastX = Double.NaN;
        double lastY = Double.NaN;
        double lastBulge = Double.NaN;
        double lastStartWidth = 0.0;
        double lastEndWidth = 0.0;
        int nVertices = atts.getIntValue(GroupCode.GC90);
        int i = 0;
        while (i < atts.size()) {
            if (atts.getGroupCodeAt(i) == GroupCode.GC10) {
                double ox = atts.getDoubleValueAt(i);
                if (atts.getGroupCodeAt(i + 1) != GroupCode.GC20) {
                    throw new InternalError(Messages.getString("ext.dxf.ImportLWPolyline.0"));
                }
                double oy = atts.getDoubleValueAt(++i);
                double x = ocs.getXinWCS(ox, oy, elevation);
                double y = ocs.getYinWCS(ox, oy, elevation);
                double startWidth = 0.0;
                double endWidth = 0.0;
                double bulge = 0.0;
                int j = 0;
                while (j < 3) {
                    int k = i + j + 1;
                    if (k >= atts.size() || atts.getGroupCodeAt(k) == GroupCode.GC10) break;
                    if (atts.getGroupCodeAt(k) == GroupCode.GC40) {
                        startWidth = atts.getDoubleValueAt(k);
                    } else if (atts.getGroupCodeAt(k) == GroupCode.GC41) {
                        endWidth = atts.getDoubleValueAt(k);
                    } else if (atts.getGroupCodeAt(k) == GroupCode.GC42) {
                        bulge = atts.getDoubleValueAt(k);
                    }
                    ++j;
                }
                if (Double.isNaN(lastX)) {
                    comp.moveTo(x, y);
                } else if (Math.abs(lastBulge) < Geo2D.getEps()) {
                    comp.lineTo(x, y);
                } else {
                    double dx = x - lastX;
                    double dy = y - lastY;
                    double l = Math.sqrt(dx * dx + dy * dy);
                    if (l > 10.0 * Geo2D.getEps()) {
                        double h = 0.5 * lastBulge * l;
                        Vector2D v12 = new Vector2D(lastX, lastY, x, y);
                        Vector2D vp = new Vector2D(v12);
                        vp.normalize();
                        vp.right();
                        v12.scaleBy(0.5);
                        vp.scaleBy(h);
                        v12.add(vp);
                        comp.arcTo(lastX + v12.x, lastY + v12.y, x, y);
                    }
                }
                lastX = x;
                lastY = y;
                lastBulge = bulge;
                lastStartWidth = startWidth;
                lastEndWidth = endWidth;
            }
            ++i;
        }
        if (atts.getIntValue(GroupCode.GC70, 0) == 1) {
            comp.close();
        }
        return comp;
    }
}

