/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.Kernel;
import cib.util.dxf.ColorNumber;
import cib.util.dxf.GroupCode;
import cib.util.dxf.ObjectCoordinateSystem;
import java.awt.Color;

public class ImportSolid {
    public static Component create(Kernel krnl, cib.util.dxf.Attributes atts) {
        int colorNumber;
        ComponentPath2D comp = new ComponentPath2D();
        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
        double x = atts.getDoubleValue(GroupCode.GC10);
        double y = atts.getDoubleValue(GroupCode.GC20);
        double z = atts.getDoubleValue(GroupCode.GC30, 0.0);
        comp.moveTo(ocs.getXinWCS(x, y, z), ocs.getYinWCS(x, y, z));
        x = atts.getDoubleValue(GroupCode.GC11);
        y = atts.getDoubleValue(GroupCode.GC21);
        z = atts.getDoubleValue(GroupCode.GC31, 0.0);
        comp.lineTo(ocs.getXinWCS(x, y, z), ocs.getYinWCS(x, y, z));
        x = atts.getDoubleValue(GroupCode.GC13);
        y = atts.getDoubleValue(GroupCode.GC23);
        z = atts.getDoubleValue(GroupCode.GC33, 0.0);
        comp.lineTo(ocs.getXinWCS(x, y, z), ocs.getYinWCS(x, y, z));
        x = atts.getDoubleValue(GroupCode.GC12);
        y = atts.getDoubleValue(GroupCode.GC22);
        z = atts.getDoubleValue(GroupCode.GC32, 0.0);
        comp.lineTo(ocs.getXinWCS(x, y, z), ocs.getYinWCS(x, y, z));
        comp.close();
        Database db = krnl.getDatabase();
        AttributeManager atm = db.getAttributeManager();
        Attributes attr = new Attributes();
        Color fillPaint = Color.BLACK;
        String fillPaintName = "COLOR_0";
        if (atts.valueExists(GroupCode.GC62) && (colorNumber = atts.getIntValue(GroupCode.GC62)) > 0 && colorNumber < 256) {
            fillPaintName = "COLOR_" + colorNumber;
            fillPaint = ColorNumber.valueOf(fillPaintName).toColor();
        }
        if (!atm.containsFillPaint(fillPaintName)) {
            atm.addFillPaint(fillPaintName, fillPaint);
        }
        attr.setFillPaint(fillPaintName);
        comp.setAttributes(attr);
        return comp;
    }
}

