/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentLine2D;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.ext.mod.Fillet;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import cib.util.geo.NoIntersectionException;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Chamfer
extends Fillet {
    private static final int MODE_DIST1_DIST2 = 0;
    private static final int MODE_DIST1_ANGLE = 1;
    private static final int MODE_DIST2_ANGLE = 2;
    private static int s_chamferMode = 0;
    private static double[][] s_chamferValues = new double[][]{{1.0, 1.0}, {0.0, 1.5707963267948966}, {0.0, 1.5707963267948966}};
    private int m_chamferedCorners = 0;
    private transient Object m_input;

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        int nEndVertices = 0;
        int nInnerVertices = 0;
        for (Component comp : selSet) {
            if (!mm.hasMarkedPrimitives(comp, 2) || !(comp instanceof CtrlSegments)) continue;
            CtrlSegments ctrlSeg = (CtrlSegments)comp;
            NamedListIterator<Point2D> pit = comp.controlPointIterator();
            while (pit.hasNext()) {
                pit.next();
                int index = pit.previousIndex();
                int name = pit.previousName();
                if (!mm.primitiveMarked(comp, 2, index) || ctrlSeg.getCtrlType(name) != 2) continue;
                int nSegs = ctrlSeg.getVertexSegmentCount(name);
                if (nSegs == 1) {
                    int segName = ctrlSeg.getVertexSegmentAt(name, 0);
                    int segType = ctrlSeg.getCtrlType(segName);
                    if (segType != 8) continue;
                    ++nEndVertices;
                    continue;
                }
                if (nSegs != 2) continue;
                int segName0 = ctrlSeg.getVertexSegmentAt(name, 0);
                int segName1 = ctrlSeg.getVertexSegmentAt(name, 1);
                int segType0 = ctrlSeg.getCtrlType(segName0);
                int segType1 = ctrlSeg.getCtrlType(segName1);
                if (segType0 == 8 && segType1 == 8) {
                    ++nInnerVertices;
                    continue;
                }
                if (segType0 == 4 && segType1 == 8) {
                    ++nEndVertices;
                    continue;
                }
                if (segType1 != 4 || segType0 != 8) continue;
                ++nEndVertices;
            }
        }
        return nInnerVertices > 0 || nEndVertices > 0 && nEndVertices % 2 == 0;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        double[] crds = new double[8];
        ArrayList<Fillet.Vertex> endVertices = new ArrayList<Fillet.Vertex>();
        ArrayList<Fillet.Vertex> innerVertices = new ArrayList<Fillet.Vertex>();
        if (!this._analyseSelectedVertices(endVertices, innerVertices, 8)) {
            return;
        }
        this._promptForChamferValues();
        int nBadCorners = 0;
        int nUnsupportedCorners = 0;
        int i = 0;
        while (i < endVertices.size()) {
            Object vtx1 = (Fillet.Vertex)endVertices.get(i);
            Object vtx2 = (Fillet.Vertex)endVertices.get(i + 1);
            int seg1 = ((Fillet.Vertex)vtx1).extendableSegments.get(0);
            int seg2 = ((Fillet.Vertex)vtx2).extendableSegments.get(0);
            block0 : switch (((Fillet.Vertex)vtx1).getCtrlSeg().getCtrlType(seg1)) {
                case 8: {
                    if (8 != ((Fillet.Vertex)vtx1).getCtrlSeg().getSegmentCrds(seg1, crds)) {
                        throw new InternalError();
                    }
                    Line2D.Double l1 = new Line2D.Double();
                    if (((Fillet.Vertex)vtx1).name == ((Fillet.Vertex)vtx1).getCtrlSeg().getSegmentVertex1(seg1)) {
                        ((Line2D)l1).setLine(crds[0], crds[1], crds[2], crds[3]);
                    } else if (((Fillet.Vertex)vtx1).name == ((Fillet.Vertex)vtx1).getCtrlSeg().getSegmentVertex2(seg1)) {
                        ((Line2D)l1).setLine(crds[2], crds[3], crds[0], crds[1]);
                    } else {
                        throw new InternalError();
                    }
                    switch (((Fillet.Vertex)vtx2).getCtrlSeg().getCtrlType(seg2)) {
                        case 8: {
                            Line2D.Double l;
                            if (8 != ((Fillet.Vertex)vtx2).getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                throw new InternalError();
                            }
                            Line2D.Double l2 = new Line2D.Double();
                            if (((Fillet.Vertex)vtx2).name == ((Fillet.Vertex)vtx2).getCtrlSeg().getSegmentVertex1(seg2)) {
                                ((Line2D)l2).setLine(crds[0], crds[1], crds[2], crds[3]);
                            } else if (((Fillet.Vertex)vtx2).name == ((Fillet.Vertex)vtx2).getCtrlSeg().getSegmentVertex2(seg2)) {
                                ((Line2D)l2).setLine(crds[2], crds[3], crds[0], crds[1]);
                            } else {
                                throw new InternalError();
                            }
                            if (((Fillet.Vertex)vtx1).comp == ((Fillet.Vertex)vtx2).comp && ((Fillet.Vertex)vtx1).subPath == ((Fillet.Vertex)vtx2).subPath) {
                                Object vtx = vtx1;
                                vtx1 = vtx2;
                                vtx2 = vtx;
                                Line2D.Double l3 = l1;
                                l1 = l2;
                                l2 = l3;
                                int seg = seg1;
                                seg1 = seg2;
                                seg2 = seg;
                            }
                            if (!this._calculateChamferLine(l1, l2, l = new Line2D.Double())) {
                                ++nBadCorners;
                                break block0;
                            }
                            this._saveState(((Fillet.Vertex)vtx1).comp);
                            ((Fillet.Vertex)vtx1).comp.setControlPointStarts();
                            ((Fillet.Vertex)vtx1).comp.setControlPoint(((Line2D)l).getP1(), ((Fillet.Vertex)vtx1).name);
                            ((Fillet.Vertex)vtx1).comp.setControlPointEnds();
                            this._saveState(((Fillet.Vertex)vtx2).comp);
                            ((Fillet.Vertex)vtx2).comp.setControlPointStarts();
                            ((Fillet.Vertex)vtx2).comp.setControlPoint(((Line2D)l).getP2(), ((Fillet.Vertex)vtx2).name);
                            ((Fillet.Vertex)vtx2).comp.setControlPointEnds();
                            ++this.m_chamferedCorners;
                            if (((Fillet.Vertex)vtx1).comp == ((Fillet.Vertex)vtx2).comp && ((Fillet.Vertex)vtx1).subPath == ((Fillet.Vertex)vtx2).subPath) {
                                int segNew = ((Fillet.Vertex)vtx1).getCtrlSeg().split(seg1);
                                ((Fillet.Vertex)vtx1).getCtrlSeg().setCtrlType(8, segNew);
                                crds[0] = ((Line2D)l).getX1();
                                crds[1] = ((Line2D)l).getY1();
                                crds[2] = ((Line2D)l).getX2();
                                crds[3] = ((Line2D)l).getY2();
                                ((Fillet.Vertex)vtx1).getCtrlSeg().setSegmentCrds(segNew, crds);
                                mm.clearChain(((Fillet.Vertex)vtx2).comp, 2);
                                break block0;
                            }
                            this.m_insertedComponent = new ComponentLine2D(l);
                            cmpSet.add(this.m_insertedComponent);
                            selSet.add(this.m_insertedComponent);
                            break block0;
                        }
                    }
                    ++nUnsupportedCorners;
                    break;
                }
                default: {
                    ++nUnsupportedCorners;
                }
            }
            i += 2;
        }
        for (Fillet.Vertex vtx : innerVertices) {
            if (vtx.extendableSegments.size() != 2) continue;
            int seg1 = vtx.extendableSegments.get(0);
            int seg2 = vtx.extendableSegments.get(1);
            block6 : switch (vtx.getCtrlSeg().getCtrlType(seg1)) {
                case 8: {
                    if (8 != vtx.getCtrlSeg().getSegmentCrds(seg1, crds)) {
                        throw new InternalError();
                    }
                    Line2D.Double l1 = new Line2D.Double();
                    if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg1)) {
                        ((Line2D)l1).setLine(crds[0], crds[1], crds[2], crds[3]);
                    } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                        ((Line2D)l1).setLine(crds[2], crds[3], crds[0], crds[1]);
                    } else {
                        throw new InternalError();
                    }
                    switch (vtx.getCtrlSeg().getCtrlType(seg2)) {
                        case 8: {
                            boolean invert;
                            int seg;
                            if (8 != vtx.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                throw new InternalError();
                            }
                            Line2D.Double l2 = new Line2D.Double();
                            if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg2)) {
                                ((Line2D)l2).setLine(crds[0], crds[1], crds[2], crds[3]);
                            } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg2)) {
                                ((Line2D)l2).setLine(crds[2], crds[3], crds[0], crds[1]);
                            } else {
                                throw new InternalError();
                            }
                            Line2D.Double l = new Line2D.Double();
                            if (!this._calculateChamferLine(l1, l2, l)) {
                                ++nBadCorners;
                                break block6;
                            }
                            this._saveState(vtx.comp);
                            int segNew = vtx.getCtrlSeg().split(seg1);
                            if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg1)) {
                                seg = seg1;
                                invert = true;
                            } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                                seg = seg1;
                                invert = false;
                            } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(segNew)) {
                                seg = segNew;
                                invert = true;
                            } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(segNew)) {
                                seg = segNew;
                                invert = false;
                            } else {
                                throw new InternalError();
                            }
                            vtx.getCtrlSeg().setCtrlType(8, seg);
                            if (invert) {
                                crds[0] = ((Line2D)l).getX2();
                                crds[1] = ((Line2D)l).getY2();
                                crds[2] = ((Line2D)l).getX1();
                                crds[3] = ((Line2D)l).getY1();
                            } else {
                                crds[0] = ((Line2D)l).getX1();
                                crds[1] = ((Line2D)l).getY1();
                                crds[2] = ((Line2D)l).getX2();
                                crds[3] = ((Line2D)l).getY2();
                            }
                            vtx.getCtrlSeg().setSegmentCrds(seg, crds);
                            ++this.m_chamferedCorners;
                            mm.clearChain(vtx.comp, 2);
                            break block6;
                        }
                    }
                    ++nUnsupportedCorners;
                    break;
                }
                default: {
                    ++nUnsupportedCorners;
                }
            }
        }
        String errMsg = null;
        if (nBadCorners != 0) {
            errMsg = String.valueOf(Messages.getString("ext.mod.Chamfer.0")) + nBadCorners + Messages.getString("ext.mod.Chamfer.1");
        }
        if (nUnsupportedCorners != 0) {
            String str = Messages.getString("ext.mod.Chamfer.2");
            errMsg = errMsg == null ? str : String.valueOf(errMsg) + "\n" + str;
        }
        if (errMsg != null) {
            System.err.println(errMsg);
        }
        System.out.println(this);
    }

    @Override
    public String toString() {
        return String.valueOf(Messages.getString("ext.mod.Chamfer.4")) + this.m_chamferedCorners + Messages.getString("ext.mod.Chamfer.5");
    }

    private void _promptForChamferValues() throws CmdAbortedException {
        Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        block6: while (true) {
            double b;
            double a;
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("ext.mod.Chamfer-menu0");
            dlg.setPrompt(Messages.getString("ext.mod.Chamfer.7"));
            dlg.addChoice("a b");
            dlg.setChoiceHints(0, Messages.getString("ext.mod.Chamfer.8"));
            dlg.addChoice("a alfa");
            dlg.setChoiceHints(1, Messages.getString("ext.mod.Chamfer.10"));
            dlg.addChoice("b beta");
            dlg.setChoiceHints(2, Messages.getString("ext.mod.Chamfer.12"));
            dlg.addSeparator();
            dlg.addChoice("OK");
            dlg.setDefaultChoice(3);
            if (s_chamferMode == 0) {
                dlg.setChoiceChecked(0);
                a = s_chamferValues[0][0];
                b = s_chamferValues[0][1];
                dlg.setPrompt(String.valueOf(Messages.getString("ext.mod.Chamfer.14")) + Geo2D.formatCoordinate(a) + Messages.getString("ext.mod.Chamfer.15") + Geo2D.formatCoordinate(b));
            } else if (s_chamferMode == 1) {
                dlg.setChoiceChecked(1);
                a = s_chamferValues[1][0];
                double alfa = s_chamferValues[1][1];
                dlg.setPrompt(String.valueOf(Messages.getString("ext.mod.Chamfer.16")) + Geo2D.formatCoordinate(a) + Messages.getString("ext.mod.Chamfer.17") + Geo2D.formatDegrees(Math.toDegrees(alfa)));
            } else if (s_chamferMode == 2) {
                dlg.setChoiceChecked(2);
                double b2 = s_chamferValues[2][0];
                double beta = s_chamferValues[2][1];
                dlg.setPrompt(String.valueOf(Messages.getString("ext.mod.Chamfer.18")) + Geo2D.formatCoordinate(b2) + Messages.getString("ext.mod.Chamfer.19") + Geo2D.formatDegrees(Math.toDegrees(beta)));
            }
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    Chamfer.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    Chamfer.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            if (!(this.m_input instanceof Integer)) continue;
            switch ((Integer)this.m_input) {
                case 0: {
                    a = s_chamferValues[0][0];
                    b = s_chamferValues[0][1];
                    do {
                        if (!((a = krnl.getConstruction().distance2D(Messages.getString("ext.mod.Chamfer.20"), 1.0)) < Geo2D.getEps())) continue;
                        System.err.println(Messages.getString("ext.mod.Chamfer.21"));
                    } while (a < Geo2D.getEps());
                    do {
                        if (!((b = krnl.getConstruction().distance2D(Messages.getString("ext.mod.Chamfer.22"), a)) < Geo2D.getEps())) continue;
                        System.err.println(Messages.getString("ext.mod.Chamfer.23"));
                    } while (b < Geo2D.getEps());
                    s_chamferMode = 0;
                    Chamfer.s_chamferValues[0][0] = a;
                    Chamfer.s_chamferValues[0][1] = b;
                    continue block6;
                }
                case 1: {
                    a = s_chamferValues[1][0];
                    double angle = s_chamferValues[1][1];
                    do {
                        if (!((a = krnl.getConstruction().distance2D(Messages.getString("ext.mod.Chamfer.24"), 1.0)) < Geo2D.getEps())) continue;
                        System.err.println(Messages.getString("ext.mod.Chamfer.25"));
                    } while (a < Geo2D.getEps());
                    do {
                        if (!((angle = krnl.getConstruction().angle2D(Messages.getString("ext.mod.Chamfer.26"), 0.7853981633974483)) < Geo2D.getEps()) && !(angle > Math.PI - Geo2D.getEps())) continue;
                        System.err.println(Messages.getString("ext.mod.Chamfer.27"));
                        angle = -1.0;
                    } while (angle < 0.0);
                    s_chamferMode = 1;
                    Chamfer.s_chamferValues[1][0] = a;
                    Chamfer.s_chamferValues[1][1] = angle;
                    continue block6;
                }
                case 2: {
                    b = s_chamferValues[2][0];
                    double angle = s_chamferValues[2][1];
                    do {
                        if (!((b = krnl.getConstruction().distance2D(Messages.getString("ext.mod.Chamfer.28"), 1.0)) < Geo2D.getEps())) continue;
                        System.err.println(Messages.getString("ext.mod.Chamfer.29"));
                    } while (b < Geo2D.getEps());
                    do {
                        if (!((angle = krnl.getConstruction().angle2D(Messages.getString("ext.mod.Chamfer.30"), 0.7853981633974483)) < Geo2D.getEps()) && !(angle > Math.PI - Geo2D.getEps())) continue;
                        System.err.println(Messages.getString("ext.mod.Chamfer.31"));
                        angle = -1.0;
                    } while (angle < 0.0);
                    s_chamferMode = 2;
                    Chamfer.s_chamferValues[2][0] = b;
                    Chamfer.s_chamferValues[2][1] = angle;
                    continue block6;
                }
                case 3: {
                    return;
                }
            }
        }
    }

    private boolean _calculateChamferLine(Line2D l1, Line2D l2, Line2D l) {
        try {
            Point2D iscPnt = Geo2D.intersection(l1, true, l2, true, new Point2D.Double());
            l.setLine(iscPnt, iscPnt);
            Point2D ep1 = l1.getP2();
            Point2D ep2 = l2.getP2();
            Vector2D iscLeft = new Vector2D(iscPnt, ep1).normalize();
            Vector2D iscRight = new Vector2D(iscPnt, ep2).normalize();
            switch (s_chamferMode) {
                case 0: {
                    double a = s_chamferValues[0][0];
                    double b = s_chamferValues[0][1];
                    iscLeft.scaleBy(a);
                    iscRight.scaleBy(b);
                    break;
                }
                case 1: {
                    double a = s_chamferValues[1][0];
                    double beta = s_chamferValues[1][1];
                    double gamma = iscLeft.getAngleSmallest(iscRight);
                    double alfa = Math.PI - beta - gamma;
                    double b = a * Math.sin(beta) / Math.sin(alfa);
                    iscLeft.scaleBy(a);
                    iscRight.scaleBy(b);
                    break;
                }
                case 2: {
                    double b = s_chamferValues[2][0];
                    double alfa = s_chamferValues[1][1];
                    double gamma = iscLeft.getAngleSmallest(iscRight);
                    double beta = Math.PI - alfa - gamma;
                    double a = b * Math.sin(alfa) / Math.sin(beta);
                    iscLeft.scaleBy(a);
                    iscRight.scaleBy(b);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            l.setLine(iscPnt.getX() + iscLeft.x, iscPnt.getY() + iscLeft.y, iscPnt.getX() + iscRight.x, iscPnt.getY() + iscRight.y);
            Vector2D v = new Vector2D(l1.getP2(), l1.getP1());
            Vector2D w = new Vector2D(l1.getP1(), l.getP1());
            double extent1 = w.length() * Math.signum(v.getScalarProduct(w));
            v = new Vector2D(l2.getP2(), l2.getP1());
            w = new Vector2D(l2.getP1(), l.getP2());
            double extent2 = w.length() * Math.signum(v.getScalarProduct(w));
            return !(Geo2D.length(l1) + extent1 < -Geo2D.getEps()) && !(Geo2D.length(l2) + extent2 < -Geo2D.getEps());
        }
        catch (NoIntersectionException e) {
            return false;
        }
        catch (NullVectorException e) {
            return false;
        }
    }
}

