/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;

public class DragPreferences
implements Cmd {
    public static final int MODE_TRANSLATE_COMP = 0;
    public static final int MODE_TRANSLATE_POINT = 1;
    public static final int MODE_OFFSET = 2;
    public static final int MODE_EXTEND = 3;
    private static int s_mode = 0;
    private static double s_offsetDist = -1.0;
    private static boolean s_clone = false;
    private int m_svMode = -1;
    private double m_svOffsetDist;
    private boolean m_svClone;
    private transient Object m_input = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("ext.mod.DragPreferences-menu0");
        dlg.setPrompt(Messages.getString("ext.mod.DragPreferences.0"));
        dlg.enableTextInput(true);
        dlg.enableDigitize(0);
        int i = dlg.addChoice("Move comp");
        dlg.setChoiceChecked(i, s_mode == 0);
        i = dlg.addChoice("Move point");
        dlg.setChoiceChecked(i, s_mode == 1);
        i = dlg.addChoice("Offset");
        dlg.setChoiceChecked(i, s_mode == 2);
        dlg.setChoiceHints(i, s_offsetDist < 0.0 ? Messages.getString("ext.mod.DragPreferences.4") : String.valueOf(Messages.getString("ext.mod.DragPreferences.5")) + Geo2D.formatCoordinate(s_offsetDist));
        i = dlg.addChoice("Extend");
        dlg.setChoiceChecked(i, s_mode == 3);
        dlg.addSeparator();
        i = dlg.addChoice("Original");
        dlg.setChoiceChecked(i, !s_clone);
        i = dlg.addChoice("Clone");
        dlg.setChoiceChecked(i, s_clone);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                DragPreferences.this.m_input = new Integer(iChoice);
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                DragPreferences.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (this.m_input instanceof Integer) {
            int iChoice = (Integer)this.m_input;
            int mode = s_mode;
            boolean clone = s_clone;
            double offsetDist = s_offsetDist;
            switch (iChoice) {
                case 0: {
                    mode = 0;
                    break;
                }
                case 1: {
                    mode = 1;
                    break;
                }
                case 2: {
                    mode = 2;
                    offsetDist = this.readOffset(s_offsetDist);
                    break;
                }
                case 3: {
                    mode = 3;
                    break;
                }
                case 4: {
                    clone = false;
                    break;
                }
                case 5: {
                    clone = true;
                    break;
                }
                default: {
                    System.err.println(Messages.getString("ext.mod.DragPreferences.40"));
                }
            }
            this.m_svMode = s_mode;
            this.m_svOffsetDist = s_offsetDist;
            this.m_svClone = s_clone;
            s_mode = mode;
            s_clone = clone;
            s_offsetDist = offsetDist;
        } else if (this.m_input instanceof CmdAbortedException) {
            throw (CmdAbortedException)this.m_input;
        }
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        int svMode = s_mode;
        double svOffsetDist = s_offsetDist;
        boolean svClone = s_clone;
        s_mode = this.m_svMode;
        s_offsetDist = this.m_svOffsetDist;
        s_clone = this.m_svClone;
        this.m_svMode = svMode;
        this.m_svOffsetDist = svOffsetDist;
        this.m_svClone = svClone;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_svMode != -1;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("ext.mod.DragPreferences.41");
    }

    public static void setDragMode(int mode) {
        s_mode = mode;
    }

    public static void setOffsetDistance(double dist) {
        s_offsetDist = dist;
    }

    public static void setIsCloning(boolean isCloning) {
        s_clone = isCloning;
    }

    public static int getDragMode() {
        return s_mode;
    }

    public static double getOffsetDistance() {
        return s_offsetDist;
    }

    public static boolean getIsCloning() {
        return s_clone;
    }

    private double readOffset(double lastOffset) throws CmdAbortedException {
        double offset;
        boolean ok;
        Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("ext.mod.DragPreferences-menu1");
            dlg.setPrompt(Messages.getString("ext.mod.DragPreferences.42"));
            dlg.enableTextInput(true);
            dlg.enableDigitize(0);
            dlg.addChoice("Through point");
            dlg.setDefaultChoice(0);
            dlg.addSeparator();
            dlg.addChoice("115");
            dlg.addChoice("175");
            dlg.addChoice("240");
            dlg.addChoice("300");
            dlg.addChoice("365");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    DragPreferences.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    DragPreferences.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    DragPreferences.this.m_input = new TextToken(text);
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            ok = true;
            offset = -1.0;
            CoordSpace cs = CoordSpace.getCoordSpace();
            double mmPerNU = cs.getMillimetersPerNaturalUnit();
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        offset = -1.0;
                        break;
                    }
                    case 1: {
                        offset = 115.0 / mmPerNU;
                        break;
                    }
                    case 2: {
                        offset = 175.0 / mmPerNU;
                        break;
                    }
                    case 3: {
                        offset = 240.0 / mmPerNU;
                        break;
                    }
                    case 4: {
                        offset = 300.0 / mmPerNU;
                        break;
                    }
                    case 5: {
                        offset = 365.0 / mmPerNU;
                        break;
                    }
                    default: {
                        System.err.println(Messages.getString("ext.mod.DragPreferences.49"));
                        break;
                    }
                }
                continue;
            }
            if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            if (!(this.m_input instanceof TextToken)) continue;
            String text = ((TextToken)this.m_input).toString();
            try {
                offset = Double.parseDouble(text);
                if (!(offset < Geo2D.getEps())) continue;
                System.err.println(Messages.getString("ext.mod.DragPreferences.50"));
                ok = false;
            }
            catch (NumberFormatException e) {
                System.err.println(String.valueOf(text) + Messages.getString("ext.mod.DragPreferences.51"));
                ok = false;
            }
        } while (!ok);
        return offset;
    }
}

