/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.bnd.BindingDimCtrlPoints;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentDimSingle;
import cib.cad.db.feature.Feature;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class AddDimAngle
implements Cmd {
    public static String[] DIM_FEATURES = new String[]{"DIM.TERMINATOR", "DIM.PROJ_LEFT", "DIM.PROJ_RIGHT", "DIM.PROJ_VALUE_LEFT_MM", "DIM.PROJ_VALUE_RIGHT_MM", "DIM.PROJ_VALUE_EXT_MM", "DIM_TEXT.JUSTIFICATION", "DIM_TEXT.UNIT", "DIM_TEXT.PREFIX", "DIM_TEXT.POSTFIX", "DIM_TEXT.SCALE", "DIM_TEXT.FORMAT_SPEC", "DIM_TEXT.FORMAT_STRING", "DIM_TEXT.MM_PER_UNIT", "DIM_TEXT.FREE_TEXT", "DIM_TEXT.LOWER_TEXT"};
    private Set<Pair> m_pairs = new HashSet<Pair>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        final class DimPoint {
            private Point2D pnt = null;
            private Component comp = null;
            private int pntName = -1;
            private double distance = 0.0;

            DimPoint() {
            }
        }
        DimPoint dimPoint;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        BindingModel<Component> bindingModel = db.getBindingModel();
        MarkerMap mm = db.getMarkerMap();
        ArrayList<DimPoint> pntList = new ArrayList<DimPoint>();
        for (Object e : selSet) {
            Component comp;
            if (!(e instanceof Component) || !mm.hasMarkedPrimitives(comp = (Component)e, 2)) continue;
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                Point2D pnt = (Point2D)lit.next();
                int index = lit.previousIndex();
                if (!mm.primitiveMarked(comp, 2, index)) continue;
                DimPoint dimPoint2 = new DimPoint();
                dimPoint2.pnt = pnt;
                dimPoint2.comp = comp;
                dimPoint2.pntName = lit.previousName();
                pntList.add(dimPoint2);
            }
        }
        double d = krnl.getConstruction().angle2D(Messages.getString("kernel.cmds.AddDimAngle.16"));
        Point2D pd = krnl.readPoint(Messages.getString("kernel.cmds.AddDimAngle.17"));
        if (pntList.size() == 0) {
            dimPoint = new DimPoint();
            dimPoint.pnt = krnl.readPoint(Messages.getString("kernel.cmds.AddDimAngle.18"));
            pntList.add(dimPoint);
        }
        if (pntList.size() == 1) {
            dimPoint = new DimPoint();
            dimPoint.pnt = krnl.readPoint(Messages.getString("kernel.cmds.AddDimAngle.19"));
            pntList.add(dimPoint);
        }
        Vector2D _dimVec = new Vector2D(d);
        Point2D.Double _org = new Point2D.Double();
        Point2D.Double _pnt = new Point2D.Double(_dimVec.getX(), _dimVec.getY());
        AffineTransform w2u = krnl.getDatabase().getCoordSpace().getWorldToUserTransform();
        Point2D org = w2u.transform(_org, new Point2D.Double());
        Point2D pnt = w2u.transform(_pnt, new Point2D.Double());
        Vector2D dimVec = new Vector2D(org, pnt);
        dimVec.normalize();
        Vector2D vec = new Vector2D();
        for (DimPoint dimPoint3 : pntList) {
            vec.setLocation(dimPoint3.pnt);
            dimPoint3.distance = vec.getScalarProduct(dimVec);
        }
        Collections.sort(pntList, new Comparator<DimPoint>(){

            @Override
            public int compare(DimPoint dp1, DimPoint dp2) {
                if (dp1.distance > dp2.distance) {
                    return 1;
                }
                if (dp1.distance < dp2.distance) {
                    return -1;
                }
                return 0;
            }
        });
        int n = pntList.size() - 1;
        int nEffective = 1;
        int i = 0;
        while (i < n) {
            DimPoint dimPnt1 = (DimPoint)pntList.get(i);
            DimPoint dimPnt2 = (DimPoint)pntList.get(i + 1);
            if (!(Math.abs(dimPnt1.distance - dimPnt2.distance) < Geo2D.getEps())) {
                ++nEffective;
                ComponentDimSingle dim = new ComponentDimSingle(dimPnt1.pnt, dimPnt2.pnt, pd, d);
                AddDimAngle.setDefaultFeatures(krnl, dim);
                cmpSet.add(dim);
                Pair pair = new Pair();
                pair.dim = dim;
                this.m_pairs.add(pair);
                if (dimPnt1.comp != null || dimPnt2.comp != null) {
                    BindingDimCtrlPoints binding = new BindingDimCtrlPoints();
                    bindingModel.put(dim, binding);
                    if (dimPnt1.comp != null) {
                        bindingModel.addBindingObject(binding, dimPnt1.comp);
                        binding.setBindingControlPoint1(dimPnt1.comp, dimPnt1.pntName);
                    } else {
                        binding.setLocation1(dimPnt1.pnt);
                    }
                    if (dimPnt2.comp != null) {
                        bindingModel.addBindingObject(binding, dimPnt2.comp);
                        binding.setBindingControlPoint2(dimPnt2.comp, dimPnt2.pntName);
                    } else {
                        binding.setLocation2(dimPnt2.pnt);
                    }
                    pair.clonedBinding = (Binding)binding.clone();
                }
            }
            ++i;
        }
        this.m_toString = String.valueOf(nEffective) + Messages.getString("kernel.cmds.AddDimAngle.20");
        this.m_toString = Math.abs(d) < Geo2D.getEps() ? String.valueOf(this.m_toString) + Messages.getString("kernel.cmds.AddDimAngle.21") : (Math.abs(d - 1.5707963267948966) < Geo2D.getEps() ? String.valueOf(this.m_toString) + Messages.getString("kernel.cmds.AddDimAngle.22") : String.valueOf(this.m_toString) + Messages.getString("kernel.cmds.AddDimAngle.23") + Geo2D.formatDegrees(Math.toDegrees(d)) + Messages.getString("kernel.cmds.AddDimAngle.24"));
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        for (Pair pair : this.m_pairs) {
            cmpSet.remove(pair.dim);
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        BindingModel<Component> bindingModel = db.getBindingModel();
        for (Pair pair : this.m_pairs) {
            cmpSet.add(pair.dim);
            if (pair.clonedBinding == null) continue;
            bindingModel.put(pair.dim, (Binding)pair.clonedBinding.clone());
        }
    }

    @Override
    public boolean changesState() {
        return !this.m_pairs.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    public static void setDefaultFeatures(Kernel krnl, ComponentDimSingle dim) {
        int i = 0;
        while (i < DIM_FEATURES.length) {
            Feature f;
            String name = DIM_FEATURES[i];
            String value = krnl.getProperty("FEATURE_VALUE." + name);
            if (value != null && dim.hasFeature(name) && (f = dim.getFeature(name)).isChangeable()) {
                f.valueFromString(value);
                dim.setFeature(f);
            }
            ++i;
        }
    }

    private static class Pair {
        private ComponentDimSingle dim = null;
        private Binding<Component> clonedBinding = null;

        private Pair() {
        }
    }
}

