/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentImage;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.event.MouseInputAdapter;

public class AddImage
implements Cmd {
    private ComponentImage m_comp = null;
    private int m_iChoice = -1;
    private String m_toString = null;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        block27: {
            krnl = (Kernel)context;
            ui = krnl.getUserInterface();
            db = krnl.getDatabase();
            cmpSet = db.getComponentSet();
            imageFile = this._readImageFilePath(krnl);
            if (imageFile == null) {
                System.out.println(Messages.getString("kernel.cmds.AddImage.0"));
                throw new CmdAbortedException();
            }
            if (!imageFile.exists()) {
                System.out.println(Messages.getString("kernel.cmds.AddImage.1"));
                throw new CmdAbortedException();
            }
            sp = krnl.readPoint(Messages.getString("kernel.cmds.AddImage.2"));
            mml = null;
            try {
                this.m_comp = new ComponentImage();
                this.m_comp.setImageFile(imageFile);
                bi = this.m_comp.getImage();
                this.m_comp.setImageSize(0.0, 0.0);
                at = AffineTransform.getTranslateInstance(sp.getX(), sp.getY());
                this.m_comp.setTransform(at);
                cmpSet.add(this.m_comp);
                ui.updateUserInterface();
                mml = new MouseInputAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (AddImage.this.m_comp != null) {
                            this._transform(e);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void _transform(MouseEvent e) {
                        ComponentImage componentImage = AddImage.this.m_comp;
                        synchronized (componentImage) {
                            Object src = e.getSource();
                            if (src instanceof DrawPanel) {
                                DrawPanel dp = (DrawPanel)src;
                                Point2D p = dp.ungriddedModelPoint(e.getX(), e.getY());
                                double w = Math.abs(p.getX() - sp.getX());
                                double h = Math.abs(p.getY() - sp.getY());
                                AddImage.this.m_comp.setImageSize(w, h);
                                AddImage.this.m_comp.setTransform(AffineTransform.getTranslateInstance(Math.min(sp.getX(), p.getX()), Math.min(sp.getY(), p.getY())));
                                ui.updateUserInterface();
                            }
                        }
                    }
                };
                pit = ui.geometryPanelIterator();
                while (pit.hasNext()) {
                    gp = pit.next();
                    if (!(gp instanceof DrawPanel)) continue;
                    ((DrawPanel)gp).addMouseMotionListener(mml);
                }
                ep = new Point2D.Double();
                Construction.getConstruction(krnl).point2D(Messages.getString("kernel.cmds.AddImage.3"), ep, null, new ConObject.Filter(){

                    @Override
                    public boolean accept(Component comp, int chain, int prmName) {
                        return comp != AddImage.this.m_comp;
                    }
                });
                if (mml != null) {
                    pit = ui.geometryPanelIterator();
                    while (pit.hasNext()) {
                        gp = pit.next();
                        if (!(gp instanceof DrawPanel)) continue;
                        ((DrawPanel)gp).removeMouseMotionListener(mml);
                    }
                }
                w = Math.abs(ep.getX() - sp.getX());
                h = Math.abs(ep.getY() - sp.getY());
                if (w < Geo2D.getEps() || h < Geo2D.getEps()) {
                    krnl.readOK(Messages.getString("kernel.cmds.AddImage.4"), 2);
                }
                this.m_comp.setImageSize(w, h);
                this.m_comp.setTransform(AffineTransform.getTranslateInstance(Math.min(sp.getX(), ep.getX()), Math.min(sp.getY(), ep.getY())));
                ui.updateUserInterface();
                if (w < Geo2D.getEps()) {
                    w = -1.0;
                } else if (h < Geo2D.getEps()) {
                    h = -1.0;
                } else {
                    dlg = ui.getCmdLineDialog();
                    dlg.setUniqueName("kernel.cmds.AddImage-menu0");
                    dlg.setPrompt(Messages.getString("kernel.cmds.AddImage.6"));
                    dlg.addChoice("As constructed");
                    dlg.setDefaultChoice(dlg.addChoice("Keep width"));
                    dlg.addChoice("Keep height");
                    dlg.enableTextInput(false);
                    dlg.enableDigitize(0);
                    this.m_iChoice = -1;
                    dlg.addListener(new CmdLineDialog.Listener(){

                        @Override
                        public void choiceSelected(int iChoice) {
                            AddImage.this.m_iChoice = iChoice;
                            ui.disposeCmdLineDialog();
                        }

                        @Override
                        public void dialogAborted() {
                            AddImage.this.m_iChoice = -1;
                            ui.disposeCmdLineDialog();
                        }
                    });
                    ui.showCmdLineDialog(dlg);
                    if (this.m_iChoice != 0) {
                        if (this.m_iChoice == 1) {
                            h = -1.0;
                        } else {
                            if (this.m_iChoice != 2) {
                                throw new CmdAbortedException();
                            }
                            w = -1.0;
                        }
                    }
                }
                if (w < 0.0) {
                    w = h * (double)bi.getWidth() / (double)bi.getHeight();
                } else if (h < 0.0) {
                    h = w * (double)bi.getHeight() / (double)bi.getWidth();
                }
                this.m_comp.setImageSize(w, h);
                this.m_toString = String.valueOf(Messages.getString("kernel.cmds.AddImage.10")) + imageFile.getName() + Messages.getString("kernel.cmds.AddImage.11");
                System.out.println(this);
            }
            catch (IOException ioe) {
                if (this.m_comp != null) {
                    cmpSet.remove(this.m_comp);
                    this.m_comp = null;
                }
                ioe.printStackTrace();
                throw new CmdAbortedException();
            }
            catch (CmdAbortedException e) {
                if (this.m_comp != null) {
                    cmpSet.remove(this.m_comp);
                    this.m_comp = null;
                }
                throw e;
            }
            finally {
                if (mml == null) break block27;
                pit = ui.geometryPanelIterator();
                ** while (pit.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                gp = pit.next();
                if (!(gp instanceof DrawPanel)) continue;
                ((DrawPanel)gp).removeMouseMotionListener(mml);
                continue;
            }
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private File _readImageFilePath(Kernel krnl) throws CmdAbortedException {
        HashSet<String> extensions = new HashSet<String>();
        String[] informalFormatNames = ImageIO.getReaderFormatNames();
        int i = 0;
        while (i < informalFormatNames.length) {
            Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName(informalFormatNames[i]);
            while (iter.hasNext()) {
                ImageReader reader = iter.next();
                String[] suffixes = reader.getOriginatingProvider().getFileSuffixes();
                extensions.addAll(Arrays.asList(suffixes));
            }
            ++i;
        }
        final ArrayList<String> extensionList = new ArrayList<String>();
        for (String extension : extensions) {
            String str = extension.toLowerCase();
            if (!extensionList.contains(str)) {
                extensionList.add(str);
            }
            if (extensionList.contains(str = extension.toUpperCase())) continue;
            extensionList.add(str);
        }
        Collections.sort(extensionList, Collator.getInstance());
        final String[] extensionArray = extensionList.toArray(new String[0]);
        File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName();
                int posDot = fileName.lastIndexOf(46);
                if (posDot < 0) {
                    return false;
                }
                String fileExtension = fileName.substring(posDot + 1);
                if (!extensionList.contains(fileExtension)) {
                    return false;
                }
                if (!f.exists()) {
                    System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.AddImage.12"));
                    return false;
                }
                if (!f.canRead()) {
                    System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.AddImage.13"));
                    return false;
                }
                return true;
            }

            @Override
            public String[] getExtensions() {
                return extensionArray;
            }

            @Override
            public String getPrompt() {
                return Messages.getString("kernel.cmds.AddImage.14");
            }

            @Override
            public String getFileFormatDescription() {
                String dsc = String.valueOf(Messages.getString("kernel.cmds.AddImage.15")) + " (";
                if (extensionArray.length > 0) {
                    dsc = String.valueOf(dsc) + extensionArray[0];
                }
                int i = 1;
                while (i < extensionArray.length) {
                    dsc = String.valueOf(dsc) + ", " + extensionArray[i];
                    ++i;
                }
                dsc = String.valueOf(dsc) + ")";
                return dsc;
            }
        });
        if (file == null) {
            System.out.println(Messages.getString("kernel.cmds.AddImage.18"));
            throw new CmdAbortedException();
        }
        if (!file.exists()) {
            System.out.println(Messages.getString("kernel.cmds.AddImage.19"));
            throw new CmdAbortedException();
        }
        return file;
    }
}

