/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.db.comp.ComponentCircle2D;
import cib.cad.db.comp.ComponentDimSingle;
import cib.cad.db.comp.ComponentLine2D;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.comp.ComponentText2D;
import cib.cad.db.comp.ComponentTitleBlock;
import cib.cad.db.layer.LayerSet;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.ObservableSet;

public class DumpDatabaseStatistics
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> componentSet = db.getComponentSet();
        AttributeManager am = AttributeManager.getAttributeManager();
        LayerSet layerSet = db.getLayerSet();
        int arcs = 0;
        int circles = 0;
        int dims = 0;
        int lines = 0;
        int paths = 0;
        int texts = 0;
        int titleblocks = 0;
        int other = 0;
        for (Object e : componentSet) {
            if (e instanceof ComponentArc2D) {
                ++arcs;
                continue;
            }
            if (e instanceof ComponentCircle2D) {
                ++circles;
                continue;
            }
            if (e instanceof ComponentDimSingle) {
                ++dims;
                continue;
            }
            if (e instanceof ComponentLine2D) {
                ++lines;
                continue;
            }
            if (e instanceof ComponentPath2D) {
                ++paths;
                continue;
            }
            if (e instanceof ComponentText2D) {
                ++texts;
                continue;
            }
            if (e instanceof ComponentTitleBlock) {
                ++titleblocks;
                continue;
            }
            ++other;
        }
        int n = am.getDrawPaints().size() + am.getFillPaints().size() + am.getFontFamilies().size() + am.getLinePatterns().size() + am.getLineWidths().size() + am.getTextSizes().size();
        int components = arcs + circles + lines + paths + texts + titleblocks + other;
        int maxCharsComps = new Integer(components).toString().length();
        int maxCharsAttr = new Integer(n).toString().length();
        String status = String.valueOf(components) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.0") + "\n" + this.fillWithSpacesBefore(arcs, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.2") + "\n" + this.fillWithSpacesBefore(circles, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.4") + "\n" + this.fillWithSpacesBefore(dims, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.6") + "\n" + this.fillWithSpacesBefore(lines, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.8") + "\n" + this.fillWithSpacesBefore(paths, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.10") + "\n" + this.fillWithSpacesBefore(texts, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.12") + "\n" + this.fillWithSpacesBefore(titleblocks, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.14") + "\n" + this.fillWithSpacesBefore(other, maxCharsComps) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.16") + "\n\n";
        status = String.valueOf(status) + n + Messages.getString("kernel.cmds.DumpDatabaseStatistics.18") + "\n" + this.fillWithSpacesBefore(am.getDrawPaints().size(), maxCharsAttr) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.20") + "\n" + this.fillWithSpacesBefore(am.getFillPaints().size(), maxCharsAttr) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.22") + "\n" + this.fillWithSpacesBefore(am.getFontFamilies().size(), maxCharsAttr) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.24") + "\n" + this.fillWithSpacesBefore(am.getLinePatterns().size(), maxCharsAttr) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.26") + "\n" + this.fillWithSpacesBefore(am.getLineWidths().size(), maxCharsAttr) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.28") + "\n" + this.fillWithSpacesBefore(am.getTextSizes().size(), maxCharsAttr) + Messages.getString("kernel.cmds.DumpDatabaseStatistics.30") + "\n\n" + layerSet.size() + Messages.getString("kernel.cmds.DumpDatabaseStatistics.32") + "\n\n";
        krnl.readOK(Messages.getString("kernel.cmds.DumpDatabaseStatistics.34"), Messages.getString("kernel.cmds.DumpDatabaseStatistics.35"), status, 6);
    }

    private String fillWithSpacesBefore(int number, int length) {
        String s = new Integer(number).toString();
        if (s == null) {
            return s;
        }
        if (s.length() >= length) {
            return s;
        }
        int i = s.length();
        do {
            s = "  " + s;
        } while (++i < length);
        return s;
    }
}

