/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.SelectFilter;
import cib.cad.kernel.cmds.util.WindowRubberBand;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.CollUtilities;
import cib.util.coll.IteratorFilter;
import cib.util.coll.ObservableSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;

public class SelectByPickIntersect
extends UndoableCmd {
    private String m_toString = null;
    private int m_action = -1;
    private DigitizeObject m_dig = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        IteratorFilter<cib.cad.db.comp.Component> filter = null;
        boolean incremental = false;
        try {
            do {
                CmdLineDialog dlg = ui.getCmdLineDialog();
                dlg.setUniqueName("kernel.cmds.SelectByPickIntersect-menu0");
                dlg.setPrompt(Messages.getString("kernel.cmds.SelectByPickIntersect.1"));
                int iChoice = dlg.addChoice("Incremental");
                if (incremental) {
                    dlg.setChoiceChecked(iChoice);
                }
                iChoice = dlg.addChoice("Filter");
                dlg.setDefaultChoice(iChoice);
                if (filter != null) {
                    dlg.setChoiceChecked(iChoice);
                }
                dlg.enableDigitize(-1);
                dlg.addListener(new CmdLineDialog.Listener(){

                    @Override
                    public void choiceSelected(int iChoice) {
                        SelectByPickIntersect.this.m_action = iChoice;
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void digitized(int x, int y, GeometryPanel gp) {
                        SelectByPickIntersect.this.m_action = -2;
                        SelectByPickIntersect.this.m_dig = new DigitizeObject(gp, x, y);
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void dialogAborted() {
                        SelectByPickIntersect.this.m_action = -1;
                        ui.disposeCmdLineDialog();
                    }
                });
                this._setCursor(true);
                ui.showCmdLineDialog(dlg);
                if (this.m_action == 0) {
                    incremental = !incremental;
                    continue;
                }
                if (this.m_action == 1) {
                    filter = filter == null ? new SelectFilter().showDialog() : null;
                    continue;
                }
                if (this.m_action != -1) continue;
                throw new CmdAbortedException();
            } while (this.m_action != -2);
        }
        finally {
            this._setCursor(false);
        }
        if (filter == null) {
            filter = new IteratorFilter<cib.cad.db.comp.Component>(){
                private AttributeManager m_atm = AttributeManager.getAttributeManager();

                @Override
                public boolean matches(cib.cad.db.comp.Component c) {
                    if (c == null) {
                        return false;
                    }
                    Attributes attr = c.getAttributes();
                    return attr == null ? true : this.m_atm.getVisibility(attr.getVisibility());
                }
            };
        }
        WindowRubberBand rb = null;
        DigitizeObject d1 = this.m_dig;
        DigitizeObject d2 = null;
        try {
            rb = new WindowRubberBand(krnl, d1);
            while (d2 == null) {
                d2 = krnl.readDigitizeObject(String.valueOf(Messages.getString("kernel.cmds.SelectByPickIntersect.4")) + d1.getGeometryPanel().getId());
                if (d1.getGeometryPanel() == d2.getGeometryPanel()) continue;
                System.err.println(String.valueOf(Messages.getString("kernel.cmds.SelectByPickIntersect.5")) + d1.getGeometryPanel().getId());
                d2 = null;
            }
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
        GeometryPanel geometryPanel = d1.getGeometryPanel();
        Point p1 = d1.getPoint();
        Point p2 = d2.getPoint();
        Rectangle rectangle = new Rectangle();
        rectangle.setFrameFromDiagonal(p1, p2);
        Database db = krnl.getDatabase();
        ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
        if (!incremental) {
            for (cib.cad.db.comp.Component comp : selSet) {
                this._saveSelectState(comp);
            }
            selSet.clear();
        }
        Iterator<cib.cad.db.comp.Component> it = geometryPanel.objectIterator(rectangle, true);
        Iterator<cib.cad.db.comp.Component> fit = CollUtilities.filterableIterator(it, filter);
        while (fit.hasNext()) {
            cib.cad.db.comp.Component o = fit.next();
            if (selSet.contains(o)) continue;
            this._saveSelectState(o);
            selSet.add(o);
        }
        int n = this._numberOfSavedSelectStates();
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SelectByPickIntersect.6")) + n + (n == 1 ? Messages.getString("kernel.cmds.SelectByPickIntersect.7") : Messages.getString("kernel.cmds.SelectByPickIntersect.8")) + Messages.getString("kernel.cmds.SelectByPickIntersect.9");
        System.out.println(this);
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _setCursor(boolean on) {
        Cursor cursor = on ? Cursor.getPredefinedCursor(1) : Cursor.getPredefinedCursor(0);
        Kernel krnl = Kernel.getInstance();
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }
}

