/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.comp.Component;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MouseStroke;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.Translate;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.event.MouseInputAdapter;

public class TranslateByMouseDrag
extends Translate {
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        final Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        DigitizeObject dig = krnl.readDigitizeObject(Messages.getString("kernel.cmds.TranslateByMouseDrag.0"));
        GeometryPanel panel = dig.getGeometryPanel();
        if (panel instanceof DrawPanel) {
            final DrawPanel dp = (DrawPanel)panel;
            Point sp = dig.getPoint();
            final Point2D msp = this._locateCtrlPoint(sp.x, sp.y, dp);
            if (msp == null) {
                return;
            }
            final ObservableSet<Component> selectSet = krnl.getDatabase().getSelectSet();
            final Point2D.Double mep = new Point2D.Double();
            mep.setLocation(msp);
            MouseInputAdapter mml = new MouseInputAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (MouseStroke.getLogicalMouseButton(e) == MouseStroke.LEFT_BUTTON) {
                        this._translate(e);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this._translate(e);
                }

                private void _translate(MouseEvent e) {
                    AffineTransform trf = AffineTransform.getTranslateInstance(msp.getX() - mep.getX(), msp.getY() - mep.getY());
                    mep.setLocation(dp.ungriddedModelPoint(e.getX(), e.getY()));
                    trf.translate(mep.getX() - msp.getX(), mep.getY() - msp.getY());
                    TranslateByMouseDrag.this.transform(krnl, trf);
                    ui.updateUserInterface();
                }
            };
            dp.addMouseMotionListener(mml);
            try {
                try {
                    final Point2D.Double mp = new Point2D.Double();
                    final ConPoint2D conPoint = new ConPoint2D(krnl);
                    conPoint.setPrompt(Messages.getString("kernel.cmds.TranslateByMouseDrag.1"));
                    conPoint.setFilter(new ConObject.Filter(){

                        @Override
                        public boolean accept(Component comp, int chain, int name) {
                            return !selectSet.contains(comp);
                        }
                    });
                    conPoint.addListener(new ConPoint2D.Listener(){

                        @Override
                        public void pointConstructed(Point2D p) {
                            mp.setLocation(p);
                            conPoint.dispose();
                        }

                        @Override
                        public void dialogAborted() {
                            mp.setLocation(Double.NaN, 0.0);
                            conPoint.dispose();
                        }
                    });
                    conPoint.show();
                    if (Double.isNaN(((Point2D)mp).getX())) {
                        throw new CmdAbortedException();
                    }
                    AffineTransform trf = AffineTransform.getTranslateInstance(msp.getX() - ((Point2D)mep).getX(), msp.getY() - ((Point2D)mep).getY());
                    mep.setLocation(mp);
                    trf.translate(((Point2D)mep).getX() - msp.getX(), ((Point2D)mep).getY() - msp.getY());
                    this.transform(krnl, trf);
                    this.m_mat = AffineTransform.getTranslateInstance(((Point2D)mep).getX() - msp.getX(), ((Point2D)mep).getY() - msp.getY());
                    int n = selectSet.size();
                    if (n > 0) {
                        this.m_toString = String.valueOf(n) + (n > 1 ? Messages.getString("kernel.cmds.TranslateByMouseDrag.2") : Messages.getString("kernel.cmds.TranslateByMouseDrag.3")) + Messages.getString("kernel.cmds.TranslateByMouseDrag.4");
                        System.out.println(this);
                    }
                }
                catch (CmdAbortedException e) {
                    AffineTransform trf = AffineTransform.getTranslateInstance(msp.getX() - ((Point2D)mep).getX(), msp.getY() - ((Point2D)mep).getY());
                    this.transform(krnl, trf);
                    throw e;
                }
            }
            finally {
                dp.removeMouseMotionListener(mml);
            }
        }
    }

    @Override
    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private Point2D _locateCtrlPoint(int x, int y, GeometryPanel gp) {
        Rectangle2D.Double pickBox = new Rectangle2D.Double(x - 5, y - 5, 10.0, 10.0);
        AffineTransform m2v = gp.getProjection().getModelToView();
        Point2D.Double vp = new Point2D.Double();
        Iterator<Component> it = gp.objectIterator(pickBox, true);
        while (it.hasNext()) {
            Component o = it.next();
            if (!(o instanceof Component)) continue;
            Component comp = o;
            NamedListIterator<Point2D> cpit = comp.controlPointIterator();
            while (cpit.hasNext()) {
                Point2D mp = (Point2D)cpit.next();
                m2v.transform(mp, vp);
                if (!pickBox.contains(vp)) continue;
                return mp;
            }
        }
        return null;
    }
}

