/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.kernel.Kernel;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import java.awt.geom.Line2D;
import java.util.Iterator;

public class ConLine2D
extends ConObject {
    private Line2D m_defLine = null;

    public ConLine2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConLine2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConLine2D.0"));
    }

    public void setDefault(Line2D lin) {
        this.m_defLine = lin == null ? null : (Line2D)lin.clone();
    }

    public Line2D getDefault() {
        return this.m_defLine == null ? null : (Line2D)this.m_defLine.clone();
    }

    @Override
    public void show() {
        ConLineSeg2D conLineSeg = new ConLineSeg2D(this.m_krnl);
        conLineSeg.setFilter(this.m_filter);
        conLineSeg.setPrompt(this.getPrompt());
        if (this.m_defLine != null) {
            conLineSeg.setDefault(this.m_defLine);
        }
        conLineSeg.addListener(new ConLineSeg2D.Listener(){

            @Override
            public void lineSegConstructed(Line2D l) {
                ConLine2D.this.notifyLineConstructed(l);
            }

            @Override
            public void dialogAborted() {
                ConLine2D.this.notifyAborted();
            }
        });
        conLineSeg.show();
    }

    @Override
    public void dispose() {
        this._setPickCursor(false);
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void notifyLineConstructed(Line2D line) {
        if (this.isDrawEnabled()) {
            this._getUI().drawLine(line);
        }
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.lineConstructed(line);
        }
    }

    @Override
    protected void notifyAborted() {
        super.notifyAborted();
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void lineConstructed(Line2D seg) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void lineConstructed(Line2D var1);
    }
}

