/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.LineRubberBand;
import cib.cad.kernel.constr.ConAngle2D;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class ConVector2D
extends ConObject {
    private Point2D m_defVector = null;
    private transient Object m_input = null;
    private int m_nValues = 0;
    private double[] m_values = new double[2];

    public ConVector2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConVector2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConVector2D.0"));
    }

    public void setDefault(Vector2D vec) {
        this.m_defVector = vec == null ? null : (Vector2D)vec.clone();
    }

    public Vector2D getDefault() {
        return this.m_defVector == null ? null : (Vector2D)this.m_defVector.clone();
    }

    @Override
    public void show() {
        this.m_nValues = 0;
        this.showConVectorDialog();
    }

    @Override
    public void dispose() {
        this._setPickCursor(false);
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void showConVectorDialog() {
        block6: while (true) {
            CmdLineDialog dlg = this._getUI().getCmdLineDialog();
            dlg.setUniqueName("kernel.constr.ConVector2D-menu0");
            dlg.setPrompt(String.valueOf(this.getPrompt()) + (this.m_nValues == 1 ? Messages.getString("kernel.constr.ConVector2D.2") : ""));
            dlg.enableTextInput();
            if (this.m_defVector != null) {
                if (this.m_nValues == 0) {
                    dlg.setDefaultText(String.valueOf(Geo2D.formatCoordinate(this.m_defVector.getX())) + " " + Geo2D.formatCoordinate(this.m_defVector.getY()));
                } else if (this.m_nValues == 1) {
                    dlg.setDefaultText(Geo2D.formatCoordinate(this.m_defVector.getY()));
                }
            }
            dlg.enableDigitize(-1);
            dlg.addChoice("Pick");
            dlg.addChoice("Point point");
            dlg.setChoiceChecked(1, true);
            dlg.addChoice("Angle");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void textEntered(String text) {
                    double crd;
                    try {
                        crd = ConVector2D.this.m_krnl.getNumberInterpreter().getNumber(text).doubleValue();
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(Messages.getString("kernel.constr.ConVector2D.8"));
                        return;
                    }
                    double[] dArray = ConVector2D.this.m_values;
                    ConVector2D conVector2D = ConVector2D.this;
                    int n = conVector2D.m_nValues;
                    conVector2D.m_nValues = n + 1;
                    dArray[n] = crd;
                    ConVector2D.this.m_input = ConVector2D.this.m_nValues == 2 ? null : new Integer(-1);
                    ConVector2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void choiceSelected(int iChoice) {
                    ConVector2D.this.m_input = new Integer(iChoice);
                    ConVector2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    ConVector2D.this.m_krnl.pushBackArguments(new CmdLineToken[]{new DigitizeToken(x, y, gp.getId())});
                    ConVector2D.this.m_input = new Integer(1);
                    ConVector2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ConVector2D.this.m_input = new CmdAbortedException();
                    ConVector2D.this.notifyAborted();
                }

                @Override
                public void interruptStarts(String argList) {
                    ConVector2D.this.setDigitizeCursor(false);
                }

                @Override
                public void interruptEnds() {
                    ConVector2D.this.setDigitizeCursor(true);
                }
            });
            this.setDigitizeCursor(true);
            this.m_input = null;
            this._getUI().showCmdLineDialog(dlg);
            this.setDigitizeCursor(false);
            if (this.m_input == null) {
                this.showConfirmDialog(new Vector2D(this.m_values[0], this.m_values[1]), new Point2D.Double());
                return;
            }
            if (this.m_input instanceof Integer) {
                switch ((Integer)this.m_input) {
                    case -1: {
                        if (this.m_nValues == 2) {
                            return;
                        }
                        this.showConVectorDialog();
                        return;
                    }
                    case 0: {
                        if (!this.showPickVectorDialog()) continue block6;
                        return;
                    }
                    case 1: {
                        this.showPointPointDialog();
                        return;
                    }
                    case 2: {
                        this.showAngleDialog();
                        return;
                    }
                }
                throw new InternalError();
            }
            if (this.m_input instanceof CmdAbortedException) break;
        }
    }

    private boolean showPickVectorDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConVector2D-menu1");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConVector2D.10"));
        dlg.enableDigitize(-1);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void dialogAborted() {
                ConVector2D.this.m_input = new CmdAbortedException();
                ConVector2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConVector2D.this.m_input = new DigitizeObject(gp, x, y);
                ConVector2D.this._getUI().disposeCmdLineDialog();
            }
        });
        this._setPickCursor(true);
        this._getUI().showCmdLineDialog(dlg);
        this._setPickCursor(false);
        if (this.m_input instanceof CmdAbortedException) {
            this.notifyAborted();
            return true;
        }
        if (this.m_input instanceof DigitizeObject) {
            DigitizeObject dig = (DigitizeObject)this.m_input;
            Vector2D vector = new Vector2D();
            Point2D.Double showVectorAt = new Point2D.Double();
            Rectangle2D.Double pickBox = new Rectangle2D.Double(dig.getX() - 5, dig.getY() - 5, 10.0, 10.0);
            double[] crds = new double[8];
            GeometryPanel gp = dig.getGeometryPanel();
            Iterator<Component> it = gp.objectIterator(pickBox, true);
            while (it.hasNext()) {
                Component o = it.next();
                if (!this._accepts(o, -1, -1)) continue;
                GeometryPanel.SegmentIterator git = gp.intersectionSegmentIterator(o, pickBox);
                while (git.hasNext()) {
                    if (git.next(crds) != 8) continue;
                    Projection2D prj = gp.getProjection();
                    AffineTransform v2m = prj.getViewToModel();
                    Point2D digPnt = v2m.transform(new Point2D.Double(dig.getX(), dig.getY()), new Point2D.Double());
                    if (digPnt.distance(crds[0], crds[1]) < digPnt.distance(crds[2], crds[3])) {
                        vector.setLocation(crds[2] - crds[0], crds[3] - crds[1]);
                        ((Point2D)showVectorAt).setLocation(crds[0], crds[1]);
                    } else {
                        vector.setLocation(crds[0] - crds[2], crds[1] - crds[3]);
                        ((Point2D)showVectorAt).setLocation(crds[2], crds[3]);
                    }
                    this.showConfirmDialog(vector, showVectorAt);
                    return true;
                }
            }
            System.err.println(Messages.getString("kernel.constr.ConVector2D.11"));
        }
        return false;
    }

    private void showPointPointDialog() {
        LineRubberBand rb = null;
        try {
            try {
                Point2D.Double sp = new Point2D.Double();
                Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConVector2D.12"), sp, null, this.m_filter);
                rb = new LineRubberBand(this.m_krnl, sp);
                Point2D.Double ep = new Point2D.Double();
                Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConVector2D.13"), ep, null, this.m_filter);
                rb.close();
                rb = null;
                this.showConfirmDialog(new Vector2D(sp, ep), sp);
            }
            catch (CmdAbortedException e) {
                this.notifyAborted();
                if (rb != null) {
                    rb.close();
                }
            }
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
    }

    private void showAngleDialog() {
        try {
            double angle = Construction.getConstruction(this.m_krnl).angle2D(Messages.getString("kernel.constr.ConVector2D.14"), Double.NaN, this.m_filter);
            Vector2D vec = new Vector2D(Math.cos(angle), Math.sin(angle));
            this.showConfirmDialog(vec, null);
        }
        catch (CmdAbortedException e) {
            this.notifyAborted();
        }
    }

    private void showConfirmDialog(final Vector2D vec, Point2D at) {
        block10: {
            block9: {
                UserInterface ui = this.m_krnl.getUserInterface();
                ui.drawVector(vec, at);
                CmdLineDialog dlg = this._getUI().getCmdLineDialog();
                dlg.setUniqueName("kernel.constr.ConVector2D-menu2");
                dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConVector2D.16"));
                dlg.enableTextInput();
                dlg.setDefaultText(Geo2D.formatCoordinate(Geo2D.length(vec)));
                dlg.addChoice("Angle");
                dlg.addChoice("Rotate");
                dlg.addListener(new CmdLineDialog.Listener(){

                    @Override
                    public void textEntered(String text) {
                        try {
                            Number n = ConVector2D.this.m_krnl.getNumberInterpreter().getNumber(text);
                            ConVector2D.this.m_input = new Double(n.doubleValue());
                            ConVector2D.this._getUI().disposeCmdLineDialog();
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(Messages.getString("kernel.constr.ConVector2D.19"));
                        }
                    }

                    @Override
                    public void choiceSelected(int iChoice) {
                        ConVector2D.this.m_input = new Integer(iChoice);
                        ConVector2D.this._getUI().disposeCmdLineDialog();
                    }

                    @Override
                    public void dialogAborted() {
                        ConVector2D.this.m_input = new CmdAbortedException();
                        ConVector2D.this.notifyAborted();
                    }
                });
                this.m_input = null;
                this._getUI().showCmdLineDialog(dlg);
                if (this.m_input == null) {
                    return;
                }
                if (this.m_input instanceof Double) {
                    double l = (Double)this.m_input;
                    if (!Geo2D.isNull(vec)) {
                        vec.normalize();
                        vec.scaleBy(l);
                    } else {
                        vec.x = l;
                        vec.y = 0.0;
                    }
                    this.notifyVectorConstructed(vec);
                    return;
                }
                if (!(this.m_input instanceof Integer)) break block9;
                switch ((Integer)this.m_input) {
                    case 0: {
                        final ConAngle2D ca = new ConAngle2D(this);
                        ca.setFilter(this.m_filter);
                        ca.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConVector2D.20"));
                        ca.addListener(new ConAngle2D.Listener(){

                            @Override
                            public void angleConstructed(double ang) {
                                double len = vec.length();
                                vec.setLocation(Math.cos(ang), Math.sin(ang));
                                vec.scaleBy(len);
                                ca.dispose();
                            }

                            @Override
                            public void dialogAborted() {
                                ConVector2D.this.notifyAborted();
                            }
                        });
                        ca.show();
                        break block10;
                    }
                    case 1: {
                        final ConAngle2D cr = new ConAngle2D(this);
                        cr.setFilter(this.m_filter);
                        cr.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConVector2D.21"));
                        cr.addListener(new ConAngle2D.Listener(){

                            @Override
                            public void angleConstructed(double ang) {
                                vec.rotate(ang);
                                cr.dispose();
                            }

                            @Override
                            public void dialogAborted() {
                                ConVector2D.this.notifyAborted();
                            }
                        });
                        cr.show();
                        break block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            if (this.m_input instanceof CmdAbortedException) {
                return;
            }
        }
        this.showConfirmDialog(vec, at);
    }

    private void notifyVectorConstructed(Vector2D vec) {
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.vectorConstructed(vec);
        }
    }

    @Override
    protected void notifyAborted() {
        super.notifyAborted();
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void vectorConstructed(Vector2D vec) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void vectorConstructed(Vector2D var1);
    }
}

