/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.db.Marker;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.LayeredGraphics2D;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.View;
import cib.cad.kernel.ViewController;
import cib.cad.view.AxisView;
import cib.cad.view.ControlPointView;
import cib.cad.view.GraphicalUserInterface;
import cib.util.AttributedShape;
import cib.util.CoordSpace;
import cib.util.Grid;
import cib.util.coll.CollUtilities;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ReverseAccessMap;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JPanel;

public class DrawPanel
extends JPanel
implements GeometryPanel {
    private static final long serialVersionUID = 0L;
    private static final Color MICROSCOPE_COLOR = new Color(0.25f, 0.25f, 0.25f, 0.1f);
    private static final int PROJECTION = 2;
    private static final int LENGTH = 30;
    private static final int ARROW_LENGTH = 20;
    private static final int ARROW_HEIGHT = 6;
    private Kernel m_krnl;
    private int m_id;
    protected ReverseAccessMap<ViewController, Component> m_viewToModel = CollUtilities.reverseAccessMap(new HashMap());
    private Projection2D m_projection = null;
    private List<Component> m_addedComponents = new ArrayList<Component>();
    private Set<Component> m_changedComponents = new HashSet<Component>();
    private Set<Component> m_removedComponents = new HashSet<Component>();
    private boolean m_panelCleared = false;
    private BufferedImage m_panelBuffer = null;
    private BufferedImage m_microscopeBuffer = null;
    private Shape m_microscopeClip = null;
    private Set<GeometryPanel.RubberbandListener> m_listeners = new HashSet<GeometryPanel.RubberbandListener>();
    private Map<String, Image> m_layerMap = new HashMap<String, Image>();
    private _LayeredGraphics2D m_layeredGraphics = null;
    private Set<GeometryPanel.AnnotationRenderer> m_renderers = new HashSet<GeometryPanel.AnnotationRenderer>();
    private Map<Object, GeometryPanel.AnnotationRenderer> m_myGeometryRenderers = new HashMap<Object, GeometryPanel.AnnotationRenderer>();
    private Grid m_grid = new Grid(1.0, 1.0);
    private int m_microscopeRadius = 40;
    private boolean m_microscopeEnabled = false;
    private int m_flags = 1007;
    private boolean m_paintImmediately = false;

    public DrawPanel(Kernel krnl, int id) {
        this.m_krnl = krnl;
        this.m_id = id;
        this._init();
    }

    public DrawPanel(Kernel krnl, int id, boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.m_krnl = krnl;
        this.m_id = id;
        this._init();
    }

    public DrawPanel(Kernel krnl, int id, LayoutManager layout) {
        super(layout);
        this.m_krnl = krnl;
        this.m_id = id;
        this._init();
    }

    public DrawPanel(Kernel krnl, int id, LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.m_krnl = krnl;
        this.m_id = id;
        this._init();
    }

    private void _init() {
        this.m_layerMap.put("COMPONENT_GRAPHICS", null);
        this.m_layerMap.put("COMPONENT_CONTROLS", null);
        String flags = this.m_krnl.getProperty(String.valueOf(this._propertiesPrefix()) + "flags");
        try {
            this.m_flags = Integer.parseInt(flags);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Grid grid = new Grid();
        grid.fromProperties(this.m_krnl.getProperties(), this._propertiesPrefix());
        this.setGrid(grid, (this.m_flags & 0x200) != 0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (DrawPanel.this.m_layeredGraphics != null) {
                    Rectangle r = null;
                    if (DrawPanel.this.m_microscopeEnabled && DrawPanel.this.m_krnl.getUserInterface().isDrawingEnabled() && DrawPanel.this.m_microscopeClip != null) {
                        r = DrawPanel.this.m_microscopeClip.getBounds();
                        r.grow(1, 1);
                        DrawPanel.this.m_microscopeClip = null;
                    }
                    DrawPanel.this._paintComponentImmediately(r);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DrawPanel.this._mouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                DrawPanel.this._mouseMoved(e);
            }
        });
    }

    private String _propertiesPrefix() {
        return "DrawPanel_" + this.getId() + "_";
    }

    private void _mouseMoved(MouseEvent e) {
        UserInterface ui = this.m_krnl.getUserInterface();
        if (ui == null) {
            return;
        }
        if (this.m_layeredGraphics != null) {
            Rectangle r = null;
            if (this.m_microscopeEnabled && this.m_krnl.getUserInterface().isDrawingEnabled()) {
                Rectangle rOld = this.m_microscopeClip != null ? this.m_microscopeClip.getBounds() : null;
                this.m_microscopeClip = new Ellipse2D.Double(e.getX() - this.m_microscopeRadius, e.getY() - this.m_microscopeRadius, this.m_microscopeRadius + this.m_microscopeRadius, this.m_microscopeRadius + this.m_microscopeRadius);
                r = this.m_microscopeClip.getBounds();
                if (rOld != null) {
                    r.add(rOld);
                }
                r.grow(1, 1);
            }
            this._paintComponentImmediately(r);
        }
        Point2D p = this.ungriddedModelPoint(e.getX(), e.getY());
        CoordSpace cs = CoordSpace.getCoordSpace();
        String unit = cs.getNaturalUnitString();
        String loc = String.valueOf(cs.shortFormatCoordinate(p.getX())) + ", " + cs.shortFormatCoordinate(p.getY()) + " [" + unit + "]";
        ui.showLocatorPosition(loc);
    }

    @Override
    public Graphics getGraphics() {
        Graphics gfx = super.getGraphics();
        return gfx;
    }

    private void _initGraphics(Graphics gfx) {
        if ((this.m_flags & 0x100) != 0) {
            Graphics2D gfx2D = (Graphics2D)gfx;
            RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            qualityHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            qualityHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            qualityHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            qualityHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            qualityHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            qualityHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            qualityHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            qualityHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            gfx2D.setRenderingHints(qualityHints);
        } else {
            Graphics2D gfx2D = (Graphics2D)gfx;
            RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            qualityHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            qualityHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            qualityHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            qualityHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            qualityHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            qualityHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            qualityHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            qualityHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            gfx2D.setRenderingHints(qualityHints);
        }
    }

    private BufferedImage _getPanelImage() {
        if (this.m_panelBuffer == null || this.m_panelBuffer.getWidth() != this.getWidth() || this.m_panelBuffer.getHeight() != this.getHeight() || this.m_panelCleared) {
            ViewController vc;
            this.m_panelBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.m_layerMap.put("COMPONENT_GRAPHICS", this.m_panelBuffer);
            this.m_microscopeBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.m_layerMap.put("COMPONENT_CONTROLS", this.m_microscopeBuffer);
            this._initProjection();
            if (this.m_layeredGraphics != null) {
                this.m_layeredGraphics.dispose();
            }
            this.m_layeredGraphics = new _LayeredGraphics2D();
            AffineTransform modelToView = this.m_projection.getModelToView();
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
            this.m_layeredGraphics.setClip(0, 0, this.getWidth(), this.getHeight());
            if ((this.m_flags & 0x400) == 0) {
                Iterator<Component> it = this.m_krnl.nonAccessibleComponentsIterator();
                while (it.hasNext()) {
                    Component c = it.next();
                    vc = this.m_viewToModel.getKey(c);
                    if (vc == null) continue;
                    this.m_layeredGraphics.setLayer("COMPONENT_GRAPHICS");
                    vc.updateViews(modelToView, bounds, this.m_flags, this.m_layeredGraphics);
                    vc.draw(this.m_layeredGraphics);
                }
            }
            for (Component c : this.m_krnl.getDatabase().getComponentList()) {
                vc = this.m_viewToModel.getKey(c);
                if (vc == null) continue;
                this.m_layeredGraphics.setLayer("COMPONENT_GRAPHICS");
                vc.updateViews(modelToView, bounds, this.m_flags, this.m_layeredGraphics);
                vc.draw(this.m_layeredGraphics);
            }
        }
        return this.m_panelBuffer;
    }

    @Override
    public synchronized boolean addListener(GeometryPanel.RubberbandListener l) {
        return this.m_listeners.add(l);
    }

    @Override
    public synchronized boolean removeListener(GeometryPanel.RubberbandListener l) {
        if (!this.m_listeners.remove(l)) {
            return false;
        }
        l.paintStarts();
        return true;
    }

    @Override
    public Iterator<GeometryPanel.RubberbandListener> listenerIterator() {
        return this.m_listeners.iterator();
    }

    private synchronized void _paintComponentImmediately(Rectangle r) {
        Iterator<GeometryPanel.RubberbandListener> it;
        UserInterface ui = this.m_krnl.getUserInterface();
        if (ui == null) {
            return;
        }
        this.m_paintImmediately = true;
        if (ui.isDrawingEnabled()) {
            it = this.m_listeners.iterator();
            while (it.hasNext()) {
                it.next().paintStarts();
            }
        }
        if (r != null) {
            this.paintImmediately(r);
        }
        if (ui.isDrawingEnabled()) {
            it = this.m_listeners.iterator();
            while (it.hasNext()) {
                it.next().paintEnds();
            }
        }
        this.m_paintImmediately = false;
    }

    @Override
    public synchronized void paintComponent(Graphics _g) {
        super.paintComponent(_g);
        Graphics2D g = (Graphics2D)_g;
        this._initGraphics(g);
        BufferedImage panelImage = this._getPanelImage();
        g.drawImage(panelImage, null, 0, 0);
        this._paintAnnotations(g);
        if (!this.m_paintImmediately) {
            Iterator<GeometryPanel.RubberbandListener> it = this.m_listeners.iterator();
            while (it.hasNext()) {
                it.next().reset();
            }
        }
        if (this.m_microscopeClip != null) {
            g.setClip(this.m_microscopeClip);
            g.drawImage(this.m_microscopeBuffer, null, 0, 0);
            g.setPaint(MICROSCOPE_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void _initProjection() {
        try {
            if (this.m_projection == null) {
                CoordSpace cs = CoordSpace.getCoordSpace();
                double mmPerNU = cs.getMillimetersPerNaturalUnit();
                Rectangle2D.Double viewPort = new Rectangle2D.Double(-1000.0 / mmPerNU, -1000.0 / mmPerNU, 10000.0 / mmPerNU, 10000.0 / mmPerNU);
                this.m_projection = new Projection2D(viewPort, this.getWidth(), this.getHeight());
            } else {
                this.m_projection.setDeviceDimensions(this.getWidth(), this.getHeight());
                this.m_projection.setProjection();
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    private boolean _getOriginDeviceCoordinates(Point2D originDevice) {
        Point2D.Double originModel = new Point2D.Double(0.0, 0.0);
        AffineTransform modelToView = this.m_projection.getModelToView();
        modelToView.transform(originModel, originDevice);
        if (originDevice.getX() < 0.0 || originDevice.getX() > (double)this.getWidth() || originDevice.getY() < 0.0 || originDevice.getY() > (double)this.getHeight()) {
            originDevice.setLocation(20.0, this.getHeight() - 20);
            return false;
        }
        return true;
    }

    private void _drawOrigin(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        Point2D.Double originDevice = new Point2D.Double();
        Color drawPaint = Color.BLACK;
        Color fillPaint = this.m_krnl.getTempGeometryFillPaint();
        Color textPaint = Color.BLACK;
        if (!this._getOriginDeviceCoordinates(originDevice)) {
            textPaint = Color.LIGHT_GRAY;
            drawPaint = Color.LIGHT_GRAY;
            fillPaint = fillPaint.brighter();
        }
        String xLabel = "x";
        String yLabel = "y";
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform ucs = cs.getUserCrdTransform();
        if (ucs.getType() != 0) {
            xLabel = "x'";
            yLabel = "y'";
        }
        g.setStroke(new BasicStroke(1.0f));
        Polygon polyX = new Polygon();
        int x = (int)((Point2D)originDevice).getX();
        int y = (int)((Point2D)originDevice).getY();
        polyX.addPoint(x - 2, y);
        polyX.addPoint(x + 30, y);
        polyX.addPoint(x + 30, y - 6);
        polyX.addPoint(x + 30 + 20, y);
        polyX.addPoint(x + 30, y + 6);
        polyX.addPoint(x + 30, y);
        g.setPaint(fillPaint);
        g.fill(polyX);
        g.setPaint(drawPaint);
        g.draw(polyX);
        g.setPaint(textPaint);
        g.drawString(xLabel, x + 30 + 20 - 6, y + 15);
        Polygon polyY = new Polygon();
        polyY.addPoint(x, y + 2);
        polyY.addPoint(x, y - 30);
        polyY.addPoint(x - 6, y - 30);
        polyY.addPoint(x, y - 30 - 20);
        polyY.addPoint(x + 6, y - 30);
        polyY.addPoint(x, y - 30);
        g.setPaint(fillPaint);
        g.fill(polyY);
        g.setPaint(drawPaint);
        g.draw(polyY);
        g.setPaint(textPaint);
        g.drawString(yLabel, x - 13, y - 30 - 20 + 7);
    }

    private void _paintAnnotations(Graphics _g) {
        UserInterface ui = this.m_krnl.getUserInterface();
        if (ui != null && ui.isDrawingEnabled()) {
            for (GeometryPanel.AnnotationRenderer r : this.m_renderers) {
                r.paint(this, _g);
            }
        }
        this._drawGrid(_g);
        this._drawOrigin(_g);
    }

    private boolean _gridPointsTooClose() {
        if ((this.m_flags & 0x200) == 0) {
            return false;
        }
        Projection2D prj2D = this.getProjection();
        AffineTransform m2v = prj2D.getModelToView();
        return this.m_grid.getDx() * m2v.getScaleX() < 10.0 || this.m_grid.getDy() * m2v.getScaleX() < 10.0;
    }

    private void _drawGrid(Graphics _g) {
        int offset;
        int size;
        int dist;
        if ((this.m_flags & 0x200) == 0 || this._gridPointsTooClose()) {
            return;
        }
        Graphics2D g = (Graphics2D)_g;
        Dimension dim = this.getSize();
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(dim.getWidth(), dim.getHeight());
        AffineTransform viewToModel = this.m_projection.getViewToModel();
        Point2D.Double _p1 = new Point2D.Double();
        Point2D.Double _p2 = new Point2D.Double();
        viewToModel.transform(p1, _p1);
        viewToModel.transform(p2, _p2);
        Point2D.Double pmin = new Point2D.Double(Math.min(((Point2D)_p1).getX(), ((Point2D)_p2).getX()), Math.min(((Point2D)_p1).getY(), ((Point2D)_p2).getY()));
        Point2D.Double pmax = new Point2D.Double(Math.max(((Point2D)_p1).getX(), ((Point2D)_p2).getX()), Math.max(((Point2D)_p1).getY(), ((Point2D)_p2).getY()));
        Point2D.Double pMinGrd = new Point2D.Double();
        this.m_grid.snap(pmin, pMinGrd);
        int nx = (int)((((Point2D)pmax).getX() - ((Point2D)pmin).getX()) / this.m_grid.getDx()) + 2;
        int ny = (int)((((Point2D)pmax).getY() - ((Point2D)pmin).getY()) / this.m_grid.getDy()) + 2;
        int n = dist = nx > 0 ? dim.width / nx : 1000;
        if (dist < 40) {
            size = 0;
            offset = 0;
        } else if (dist < 80) {
            size = 1;
            offset = 0;
        } else {
            size = 2;
            offset = -1;
        }
        Projection2D prj2D = this.getProjection();
        AffineTransform m2v = prj2D.getModelToView();
        g.setStroke(new BasicStroke(1.0f));
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                Point2D.Double pnt = new Point2D.Double();
                ((Point2D)pnt).setLocation(((Point2D)pMinGrd).getX() + (double)i * this.m_grid.getDx(), ((Point2D)pMinGrd).getY() + (double)j * this.m_grid.getDy());
                Point2D.Double _pnt = new Point2D.Double();
                m2v.transform(pnt, _pnt);
                int px = (int)((Point2D)_pnt).getX();
                int py = (int)((Point2D)_pnt).getY();
                if (size > 1) {
                    g.setPaint(this.getBackground());
                    g.fillRect(px + offset, py + offset, size, size);
                }
                g.setPaint(this.getForeground());
                g.drawRect(px + offset, py + offset, size, size);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    @Override
    public ViewController getViewController(Component comp) {
        return this.m_viewToModel.getKey(comp);
    }

    @Override
    public Rectangle2D getViewBounds() {
        Rectangle2D bounds = null;
        Set viewSet = this.m_viewToModel.keySet();
        for (ViewController vc : viewSet) {
            Rectangle2D _b = vc.getRawBounds();
            if (_b == null || Double.isNaN(_b.getWidth())) continue;
            if (bounds == null) {
                bounds = _b;
                continue;
            }
            bounds.add(_b);
        }
        return bounds;
    }

    @Override
    public synchronized void putView(Component comp, Class<ViewController> viewControllerClass) throws IllegalAccessException, InstantiationException {
        this.removeView(comp);
        ViewController vc = viewControllerClass.newInstance();
        Marker m = this.m_krnl.getDatabase().getMarkerMap().getMarker(comp);
        vc.setComponent(comp, m, true);
        this.m_viewToModel.put(vc, comp);
        this.m_addedComponents.add(comp);
    }

    @Override
    public synchronized void updateView(Component comp) {
        ViewController vc = this.m_viewToModel.getKey(comp);
        if (vc == null) {
            return;
        }
        this.m_changedComponents.add(comp);
    }

    @Override
    public synchronized boolean removeView(Component comp) {
        ViewController vc = this.m_viewToModel.getKey(comp);
        if (vc == null) {
            return false;
        }
        this.m_removedComponents.add(comp);
        return true;
    }

    @Override
    public synchronized void clearViews() {
        this.m_panelCleared = true;
        this.m_viewToModel.clear();
        this.m_removedComponents.clear();
        this.m_addedComponents.clear();
        this.m_changedComponents.clear();
    }

    @Override
    public synchronized void updatePanel() {
        Rectangle2D vcBounds;
        ViewController vc;
        ViewController vc2;
        Iterator<Component> it;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        Set<Map.Entry<Object, GeometryPanel.AnnotationRenderer>> entries = this.m_myGeometryRenderers.entrySet();
        for (Map.Entry<Object, GeometryPanel.AnnotationRenderer> entry : entries) {
            this.removeAnnotationRenderer(entry.getValue());
        }
        if (this.m_addedComponents.isEmpty() && this.m_changedComponents.isEmpty() && this.m_removedComponents.isEmpty() && !this.m_panelCleared) {
            return;
        }
        this._getPanelImage();
        this._initProjection();
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        Rectangle2D.Double clip = new Rectangle2D.Double();
        if (this.m_panelCleared && (this.m_flags & 0x400) == 0) {
            this._loadNonAccessibleComponents();
            it = this.m_krnl.nonAccessibleComponentsIterator();
            while (it.hasNext()) {
                Component comp = it.next();
                vc2 = this.m_viewToModel.getKey(comp);
                if (vc2 == null) continue;
                vc2.updateViews(this.m_projection.getModelToView(), bounds, this.m_flags, this.m_layeredGraphics);
                this._updateClipArea(clip, vc2);
            }
        }
        for (Component comp : this.m_addedComponents) {
            vc2 = this.m_viewToModel.getKey(comp);
            vc2.updateViews(this.m_projection.getModelToView(), bounds, this.m_flags, this.m_layeredGraphics);
            this._updateClipArea(clip, vc2);
        }
        for (Component comp : this.m_changedComponents) {
            vc2 = this.m_viewToModel.getKey(comp);
            this._updateClipArea(clip, vc2);
            vc2.updateViews(this.m_projection.getModelToView(), bounds, this.m_flags, this.m_layeredGraphics);
            this._updateClipArea(clip, vc2);
        }
        for (Component comp : this.m_removedComponents) {
            vc2 = this.m_viewToModel.getKey(comp);
            this._updateClipArea(clip, vc2);
            this.m_viewToModel.remove(vc2);
        }
        this._reduceRectangleToPanelSize(clip);
        for (String name : this.m_layerMap.keySet()) {
            this.m_layeredGraphics.setLayer(name);
            Composite svComposite = this.m_layeredGraphics.getComposite();
            if (this.m_panelCleared) {
                ((Rectangle2D)clip).setRect(0.0, 0.0, this.getWidth(), this.getHeight());
            }
            this.m_layeredGraphics.setClip(clip);
            AlphaComposite ac = AlphaComposite.getInstance(1);
            this.m_layeredGraphics.setComposite(ac);
            this.m_layeredGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.m_layeredGraphics.setComposite(svComposite);
        }
        it = this.m_krnl.nonAccessibleComponentsIterator();
        while (it.hasNext()) {
            Component comp = it.next();
            vc = this.m_viewToModel.getKey(comp);
            if (vc == null || (vcBounds = vc.getBounds()) == null || !vcBounds.intersects(clip)) continue;
            this.m_layeredGraphics.setLayer("COMPONENT_GRAPHICS");
            vc.draw(this.m_layeredGraphics);
        }
        for (Component comp : this.m_krnl.getDatabase().getComponentList()) {
            vc = this.m_viewToModel.getKey(comp);
            if (vc == null || (vcBounds = vc.getBounds()) == null || !vcBounds.intersects(clip)) continue;
            this.m_layeredGraphics.setLayer("COMPONENT_GRAPHICS");
            vc.draw(this.m_layeredGraphics);
        }
        for (String name : this.m_layerMap.keySet()) {
            this.m_layeredGraphics.setLayer(name);
            this.m_layeredGraphics.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        this.m_addedComponents.clear();
        this.m_changedComponents.clear();
        this.m_removedComponents.clear();
        this.m_panelCleared = false;
        Rectangle r = clip.getBounds();
        r.grow(1, 1);
        this.repaint(r);
    }

    private void _updateClipArea(Rectangle2D clip, ViewController vc) {
        Rectangle2D vcBounds = vc.getBounds();
        if (vcBounds == null) {
            return;
        }
        if (clip.isEmpty()) {
            clip.setRect(vcBounds);
        } else {
            clip.add(vcBounds);
        }
        double x = clip.getX() - 1.0;
        double y = clip.getY() - 1.0;
        double w = clip.getWidth() + 2.0;
        double h = clip.getHeight() + 2.0;
        clip.setFrame(x, y, w, h);
    }

    private Rectangle2D _reduceRectangleToPanelSize(Rectangle2D rct) {
        if (rct == null || rct.isEmpty()) {
            return rct;
        }
        double minX = rct.getMinX();
        double minY = rct.getMinY();
        double maxX = rct.getMaxX();
        double maxY = rct.getMaxY();
        if (minX > (double)this.getWidth() || minY > (double)this.getHeight() || maxX < 0.0 || maxY < 0.0) {
            return null;
        }
        minX = Math.max(minX, 0.0);
        minY = Math.max(minY, 0.0);
        maxX = Math.min(maxX, (double)this.getWidth());
        maxY = Math.min(maxY, (double)this.getHeight());
        rct.setFrame(minX, minY, maxX - minX, maxY - minY);
        return rct;
    }

    @Override
    public void repaintPanel() {
        this.m_panelBuffer = null;
        Set<Map.Entry<Object, GeometryPanel.AnnotationRenderer>> entries = this.m_myGeometryRenderers.entrySet();
        for (Map.Entry<Object, GeometryPanel.AnnotationRenderer> entry : entries) {
            this.removeAnnotationRenderer(entry.getValue());
        }
        if ((this.m_flags & 0x400) == 0) {
            this._loadNonAccessibleComponents();
        } else {
            this._unloadNonAccessibleComponents();
        }
    }

    private void _loadNonAccessibleComponents() {
        GraphicalUserInterface gui = (GraphicalUserInterface)this.m_krnl.getUserInterface();
        Iterator<Component> it = this.m_krnl.nonAccessibleComponentsIterator();
        while (it.hasNext()) {
            Component comp = it.next();
            try {
                Class<ViewController> viewControllerClass = gui._findViewCtrlClass(comp);
                ViewController vc = viewControllerClass.newInstance();
                vc.setComponent(comp, null, false);
                this.m_viewToModel.put(vc, comp);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void _unloadNonAccessibleComponents() {
        Iterator<Component> it = this.m_krnl.nonAccessibleComponentsIterator();
        while (it.hasNext()) {
            Component comp = it.next();
            ViewController vc = this.m_viewToModel.getKey(comp);
            if (vc == null) continue;
            this.m_viewToModel.remove(vc);
        }
    }

    @Override
    public void transformPanelImmediately(AffineTransform trf) {
        BufferedImage bi = this._getPanelImage();
        if (bi == null) {
            return;
        }
        Graphics2D gfx = (Graphics2D)this.getGraphics();
        gfx.setColor(Color.LIGHT_GRAY);
        gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        Point2D.Double pmin = new Point2D.Double();
        Point2D.Double pmax = new Point2D.Double(bi.getWidth(), bi.getHeight());
        trf.transform(pmin, pmin);
        trf.transform(pmax, pmax);
        int ix = (int)((Point2D)pmin).getX();
        int iy = (int)((Point2D)pmin).getY();
        int jx = (int)((Point2D)pmax).getX() + 1;
        int jy = (int)((Point2D)pmax).getY() + 1;
        gfx.setColor(Color.WHITE);
        gfx.fillRect(ix, iy, jx - ix, jy - iy);
        gfx.drawImage(bi, trf, null);
        gfx.dispose();
    }

    @Override
    public synchronized boolean addAnnotationRenderer(GeometryPanel.AnnotationRenderer r) {
        boolean val = this.m_renderers.add(r);
        if (val) {
            this.repaint();
        }
        return val;
    }

    @Override
    public synchronized boolean removeAnnotationRenderer(GeometryPanel.AnnotationRenderer r) {
        boolean val = this.m_renderers.remove(r);
        if (val) {
            this.repaint();
        }
        return val;
    }

    @Override
    public Iterator<GeometryPanel.AnnotationRenderer> annotationRendererIterator() {
        return this.m_renderers.iterator();
    }

    @Override
    public void draw(final Point2D pnt) {
        GeometryPanel.AnnotationRenderer renderer = new GeometryPanel.AnnotationRenderer(){

            @Override
            public void paint(GeometryPanel p, Graphics _g) {
                Projection2D prj2D = DrawPanel.this.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                Point2D.Double _pnt = new Point2D.Double();
                m2v.transform(pnt, _pnt);
                Graphics2D g = (Graphics2D)_g;
                g.setPaint(DrawPanel.this.m_krnl.getTempGeometryDrawPaint());
                g.setStroke(new BasicStroke(2.0f));
                Line2D.Double _lin = new Line2D.Double();
                ((Line2D)_lin).setLine(((Point2D)_pnt).getX() - 3.0, ((Point2D)_pnt).getY(), ((Point2D)_pnt).getX() + 3.0, ((Point2D)_pnt).getY());
                g.draw(_lin);
                ((Line2D)_lin).setLine(((Point2D)_pnt).getX(), ((Point2D)_pnt).getY() - 3.0, ((Point2D)_pnt).getX(), ((Point2D)_pnt).getY() + 3.0);
                g.draw(_lin);
            }
        };
        if (this.m_myGeometryRenderers.containsKey(pnt)) {
            this.removeAnnotationRenderer(this.m_myGeometryRenderers.get(pnt));
        }
        this.m_myGeometryRenderers.put(pnt, renderer);
        this.addAnnotationRenderer(renderer);
    }

    @Override
    public void undraw(Point2D pnt) {
        GeometryPanel.AnnotationRenderer renderer = this.m_myGeometryRenderers.get(pnt);
        if (renderer != null) {
            this.removeAnnotationRenderer(renderer);
        }
    }

    @Override
    public void draw(final Shape shp) {
        GeometryPanel.AnnotationRenderer renderer = new GeometryPanel.AnnotationRenderer(){

            @Override
            public void paint(GeometryPanel p, Graphics _g) {
                Projection2D prj2D = DrawPanel.this.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                Shape _shp = m2v.createTransformedShape(shp);
                Graphics2D g = (Graphics2D)_g;
                g.setPaint(DrawPanel.this.m_krnl.getTempGeometryDrawPaint());
                g.setStroke(new BasicStroke(2.0f));
                g.draw(_shp);
            }
        };
        if (this.m_myGeometryRenderers.containsKey(shp)) {
            this.removeAnnotationRenderer(this.m_myGeometryRenderers.get(shp));
        }
        this.m_myGeometryRenderers.put(shp, renderer);
        this.addAnnotationRenderer(renderer);
    }

    @Override
    public void undraw(Shape shp) {
        GeometryPanel.AnnotationRenderer renderer = this.m_myGeometryRenderers.get(shp);
        if (renderer != null) {
            this.removeAnnotationRenderer(renderer);
        }
    }

    @Override
    public void drawLine(final Line2D lin) {
        GeometryPanel.AnnotationRenderer renderer = new GeometryPanel.AnnotationRenderer(){

            @Override
            public void paint(GeometryPanel p, Graphics _g) {
                try {
                    Projection2D prj2D = DrawPanel.this.getProjection();
                    AffineTransform m2v = prj2D.getModelToView();
                    Point2D.Double p1 = new Point2D.Double();
                    Point2D.Double p2 = new Point2D.Double();
                    m2v.transform(lin.getP1(), p1);
                    m2v.transform(lin.getP2(), p2);
                    double maxDx = Math.abs(((Point2D)p1).getX()) + (double)DrawPanel.this.getWidth();
                    double maxDy = Math.abs(((Point2D)p1).getY()) + (double)DrawPanel.this.getHeight();
                    double maxD = maxDx + maxDy;
                    Vector2D v = new Vector2D(p2, p1);
                    v.normalize();
                    v.scaleBy(maxD);
                    Vector2D q1 = new Vector2D(p1);
                    q1.add(v);
                    maxDx = Math.abs(((Point2D)p2).getX()) + (double)DrawPanel.this.getWidth();
                    maxDy = Math.abs(((Point2D)p2).getY()) + (double)DrawPanel.this.getHeight();
                    maxD = maxDx + maxDy;
                    v.setLocation(p1, p2);
                    v.normalize();
                    v.scaleBy(maxD);
                    Vector2D q2 = new Vector2D(p2);
                    q2.add(v);
                    Line2D.Double extLine = new Line2D.Double();
                    extLine.setLine(q1, q2);
                    Graphics2D g = (Graphics2D)_g;
                    g.setPaint(DrawPanel.this.m_krnl.getTempGeometryDrawPaint());
                    BasicStroke stroke = new BasicStroke(2.0f, 2, 2, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
                    g.setStroke(stroke);
                    g.draw(extLine);
                }
                catch (NullVectorException nullVectorException) {
                    // empty catch block
                }
            }
        };
        if (this.m_myGeometryRenderers.containsKey(lin)) {
            this.removeAnnotationRenderer(this.m_myGeometryRenderers.get(lin));
        }
        this.m_myGeometryRenderers.put(lin, renderer);
        this.addAnnotationRenderer(renderer);
    }

    @Override
    public void undrawLine(Line2D lin) {
        GeometryPanel.AnnotationRenderer renderer = this.m_myGeometryRenderers.get(lin);
        if (renderer != null) {
            this.removeAnnotationRenderer(renderer);
        }
    }

    @Override
    public void drawVector(final Vector2D vec, final Point2D at) {
        GeometryPanel.AnnotationRenderer renderer = new GeometryPanel.AnnotationRenderer(){

            @Override
            public void paint(GeometryPanel p, Graphics _g) {
                Projection2D prj2D = DrawPanel.this.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                Point2D from = at == null ? new Point2D.Double() : at;
                Point2D.Double _from = new Point2D.Double();
                m2v.transform(from, _from);
                Point2D.Double _to = new Point2D.Double();
                m2v.transform(new Point2D.Double(from.getX() + vec.x, from.getY() + vec.y), _to);
                double l = Geo2D.distance((Point2D)_from, _to);
                double x1 = ((Point2D)_from).getX();
                double y1 = ((Point2D)_from).getY();
                double x2 = ((Point2D)_to).getX();
                double y2 = ((Point2D)_to).getY();
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(0.0, 0.0);
                ((Path2D)path).lineTo(l - 20.0, 0.0);
                ((Path2D)path).lineTo(l - 20.0, 6.0);
                ((Path2D)path).lineTo(l, 0.0);
                ((Path2D)path).lineTo(l - 20.0, -6.0);
                ((Path2D)path).lineTo(l - 20.0, 0.0);
                double angle = Math.atan2(y2 - y1, x2 - x1);
                if (x1 < 0.0 || x1 > (double)DrawPanel.this.getWidth() || y1 < 0.0 || y1 > (double)DrawPanel.this.getWidth()) {
                    x1 = 0.5f * (float)DrawPanel.this.getWidth();
                    y1 = 0.5f * (float)DrawPanel.this.getHeight();
                }
                AffineTransform trf = AffineTransform.getTranslateInstance(x1, y1);
                trf.rotate(angle);
                Shape shp = path.createTransformedShape(trf);
                Graphics2D g = (Graphics2D)_g;
                g.setStroke(new BasicStroke(1.0f));
                g.setPaint(Color.WHITE);
                g.fill(shp);
                g.setPaint(DrawPanel.this.m_krnl.getTempGeometryDrawPaint());
                g.draw(shp);
            }
        };
        if (this.m_myGeometryRenderers.containsKey(vec)) {
            this.removeAnnotationRenderer(this.m_myGeometryRenderers.get(vec));
        }
        this.m_myGeometryRenderers.put(vec, renderer);
        this.addAnnotationRenderer(renderer);
    }

    @Override
    public void undrawVector(Vector2D vec) {
        GeometryPanel.AnnotationRenderer renderer = this.m_myGeometryRenderers.get(vec);
        if (renderer != null) {
            this.removeAnnotationRenderer(renderer);
        }
    }

    @Override
    public Iterator<Component> objectIterator() {
        return new _ObjectIterator();
    }

    @Override
    public Iterator<Component> objectIterator(Rectangle2D r, boolean intersect) {
        if (r == null) {
            throw new IllegalArgumentException();
        }
        return new _IntersectIterator(r, intersect);
    }

    @Override
    public GeometryPanel.PointIterator intersectionPointIterator(Component o, Rectangle2D r) {
        return new _PointIterator(o, r);
    }

    @Override
    public GeometryPanel.SegmentIterator intersectionSegmentIterator(Component o, Rectangle2D r) {
        return new _SegmentIterator(o, r);
    }

    @Override
    public void setGrid(Grid grid, boolean enable) {
        if (grid != null) {
            this.m_grid = new Grid(grid);
            this.m_grid.toProperties(this.m_krnl.getProperties(), this._propertiesPrefix());
        }
        int flags = this.m_flags & 0xFFFFFDFF;
        if (enable) {
            flags |= 0x200;
        }
        this.setFlags(flags);
    }

    @Override
    public Grid getGrid() {
        return (Grid)this.m_grid.clone();
    }

    @Override
    public boolean enableMicroscope(boolean enable) {
        if (enable == this.m_microscopeEnabled) {
            return enable;
        }
        if (!enable) {
            this.m_microscopeClip = null;
        }
        this.m_microscopeEnabled = enable;
        return this.m_microscopeEnabled;
    }

    @Override
    public boolean microscopeEnabled() {
        return this.m_microscopeEnabled;
    }

    @Override
    public int getFlags() {
        return this.m_flags;
    }

    @Override
    public void setFlags(int flags) {
        this.m_flags = flags;
        this.m_krnl.setProperty(String.valueOf(this._propertiesPrefix()) + "flags", String.valueOf(this.m_flags));
    }

    @Override
    public synchronized void setProjection(Projection2D p) {
        this.m_projection = p;
        this.m_panelBuffer = null;
    }

    @Override
    public Projection2D getProjection() {
        return (Projection2D)this.m_projection.clone();
    }

    @Override
    public Point2D ungriddedModelPoint(int x, int y) {
        if (this.m_projection == null) {
            return new Point2D.Double();
        }
        Point2D.Double vPnt = new Point2D.Double(x, y);
        AffineTransform v2m = this.m_projection.getViewToModel();
        Point2D.Double mPnt = new Point2D.Double();
        v2m.transform(vPnt, mPnt);
        return mPnt;
    }

    @Override
    public Point2D griddedModelPoint(int x, int y) {
        Point2D p = this.ungriddedModelPoint(x, y);
        return (this.m_flags & 0x200) != 0 ? this.m_grid.snap(p, null) : p;
    }

    public Point2D pickedModelPoint(MouseEvent e) {
        return null;
    }

    private class _ControlPointIterator
    implements GeometryPanel.PointIterator {
        private Rectangle2D m_rectangle;
        private CtrlSegments m_ctrlSegs = null;
        private ListIterator<View> m_viewIterator = null;
        private NamedListIterator<Point2D> m_compControlPointIterator = null;
        private Point2D m_nextPoint = null;
        private int m_nextName = -1;

        private _ControlPointIterator(Component o, Rectangle2D r) {
            if (o instanceof CtrlSegments) {
                this.m_ctrlSegs = (CtrlSegments)o;
            }
            this.m_rectangle = r;
            ViewController vc = DrawPanel.this.m_viewToModel.getKey(o);
            this.m_viewIterator = vc.viewIterator();
            this.m_compControlPointIterator = vc.getComponent().controlPointIterator();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.m_nextPoint != null;
        }

        @Override
        public int next(Point2D pnt) {
            if (this.m_nextPoint == null) {
                throw new NoSuchElementException();
            }
            pnt.setLocation(this.m_nextPoint);
            int name = this.m_nextName;
            this.findNext();
            return name;
        }

        private void findNext() {
            while (this.m_viewIterator != null && this.m_viewIterator.hasNext()) {
                int ctrlPointType;
                View v = this.m_viewIterator.next();
                if (!(v instanceof ControlPointView)) continue;
                do {
                    if (!this.m_compControlPointIterator.hasNext()) {
                        this.m_nextPoint = null;
                        return;
                    }
                    this.m_nextPoint = (Point2D)this.m_compControlPointIterator.next();
                    this.m_nextName = this.m_compControlPointIterator.previousName();
                } while ((ctrlPointType = this.m_ctrlSegs != null ? this.m_ctrlSegs.getCtrlType(this.m_nextName) : 1) == 128 || ctrlPointType == 4);
                ControlPointView cpv = (ControlPointView)v;
                Point2D.Double vp = new Point2D.Double(cpv.getControlPointX(), cpv.getControlPointY());
                if (!this.m_rectangle.contains(vp)) continue;
                return;
            }
            this.m_nextPoint = null;
            this.m_nextName = -1;
        }
    }

    private class _ControlSegmentIterator
    implements GeometryPanel.SegmentIterator {
        private Component m_comp = null;
        private Rectangle2D m_rectangle;
        private ListIterator<View> m_axisViewIterator = null;
        private int m_nextType = -1;
        private int m_nextCtrlPntName = -1;
        private int m_previousCtrlPntName = -1;
        private double[] m_nextCoords = new double[8];

        private _ControlSegmentIterator(Component o, Rectangle2D r) {
            this.m_comp = o;
            this.m_rectangle = r;
            ViewController vc = DrawPanel.this.m_viewToModel.getKey(o);
            this.m_axisViewIterator = vc.viewIterator();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.m_nextType != -1;
        }

        @Override
        public int next(double[] coords) {
            if (this.m_nextType == -1) {
                throw new NoSuchElementException();
            }
            int i = 0;
            while (i < 8) {
                coords[i] = this.m_nextCoords[i];
                ++i;
            }
            int type = this.m_nextType;
            this.m_previousCtrlPntName = this.m_nextCtrlPntName;
            this.findNext();
            return type;
        }

        @Override
        public int previousCtrlPntName() {
            return this.m_previousCtrlPntName;
        }

        private void findNext() {
            while (this.m_axisViewIterator.hasNext()) {
                View view = this.m_axisViewIterator.next();
                if (!(view instanceof AxisView)) continue;
                CtrlSegments cs = (CtrlSegments)this.m_comp;
                AxisView axis = (AxisView)view;
                this.m_nextCtrlPntName = axis.getCtrlPntName();
                this.m_nextType = cs.getSegmentCrds(this.m_nextCtrlPntName, this.m_nextCoords);
                Shape shape = axis.getAxis();
                if (shape.contains(this.m_rectangle) || !shape.intersects(this.m_rectangle)) continue;
                return;
            }
            this.m_nextType = -1;
        }
    }

    private class _IntersectIterator
    implements Iterator<Component> {
        private Rectangle2D m_rectangle;
        private boolean m_intersect;
        private Set<ViewController> m_ViewControllers;
        private Iterator<ViewController> m_viewControllerIterator;
        private ViewController m_nextIntersectedViewController = null;
        private boolean m_iterationTerminated = false;

        private _IntersectIterator(Rectangle2D r, boolean intersect) {
            this.m_rectangle = r;
            this.m_intersect = intersect;
            this.m_ViewControllers = DrawPanel.this.m_viewToModel.keySet();
            this.m_viewControllerIterator = this.m_ViewControllers.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.m_iterationTerminated) {
                return false;
            }
            if (this.m_nextIntersectedViewController != null) {
                return true;
            }
            this.findNext();
            if (this.m_iterationTerminated) {
                return false;
            }
            return this.m_nextIntersectedViewController != null;
        }

        @Override
        public Component next() {
            if (this.m_iterationTerminated) {
                throw new NoSuchElementException();
            }
            if (this.m_nextIntersectedViewController == null) {
                this.findNext();
            }
            if (this.m_iterationTerminated) {
                throw new NoSuchElementException();
            }
            ViewController vc = this.m_nextIntersectedViewController;
            this.m_nextIntersectedViewController = null;
            return (Component)DrawPanel.this.m_viewToModel.get(vc);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            if (this.m_iterationTerminated) {
                return;
            }
            this.m_nextIntersectedViewController = null;
            while (this.m_viewControllerIterator.hasNext()) {
                ViewController vc = this.m_viewControllerIterator.next();
                if (this.m_intersect && !vc.intersects(this.m_rectangle) || !this.m_intersect && !this.m_rectangle.contains(vc.getBounds())) continue;
                this.m_nextIntersectedViewController = vc;
                return;
            }
            this.m_iterationTerminated = true;
        }
    }

    private class _LayeredGraphics2D
    extends LayeredGraphics2D {
        private Graphics2D m_gfx = null;
        private Map<String, Graphics2D> m_layerGraphics = new HashMap<String, Graphics2D>();

        private _LayeredGraphics2D() {
            Set layers = DrawPanel.this.m_layerMap.keySet();
            for (String layer : layers) {
                this.m_layerGraphics.put(layer, null);
                Image img = (Image)DrawPanel.this.m_layerMap.get(layer);
                if (img == null) continue;
                Graphics2D gfx = (Graphics2D)img.getGraphics();
                DrawPanel.this._initGraphics(gfx);
                this.m_layerGraphics.put(layer, gfx);
            }
            this.setLayer("COMPONENT_GRAPHICS");
        }

        @Override
        public void dispose() {
            Set<String> layers = this.m_layerGraphics.keySet();
            for (String layer : layers) {
                Graphics gfx = this.m_layerGraphics.get(layer);
                if (gfx == null) continue;
                gfx.dispose();
                this.m_layerGraphics.put(layer, null);
            }
        }

        @Override
        protected Graphics2D getGraphics() {
            if (this.m_gfx == null) {
                throw new IllegalStateException();
            }
            return this.m_gfx;
        }

        @Override
        public boolean setLayer(String name) {
            if (!this.m_layerGraphics.containsKey(name)) {
                throw new IllegalArgumentException();
            }
            Graphics2D gfx = this.m_layerGraphics.get(name);
            if (gfx == null) {
                return false;
            }
            this.m_gfx = gfx;
            return true;
        }
    }

    private class _ObjectIterator
    implements Iterator<Component> {
        private Iterator<Component> m_iterator;

        private _ObjectIterator() {
            HashSet set = new HashSet(DrawPanel.this.m_viewToModel.values());
            this.m_iterator = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public Component next() {
            return this.m_iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class _PathPointIterator
    implements GeometryPanel.PointIterator {
        private PathIterator m_pit = null;
        private AffineTransform m_modelToView = null;
        private Rectangle2D m_rectangle;
        private boolean m_hasNext = false;
        private Point2D m_pnt = new Point2D.Double();

        private _PathPointIterator(PathIterator pit, AffineTransform m2v, Rectangle2D r) {
            this.m_pit = pit;
            this.m_modelToView = m2v;
            this.m_rectangle = r;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.m_hasNext;
        }

        @Override
        public int next(Point2D pnt) {
            if (!this.m_hasNext) {
                throw new NoSuchElementException();
            }
            pnt.setLocation(this.m_pnt);
            this.findNext();
            return -1;
        }

        private void findNext() {
            double[] crds = new double[6];
            Point2D.Double viewPnt = new Point2D.Double();
            while (!this.m_pit.isDone()) {
                block8: {
                    int type = this.m_pit.currentSegment(crds);
                    switch (type) {
                        case 0: 
                        case 1: {
                            this.m_pnt.setLocation(crds[0], crds[1]);
                            break;
                        }
                        case 2: {
                            this.m_pnt.setLocation(crds[2], crds[3]);
                            break;
                        }
                        case 3: {
                            this.m_pnt.setLocation(crds[4], crds[5]);
                            break;
                        }
                        default: {
                            break block8;
                        }
                    }
                    this.m_modelToView.transform(this.m_pnt, viewPnt);
                    if (this.m_rectangle.contains(viewPnt)) {
                        if (!this.m_pit.isDone()) {
                            this.m_pit.next();
                        }
                        this.m_hasNext = true;
                        return;
                    }
                }
                this.m_pit.next();
            }
            this.m_hasNext = false;
        }
    }

    private class _PathSegmentIterator
    implements GeometryPanel.SegmentIterator {
        private PathIterator m_pit = null;
        private AffineTransform m_modelToView = null;
        private Rectangle2D m_rectangle;
        private boolean m_hasNext = false;
        private double[] m_moveto = new double[2];
        private double[] m_lastto = new double[2];
        private double[] m_crds = new double[8];
        private int m_type = -1;

        private _PathSegmentIterator(PathIterator pit, AffineTransform m2v, Rectangle2D r) {
            this.m_pit = pit;
            this.m_modelToView = m2v;
            this.m_rectangle = r;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.m_hasNext;
        }

        @Override
        public int next(double[] crds) {
            if (!this.m_hasNext) {
                throw new NoSuchElementException();
            }
            int i = 0;
            while (i < 8) {
                crds[i] = this.m_crds[i];
                ++i;
            }
            int type = this.m_type;
            this.findNext();
            return type;
        }

        private void findNext() {
            double[] crds = new double[8];
            while (!this.m_pit.isDone()) {
                block15: {
                    Shape viewShape;
                    int type = this.m_pit.currentSegment(crds);
                    switch (type) {
                        case 0: {
                            this.m_type = -1;
                            this.m_moveto[0] = crds[0];
                            this.m_moveto[1] = crds[1];
                            this.m_lastto[0] = crds[0];
                            this.m_lastto[1] = crds[1];
                            break block15;
                        }
                        case 1: {
                            this.m_type = 8;
                            this.m_crds[0] = this.m_lastto[0];
                            this.m_crds[1] = this.m_lastto[1];
                            this.m_crds[2] = crds[0];
                            this.m_crds[3] = crds[1];
                            this.m_lastto[0] = crds[0];
                            this.m_lastto[1] = crds[1];
                            break;
                        }
                        case 2: {
                            this.m_type = 16;
                            this.m_crds[0] = this.m_lastto[0];
                            this.m_crds[1] = this.m_lastto[1];
                            this.m_crds[2] = crds[0];
                            this.m_crds[3] = crds[1];
                            this.m_crds[4] = crds[2];
                            this.m_crds[5] = crds[3];
                            this.m_lastto[0] = crds[2];
                            this.m_lastto[1] = crds[3];
                            break;
                        }
                        case 3: {
                            this.m_type = 32;
                            this.m_crds[0] = this.m_lastto[0];
                            this.m_crds[1] = this.m_lastto[1];
                            this.m_crds[2] = crds[0];
                            this.m_crds[3] = crds[1];
                            this.m_crds[4] = crds[2];
                            this.m_crds[5] = crds[3];
                            this.m_crds[6] = crds[4];
                            this.m_crds[7] = crds[5];
                            this.m_lastto[0] = crds[4];
                            this.m_lastto[1] = crds[5];
                            break;
                        }
                        case 4: {
                            this.m_type = 8;
                            this.m_crds[0] = this.m_lastto[0];
                            this.m_crds[1] = this.m_lastto[1];
                            this.m_crds[2] = this.m_moveto[0];
                            this.m_crds[3] = this.m_moveto[1];
                            break;
                        }
                        default: {
                            break block15;
                        }
                    }
                    switch (this.m_type) {
                        case 8: {
                            this.m_modelToView.transform(this.m_crds, 0, crds, 0, 2);
                            viewShape = new Line2D.Double(crds[0], crds[1], crds[2], crds[3]);
                            break;
                        }
                        case 16: {
                            this.m_modelToView.transform(this.m_crds, 0, crds, 0, 2);
                            viewShape = new QuadCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                            break;
                        }
                        case 32: {
                            this.m_modelToView.transform(this.m_crds, 0, crds, 0, 2);
                            viewShape = new CubicCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    if (this.m_type != -1 && !viewShape.contains(this.m_rectangle) && viewShape.intersects(this.m_rectangle)) {
                        if (!this.m_pit.isDone()) {
                            this.m_pit.next();
                        }
                        this.m_hasNext = true;
                        return;
                    }
                }
                this.m_pit.next();
            }
            this.m_hasNext = false;
        }

        @Override
        public int previousCtrlPntName() {
            return 0;
        }
    }

    private class _PointIterator
    implements GeometryPanel.PointIterator {
        private _ControlPointIterator m_controlPointIterator;
        private List<_PathPointIterator> m_pathPointIterators = new ArrayList<_PathPointIterator>();

        private _PointIterator(Component o, Rectangle2D r) {
            AffineTransform m2v = DrawPanel.this.m_projection.getModelToView();
            this.m_controlPointIterator = new _ControlPointIterator(o, r);
            NamedListIterator<AttributedShape> it = o.shapeIterator();
            while (it.hasNext()) {
                Shape shape = (Shape)it.next();
                this.m_pathPointIterators.add(new _PathPointIterator(shape.getPathIterator(null), m2v, r));
            }
        }

        @Override
        public boolean hasNext() {
            if (this.m_controlPointIterator.hasNext()) {
                return true;
            }
            Iterator<_PathPointIterator> it = this.m_pathPointIterators.iterator();
            while (it.hasNext()) {
                if (!it.next().hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int next(Point2D pnt) {
            if (this.m_controlPointIterator.hasNext()) {
                return this.m_controlPointIterator.next(pnt);
            }
            for (_PathPointIterator ppit : this.m_pathPointIterators) {
                if (!ppit.hasNext()) continue;
                return ppit.next(pnt);
            }
            throw new NoSuchElementException();
        }
    }

    private class _SegmentIterator
    implements GeometryPanel.SegmentIterator {
        private _ControlSegmentIterator m_controlSegmentIterator;
        private List<_PathSegmentIterator> m_pathSegmentIterators = new ArrayList<_PathSegmentIterator>();
        private int m_previousControlPntName = -1;

        private _SegmentIterator(Component o, Rectangle2D r) {
            AffineTransform m2v = DrawPanel.this.m_projection.getModelToView();
            this.m_controlSegmentIterator = new _ControlSegmentIterator(o, r);
            NamedListIterator<AttributedShape> it = o.shapeIterator();
            while (it.hasNext()) {
                Shape shape = (Shape)it.next();
                this.m_pathSegmentIterators.add(new _PathSegmentIterator(shape.getPathIterator(null), m2v, r));
            }
        }

        @Override
        public boolean hasNext() {
            if (this.m_controlSegmentIterator.hasNext()) {
                return true;
            }
            Iterator<_PathSegmentIterator> it = this.m_pathSegmentIterators.iterator();
            while (it.hasNext()) {
                if (!it.next().hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int next(double[] crds) {
            if (this.m_controlSegmentIterator.hasNext()) {
                int type = this.m_controlSegmentIterator.next(crds);
                this.m_previousControlPntName = this.m_controlSegmentIterator.previousCtrlPntName();
                return type;
            }
            for (_PathSegmentIterator ppit : this.m_pathSegmentIterators) {
                if (!ppit.hasNext()) continue;
                this.m_previousControlPntName = ppit.previousCtrlPntName();
                return ppit.next(crds);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int previousCtrlPntName() {
            return this.m_previousControlPntName;
        }
    }
}

