/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.view.ViewUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorMessagePrintStream
extends PrintStream {
    private JFrame m_frame;
    private MsgThread m_msgThread = null;

    public ErrorMessagePrintStream(JFrame frame) {
        super(new ByteArrayOutputStream());
        this.m_frame = frame;
        this.m_msgThread = new MsgThread();
        this.m_msgThread.start();
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void print(boolean b) {
        System.out.print(b);
        this._print(b);
    }

    private void _print(boolean b) {
        this._append(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        System.out.print(c);
        this._print(c);
    }

    private void _print(char c) {
        this._append(String.valueOf(c));
    }

    @Override
    public void print(char[] s) {
        System.out.print(s);
        this._print(s);
    }

    private void _print(char[] s) {
        this._append(String.valueOf(s));
    }

    @Override
    public void print(double d) {
        System.out.print(d);
        this._print(d);
    }

    private void _print(double d) {
        this._append(String.valueOf(d));
    }

    @Override
    public void print(float f) {
        System.out.print(f);
        this._print(f);
    }

    private void _print(float f) {
        this._append(String.valueOf(f));
    }

    @Override
    public void print(int i) {
        System.out.print(i);
        this._print(i);
    }

    private void _print(int i) {
        this._append(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        System.out.print(l);
        this._print(l);
    }

    private void _print(long l) {
        this._append(String.valueOf(l));
    }

    @Override
    public void print(Object obj) {
        System.out.print(obj);
        this._print(obj);
    }

    private void _print(Object obj) {
        this._append(String.valueOf(obj));
    }

    @Override
    public void print(String s) {
        System.out.print(s);
        this._print(s);
    }

    private void _print(String s) {
        this._append(s);
    }

    @Override
    public void println() {
        System.out.println();
        this._println();
    }

    private void _println() {
        this._append("\n");
    }

    @Override
    public void println(boolean x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(char x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(char[] x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(double x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(float x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(int x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(long x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(Object x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void println(String x) {
        System.out.println(x);
        this._print(x);
        this._println();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        System.out.write(buf, off, len);
        this._print(new String(buf, off, len));
    }

    @Override
    public void write(int b) {
        System.out.write(b);
        this._print(String.valueOf((char)b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        System.out.write(b);
        this._print(new String(b));
    }

    private void _append(String text) {
        this.m_msgThread.append(text);
    }

    private class MsgThread
    extends Thread {
        private static final int WAIT = 300;
        private long m_msgChangedTime = -1L;
        private String m_msg = null;

        public void append(String msg) {
            this.m_msg = this.m_msg == null ? msg : String.valueOf(this.m_msg) + msg;
            this.m_msgChangedTime = System.currentTimeMillis();
        }

        @Override
        public void run() {
            while (true) {
                if (this.m_msg != null && System.currentTimeMillis() - this.m_msgChangedTime > 300L) {
                    String msg = this.m_msg;
                    this.m_msg = null;
                    this._showMessageDialog(msg);
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private void _showMessageDialog(String msg) {
            JTextArea textArea = new JTextArea(msg);
            int size = textArea.getFont().getSize();
            textArea.setFont(new Font("sansserif", 0, size));
            textArea.setRows(Math.min(25, textArea.getLineCount()));
            int width = Math.min(800, textArea.getPreferredSize().width);
            int height = textArea.getPreferredSize().height;
            textArea.setEditable(false);
            textArea.setTabSize(2);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.setPreferredSize(new Dimension(width, height));
            JOptionPane jOptionPane = new JOptionPane(scrollPane, 0);
            Color bg = jOptionPane.getBackground();
            textArea.setBackground(bg);
            JDialog jDlg = jOptionPane.createDialog(ErrorMessagePrintStream.this.m_frame, Messages.getString("view.ErrorMessagePrintStream.4"));
            jDlg.setResizable(false);
            jDlg.setModal(true);
            jDlg.pack();
            Kernel.getInstance().setPreferredLocation(jDlg);
            jDlg.setVisible(true);
            Kernel.getInstance().savePreferredLocation(jDlg);
            ViewUtilities.requestFocusAsynchronously(ErrorMessagePrintStream.this.m_frame);
        }
    }
}

