/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class _ConsistentHashMap<K, V>
implements ReverseAccessMap<K, V>,
Serializable {
    private static final long serialVersionUID = 0L;
    private ReverseAccessMap<K, V> m_map;
    private Set<K> m_keys;
    private Set<V> m_values;

    protected _ConsistentHashMap(ReverseAccessMap<K, V> map, ObservableSet<K> keys, ObservableSet<V> values) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.m_map = map;
        keys.addListener(new ObservableSet.Listener<K>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasRemoved(K key) {
                _ConsistentHashMap.this.m_map.remove(key);
            }
        });
        values.addListener(new ObservableSet.Listener<V>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasRemoved(V value) {
                Set keySet = _ConsistentHashMap.this.m_map.keySet(value);
                for (Object key : keySet) {
                    _ConsistentHashMap.this.m_map.remove(key);
                }
            }
        });
    }

    @Override
    public K getKey(V value) {
        return this.m_map.getKey(value);
    }

    @Override
    public Set<K> keySet(V value) {
        return this.m_map.keySet(value);
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.m_map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.m_map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.m_map.keySet();
    }

    @Override
    public V put(K key, V value) {
        if (!this.m_keys.contains(key) || !this.m_values.contains(value)) {
            throw new IllegalArgumentException();
        }
        return this.m_map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) throws UnsupportedOperationException {
        if (!this.m_keys.containsAll(t.keySet()) || !this.m_values.containsAll(t.values())) {
            throw new IllegalArgumentException();
        }
        this.m_map.putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.m_map.remove(key);
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public Collection<V> values() {
        return this.m_map.values();
    }

    public String toString() {
        return this.m_map.toString();
    }
}

