/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.coll.ObservableSet;
import cib.util.coll.SwappableList;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

class _OrderedSet<E>
extends AbstractList<E>
implements SwappableList<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected ObservableSet<E> m_set = null;
    protected List<E> m_list = null;

    protected _OrderedSet(ObservableSet<E> set) {
        this.m_set = set;
        this.m_list = new ArrayList<E>(set);
        set.addListener(new ObservableSet.Listener<E>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(E o) {
                if (_OrderedSet.this.m_list.contains(o)) {
                    throw new IllegalArgumentException("Inconsistent add(): Object was already contained");
                }
                _OrderedSet.this.m_list.add(o);
            }

            @Override
            public void wasRemoved(E o) {
                if (!_OrderedSet.this.m_list.contains(o)) {
                    throw new IllegalArgumentException("Inconsistent remove(): Object was not contained");
                }
                _OrderedSet.this.m_list.remove(o);
            }
        });
    }

    @Override
    public E get(int index) {
        return this.m_list.get(index);
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public E set(int index, E element) {
        return this.m_list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.m_list.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.m_list.remove(index);
    }

    @Override
    public void swap(int i, int j) {
        if (i < 0 || j < 0 || i >= this.size() || j >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        E ei = this.m_list.get(i);
        E ej = this.m_list.get(j);
        this.m_list.set(i, ej);
        this.m_list.set(j, ei);
        this.m_set.wasChanged(ei);
        this.m_set.wasChanged(ej);
    }
}

