/*
 * Decompiled with CFR 0.152.
 */
package cib.util.dxf;

import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;
import cib.util.dxf.interpreter.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class AttributesAdapter
implements Attributes {
    private List<DXFDataElement> m_list = new ArrayList<DXFDataElement>();
    private Map<GroupCode, List<String>> m_map = new HashMap<GroupCode, List<String>>();
    private int m_firstParsedLine = -1;
    private int m_lastParsedLine = -1;

    @Override
    public int firstParsedLine() {
        return this.m_firstParsedLine;
    }

    @Override
    public int lastParsedLine() {
        return this.m_lastParsedLine;
    }

    public void clear() {
        this.m_list.clear();
        this.m_map.clear();
    }

    public void add(Token token) {
        DXFDataElement de = new DXFDataElement(token);
        this.m_list.add(de);
        if (!this.m_map.containsKey((Object)de.m_gc)) {
            this.m_map.put(de.m_gc, new ArrayList());
        }
        List<String> values = this.m_map.get((Object)de.m_gc);
        values.add(de.m_val);
    }

    public void add(GroupCode gc, String val) {
        DXFDataElement de = new DXFDataElement(gc, val);
        this.m_list.add(de);
        if (!this.m_map.containsKey((Object)de.m_gc)) {
            this.m_map.put(de.m_gc, new ArrayList());
        }
        List<String> values = this.m_map.get((Object)de.m_gc);
        values.add(de.m_val);
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public GroupCode getGroupCodeAt(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            throw new NoSuchElementException("No element at index " + index);
        }
        DXFDataElement de = this.m_list.get(index);
        return de.m_gc;
    }

    @Override
    public String getValueAt(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            throw new NoSuchElementException("No element at index " + index);
        }
        DXFDataElement de = this.m_list.get(index);
        return de.m_val;
    }

    @Override
    public int getIntValueAt(int index) {
        String str = this.getValueAt(index);
        return Integer.parseInt(str.trim());
    }

    @Override
    public double getDoubleValueAt(int index) {
        String str = this.getValueAt(index);
        return Double.parseDouble(str.trim());
    }

    @Override
    public boolean getBooleanValueAt(int index) {
        String str = this.getValueAt(index);
        return Boolean.parseBoolean(str.trim());
    }

    @Override
    public int getValueSize(GroupCode code) {
        if (!this.m_map.containsKey((Object)code)) {
            return 0;
        }
        List<String> values = this.m_map.get((Object)code);
        return values.size();
    }

    @Override
    public boolean valueExists(GroupCode code) {
        return this.getValueSize(code) > 0;
    }

    @Override
    public String getValue(GroupCode code) {
        return this.getValue(0, code);
    }

    @Override
    public String getValue(GroupCode code, String def) {
        return this.getValue(0, code, def);
    }

    @Override
    public int getIntValue(GroupCode code) {
        return this.getIntValue(0, code);
    }

    @Override
    public int getIntValue(GroupCode code, int def) {
        return this.getIntValue(0, code, def);
    }

    @Override
    public double getDoubleValue(GroupCode code) {
        return this.getDoubleValue(0, code);
    }

    @Override
    public double getDoubleValue(GroupCode code, double def) {
        return this.getDoubleValue(0, code, def);
    }

    @Override
    public boolean getBooleanValue(GroupCode code) {
        return this.getBooleanValue(0, code);
    }

    @Override
    public boolean getBooleanValue(GroupCode code, boolean def) {
        return this.getBooleanValue(0, code, def);
    }

    @Override
    public boolean valueExists(int index, GroupCode code) {
        return index >= 0 && index < this.getValueSize(code);
    }

    @Override
    public String getValue(int index, GroupCode code) {
        try {
            List<String> values = this.m_map.get((Object)code);
            return values.get(index);
        }
        catch (Exception e) {
            throw new NoSuchElementException("No value for Group Code " + (Object)((Object)code) + " at index " + index);
        }
    }

    @Override
    public String getValue(int index, GroupCode code, String def) {
        try {
            return this.getValue(index, code);
        }
        catch (NoSuchElementException noSuchElementException) {
            return def;
        }
    }

    @Override
    public int getIntValue(int index, GroupCode code) {
        String str = this.getValue(index, code);
        return Integer.parseInt(str.trim());
    }

    @Override
    public int getIntValue(int index, GroupCode code, int def) {
        try {
            String str = this.getValue(index, code);
            return Integer.parseInt(str.trim());
        }
        catch (NoSuchElementException noSuchElementException) {
            return def;
        }
    }

    @Override
    public double getDoubleValue(int index, GroupCode code) {
        String str = this.getValue(index, code);
        return Double.parseDouble(str.trim());
    }

    @Override
    public double getDoubleValue(int index, GroupCode code, double def) {
        try {
            String str = this.getValue(index, code);
            return Double.parseDouble(str.trim());
        }
        catch (NoSuchElementException noSuchElementException) {
            return def;
        }
    }

    @Override
    public boolean getBooleanValue(int index, GroupCode code) {
        String str = this.getValue(index, code);
        return Boolean.parseBoolean(str.trim());
    }

    @Override
    public boolean getBooleanValue(int index, GroupCode code, boolean def) {
        try {
            String str = this.getValue(index, code);
            return Boolean.parseBoolean(str.trim());
        }
        catch (NoSuchElementException noSuchElementException) {
            return def;
        }
    }

    public void setFirstParsedLine(int line) {
        this.m_firstParsedLine = line;
    }

    public void setLastParsedLine(int line) {
        this.m_lastParsedLine = line;
    }

    private class DXFDataElement {
        private GroupCode m_gc;
        private String m_val;

        private DXFDataElement(GroupCode gc, String val) {
            this.m_gc = gc;
            this.m_val = val;
        }

        private DXFDataElement(Token token) {
            int i = token.image.indexOf("\r\n");
            if (i != -1) {
                this.m_val = token.image.substring(i + 2, token.image.length() - 2);
            } else {
                i = token.image.indexOf("\n");
                this.m_val = token.image.substring(i + 1, token.image.length() - 1);
            }
            String gc = token.image.substring(0, i);
            int j = gc.lastIndexOf(" ");
            gc = gc.substring(j + 1);
            this.m_gc = GroupCode.valueOf("GC" + gc);
        }
    }
}

