/*
 * Decompiled with CFR 0.152.
 */
package cib.util.dxf;

import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;

public class ObjectCoordinateSystem {
    private double[][] m_ocs2wcs = null;

    public ObjectCoordinateSystem(Attributes atts) {
        if (!atts.valueExists(GroupCode.GC210)) {
            this.m_ocs2wcs = null;
            return;
        }
        double[] az = new double[]{atts.getDoubleValue(GroupCode.GC210), atts.getDoubleValue(GroupCode.GC220), atts.getDoubleValue(GroupCode.GC230)};
        double[] ax = new double[3];
        double[] ay = new double[3];
        ObjectCoordinateSystem.calculateArbitraryAxes(az, ax, ay);
        double[] rz = new double[]{az[0], az[1], az[2]};
        ObjectCoordinateSystem.normalize(rz, rz);
        double[] rx = new double[3];
        ObjectCoordinateSystem.cross(ay, az, rx);
        ObjectCoordinateSystem.normalize(rx, rx);
        double[] ry = new double[3];
        ObjectCoordinateSystem.cross(rz, rx, ry);
        double[][] mat = new double[][]{{rx[0], rx[1], rx[2]}, {ry[0], ry[1], ry[2]}, {rz[0], rz[1], rz[2]}};
        ObjectCoordinateSystem.invert(mat, mat);
        this.m_ocs2wcs = mat;
    }

    public void toWCS(double ox, double oy, double oz, double[] wcrds) {
        if (this.m_ocs2wcs == null) {
            wcrds[0] = ox;
            wcrds[1] = oy;
            wcrds[2] = oz;
        } else {
            wcrds[0] = this.m_ocs2wcs[0][0] * ox + this.m_ocs2wcs[0][1] * oy + this.m_ocs2wcs[0][2] * oz;
            wcrds[1] = this.m_ocs2wcs[1][0] * ox + this.m_ocs2wcs[1][1] * oy + this.m_ocs2wcs[1][2] * oz;
            wcrds[2] = this.m_ocs2wcs[2][0] * ox + this.m_ocs2wcs[2][1] * oy + this.m_ocs2wcs[2][2] * oz;
        }
    }

    public double getXinWCS(double ox, double oy, double oz) {
        return this.m_ocs2wcs == null ? ox : this.m_ocs2wcs[0][0] * ox + this.m_ocs2wcs[0][1] * oy + this.m_ocs2wcs[0][2] * oz;
    }

    public double getYinWCS(double ox, double oy, double oz) {
        return this.m_ocs2wcs == null ? oy : this.m_ocs2wcs[1][0] * ox + this.m_ocs2wcs[1][1] * oy + this.m_ocs2wcs[1][2] * oz;
    }

    public double getZinWCS(double ox, double oy, double oz) {
        return this.m_ocs2wcs == null ? oz : this.m_ocs2wcs[2][0] * ox + this.m_ocs2wcs[2][1] * oy + this.m_ocs2wcs[2][2] * oz;
    }

    private static void calculateArbitraryAxes(double[] az, double[] ax, double[] ay) {
        double[] WY = new double[]{0.0, 1.0, 0.0};
        double[] WZ = new double[]{0.0, 0.0, 1.0};
        double LIMIT = 0.015625;
        if (Math.abs(az[0]) < 0.015625 && Math.abs(az[1]) < 0.015625) {
            ObjectCoordinateSystem.cross(WY, az, ax);
        } else {
            ObjectCoordinateSystem.cross(WZ, az, ax);
        }
        ObjectCoordinateSystem.normalize(ax, ax);
        ObjectCoordinateSystem.cross(az, ax, ay);
        ObjectCoordinateSystem.normalize(ay, ay);
    }

    private static void cross(double[] a, double[] b, double[] c) {
        double c0 = a[1] * b[2] - a[2] * b[1];
        double c1 = a[2] * b[0] - a[0] * b[2];
        double c2 = a[0] * b[1] - a[1] * b[0];
        c[0] = c0;
        c[1] = c1;
        c[2] = c2;
    }

    private static void normalize(double[] in, double[] out) {
        double len = ObjectCoordinateSystem.length(in);
        out[0] = in[0] / len;
        out[1] = in[1] / len;
        out[2] = in[2] / len;
    }

    private static double length(double[] a) {
        return Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    private static double det(double[][] mat) {
        return mat[0][0] * (mat[1][1] * mat[2][2] - mat[2][1] * mat[1][2]) - mat[0][1] * (mat[1][0] * mat[2][2] - mat[2][0] * mat[1][2]) + mat[0][2] * (mat[1][0] * mat[2][1] - mat[2][0] * mat[1][1]);
    }

    private static void invert(double[][] mat, double[][] inv) {
        double _00 = mat[1][1] * mat[2][2] - mat[1][2] * mat[2][1];
        double _01 = mat[0][2] * mat[2][1] - mat[0][1] * mat[2][2];
        double _02 = mat[0][1] * mat[1][2] - mat[0][2] * mat[1][1];
        double _10 = mat[1][2] * mat[2][0] - mat[1][0] * mat[2][2];
        double _11 = mat[0][0] * mat[2][2] - mat[0][2] * mat[2][0];
        double _12 = mat[0][2] * mat[1][0] - mat[0][0] * mat[1][2];
        double _20 = mat[1][0] * mat[2][1] - mat[1][1] * mat[2][0];
        double _21 = mat[0][1] * mat[2][0] - mat[0][0] * mat[2][1];
        double _22 = mat[0][0] * mat[1][1] - mat[0][1] * mat[1][0];
        double d = ObjectCoordinateSystem.det(mat);
        inv[0][0] = _00 / d;
        inv[0][1] = _01 / d;
        inv[0][2] = _02 / d;
        inv[1][0] = _10 / d;
        inv[1][1] = _11 / d;
        inv[1][2] = _12 / d;
        inv[2][0] = _20 / d;
        inv[2][1] = _21 / d;
        inv[2][2] = _22 / d;
    }
}

