/*
 * Decompiled with CFR 0.152.
 */
package cib.util.view;

import cib.util.view.FillPaint;
import cib.util.view.Projection2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboPopup;

public class ViewUtilities {
    public static boolean MAC_OS = false;
    public static boolean WINDOWS = false;
    public static boolean LINUX = false;
    private static boolean s_menuIconsEnabled;
    public static final int BUTTON_WIDTH = 21;
    public static final int BUTTON_HEIGHT = 21;
    public static final int SHORTCUT;
    public static final int SHIFT = 1;
    public static final int ALT = 8;

    static {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os x")) {
            MAC_OS = true;
        } else if (os.startsWith("windows")) {
            WINDOWS = true;
        } else if (os.startsWith("linux")) {
            LINUX = true;
        }
        s_menuIconsEnabled = true;
        SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public static JButton createImageButton(String name, URL url, String help) {
        ImageIcon icon;
        if (url != null) {
            icon = new ImageIcon(url);
        } else {
            int w = 21;
            int h = 21;
            int[] pix = new int[w * h];
            int i = 4;
            while (i < w - 4) {
                int j = 4;
                while (j < h - 4) {
                    pix[j * w + i] = i == j || w - i == j ? Color.RED.getRGB() : 0;
                    ++j;
                }
                ++i;
            }
            icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w)));
        }
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        JButton button = new JButton(icon);
        button.putClientProperty("JButton.buttonType", "toolbar");
        button.setName(name);
        Dimension dim = new Dimension(iw + 2, ih + 2);
        button.setMinimumSize(dim);
        button.setMaximumSize(dim);
        button.setPreferredSize(dim);
        button.setToolTipText(help);
        return button;
    }

    public static JToggleButton createToggleButton(String name, URL onUrl, URL offUrl, String help, boolean selected) {
        ImageIcon offIcon;
        int j;
        int i;
        int[] pix;
        int h;
        int w;
        ImageIcon onIcon;
        if (onUrl != null) {
            onIcon = new ImageIcon(onUrl);
        } else {
            w = 21;
            h = 21;
            pix = new int[w * h];
            i = 4;
            while (i < w - 4) {
                j = 4;
                while (j < h - 4) {
                    pix[j * w + i] = i == j || w - i == j ? Color.RED.getRGB() : 0;
                    ++j;
                }
                ++i;
            }
            onIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w)));
        }
        if (offUrl != null) {
            offIcon = new ImageIcon(onUrl);
        } else {
            w = 21;
            h = 21;
            pix = new int[w * h];
            i = 4;
            while (i < w - 4) {
                j = 4;
                while (j < h - 4) {
                    pix[j * w + i] = i == j || w - i == j ? Color.RED.getRGB() : 0;
                    ++j;
                }
                ++i;
            }
            offIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w)));
        }
        int iw = Math.max(onIcon.getIconWidth(), offIcon.getIconWidth());
        int ih = Math.max(onIcon.getIconHeight(), offIcon.getIconHeight());
        JToggleButton button = new JToggleButton();
        button.setName(name);
        button.setSelected(selected);
        button.setIcon(onIcon);
        button.setSelectedIcon(offIcon);
        Dimension dim = new Dimension(iw + 2, ih + 2);
        button.setMinimumSize(dim);
        button.setMaximumSize(dim);
        button.setPreferredSize(dim);
        button.setToolTipText(help);
        return button;
    }

    public static ImageIcon createImageByName(URL url, boolean showProxy) {
        if (url == null) {
            if (!showProxy) {
                int w = 19;
                int h = 19;
                int[] pix = new int[w * h];
                ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w)));
                return icon;
            }
            int w = 21;
            int h = 21;
            int[] pix = new int[w * h];
            pix[239] = Color.BLACK.getRGB();
            pix[240] = Color.BLACK.getRGB();
            pix[243] = Color.BLACK.getRGB();
            pix[244] = Color.BLACK.getRGB();
            pix[247] = Color.BLACK.getRGB();
            pix[248] = Color.BLACK.getRGB();
            pix[260] = Color.BLACK.getRGB();
            pix[261] = Color.BLACK.getRGB();
            pix[264] = Color.BLACK.getRGB();
            pix[265] = Color.BLACK.getRGB();
            pix[268] = Color.BLACK.getRGB();
            pix[269] = Color.BLACK.getRGB();
            ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w)));
            return icon;
        }
        return new ImageIcon(url);
    }

    public static JButton createPopupButton(JButton b, final JComboBox c, final boolean selectLower) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton _b = (JButton)e.getSource();
                c.setRenderer(new _LabelComboBoxRenderer(selectLower));
                final BasicComboPopup popup = new BasicComboPopup(c);
                popup.show(_b, 0, _b.getBounds().height);
                c.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.hide();
                    }
                });
            }
        });
        return b;
    }

    public static ImageIcon createImageIconByLineWidth(double d) {
        int b = 3;
        int w = 31;
        int h = 21 - 2 * b;
        int t = (int)Math.round(11.0 * d);
        if (t <= 1) {
            t = 2;
        }
        if (t >= h) {
            t = h - 1;
        }
        int[] pix = new int[w * h];
        int i = b;
        while (i <= w - b) {
            int j = h / 2 - t / 2;
            while (j < h / 2 + t / 2) {
                pix[j * w + i + 1] = Color.BLACK.getRGB();
                ++j;
            }
            ++i;
        }
        ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w)));
        return icon;
    }

    public static ImageIcon createImageIconByLinePattern(double[] d) {
        double[] _d;
        if (d == null || d.length == 0 || d.length == 1) {
            _d = new double[]{5.0, 0.0};
        } else {
            _d = new double[d.length];
            int i = 0;
            while (i < d.length) {
                _d[i] = d[i] < 1.0 ? 1.0 : d[i];
                ++i;
            }
        }
        int b = 3;
        int w = 52;
        int h = 15;
        boolean t = true;
        int[] pix = new int[780];
        int[] col = new int[46];
        boolean gap = false;
        boolean end = false;
        int k = 0;
        double sum = 0.0;
        int i = 0;
        while (i < _d.length) {
            sum += _d[i];
            ++i;
        }
        if (6.0 * sum >= 46.0) {
            double factor = 46.0 / (3.0 * sum);
            factor /= 2.0;
            sum = 0.0;
            int i2 = 0;
            while (i2 < _d.length) {
                int n = i2;
                _d[n] = _d[n] * factor;
                sum += _d[i2];
                ++i2;
            }
        }
        int m = 0;
        while ((double)m < 52.0 / sum + 1.0) {
            int i3 = 0;
            while (i3 < _d.length) {
                int j = 0;
                while ((double)j < 2.0 * _d[i3]) {
                    if (k == col.length - 1) {
                        end = true;
                        break;
                    }
                    if (!gap) {
                        col[k] = Color.BLACK.getRGB();
                    }
                    ++k;
                    ++j;
                }
                if (end) break;
                gap = !gap;
                ++i3;
            }
            if (end) break;
            ++m;
        }
        i = 3;
        while (i < 49) {
            int j = 7;
            while (j < 8) {
                int index = j * 52 + i + 1;
                if (index >= 0 && index < pix.length) {
                    pix[index] = col[i - 3];
                }
                ++j;
            }
            ++i;
        }
        ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(52, 15, pix, 0, 52)));
        return icon;
    }

    public static ImageIcon createImageIconByDrawPaint(Paint p) {
        int b = 3;
        int w = 21 - 2 * b;
        int h = 21 - 2 * b;
        BufferedImage bi = new BufferedImage(w, h, 6);
        Graphics2D big = (Graphics2D)bi.getGraphics();
        big.setTransform(AffineTransform.getTranslateInstance(b + 1, b + 1));
        big.setBackground(new Color(0, 0, 0, 0));
        big.clearRect(-1, -1, bi.getWidth() + 1, bi.getHeight() + 1);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
        BasicStroke stroke = new BasicStroke(2.0f);
        Shape shape = stroke.createStrokedShape(rect);
        big.setPaint(Color.BLACK);
        big.draw(shape);
        big.setPaint(p);
        big.fill(shape);
        big.dispose();
        bi.flush();
        return new ImageIcon(bi);
    }

    public static ImageIcon createImageIconByFillPaint(Paint p) {
        int b = 3;
        int w = 21 - 2 * b;
        int h = 21 - 2 * b;
        BufferedImage bi = new BufferedImage(w, h, 6);
        Graphics2D big = (Graphics2D)bi.getGraphics();
        if (p instanceof FillPaint) {
            FillPaint fp = (FillPaint)p;
            double sv_p2m = fp.getPaperToModel();
            AffineTransform sv_m2v = fp.getModelToView();
            double p2m = 1.0;
            fp.setPaperToModel(p2m);
            Projection2D p2d = null;
            try {
                p2d = new Projection2D(new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0), bi.getWidth(), bi.getHeight());
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
                big.setPaint(p);
                big.setTransform(AffineTransform.getTranslateInstance(b, b));
                big.setBackground(new Color(0, 0, 0, 0));
                big.clearRect(-1, -1, bi.getWidth() + 1, bi.getHeight() + 1);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
                big.fill(rect);
                big.setColor(Color.BLACK);
                big.setStroke(new BasicStroke(0.0f));
                big.draw(rect);
                return new ImageIcon(bi);
            }
            AffineTransform at = p2d.getModelToView();
            at.preConcatenate(AffineTransform.getTranslateInstance((double)(-b) / p2m, (double)(-b) / p2m));
            fp.setModelToView(at);
            big.setPaint(fp);
            big.setTransform(AffineTransform.getTranslateInstance(b, b));
            big.setBackground(new Color(0, 0, 0, 0));
            big.clearRect(-1, -1, bi.getWidth() + 1, bi.getHeight() + 1);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
            big.fill(rect);
            big.setColor(Color.BLACK);
            big.setStroke(new BasicStroke(0.0f));
            big.draw(rect);
            fp.setPaperToModel(sv_p2m);
            fp.setModelToView(sv_m2v);
        } else {
            big.setPaint(p);
            big.setTransform(AffineTransform.getTranslateInstance(b, b));
            big.setBackground(new Color(0, 0, 0, 0));
            big.clearRect(-1, -1, bi.getWidth() + 1, bi.getHeight() + 1);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
            big.fill(rect);
            big.setColor(Color.BLACK);
            big.setStroke(new BasicStroke(0.0f));
            big.draw(rect);
        }
        return new ImageIcon(bi);
    }

    public static ImageIcon createImageIconByFontFamily(String name) {
        int b = 3;
        int w = 31;
        int h = 21 - 2 * b;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = ((Image)image).getGraphics();
        g.setColor(Color.BLACK);
        g.setFont(new Font(name, 0, 14));
        g.drawString("abc", b, h - b);
        return new ImageIcon(image);
    }

    public static ImageIcon createImageIconByTextSize(double d) {
        int b = 3;
        int w = 31;
        int h = 21 - 2 * b;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = ((Image)image).getGraphics();
        g.setColor(Color.BLACK);
        int t = (int)(2L * Math.round(d));
        if (t > h) {
            t = h;
        }
        g.setFont(new Font("arial", 0, t));
        g.drawString(String.valueOf(d), b, h - b);
        return new ImageIcon(image);
    }

    public static JMenu createMenu(String text, String name, int mnemonic) {
        JMenu menu = new JMenu(text);
        menu.setName(name);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public static JMenu createMenu(String text, int mnemonic) {
        return ViewUtilities.createMenu(text, text, mnemonic);
    }

    public static void enableMenuIcons(boolean enable) {
        s_menuIconsEnabled = enable;
    }

    public static boolean menuIconsEnabled() {
        return s_menuIconsEnabled;
    }

    public static ImageIcon createMenuImageByName(URL url, boolean showProxy) {
        if (!s_menuIconsEnabled) {
            return null;
        }
        return ViewUtilities.createImageByName(url, showProxy);
    }

    public static JMenuItem createMenuItem(String name, URL url, char mnemonic, int keyCode, int modifiers, String help) {
        JMenuItem item;
        if (s_menuIconsEnabled) {
            ImageIcon icon = ViewUtilities.createImageByName(url, false);
            item = new JMenuItem(name, icon);
        } else {
            item = new JMenuItem(name);
        }
        item.setName(name);
        if (keyCode != 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifiers));
        }
        if (mnemonic != ' ' && name.indexOf(mnemonic) != -1) {
            item.setMnemonic(mnemonic);
        }
        item.setToolTipText(help);
        return item;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String name, URL url, char mnemonic, int keyCode, int modifiers, String help) {
        JCheckBoxMenuItem item;
        if (s_menuIconsEnabled) {
            ImageIcon icon = ViewUtilities.createImageByName(url, false);
            item = new JCheckBoxMenuItem(name, icon);
        } else {
            item = new JCheckBoxMenuItem(name);
        }
        item.setName(name);
        if (keyCode != 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifiers));
        }
        if (mnemonic != ' ' && name.indexOf(mnemonic) != -1) {
            item.setMnemonic(mnemonic);
        }
        item.setToolTipText(help);
        return item;
    }

    public static void requestFocusAsynchronously(final Window comp) {
        if (comp.isFocusOwner()) {
            return;
        }
        final _GuardAsynchronous guard = new _GuardAsynchronous();
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                comp.removeFocusListener(this);
                guard.resume();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        comp.addFocusListener(fl);
        comp.requestFocus();
        guard.suspend();
    }

    private static class _GuardAsynchronous {
        private int m_suspended = 0;

        private _GuardAsynchronous() {
        }

        public synchronized void suspend() {
            if (this.m_suspended > 0) {
                throw new InternalError("_GuardAsynchronous: already suspended");
            }
            ++this.m_suspended;
            while (this.m_suspended > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void resume() {
            if (--this.m_suspended == 0) {
                this.notifyAll();
            }
        }
    }

    public static class _LabelComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 0L;
        private boolean m_selectLower = false;

        public _LabelComboBoxRenderer(boolean selectLower) {
            this.setOpaque(true);
            this.setFocusable(false);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.m_selectLower = selectLower;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                if (value instanceof JLabel) {
                    JLabel l = (JLabel)value;
                    this.setText(" " + l.getText() + " ");
                    this.setToolTipText(l.getText());
                    this.setIcon(l.getIcon());
                } else {
                    this.setText(" " + value.toString() + " ");
                }
            } else {
                this.setText("");
                this.setIcon(null);
            }
            if (index == list.getSelectedIndex() || index < list.getSelectedIndex() && this.m_selectLower) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            int n = list.getSelectedIndex() + 1;
            if (this.m_selectLower) {
                if (!(value instanceof JLabel)) {
                    switch (n) {
                        case 0: {
                            list.setToolTipText("No elements.");
                            break;
                        }
                        case 1: {
                            list.setToolTipText("1 element.");
                            break;
                        }
                        default: {
                            list.setToolTipText(String.valueOf(n) + " elements.");
                            break;
                        }
                    }
                } else if (!(value instanceof JLabel)) {
                    switch (n) {
                        case 0: {
                            list.setToolTipText("No elements.");
                            break;
                        }
                        default: {
                            String text = list.getSelectedValue() == null ? "" : list.getSelectedValue().toString();
                            list.setToolTipText(text);
                        }
                    }
                }
            }
            return this;
        }
    }
}

