/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.boards;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import org.diylc.awt.StringUtils;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Breadboard", category="Boards", author="Branislav Stojkovic", description="Prototyping solderless breadboard", instanceNamePrefix="BB", zOrder=2.0, bomPolicy=BomPolicy.SHOW_ONLY_TYPE_NAME, autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TYPE_NAME)
public class Breadboard
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color FILL_COLOR = Color.white;
    public static Color BORDER_COLOR = Color.black;
    public static Size BODY_ARC = new Size(Double.valueOf(3.0), SizeUnit.mm);
    public static Size SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Color SELECTION_COLOR = Color.red;
    public static Color HOLE_COLOR = Color.decode("#EEEEEE");
    public static Color PLUS_COLOR = Color.red;
    public static Color MINUS_COLOR = Color.blue;
    public static float COORDINATE_FONT_SIZE = 9.0f;
    public static Color COORDINATE_COLOR = Color.gray.brighter();
    public static Size HOLE_SIZE = new Size(Double.valueOf(1.5), SizeUnit.mm);
    public static Size HOLE_ARC = new Size(Double.valueOf(1.0), SizeUnit.mm);
    protected Point point = new Point(0, 0);
    protected BreadboardSize breadboardSize;
    protected PowerStripPosition powerStripPosition;
    protected Orientation orientation;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        int section;
        int holeX;
        int x;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        double theta = 0.0;
        switch (this.getOrientation()) {
            case _90: {
                theta = 1.5707963267948966;
                break;
            }
            case _180: {
                theta = Math.PI;
                break;
            }
            case _270: {
                theta = 4.71238898038469;
            }
        }
        if (theta != 0.0) {
            g2d.rotate(theta, this.point.x, this.point.y);
        }
        int bodyArc = (int)BODY_ARC.convertToPixels();
        double spacing = SPACING.convertToPixels();
        int holeCount = this.getBreadboardSize() == BreadboardSize.Full ? 63 : 30;
        g2d.setColor(FILL_COLOR);
        int width = (int)(23.0 * project.getGridSpacing().convertToPixels());
        int height = (int)((double)(holeCount + 1) * project.getGridSpacing().convertToPixels());
        g2d.fillRoundRect(this.point.x, this.point.y, width, height, bodyArc, bodyArc);
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BORDER_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.drawRoundRect(this.point.x, this.point.y, width, height, bodyArc, bodyArc);
        drawingObserver.stopTracking();
        g2d.setColor(PLUS_COLOR);
        g2d.drawLine((int)((double)this.point.x + spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + spacing), (int)((double)this.point.y + (double)holeCount * spacing));
        g2d.drawLine((int)((double)this.point.x + 19.0 * spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + 19.0 * spacing), (int)((double)this.point.y + (double)holeCount * spacing));
        g2d.setColor(MINUS_COLOR);
        g2d.drawLine((int)((double)this.point.x + 4.0 * spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + 4.0 * spacing), (int)((double)this.point.y + (double)holeCount * spacing));
        g2d.drawLine((int)((double)this.point.x + 22.0 * spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + 22.0 * spacing), (int)((double)this.point.y + (double)holeCount * spacing));
        int holeSize = this.getClosestOdd(HOLE_SIZE.convertToPixels());
        int holeArc = (int)HOLE_ARC.convertToPixels();
        g2d.setFont(LABEL_FONT.deriveFont(COORDINATE_FONT_SIZE));
        byte a = "a".getBytes()[0];
        for (int section2 = 0; section2 <= 1; ++section2) {
            double offset = (double)(section2 * 7) * spacing;
            for (int y = 0; y < holeCount; ++y) {
                g2d.setColor(COORDINATE_COLOR);
                int coordinateX = section2 == 0 ? (int)((double)this.point.x + offset + 5.5 * spacing) : (int)((double)this.point.x + offset + 10.5 * spacing);
                StringUtils.drawCenteredText(g2d, new Integer(y + 1).toString(), coordinateX, (int)((double)this.point.y + (double)(y + 1) * spacing), section2 == 0 ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
                for (int x2 = 0; x2 < 5; ++x2) {
                    int holeX2 = (int)((double)this.point.x + offset + (double)(x2 + 6) * spacing);
                    int holeY = (int)((double)this.point.y + (double)(y + 1) * spacing);
                    g2d.setColor(HOLE_COLOR);
                    g2d.fillRoundRect(holeX2 - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                    g2d.setColor(BORDER_COLOR);
                    g2d.drawRoundRect(holeX2 - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                    if (y != 0) continue;
                    g2d.setColor(COORDINATE_COLOR);
                    StringUtils.drawCenteredText(g2d, new String(new byte[]{(byte)(a + x2 + 5 * section2)}), holeX2, this.point.y, HorizontalAlignment.CENTER, VerticalAlignment.TOP);
                    StringUtils.drawCenteredText(g2d, new String(new byte[]{(byte)(a + x2 + 5 * section2)}), holeX2, (int)((double)this.point.y + spacing * 30.0 + (double)(COORDINATE_FONT_SIZE / 2.0f)), HorizontalAlignment.CENTER, VerticalAlignment.TOP);
                }
            }
        }
        double powerOffset = this.getPowerStripPosition() == PowerStripPosition.Inline ? (this.getBreadboardSize() == BreadboardSize.Full ? 2.0 : 1.0) : (this.getBreadboardSize() == BreadboardSize.Full ? 1.5 : 0.5);
        int psHoleCount = Math.round((float)holeCount / 10.0f) * 10;
        for (int section3 = 0; section3 <= 1; ++section3) {
            double offset = (double)(section3 * 18) * spacing;
            for (int y = 0; y < psHoleCount - 1; ++y) {
                for (x = 0; x < 2; ++x) {
                    if ((y + 1) % 6 == 0) continue;
                    holeX = (int)((double)this.point.x + offset + (double)(x + 2) * spacing);
                    int holeY = (int)((double)this.point.y + ((double)(y + 1) + powerOffset) * spacing);
                    g2d.setColor(HOLE_COLOR);
                    g2d.fillRoundRect(holeX - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                    g2d.setColor(BORDER_COLOR);
                    g2d.drawRoundRect(holeX - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                }
            }
        }
        drawingObserver.startTrackingContinuityArea(true);
        Composite oldComposite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.0f));
        for (section = 0; section <= 1; ++section) {
            double offset = (double)(section * 18) * spacing;
            for (x = 0; x < 2; ++x) {
                holeX = (int)((double)this.point.x + offset + (double)(x + 2) * spacing);
                int holeY1 = (int)((double)this.point.y + (1.0 + powerOffset) * spacing);
                int holeY2 = (int)((double)this.point.y + ((double)(psHoleCount - 1) + powerOffset) * spacing);
                g2d.setColor(HOLE_COLOR);
                g2d.fillRoundRect(holeX - holeSize / 2, holeY1 - holeSize / 2, holeSize, holeSize + holeY2 - holeY1, holeArc, holeArc);
            }
        }
        for (section = 0; section <= 1; ++section) {
            double offset = (double)(section * 7) * spacing;
            for (int y = 0; y < holeCount; ++y) {
                g2d.setColor(COORDINATE_COLOR);
                int coordinateX = section == 0 ? (int)((double)this.point.x + offset + 5.5 * spacing) : (int)((double)this.point.x + offset + 10.5 * spacing);
                StringUtils.drawCenteredText(g2d, new Integer(y + 1).toString(), coordinateX, (int)((double)this.point.y + (double)(y + 1) * spacing), section == 0 ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
                int holeX1 = (int)((double)this.point.x + offset + 6.0 * spacing);
                int holeX2 = (int)((double)this.point.x + offset + 10.0 * spacing);
                int holeY = (int)((double)this.point.y + (double)(y + 1) * spacing);
                g2d.setColor(HOLE_COLOR);
                g2d.fillRoundRect(holeX1 - holeSize / 2, holeY - holeSize / 2, holeSize + holeX2 - holeX1, holeSize, holeArc, holeArc);
            }
        }
        g2d.setComposite(oldComposite);
        drawingObserver.stopTrackingContinuityArea();
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        int arc = 4 / factor;
        g2d.setColor(FILL_COLOR);
        g2d.fillRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(2 * width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(2 * width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(2 * width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(2 * width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(MINUS_COLOR);
        g2d.drawLine(width / 2, 2 / factor, width / 2, height - 4 / factor);
    }

    @EditableProperty
    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = Orientation.DEFAULT;
        }
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @EditableProperty(name="Size")
    public BreadboardSize getBreadboardSize() {
        if (this.breadboardSize == null) {
            this.breadboardSize = BreadboardSize.Half;
        }
        return this.breadboardSize;
    }

    public void setBreadboardSize(BreadboardSize breadboardSize) {
        this.breadboardSize = breadboardSize;
    }

    @EditableProperty(name="Power Strip")
    public PowerStripPosition getPowerStripPosition() {
        if (this.powerStripPosition == null) {
            this.powerStripPosition = PowerStripPosition.Inline;
        }
        return this.powerStripPosition;
    }

    public void setPowerStripPosition(PowerStripPosition powerStripPosition) {
        this.powerStripPosition = powerStripPosition;
    }

    public int getControlPointCount() {
        return 2;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public Point getControlPoint(int index) {
        if (index == 0) {
            return this.point;
        }
        double spacing = SPACING.convertToPixels();
        int holeCount = this.getBreadboardSize() == BreadboardSize.Full ? 63 : 30;
        double theta = 0.0;
        switch (this.getOrientation()) {
            case _90: {
                theta = 1.5707963267948966;
                break;
            }
            case _180: {
                theta = Math.PI;
                break;
            }
            case _270: {
                theta = 4.71238898038469;
            }
        }
        Point secondPoint = new Point((int)((double)this.point.x + 23.0 * spacing), (int)((double)this.point.y + (double)(holeCount + 1) * spacing));
        if (theta != 0.0) {
            AffineTransform tx = AffineTransform.getRotateInstance(theta, this.point.x, this.point.y);
            tx.transform(secondPoint, secondPoint);
        }
        return secondPoint;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        if (index == 0) {
            this.point.setLocation(point);
        }
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    public String getControlPointNodeName(int index) {
        return null;
    }

    public static enum PowerStripPosition {
        Inline,
        Offset;

    }

    public static enum BreadboardSize {
        Half,
        Full;

    }
}

