/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractMultiPartComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Open 1/4\" Jack", category="Electro-Mechanical", author="Branislav Stojkovic", description="Switchcraft-style open panel mount 1/4\" phono jack, stereo and mono", zOrder=4.0, instanceNamePrefix="J")
public class OpenJack1_4
extends AbstractMultiPartComponent<String> {
    private static final double RING_THETA = 2.4975661596038856;
    private static final double SLEEVE_THETA = 0.925024503543032;
    private static final double SLEEVE_SWITCHED_THETA = 4.1887902047863905;
    private static final double SWITCH_THETA = 5.235987755982989;
    private static final long serialVersionUID = 1L;
    private static Color BASE_COLOR = Color.lightGray;
    private static Color WAFER_COLOR = Color.decode("#CD8500");
    private static Size OUTER_DIAMETER = new Size(Double.valueOf(0.75), SizeUnit.in);
    private static Size INNER_DIAMETER = new Size(Double.valueOf(0.25), SizeUnit.in);
    private static Size RING_DIAMETER = new Size(Double.valueOf(0.33), SizeUnit.in);
    private static Size SPRING_LENGTH = new Size(Double.valueOf(0.563), SizeUnit.in);
    private static Size SPRING_WIDTH = new Size(Double.valueOf(0.12), SizeUnit.in);
    private static Size HOLE_DIAMETER = new Size(Double.valueOf(0.05), SizeUnit.in);
    private static Size HOLE_TO_EDGE = new Size(Double.valueOf(0.063), SizeUnit.in);
    private String value = "";
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    transient Area[] body;
    @Deprecated
    private Orientation orientation = Orientation.DEFAULT;
    private Integer angle = 0;
    private OpenJackType type = OpenJackType.MONO;
    private boolean showLabels = true;

    public OpenJack1_4() {
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Theme theme;
        Area[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : WAFER_COLOR);
        g2d.fill(body[0]);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = theme.getOutlineColor();
        } else {
            finalBorderColor = WAFER_COLOR.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BASE_COLOR);
        drawingObserver.startTrackingContinuityArea(true);
        g2d.fill(body[1]);
        g2d.fill(body[2]);
        if (body[3] != null) {
            g2d.fill(body[3]);
        }
        drawingObserver.stopTrackingContinuityArea();
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = theme.getOutlineColor();
        } else {
            finalBorderColor = BASE_COLOR.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[1]);
        g2d.draw(body[2]);
        if (body[3] != null) {
            g2d.draw(body[3]);
        }
        if (this.showLabels) {
            g2d.setColor(BASE_COLOR.darker());
            g2d.setFont(project.getFont().deriveFont(project.getFont().getSize2D() * 0.8f));
            int springLength = (int)SPRING_LENGTH.convertToPixels();
            int holeToEdge = (int)HOLE_TO_EDGE.convertToPixels();
            int centerY = this.controlPoints[0].y + springLength - holeToEdge;
            Point tipLabel = new Point(this.controlPoints[0].x, (int)((double)this.controlPoints[0].y + (double)holeToEdge * 1.25));
            AffineTransform ringTransform = AffineTransform.getRotateInstance(this.getType() == OpenJackType.SWITCHED ? 5.235987755982989 : 2.4975661596038856, this.controlPoints[0].x, centerY);
            AffineTransform sleeveTransform = AffineTransform.getRotateInstance(this.getType() == OpenJackType.SWITCHED ? 4.1887902047863905 : 0.925024503543032, this.controlPoints[0].x, centerY);
            Point ringOrSwitchLabel = new Point(0, 0);
            Point sleeveLabel = new Point(0, 0);
            ringTransform.transform(tipLabel, ringOrSwitchLabel);
            sleeveTransform.transform(tipLabel, sleeveLabel);
            if (this.getTheta() != 0.0) {
                AffineTransform rotation = AffineTransform.getRotateInstance(this.getTheta(), this.controlPoints[0].x, this.controlPoints[0].y);
                rotation.transform(tipLabel, tipLabel);
                rotation.transform(ringOrSwitchLabel, ringOrSwitchLabel);
                rotation.transform(sleeveLabel, sleeveLabel);
            }
            StringUtils.drawCenteredText(g2d, "T", tipLabel.x, tipLabel.y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            StringUtils.drawCenteredText(g2d, "S", sleeveLabel.x, sleeveLabel.y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            if (this.getType() == OpenJackType.STEREO) {
                StringUtils.drawCenteredText(g2d, "R", ringOrSwitchLabel.x, ringOrSwitchLabel.y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            }
            if (this.getType() == OpenJackType.SWITCHED) {
                StringUtils.drawCenteredText(g2d, "Sw", ringOrSwitchLabel.x, ringOrSwitchLabel.y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            }
        }
        this.drawSelectionOutline(g2d, componentState, outlineMode, project, drawingObserver);
    }

    @Override
    public Area[] getBody() {
        if (this.body == null) {
            this.body = new Area[4];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int outerDiameter = this.getClosestOdd(OUTER_DIAMETER.convertToPixels());
            int innerDiameter = this.getClosestOdd(INNER_DIAMETER.convertToPixels());
            int ringDiameter = this.getClosestOdd(RING_DIAMETER.convertToPixels());
            int springLength = (int)SPRING_LENGTH.convertToPixels();
            int springWidth = (int)SPRING_WIDTH.convertToPixels();
            int holeDiameter = this.getClosestOdd(HOLE_DIAMETER.convertToPixels());
            int holeToEdge = (int)HOLE_TO_EDGE.convertToPixels();
            int centerY = y + springLength - holeToEdge;
            Area wafer = new Area(new Ellipse2D.Double(x - outerDiameter / 2, centerY - outerDiameter / 2, outerDiameter, outerDiameter));
            wafer.subtract(new Area(new Ellipse2D.Double(x - ringDiameter / 2, centerY - ringDiameter / 2, ringDiameter, ringDiameter)));
            this.body[0] = wafer;
            Area tip = new Area(new RoundRectangle2D.Double(x - springWidth / 2, y - holeToEdge, springWidth, springLength - ringDiameter / 2, springWidth, springWidth));
            tip.subtract(new Area(new Ellipse2D.Double(x - holeDiameter / 2, y - holeDiameter / 2, holeDiameter, holeDiameter)));
            tip.subtract(wafer);
            this.body[1] = tip;
            Area sleeve = new Area(new RoundRectangle2D.Double(x - springWidth / 2, y - holeToEdge, springWidth, springLength, springWidth, springWidth));
            sleeve.subtract(new Area(new Ellipse2D.Double(x - holeDiameter / 2, y - holeDiameter / 2, holeDiameter, holeDiameter)));
            sleeve.transform(AffineTransform.getRotateInstance(this.getType() == OpenJackType.SWITCHED ? 4.1887902047863905 : 0.925024503543032, x, centerY));
            sleeve.add(new Area(new Ellipse2D.Double(x - ringDiameter / 2, centerY - ringDiameter / 2, ringDiameter, ringDiameter)));
            sleeve.subtract(new Area(new Ellipse2D.Double(x - innerDiameter / 2, centerY - innerDiameter / 2, innerDiameter, innerDiameter)));
            this.body[2] = sleeve;
            if (this.getType() != OpenJackType.MONO) {
                Area ringOrSwitch = new Area(new RoundRectangle2D.Double(x - springWidth / 2, y - holeToEdge, springWidth, springLength, springWidth, springWidth));
                ringOrSwitch.subtract(new Area(new Ellipse2D.Double(x - holeDiameter / 2, y - holeDiameter / 2, holeDiameter, holeDiameter)));
                ringOrSwitch.transform(AffineTransform.getRotateInstance(this.getType() == OpenJackType.SWITCHED ? 5.235987755982989 : 2.4975661596038856, x, centerY));
                ringOrSwitch.subtract(new Area(new Ellipse2D.Double(x - outerDiameter / 2, centerY - outerDiameter / 2, outerDiameter, outerDiameter)));
                this.body[3] = ringOrSwitch;
            }
            if (this.getTheta() != 0.0) {
                AffineTransform rotation = AffineTransform.getRotateInstance(this.getTheta(), x, y);
                for (int i = 0; i < this.body.length; ++i) {
                    Area shape = this.body[i];
                    Area area = shape;
                    if (area == null) continue;
                    area.transform(rotation);
                }
            }
        }
        return this.body;
    }

    private void updateControlPoints() {
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        int springLength = (int)SPRING_LENGTH.convertToPixels();
        int holeToEdge = (int)HOLE_TO_EDGE.convertToPixels();
        int centerY = y + springLength - holeToEdge;
        AffineTransform.getRotateInstance(this.getType() == OpenJackType.SWITCHED ? 4.1887902047863905 : 0.925024503543032, x, centerY).transform(this.controlPoints[0], this.controlPoints[1]);
        AffineTransform.getRotateInstance(this.getType() == OpenJackType.SWITCHED ? 5.235987755982989 : 2.4975661596038856, x, centerY).transform(this.controlPoints[0], this.controlPoints[2]);
        if (this.getTheta() != 0.0) {
            AffineTransform rotation = AffineTransform.getRotateInstance(this.getTheta(), x, y);
            for (Point point : this.controlPoints) {
                rotation.transform(point, point);
            }
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int waferDiameter = 15 * width / 32;
        int sleeveDiameter = 9 * width / 32;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(6.0f * (float)width / 32.0f));
        g2d.setColor(BASE_COLOR);
        g2d.drawLine(width / 2, 4 * width / 32, width / 2, width / 4);
        g2d.rotate(2.4975661596038856, width / 2, height / 2);
        g2d.drawLine(width / 2, 4 * width / 32, width / 2, width / 4);
        g2d.setColor(WAFER_COLOR);
        g2d.draw(new Ellipse2D.Double(width / 2 - waferDiameter / 2, height / 2 - waferDiameter / 2, waferDiameter, waferDiameter));
        g2d.setColor(BASE_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f * (float)width / 32.0f));
        g2d.draw(new Ellipse2D.Double(width / 2 - sleeveDiameter / 2, height / 2 - sleeveDiameter / 2, sleeveDiameter, sleeveDiameter));
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(6.0f * (float)width / 32.0f));
        g2d.rotate(-1.5707963267948966, width / 2, height / 2);
        g2d.drawLine(width / 2, 4 * width / 32, width / 2, width / 3);
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public boolean isControlPointSticky(int index) {
        return index < 2 || this.getType() == OpenJackType.STEREO;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Integer getAngle() {
        if (this.angle == null) {
            this.angle = this.orientation != null && this.orientation != Orientation.DEFAULT ? Integer.valueOf(Integer.parseInt(this.orientation.name().replace("_", ""))) : Integer.valueOf(0);
        }
        return this.angle;
    }

    public void setAngle(Integer angle) {
        this.angle = angle;
        this.updateControlPoints();
        this.body = null;
    }

    protected double getTheta() {
        return Math.toRadians(this.getAngle().intValue());
    }

    @EditableProperty
    public OpenJackType getType() {
        return this.type;
    }

    public void setType(OpenJackType type) {
        this.type = type;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Labels")
    public boolean getShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public String getControlPointNodeName(int index) {
        if (index == 0) {
            return "Tip";
        }
        if (index == 1) {
            return "Sleeve";
        }
        if (index == 2 && this.getType() == OpenJackType.STEREO) {
            return "Ring";
        }
        if (index == 2 && this.getType() == OpenJackType.SWITCHED) {
            return "Shunt";
        }
        return null;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public static enum OpenJackType {
        MONO,
        STEREO,
        SWITCHED;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

