/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.OrientationHV;
import org.diylc.components.guitar.AbstractSingleOrHumbuckerPickup;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="P-90 Single Coil Pickup", category="Guitar", author="Branislav Stojkovic", description="Single coil P-90 guitar pickup, both \"dog ear\" and \"soap bar\"", zOrder=4.0, instanceNamePrefix="PKP", autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Guitar Wiring Diagram")
public class P90Pickup
extends AbstractSingleOrHumbuckerPickup {
    private static final long serialVersionUID = 1L;
    private static Color BODY_COLOR = Color.decode("#D8C989");
    private static Size DOG_EAR_WIDTH = new Size(Double.valueOf(41.0), SizeUnit.mm);
    private static Size DOG_EAR_LENGTH = new Size(Double.valueOf(86.9), SizeUnit.mm);
    private static Size TOTAL_LENGTH = new Size(Double.valueOf(118.7), SizeUnit.mm);
    private static Size DOG_EAR_EDGE_RADIUS = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size SOAP_BAR_WIDTH = new Size(Double.valueOf(35.3), SizeUnit.mm);
    private static Size SOAP_BAR_LENGTH = new Size(Double.valueOf(85.6), SizeUnit.mm);
    private static Size SOAP_BAR_EDGE_RADIUS = new Size(Double.valueOf(8.0), SizeUnit.mm);
    private static Size LIP_RADIUS = new Size(Double.valueOf(10.0), SizeUnit.mm);
    private static Size POINT_MARGIN = new Size(Double.valueOf(3.5), SizeUnit.mm);
    private static Size POINT_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private static Size LIP_HOLE_SIZE = new Size(Double.valueOf(2.5), SizeUnit.mm);
    private static Size LIP_HOLE_SPACING = new Size(Double.valueOf(97.0), SizeUnit.mm);
    private static Size POLE_SIZE = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size POLE_SPACING = new Size(Double.valueOf(11.68), SizeUnit.mm);
    private Color color = BODY_COLOR;
    private P90Type type = P90Type.DOG_EAR;
    private Color poleColor = METAL_COLOR;

    @Override
    protected OrientationHV getControlPointDirection() {
        return OrientationHV.VERTICAL;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.color);
        g2d.fill(body[0]);
        if (body[1] != null) {
            g2d.fill(body[1]);
        }
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        if (body[1] != null) {
            g2d.draw(body[1]);
        }
        if (!outlineMode) {
            g2d.setColor(this.getPoleColor());
            g2d.fill(body[3]);
            g2d.setColor(this.darkerOrLighter(this.getPoleColor()));
            g2d.draw(body[3]);
        }
        this.drawMainLabel(g2d, project, outlineMode, componentState);
        this.drawlTerminalLabels(g2d, finalBorderColor, project);
    }

    @Override
    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[4];
            Point[] points = this.getControlPoints();
            int x = points[0].x;
            int y = points[0].y;
            int width = (int)this.getType().getWidth().convertToPixels();
            int length = (int)this.getType().getLength().convertToPixels();
            int edgeRadius = (int)this.getType().getEdgeRadius().convertToPixels();
            int pointMargin = (int)POINT_MARGIN.convertToPixels();
            int totalLength = (int)TOTAL_LENGTH.convertToPixels();
            int lipRadius = (int)LIP_RADIUS.convertToPixels();
            int pointSize = this.getClosestOdd(POINT_SIZE.convertToPixels());
            int lipHoleSize = this.getClosestOdd(LIP_HOLE_SIZE.convertToPixels());
            int lipHoleSpacing = this.getClosestOdd(LIP_HOLE_SPACING.convertToPixels());
            this.body[0] = new Area(new RoundRectangle2D.Double(x - length, y - pointMargin, length, width, edgeRadius, edgeRadius));
            if (this.getType() == P90Type.DOG_EAR) {
                double rectWidth = (double)(totalLength - length) / Math.sqrt(2.0);
                RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(-rectWidth / 2.0, -rectWidth / 2.0, rectWidth, rectWidth, lipRadius, lipRadius);
                Area leftEar = new Area(roundRect);
                leftEar.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                leftEar.transform(AffineTransform.getScaleInstance(1.1, 1.45));
                leftEar.transform(AffineTransform.getTranslateInstance(x - length, y - pointMargin + width / 2));
                leftEar.subtract((Area)this.body[0]);
                Area rightEar = new Area(roundRect);
                rightEar.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                rightEar.transform(AffineTransform.getScaleInstance(1.1, 1.45));
                rightEar.transform(AffineTransform.getTranslateInstance(x, y - pointMargin + width / 2));
                rightEar.subtract((Area)this.body[0]);
                Area lipArea = leftEar;
                lipArea.add(rightEar);
                lipArea.subtract(new Area(new Ellipse2D.Double(x - length / 2 - lipHoleSpacing / 2 - lipHoleSize / 2, y - pointMargin + width / 2 - lipHoleSize / 2, lipHoleSize, lipHoleSize)));
                lipArea.subtract(new Area(new Ellipse2D.Double(x - length / 2 + lipHoleSpacing / 2 - lipHoleSize / 2, y - pointMargin + width / 2 - lipHoleSize / 2, lipHoleSize, lipHoleSize)));
                this.body[1] = lipArea;
            }
            this.body[2] = new Area(new Ellipse2D.Double(x - pointSize / 2, y - pointSize / 2, pointSize, pointSize));
            int poleSize = (int)POLE_SIZE.convertToPixels();
            int poleSpacing = (int)POLE_SPACING.convertToPixels();
            int poleMargin = (length - poleSpacing * 5) / 2;
            Area poleArea = new Area();
            for (int i = 0; i < 6; ++i) {
                Ellipse2D.Double pole = new Ellipse2D.Double(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin - poleSize / 2 + width / 2, poleSize, poleSize);
                poleArea.add(new Area(pole));
            }
            this.body[3] = poleArea;
            if (this.orientation != Orientation.DEFAULT) {
                double theta = 0.0;
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
                for (Shape shape : this.body) {
                    Area area = (Area)shape;
                    if (shape == null) continue;
                    area.transform(rotation);
                }
            }
        }
        return this.body;
    }

    @Override
    protected int getMainLabelYOffset() {
        return (int)(this.getType().getWidth().convertToPixels() / 2.0 - 20.0);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(0.7853981633974483, width / 2, height / 2);
        int baseWidth = 13 * width / 32;
        int baseLength = 27 * width / 32;
        int radius = 6 * width / 32;
        g2d.setColor(BODY_COLOR);
        Polygon base = new Polygon(new int[]{width / 2, (width + baseWidth) / 2, (width + baseWidth) / 2, width / 2, (width - baseWidth) / 2, (width - baseWidth) / 2}, new int[]{-2, (height - baseLength) / 2, (height + baseLength) / 2, height + 1, (height + baseLength) / 2, (height - baseLength) / 2}, 6);
        Area baseArea = new Area(base);
        baseArea.intersect(new Area(new Rectangle(0, -1, width, height + 1)));
        g2d.fill(baseArea);
        g2d.setColor(BODY_COLOR.darker());
        g2d.draw(baseArea);
        g2d.setColor(BODY_COLOR);
        g2d.fillRoundRect((width - baseWidth) / 2, (height - baseLength) / 2, baseWidth, baseLength, radius, radius);
        g2d.setColor(BODY_COLOR.darker());
        g2d.drawRoundRect((width - baseWidth) / 2, (height - baseLength) / 2, baseWidth, baseLength, radius, radius);
        g2d.setColor(METAL_COLOR);
        int poleSize = 2;
        int poleSpacing = 17 * width / 32;
        for (int i = 0; i < 6; ++i) {
            g2d.fillOval((width - poleSize) / 2, (height - poleSpacing) / 2 + i * poleSpacing / 5, poleSize, poleSize);
        }
    }

    @EditableProperty(name="Type")
    public P90Type getType() {
        return this.type;
    }

    public void setType(P90Type type) {
        this.type = type;
        this.body = null;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Pole Color")
    public Color getPoleColor() {
        if (this.poleColor == null) {
            this.poleColor = METAL_COLOR;
        }
        return this.poleColor;
    }

    public void setPoleColor(Color poleColor) {
        this.poleColor = poleColor;
    }

    static /* synthetic */ Size access$000() {
        return DOG_EAR_LENGTH;
    }

    static /* synthetic */ Size access$100() {
        return DOG_EAR_WIDTH;
    }

    static /* synthetic */ Size access$200() {
        return DOG_EAR_EDGE_RADIUS;
    }

    static /* synthetic */ Size access$300() {
        return SOAP_BAR_LENGTH;
    }

    static /* synthetic */ Size access$400() {
        return SOAP_BAR_WIDTH;
    }

    static /* synthetic */ Size access$500() {
        return SOAP_BAR_EDGE_RADIUS;
    }

    public static enum P90Type {
        DOG_EAR("Dog Ear", P90Pickup.access$000(), P90Pickup.access$100(), P90Pickup.access$200()),
        SOAP_BAR("Soap Bar", P90Pickup.access$300(), P90Pickup.access$400(), P90Pickup.access$500());

        private String label;
        private Size length;
        private Size width;
        private Size edgeRadius;

        private P90Type(String label, Size length, Size width, Size edgeRadius) {
            this.label = label;
            this.length = length;
            this.width = width;
            this.edgeRadius = edgeRadius;
        }

        public Size getLength() {
            return this.length;
        }

        public Size getWidth() {
            return this.width;
        }

        public Size getEdgeRadius() {
            return this.edgeRadius;
        }

        public String toString() {
            return this.label;
        }
    }
}

