/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class MemoryBar
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(MemoryBar.class);
    private static final int DELAY = 10000;
    private static final boolean USE_LOG = false;
    private static final Format format = new DecimalFormat("0.00");
    private static final String logPattern = "%s MB of %s MB free, max %s MB is available";
    private static final String tooltipPattern = "<html>%s MB of %s MB free<br>Max %s MB is available<br>Click to run the garbage collector</html>";
    private static final double THRESHOLD = 0.1;
    private Thread bgThread;
    private long totalMemory = 0L;
    private long freeMemory = 0L;
    private long maxMemory = 0L;
    private double percentFree = 0.0;
    private boolean autoGC;

    public MemoryBar(boolean autoGC) {
        this.autoGC = autoGC;
        this.setPreferredSize(new Dimension(16, 20));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.bgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(1);
                while (true) {
                    MemoryBar.this.totalMemory = Runtime.getRuntime().totalMemory();
                    MemoryBar.this.freeMemory = Runtime.getRuntime().freeMemory();
                    MemoryBar.this.maxMemory = Runtime.getRuntime().maxMemory();
                    MemoryBar.this.percentFree = (double)MemoryBar.this.freeMemory / (double)MemoryBar.this.totalMemory;
                    if (MemoryBar.this.autoGC && MemoryBar.this.percentFree < 0.1) {
                        System.gc();
                    }
                    MemoryBar.this.setToolTipText(String.format(MemoryBar.tooltipPattern, format.format(MemoryBar.this.convertToMb(MemoryBar.this.freeMemory)), format.format(MemoryBar.this.convertToMb(MemoryBar.this.totalMemory)), format.format(MemoryBar.this.convertToMb(MemoryBar.this.maxMemory))));
                    MemoryBar.this.repaint();
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        this.bgThread.start();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LOG.info((Object)"Running GC");
                System.gc();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int barHeight = (int)((1.0 - this.percentFree) * (double)this.getHeight());
        if (this.percentFree < 0.1) {
            g2d.setColor(Color.red);
        } else {
            g2d.setColor(UIManager.getColor("List.selectionBackground"));
        }
        g2d.fillRect(0, this.getHeight() - barHeight - 1, this.getWidth() - 1, barHeight);
        g2d.setColor(UIManager.getColor("Button.shadow"));
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private double convertToMb(long size) {
        return (double)size / 1024.0 / 1024.0;
    }

    public void dispose() {
        if (this.bgThread != null) {
            this.bgThread.interrupt();
        }
    }
}

