/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.openide;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.diylc.swingframework.images.IconLoader;
import org.diylc.swingframework.openide.Parameters;

class IconWithArrow
implements Icon {
    private Icon orig;
    private Icon arrow = IconLoader.Arrow.getIcon();
    private boolean paintRollOver;

    public IconWithArrow(Icon orig, boolean paintRollOver) {
        Parameters.notNull("original icon", orig);
        this.orig = orig;
        this.paintRollOver = paintRollOver;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int height = this.getIconHeight();
        this.orig.paintIcon(c, g, x, y + (height - this.orig.getIconHeight()) / 2);
        this.arrow.paintIcon(c, g, x + 6 + this.orig.getIconWidth(), y + (height - this.arrow.getIconHeight()) / 2);
        if (this.paintRollOver) {
            Color brighter = UIManager.getColor("controlHighlight");
            Color darker = UIManager.getColor("controlShadow");
            if (null == brighter || null == darker) {
                brighter = c.getBackground().brighter();
                darker = c.getBackground().darker();
            }
            if (null != brighter && null != darker) {
                g.setColor(brighter);
                g.drawLine(x + this.orig.getIconWidth() + 1, y, x + this.orig.getIconWidth() + 1, y + this.getIconHeight());
                g.setColor(darker);
                g.drawLine(x + this.orig.getIconWidth() + 2, y, x + this.orig.getIconWidth() + 2, y + this.getIconHeight());
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.orig.getIconWidth() + 6 + this.arrow.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.orig.getIconHeight(), this.arrow.getIconHeight());
    }

    public static int getArrowAreaWidth() {
        return 8;
    }
}

