/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.awt.Point;

public class PointConverter
implements Converter {
    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Point point = (Point)object;
        hierarchicalStreamWriter.addAttribute("x", Double.toString(1.0 * (double)point.x / 200.0));
        hierarchicalStreamWriter.addAttribute("y", Double.toString(1.0 * (double)point.y / 200.0));
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        double d = Double.parseDouble(hierarchicalStreamReader.getAttribute("x"));
        double d2 = Double.parseDouble(hierarchicalStreamReader.getAttribute("y"));
        return new Point((int)Math.round(d * 200.0), (int)Math.round(d2 * 200.0));
    }

    public boolean canConvert(Class clazz) {
        return Point.class.isAssignableFrom(clazz);
    }
}

