/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.JarScanner;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.appframework.simplemq.IMessageListener;
import org.diylc.appframework.simplemq.MessageDispatcher;
import org.diylc.appframework.update.Version;
import org.diylc.appframework.update.VersionNumber;
import org.diylc.common.BuildingBlockPackage;
import org.diylc.common.ComponentType;
import org.diylc.common.DrawOption;
import org.diylc.common.EventType;
import org.diylc.common.IBlockProcessor;
import org.diylc.common.IComponentFiler;
import org.diylc.common.INetlistAnalyzer;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.common.PropertyWrapper;
import org.diylc.common.VariantPackage;
import org.diylc.core.ExpansionMode;
import org.diylc.core.IContinuity;
import org.diylc.core.IDIYComponent;
import org.diylc.core.ISwitch;
import org.diylc.core.IView;
import org.diylc.core.Project;
import org.diylc.core.Template;
import org.diylc.core.Theme;
import org.diylc.core.annotations.IAutoCreator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.netlist.Group;
import org.diylc.netlist.Netlist;
import org.diylc.netlist.NetlistAnalyzer;
import org.diylc.netlist.Node;
import org.diylc.netlist.Position;
import org.diylc.netlist.SwitchSetup;
import org.diylc.presenter.CalcUtils;
import org.diylc.presenter.ComparatorFactory;
import org.diylc.presenter.ComponentArea;
import org.diylc.presenter.ComponentProcessor;
import org.diylc.presenter.Connection;
import org.diylc.presenter.DrawingManager;
import org.diylc.presenter.InstantiationManager;
import org.diylc.presenter.ProjectFileManager;
import org.diylc.utils.Constants;

public class Presenter
implements IPlugInPort {
    private static final Logger LOG;
    public static VersionNumber CURRENT_VERSION;
    public static List<Version> RECENT_VERSIONS;
    public static final String DEFAULTS_KEY_PREFIX = "default.";
    private static Map<String, List<Template>> defaultVariantMap;
    public static final List<IDIYComponent<?>> EMPTY_SELECTION;
    public static final int ICON_SIZE = 32;
    private static final int MAX_RECENT_FILES = 20;
    private Project currentProject;
    private Map<String, List<ComponentType>> componentTypes;
    private List<IAutoCreator> autoCreators;
    private List<IPlugIn> plugIns;
    private Set<IDIYComponent<?>> selectedComponents;
    private Map<IDIYComponent<?>, Set<Integer>> controlPointMap;
    private Set<IDIYComponent<?>> lockedComponents;
    private DrawingManager drawingManager;
    private ProjectFileManager projectFileManager;
    private InstantiationManager instantiationManager;
    private Rectangle selectionRect;
    private final IView view;
    private MessageDispatcher<EventType> messageDispatcher;
    private boolean dragInProgress = false;
    private Point previousDragPoint = null;
    private Project preDragProject = null;
    private int dragAction;
    private Point previousScaledPoint;
    private static boolean upgradedVariants;

    public Presenter(IView iView) {
        this.view = iView;
        this.plugIns = new ArrayList<IPlugIn>();
        this.messageDispatcher = new MessageDispatcher(true);
        this.selectedComponents = new HashSet();
        this.lockedComponents = new HashSet();
        this.currentProject = new Project();
        this.drawingManager = new DrawingManager(this.messageDispatcher);
        this.projectFileManager = new ProjectFileManager(this.messageDispatcher);
        this.instantiationManager = new InstantiationManager();
        this.upgradeVariants();
    }

    public void installPlugin(IPlugIn iPlugIn) {
        LOG.info((Object)String.format("installPlugin(%s)", iPlugIn.getClass().getSimpleName()));
        this.plugIns.add(iPlugIn);
        iPlugIn.connect(this);
        this.messageDispatcher.registerListener((IMessageListener)iPlugIn);
    }

    public void dispose() {
        for (IPlugIn iPlugIn : this.plugIns) {
            this.messageDispatcher.unregisterListener((IMessageListener)iPlugIn);
        }
    }

    @Override
    public Double[] getAvailableZoomLevels() {
        return new Double[]{0.25, 0.3333, 0.5, 0.6667, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0};
    }

    @Override
    public double getZoomLevel() {
        return this.drawingManager.getZoomLevel();
    }

    @Override
    public void setZoomLevel(double d) {
        LOG.info((Object)String.format("setZoomLevel(%s)", d));
        if (this.drawingManager.getZoomLevel() == d) {
            return;
        }
        this.drawingManager.setZoomLevel(d);
    }

    @Override
    public Cursor getCursorAt(Point point) {
        if (ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false)) {
            return Cursor.getPredefinedCursor(1);
        }
        if (this.instantiationManager.getComponentTypeSlot() == null) {
            Point point2 = this.scalePoint(point);
            if (this.controlPointMap != null && !this.controlPointMap.isEmpty()) {
                return Cursor.getPredefinedCursor(12);
            }
            for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
                ComponentArea componentArea;
                if (this.isComponentLocked(iDIYComponent) || !this.isComponentVisible(iDIYComponent) || ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false) || (componentArea = this.drawingManager.getComponentArea(iDIYComponent)) == null || componentArea.getOutlineArea() == null || !componentArea.getOutlineArea().contains(point2)) continue;
                return Cursor.getPredefinedCursor(12);
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public Dimension getCanvasDimensions(boolean bl, boolean bl2) {
        return this.drawingManager.getCanvasDimensions(this.currentProject, bl ? this.drawingManager.getZoomLevel() : 1.0 / Constants.PIXEL_SIZE, bl2);
    }

    @Override
    public Project getCurrentProject() {
        return this.currentProject;
    }

    @Override
    public void loadProject(Project project, boolean bl, String string) {
        LOG.info((Object)String.format("loadProject(%s, %s)", project.getTitle(), bl));
        this.currentProject = project;
        this.drawingManager.clearComponentAreaMap();
        this.drawingManager.clearContinuityArea();
        this.updateSelection(EMPTY_SELECTION);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_LOADED, new Object[]{project, bl, string});
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.messageDispatcher.dispatchMessage((Enum)EventType.LAYER_STATE_CHANGED, new Object[]{this.currentProject.getLockedLayers()});
        this.messageDispatcher.dispatchMessage((Enum)EventType.LAYER_VISIBILITY_CHANGED, new Object[]{this.currentProject.getHiddenLayers()});
    }

    @Override
    public void createNewProject() {
        LOG.info((Object)"createNewFile()");
        try {
            Project project = new Project();
            this.instantiationManager.fillWithDefaultProperties(project, null);
            this.loadProject(project, true, null);
            this.projectFileManager.startNewFile();
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not create new file", (Throwable)exception);
            this.view.showMessage("Could not create a new file. Check the log for details.", "Error", 0);
        }
    }

    @Override
    public void loadProjectFromFile(String string) {
        LOG.info((Object)String.format("loadProjectFromFile(%s)", string));
        ArrayList<String> arrayList = null;
        try {
            arrayList = new ArrayList<String>();
            Project project = this.projectFileManager.deserializeProjectFromFile(string, arrayList);
            this.loadProject(project, true, string);
            this.projectFileManager.fireFileStatusChanged();
            if (!arrayList.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder("<html>File was opened, but there were some issues with it:<br><br>");
                for (String string2 : arrayList) {
                    stringBuilder.append(string2);
                    stringBuilder.append("<br>");
                }
                stringBuilder.append("</html");
                this.view.showMessage(stringBuilder.toString(), "Warning", 2);
            }
            this.addToRecentFiles(string);
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not load file", (Throwable)exception);
            String string3 = "Could not open file " + string + ". Check the log for details.";
            if (arrayList != null && !arrayList.isEmpty()) {
                string3 = string3 + " Possible reasons are:\n\n";
                for (String string4 : arrayList) {
                    string3 = string3 + string4;
                    string3 = string3 + "\n";
                }
            }
            this.view.showMessage(string3, "Error", 0);
        }
    }

    private void addToRecentFiles(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)ConfigurationManager.getInstance().readObject("recentFiles", null);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.remove(string);
        arrayList.add(0, string);
        while (arrayList.size() > 20) {
            arrayList.remove(arrayList.size() - 1);
        }
        ConfigurationManager.getInstance().writeValue("recentFiles", arrayList);
    }

    @Override
    public boolean allowFileAction() {
        if (this.projectFileManager.isModified()) {
            int n = this.view.showConfirmDialog("There are unsaved changes. Would you like to save them?", "Warning", 1, 2);
            if (n == 0) {
                if (this.getCurrentFileName() == null) {
                    File file = this.view.promptFileSave();
                    if (file == null) {
                        return false;
                    }
                    this.saveProjectToFile(file.getAbsolutePath(), false);
                } else {
                    this.saveProjectToFile(this.getCurrentFileName(), false);
                }
            }
            return n != 2;
        }
        return true;
    }

    @Override
    public void saveProjectToFile(String string, boolean bl) {
        block3: {
            LOG.info((Object)String.format("saveProjectToFile(%s)", string));
            try {
                this.currentProject.setFileVersion(CURRENT_VERSION);
                this.projectFileManager.serializeProjectToFile(this.currentProject, string, bl);
                if (!bl) {
                    this.addToRecentFiles(string);
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Could not save file", (Throwable)exception);
                if (bl) break block3;
                this.view.showMessage("Could not save file " + string + ". Check the log for details.", "Error", 0);
            }
        }
    }

    @Override
    public String getCurrentFileName() {
        return this.projectFileManager.getCurrentFileName();
    }

    @Override
    public boolean isProjectModified() {
        return this.projectFileManager.isModified();
    }

    @Override
    public Map<String, List<ComponentType>> getComponentTypes() {
        if (this.componentTypes == null) {
            LOG.info((Object)"Loading component types.");
            this.componentTypes = new HashMap<String, List<ComponentType>>();
            Set set = null;
            try {
                set = Utils.getClasses((String)"org.diylc.components");
                try {
                    Iterator<Map.Entry<String, List<ComponentType>>> iterator = JarScanner.getInstance().scanFolder("library", IDIYComponent.class);
                    if (iterator != null) {
                        set.addAll(iterator);
                    }
                }
                catch (Exception exception) {
                    LOG.warn((Object)"Could not find additional type classes", (Throwable)exception);
                }
                for (Class object : set) {
                    List<Object> list;
                    ComponentType componentType;
                    if (Modifier.isAbstract(object.getModifiers()) || !IDIYComponent.class.isAssignableFrom(object) || (componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(object)) == null) continue;
                    if (this.componentTypes.containsKey(componentType.getCategory())) {
                        list = this.componentTypes.get(componentType.getCategory());
                    } else {
                        list = new ArrayList();
                        this.componentTypes.put(componentType.getCategory(), list);
                    }
                    list.add(componentType);
                }
                for (Map.Entry<String, List<ComponentType>> entry : this.componentTypes.entrySet()) {
                    LOG.debug((Object)(entry.getKey() + ": " + entry.getValue()));
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error loading component types", (Throwable)exception);
            }
        }
        return this.componentTypes;
    }

    public List<IAutoCreator> getAutoCreators() {
        if (this.autoCreators == null) {
            this.autoCreators = new ArrayList<IAutoCreator>();
            Set set = null;
            try {
                set = Utils.getClasses((String)"org.diylc.components.autocreate");
                for (Class clazz : set) {
                    if (!IAutoCreator.class.isAssignableFrom(clazz)) continue;
                    this.autoCreators.add((IAutoCreator)clazz.newInstance());
                    LOG.debug((Object)("Loaded auto-creator: " + clazz.getName()));
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error loading auto-creator types", (Throwable)exception);
            }
        }
        return this.autoCreators;
    }

    private boolean isComponentVisible(IDIYComponent<?> iDIYComponent) {
        ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
        return !this.currentProject.getHiddenLayers().contains((int)Math.round(componentType.getZOrder()));
    }

    @Override
    public void draw(Graphics2D graphics2D, Set<DrawOption> set, final IComponentFiler iComponentFiler, Double d) {
        IDIYComponent<?> iDIYComponent2;
        if (this.currentProject == null) {
            return;
        }
        HashSet hashSet = new HashSet();
        for (IDIYComponent<?> iDIYComponent2 : this.currentProject.getComponents()) {
            if (this.findAllGroupedComponents(iDIYComponent2).size() <= 1) continue;
            hashSet.add(iDIYComponent2);
        }
        IComponentFiler iComponentFiler2 = new IComponentFiler(){

            @Override
            public boolean testComponent(IDIYComponent<?> iDIYComponent) {
                return (iComponentFiler == null || iComponentFiler.testComponent(iDIYComponent)) && Presenter.this.isComponentVisible(iDIYComponent);
            }
        };
        iDIYComponent2 = this.instantiationManager.getFirstControlPoint() != null && this.instantiationManager.getPotentialControlPoint() != null && this.instantiationManager.getFirstControlPoint().equals(this.instantiationManager.getPotentialControlPoint()) ? null : this.instantiationManager.getComponentSlot();
        List<IDIYComponent<?>> list = this.drawingManager.drawProject(graphics2D, this.currentProject, set, iComponentFiler2, this.selectionRect, (Collection<IDIYComponent<?>>)this.selectedComponents, this.getLockedComponents(), hashSet, Arrays.asList(this.instantiationManager.getFirstControlPoint(), this.instantiationManager.getPotentialControlPoint()), (List<IDIYComponent<?>>)((Object)iDIYComponent2), this.dragInProgress, d);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IDIYComponent<?> iDIYComponent3 : list) {
            arrayList.add(iDIYComponent3.getName());
        }
        Collections.sort(arrayList);
        if (!arrayList.isEmpty()) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.STATUS_MESSAGE_CHANGED, new Object[]{"<html><font color='red'>Failed to draw components: " + Utils.toCommaString(arrayList) + "</font></html>"});
        } else {
            this.messageDispatcher.dispatchMessage((Enum)EventType.STATUS_MESSAGE_CHANGED, new Object[]{""});
        }
    }

    public List<IDIYComponent<?>> findComponentsAtScaled(Point point) {
        List<IDIYComponent<?>> list = this.drawingManager.findComponentsAt(point, this.currentProject);
        Iterator<IDIYComponent<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            IDIYComponent<?> iDIYComponent = iterator.next();
            if (!this.isComponentLocked(iDIYComponent) && this.isComponentVisible(iDIYComponent)) continue;
            iterator.remove();
        }
        return list;
    }

    @Override
    public List<IDIYComponent<?>> findComponentsAt(Point point) {
        Point point2 = this.scalePoint(point);
        List<IDIYComponent<?>> list = this.findComponentsAtScaled(point2);
        return list;
    }

    @Override
    public void mouseClicked(Point point, int n, boolean bl, boolean bl2, boolean bl3, int n2) {
        LOG.debug((Object)String.format("mouseClicked(%s, %s, %s, %s, %s)", point, n, bl, bl2, bl3));
        Point point2 = this.scalePoint(point);
        if (n2 >= 2) {
            this.editSelection();
        } else if (this.instantiationManager.getComponentTypeSlot() != null) {
            if (n != 1) {
                this.instantiationManager.tryToRotateComponentSlot();
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                return;
            }
            ComponentType componentType = this.instantiationManager.getComponentTypeSlot();
            Template template = this.instantiationManager.getTemplate();
            Project project = this.currentProject.clone();
            switch (componentType.getCreationMethod()) {
                case SINGLE_CLICK: {
                    try {
                        if (this.isSnapToGrid()) {
                            CalcUtils.snapPointToGrid(point2, this.currentProject.getGridSpacing());
                        }
                        List<IDIYComponent<?>> list = this.instantiationManager.getComponentSlot();
                        ArrayList arrayList = new ArrayList();
                        for (IDIYComponent<?> iDIYComponent : list) {
                            this.currentProject.getComponents().add(iDIYComponent);
                            arrayList.add(iDIYComponent);
                        }
                        if (list.size() > 1 && !componentType.getName().toLowerCase().contains("clipboard")) {
                            this.currentProject.getGroups().add(new HashSet(list));
                        }
                        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                        this.updateSelection(arrayList);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)("Error instatiating component of type: " + componentType.getInstanceClass().getName()), (Throwable)exception);
                    }
                    if (componentType.isAutoEdit() && ConfigurationManager.getInstance().readBoolean("autoEdit", false)) {
                        this.editSelection();
                    }
                    if (ConfigurationManager.getInstance().readBoolean("continuousCreation", false)) {
                        this.setNewComponentTypeSlot(componentType, template, false);
                        break;
                    }
                    this.setNewComponentTypeSlot(null, null, false);
                    break;
                }
                case POINT_BY_POINT: {
                    if (this.isSnapToGrid()) {
                        CalcUtils.snapPointToGrid(point2, this.currentProject.getGridSpacing());
                    }
                    if (this.instantiationManager.getComponentSlot() == null) {
                        try {
                            this.instantiationManager.instatiatePointByPoint(point2, this.currentProject);
                        }
                        catch (Exception exception) {
                            this.view.showMessage("Could not create component. Check log for details.", "Error", 0);
                            LOG.error((Object)"Could not create component", (Throwable)exception);
                        }
                        this.messageDispatcher.dispatchMessage((Enum)EventType.SLOT_CHANGED, new Object[]{componentType, this.instantiationManager.getFirstControlPoint()});
                        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                        break;
                    }
                    this.addPendingComponentsToProject(point2, componentType, template);
                    break;
                }
                default: {
                    LOG.error((Object)("Unknown creation method: " + (Object)((Object)componentType.getCreationMethod())));
                }
            }
            if (!project.equals(this.currentProject)) {
                this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Add " + componentType.getName()});
                this.drawingManager.clearContinuityArea();
                this.projectFileManager.notifyFileChange();
            }
        } else if (ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false)) {
            this.drawingManager.findContinuityAreaAtPoint(this.currentProject, point2);
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        } else {
            ArrayList arrayList = new ArrayList(this.selectedComponents);
            List<IDIYComponent<?>> list = this.findComponentsAtScaled(point2);
            if (list.isEmpty()) {
                if (!bl) {
                    arrayList.clear();
                }
            } else {
                IDIYComponent<?> iDIYComponent = list.get(0);
                if (bl) {
                    if (arrayList.contains(iDIYComponent)) {
                        arrayList.removeAll(this.findAllGroupedComponents(iDIYComponent));
                    } else {
                        arrayList.addAll(this.findAllGroupedComponents(iDIYComponent));
                    }
                } else {
                    if (n == 1 || n == 3 && arrayList.size() == 1 || !arrayList.contains(iDIYComponent)) {
                        arrayList.clear();
                    }
                    arrayList.addAll(this.findAllGroupedComponents(iDIYComponent));
                }
            }
            this.updateSelection(arrayList);
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        }
    }

    private void addPendingComponentsToProject(Point point, ComponentType componentType, Template template) {
        List<IDIYComponent<?>> list = this.instantiationManager.getComponentSlot();
        Point point2 = list.get(0).getControlPoint(0);
        if (point == null || point.equals(point2)) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (IDIYComponent<?> iDIYComponent : list) {
            this.addComponent(iDIYComponent, true);
            if (this.isComponentLocked(iDIYComponent) || !this.isComponentVisible(iDIYComponent)) continue;
            arrayList.add(iDIYComponent);
        }
        this.updateSelection(arrayList);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        if (componentType.isAutoEdit() && ConfigurationManager.getInstance().readBoolean("autoEdit", false)) {
            this.editSelection();
        }
        if (ConfigurationManager.getInstance().readBoolean("continuousCreation", false)) {
            this.setNewComponentTypeSlot(componentType, template, false);
        } else {
            this.setNewComponentTypeSlot(null, null, false);
        }
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        if (n != 40 && n != 37 && n != 38 && n != 39 && n != 72 && n != 86) {
            return false;
        }
        LOG.debug((Object)String.format("keyPressed(%s, %s, %s, %s)", n, bl, bl2, bl3));
        HashMap hashMap = new HashMap();
        for (Serializable serializable : this.selectedComponents) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (serializable.getControlPointCount() <= 0) continue;
            for (n2 = 0; n2 < serializable.getControlPointCount(); ++n2) {
                hashSet.add(n2);
            }
            hashMap.put((IDIYComponent<?>)serializable, (Set<Integer>)hashSet);
        }
        if (hashMap.isEmpty()) {
            return false;
        }
        boolean bl4 = ConfigurationManager.getInstance().readBoolean("snapToGrid", true);
        if (bl2) {
            boolean bl5 = bl4 = !bl4;
        }
        if (bl3) {
            Serializable serializable;
            serializable = null;
            if (n == 39) {
                serializable = this.currentProject.clone();
                this.rotateComponents(this.selectedComponents, 1, bl4);
            } else if (n == 37) {
                serializable = this.currentProject.clone();
                this.rotateComponents(this.selectedComponents, -1, bl4);
            } else if (n == 72) {
                serializable = this.currentProject.clone();
                this.mirrorComponents(this.selectedComponents, 0, bl4);
            } else if (n == 86) {
                serializable = this.currentProject.clone();
                this.mirrorComponents(this.selectedComponents, 1, bl4);
            } else {
                return false;
            }
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{serializable, this.currentProject.clone(), "Rotate Selection"});
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            this.drawingManager.clearContinuityArea();
            return true;
        }
        boolean bl6 = ConfigurationManager.getInstance().readBoolean("stickyPoints", true);
        if (bl) {
            boolean bl7 = bl6 = !bl6;
        }
        if (bl6) {
            this.includeStuckComponents(hashMap);
        }
        int n3 = bl4 ? (int)this.currentProject.getGridSpacing().convertToPixels() : 1;
        n2 = 0;
        int n4 = 0;
        switch (n) {
            case 40: {
                n4 = n3;
                break;
            }
            case 37: {
                n2 = -n3;
                break;
            }
            case 38: {
                n4 = -n3;
                break;
            }
            case 39: {
                n2 = n3;
                break;
            }
            default: {
                return false;
            }
        }
        Project project = this.currentProject.clone();
        this.moveComponents(hashMap, n2, n4, bl4);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Move Selection"});
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        return true;
    }

    @Override
    public void editSelection() {
        HashSet<PropertyWrapper> hashSet;
        boolean bl;
        List<PropertyWrapper> list = this.getMutualSelectionProperties();
        if (list != null && !list.isEmpty() && (bl = this.view.editProperties(list, hashSet = new HashSet<PropertyWrapper>()))) {
            try {
                this.applyPropertiesToSelection(list);
            }
            catch (Exception exception) {
                this.view.showMessage("Error occured while editing selection. Check the log for details.", "Error", 0);
                LOG.error((Object)"Error applying properties", (Throwable)exception);
            }
            for (PropertyWrapper propertyWrapper : hashSet) {
                if (propertyWrapper.getValue() == null) continue;
                this.setSelectionDefaultPropertyValue(propertyWrapper.getName(), propertyWrapper.getValue());
            }
        }
    }

    @Override
    public void mouseMoved(Point point, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        int n;
        if (point == null) {
            return;
        }
        this.dragAction = bl2 ? 0x40000000 : 0;
        HashMap hashMap = new HashMap();
        this.previousScaledPoint = this.scalePoint(point);
        if (this.instantiationManager.getComponentTypeSlot() != null) {
            if (this.isSnapToGrid()) {
                CalcUtils.snapPointToGrid(this.previousScaledPoint, this.currentProject.getGridSpacing());
            }
            n = 0;
            switch (this.instantiationManager.getComponentTypeSlot().getCreationMethod()) {
                case POINT_BY_POINT: {
                    n = this.instantiationManager.updatePointByPoint(this.previousScaledPoint) ? 1 : 0;
                    break;
                }
                case SINGLE_CLICK: {
                    n = this.instantiationManager.updateSingleClick(this.previousScaledPoint, this.isSnapToGrid(), this.currentProject.getGridSpacing()) ? 1 : 0;
                }
            }
            if (n != 0) {
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            }
        } else {
            block6: for (n = this.currentProject.getComponents().size() - 1; n >= 0; --n) {
                serializable = this.currentProject.getComponents().get(n);
                for (int i = 0; i < serializable.getControlPointCount(); ++i) {
                    Point point2 = serializable.getControlPoint(i);
                    if (!this.selectedComponents.contains(serializable) || !serializable.canPointMoveFreely(i) || this.findAllGroupedComponents((IDIYComponent<?>)serializable).size() != 1) continue;
                    try {
                        if (!(this.previousScaledPoint.distance(point2) < (double)DrawingManager.CONTROL_POINT_SIZE)) continue;
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        hashSet.add(i);
                        hashMap.put((IDIYComponent<?>)serializable, (Set<Integer>)hashSet);
                        continue block6;
                    }
                    catch (Exception exception) {
                        LOG.warn((Object)("Error reading control point for component of type: " + serializable.getClass().getName()));
                    }
                }
            }
        }
        Point2D.Double double_ = new Point2D.Double(1.0 * (double)this.previousScaledPoint.x / 200.0, 1.0 * (double)this.previousScaledPoint.y / 200.0);
        serializable = new Point2D.Double(((Point2D)double_).getX() * SizeUnit.in.getFactor() / SizeUnit.cm.getFactor() * 10.0, ((Point2D)double_).getY() * SizeUnit.in.getFactor() / SizeUnit.cm.getFactor() * 10.0);
        this.messageDispatcher.dispatchMessage((Enum)EventType.MOUSE_MOVED, new Object[]{this.previousScaledPoint, double_, serializable});
        if (!((Object)hashMap).equals(this.controlPointMap)) {
            this.controlPointMap = hashMap;
            this.messageDispatcher.dispatchMessage((Enum)EventType.AVAILABLE_CTRL_POINTS_CHANGED, new Object[]{new HashMap(hashMap)});
        }
    }

    @Override
    public Collection<IDIYComponent<?>> getSelectedComponents() {
        ArrayList arrayList = new ArrayList(this.selectedComponents);
        Collections.sort(arrayList, ComparatorFactory.getInstance().getComponentProjectZOrderComparator(this.currentProject));
        return arrayList;
    }

    @Override
    public void selectAll(int n) {
        LOG.info((Object)"selectAll()");
        ArrayList arrayList = new ArrayList(this.currentProject.getComponents());
        arrayList.removeAll(this.getLockedComponents());
        if (n > 0) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IDIYComponent iDIYComponent = (IDIYComponent)iterator.next();
                ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
                if ((int)componentType.getZOrder() == n) continue;
                iterator.remove();
            }
        }
        this.updateSelection(arrayList);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public Rectangle2D getSelectionBounds(boolean bl) {
        if (this.selectedComponents == null || this.selectedComponents.isEmpty()) {
            return null;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            ComponentArea componentArea = this.drawingManager.getComponentArea(iDIYComponent);
            if (componentArea != null && componentArea.getOutlineArea() != null) {
                Rectangle rectangle = componentArea.getOutlineArea().getBounds();
                if (rectangle.x < n) {
                    n = rectangle.x;
                }
                if (rectangle.x + rectangle.width > n2) {
                    n2 = rectangle.x + rectangle.width;
                }
                if (rectangle.y < n3) {
                    n3 = rectangle.y;
                }
                if (rectangle.y + rectangle.height <= n4) continue;
                n4 = rectangle.y + rectangle.height;
                continue;
            }
            if (!this.currentProject.getComponents().contains(iDIYComponent)) continue;
            LOG.debug((Object)("Area is null for " + iDIYComponent.getName() + " of type " + iDIYComponent.getClass().getName()));
        }
        if (ConfigurationManager.getInstance().readBoolean("extraSpace", true)) {
            double d = this.drawingManager.getExtraSpace(this.currentProject);
            n = (int)((double)n + d);
            n2 = (int)((double)n2 + d);
            n3 = (int)((double)n3 + d);
            n4 = (int)((double)n4 + d);
        }
        if (this.drawingManager.getZoomLevel() != 1.0 && bl) {
            n = (int)((double)n * this.drawingManager.getZoomLevel());
            n2 = (int)((double)n2 * this.drawingManager.getZoomLevel());
            n3 = (int)((double)n3 * this.drawingManager.getZoomLevel());
            n4 = (int)((double)n4 * this.drawingManager.getZoomLevel());
        }
        return new Rectangle2D.Double(n, n3, n2 - n, n4 - n3);
    }

    @Override
    public void nudgeSelection(Size size, Size size2, boolean bl) {
        Serializable serializable;
        if (this.selectedComponents == null || this.selectedComponents.isEmpty()) {
            return;
        }
        LOG.debug((Object)String.format("nudgeSelection(%s, %s, %s)", size, size2, bl));
        HashMap hashMap = new HashMap();
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            serializable = new HashSet();
            if (iDIYComponent.getControlPointCount() <= 0) continue;
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                serializable.add(i);
            }
            hashMap.put(iDIYComponent, (Set<Integer>)((Object)serializable));
        }
        if (hashMap.isEmpty()) {
            return;
        }
        if (bl) {
            this.includeStuckComponents(hashMap);
        }
        int n = (int)size.convertToPixels();
        int n2 = (int)size2.convertToPixels();
        serializable = this.currentProject.clone();
        this.moveComponents(hashMap, n, n2, false);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{serializable, this.currentProject.clone(), "Move Selection"});
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.drawingManager.clearContinuityArea();
    }

    @Override
    public VersionNumber getCurrentVersionNumber() {
        return CURRENT_VERSION;
    }

    @Override
    public List<Version> getRecentUpdates() {
        return RECENT_VERSIONS;
    }

    @Override
    public void dragStarted(Point point, int n, boolean bl) {
        List<IDIYComponent<?>> list;
        Point point2;
        LOG.debug((Object)String.format("dragStarted(%s, %s)", point, n));
        if (this.instantiationManager.getComponentTypeSlot() != null) {
            LOG.debug((Object)"Cannot start drag because a new component is being created.");
            this.mouseClicked(point, 1, n == 1, n == 0x40000000, n == 2, 1);
            return;
        }
        if (ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false)) {
            LOG.debug((Object)"Cannot start drag in hightlight continuity mode.");
            return;
        }
        this.dragInProgress = true;
        this.dragAction = n;
        this.preDragProject = this.currentProject.clone();
        this.previousDragPoint = point2 = this.scalePoint(point);
        List<IDIYComponent<?>> list2 = list = bl ? null : this.findComponentsAtScaled(point2);
        if (!this.controlPointMap.isEmpty()) {
            this.updateSelection(new ArrayList(this.controlPointMap.keySet()));
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        } else if (list == null || list.isEmpty()) {
            this.updateSelection(EMPTY_SELECTION);
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        } else {
            IDIYComponent<?> iDIYComponent = list.get(0);
            if (!this.selectedComponents.contains(iDIYComponent)) {
                this.updateSelection(new ArrayList(this.findAllGroupedComponents(iDIYComponent)));
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            }
            for (IDIYComponent<?> iDIYComponent2 : this.selectedComponents) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                if (iDIYComponent2.getControlPointCount() <= 0) continue;
                for (int i = 0; i < iDIYComponent2.getControlPointCount(); ++i) {
                    hashSet.add(i);
                }
                this.controlPointMap.put(iDIYComponent2, hashSet);
            }
            boolean bl2 = ConfigurationManager.getInstance().readBoolean("stickyPoints", true);
            if (this.dragAction == 1) {
                boolean bl3 = bl2 = !bl2;
            }
            if (bl2) {
                this.includeStuckComponents(this.controlPointMap);
            }
        }
    }

    @Override
    public void dragActionChanged(int n) {
        LOG.debug((Object)("dragActionChanged(" + n + ")"));
        this.dragAction = n;
    }

    private void includeStuckComponents(Map<IDIYComponent<?>, Set<Integer>> map) {
        int n = map.size();
        LOG.trace((Object)"Expanding selected component map");
        for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                if (map.containsKey(iDIYComponent) && map.get(iDIYComponent).contains(i) || this.isComponentLocked(iDIYComponent) || !this.isComponentVisible(iDIYComponent) || !iDIYComponent.isControlPointSticky(i)) continue;
                boolean bl = false;
                block2: for (Map.Entry<IDIYComponent<?>, Set<Integer>> entry : map.entrySet()) {
                    if (bl) break;
                    for (Integer n2 : entry.getValue()) {
                        Point point;
                        Point point2 = iDIYComponent.getControlPoint(i);
                        if (!entry.getKey().isControlPointSticky(n2) || !(point2.distance(point = entry.getKey().getControlPoint(n2)) < (double)DrawingManager.CONTROL_POINT_SIZE)) continue;
                        bl = true;
                        continue block2;
                    }
                }
                if (!bl) continue;
                LOG.trace((Object)("Including component: " + iDIYComponent));
                HashSet hashSet = new HashSet();
                if (iDIYComponent.canPointMoveFreely(i)) {
                    hashSet.add(i);
                } else {
                    for (int j = 0; j < iDIYComponent.getControlPointCount(); ++j) {
                        hashSet.add(j);
                    }
                }
                if (map.containsKey(iDIYComponent)) {
                    map.get(iDIYComponent).addAll(hashSet);
                    continue;
                }
                map.put(iDIYComponent, hashSet);
            }
        }
        int n3 = map.size();
        if (n3 > n) {
            LOG.trace((Object)"Component count changed, trying one more time.");
            this.includeStuckComponents(map);
        } else {
            LOG.trace((Object)"Component count didn't change, done with expanding.");
        }
    }

    private boolean isSnapToGrid() {
        boolean bl = ConfigurationManager.getInstance().readBoolean("snapToGrid", true);
        if (this.dragAction == 0x40000000) {
            bl = !bl;
        }
        return bl;
    }

    @Override
    public boolean dragOver(Point point) {
        if (point == null || ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false)) {
            return false;
        }
        Point point2 = this.scalePoint(point);
        if (!this.controlPointMap.isEmpty()) {
            int n = point2.x - this.previousDragPoint.x;
            int n2 = point2.y - this.previousDragPoint.y;
            Point point3 = this.moveComponents(this.controlPointMap, n, n2, this.isSnapToGrid());
            if (point3 == null) {
                return true;
            }
            this.previousDragPoint.translate(point3.x, point3.y);
        } else if (this.selectedComponents.isEmpty() && this.instantiationManager.getComponentTypeSlot() == null && this.previousDragPoint != null) {
            Rectangle rectangle = this.selectionRect == null ? null : new Rectangle(this.selectionRect);
            this.selectionRect = Utils.createRectangle((Point)point2, (Point)this.previousDragPoint);
            if (this.selectionRect.equals(rectangle)) {
                return true;
            }
        } else if (this.instantiationManager.getComponentSlot() != null) {
            this.previousScaledPoint = this.scalePoint(point);
            this.instantiationManager.updateSingleClick(this.previousScaledPoint, this.isSnapToGrid(), this.currentProject.getGridSpacing());
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        return true;
    }

    private Point moveComponents(Map<IDIYComponent<?>, Set<Integer>> map, int n, int n2, boolean bl) {
        Serializable serializable;
        double d;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = ConfigurationManager.getInstance().readBoolean("extraSpace", true);
        Dimension dimension = this.drawingManager.getCanvasDimensions(this.currentProject, 1.0, bl2);
        double d2 = d = bl2 ? this.drawingManager.getExtraSpace(this.currentProject) : 0.0;
        if (map.size() == 1) {
            Iterator<Map.Entry<IDIYComponent<?>, Set<Integer>>> iterator = map.entrySet().iterator().next();
            Map.Entry<IDIYComponent<?>, Set<Integer>> entry = iterator.getKey().getControlPoint(iterator.getValue().toArray(new Integer[0])[0]);
            serializable = new Point((Point)((Object)entry));
            ((Point)serializable).translate(n, n2);
            if (bl) {
                CalcUtils.snapPointToGrid((Point)serializable, this.currentProject.getGridSpacing());
            }
            n3 = ((Point)serializable).x - ((Point)((Object)entry)).x;
            n4 = ((Point)serializable).y - ((Point)((Object)entry)).y;
        } else if (bl) {
            n3 = CalcUtils.roundToGrid(n, this.currentProject.getGridSpacing());
            n4 = CalcUtils.roundToGrid(n2, this.currentProject.getGridSpacing());
        } else {
            n3 = n;
            n4 = n2;
        }
        if (n3 == 0 && n4 == 0) {
            return null;
        }
        for (Map.Entry<IDIYComponent<?>, Set<Integer>> entry : map.entrySet()) {
            int n5;
            serializable = (IDIYComponent)entry.getKey();
            Point[] pointArray = new Point[serializable.getControlPointCount()];
            for (n5 = 0; n5 < serializable.getControlPointCount(); ++n5) {
                pointArray[n5] = new Point(serializable.getControlPoint(n5));
                if (entry.getValue().contains(n5)) {
                    ((Point)pointArray[n5]).translate(n3, n4);
                    ((Point)pointArray[n5]).translate((int)d, (int)d);
                    if (((Point)pointArray[n5]).x < 0 || ((Point)pointArray[n5]).y < 0 || ((Point)pointArray[n5]).x > dimension.width || ((Point)pointArray[n5]).y > dimension.height) {
                        return null;
                    }
                }
                if (!serializable.canControlPointOverlap(n5)) continue;
                pointArray[n5] = null;
            }
            for (n5 = 0; n5 < pointArray.length - 1; ++n5) {
                for (int i = n5 + 1; i < pointArray.length; ++i) {
                    if (pointArray[n5] == null || pointArray[i] == null || !((Point)pointArray[n5]).equals(pointArray[i])) continue;
                    return null;
                }
            }
        }
        for (Map.Entry<IDIYComponent<?>, Set<Integer>> entry : map.entrySet()) {
            serializable = entry.getKey();
            this.drawingManager.invalidateComponent((IDIYComponent<?>)serializable);
            for (Integer n6 : entry.getValue()) {
                Point point = new Point(serializable.getControlPoint(n6));
                point.translate(n3, n4);
                serializable.setControlPoint(point, n6);
            }
        }
        return new Point(n3, n4);
    }

    @Override
    public void rotateSelection(int n) {
        if (!this.selectedComponents.isEmpty()) {
            LOG.trace((Object)"Rotating selected components");
            Project project = this.currentProject.clone();
            this.rotateComponents(this.selectedComponents, n, this.isSnapToGrid());
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Rotate Selection"});
            this.drawingManager.clearContinuityArea();
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        }
    }

    private void rotateComponents(Collection<IDIYComponent<?>> collection, int n, boolean bl) {
        ComponentType componentType;
        Point point = this.getCenterOf(collection, bl);
        boolean bl2 = true;
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            if (componentType.getTransformer() != null && componentType.getTransformer().canRotate(iDIYComponent)) continue;
            bl2 = false;
            break;
        }
        if (!bl2 && this.view.showConfirmDialog("Selection contains components that cannot be rotated. Do you want to exclude them?", "Mirror Selection", 0, 3) != 0) {
            return;
        }
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            if (componentType.getTransformer() == null || !componentType.getTransformer().canRotate(iDIYComponent)) continue;
            this.drawingManager.invalidateComponent(iDIYComponent);
            componentType.getTransformer().rotate(iDIYComponent, point, n);
        }
    }

    @Override
    public void mirrorSelection(int n) {
        if (!this.selectedComponents.isEmpty()) {
            LOG.trace((Object)"Mirroring selected components");
            Project project = this.currentProject.clone();
            this.mirrorComponents(this.selectedComponents, n, this.isSnapToGrid());
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Mirror Selection"});
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            this.drawingManager.clearContinuityArea();
        }
    }

    private void mirrorComponents(Collection<IDIYComponent<?>> collection, int n, boolean bl) {
        ComponentType componentType;
        Point point = this.getCenterOf(collection, bl);
        boolean bl2 = true;
        boolean bl3 = false;
        for (IDIYComponent<?> iDIYComponent : collection) {
            componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            if (componentType.getTransformer() == null || !componentType.getTransformer().canMirror(iDIYComponent)) {
                bl2 = false;
                break;
            }
            if (componentType.getTransformer() == null || !componentType.getTransformer().mirroringChangesCircuit()) continue;
            bl3 = true;
        }
        if (!bl2 && this.view.showConfirmDialog("Selection contains components that cannot be mirrored. Do you want to exclude them?", "Mirror Selection", 0, 3) != 0) {
            return;
        }
        if (bl3 && this.view.showConfirmDialog("Mirroring operation will change the circuit. Do you want to continue?", "Mirror Selection", 0, 3) != 0) {
            return;
        }
        for (IDIYComponent<?> iDIYComponent : collection) {
            componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            this.drawingManager.invalidateComponent(iDIYComponent);
            if (componentType.getTransformer() == null || !componentType.getTransformer().canMirror(iDIYComponent)) continue;
            componentType.getTransformer().mirror(iDIYComponent, point, n);
        }
    }

    private Point getCenterOf(Collection<IDIYComponent<?>> collection, boolean bl) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (IDIYComponent<?> iDIYComponent : collection) {
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                Point point = iDIYComponent.getControlPoint(i);
                if (n > point.x) {
                    n = point.x;
                }
                if (n3 < point.x) {
                    n3 = point.x;
                }
                if (n2 > point.y) {
                    n2 = point.y;
                }
                if (n4 >= point.y) continue;
                n4 = point.y;
            }
        }
        int n5 = (n3 + n) / 2;
        int n6 = (n4 + n2) / 2;
        if (bl) {
            CalcUtils.roundToGrid(n5, this.currentProject.getGridSpacing());
            CalcUtils.roundToGrid(n6, this.currentProject.getGridSpacing());
        }
        return new Point(n5, n6);
    }

    @Override
    public void dragEnded(Point point) {
        LOG.debug((Object)String.format("dragEnded(%s)", point));
        Point point2 = this.scalePoint(point);
        if (!this.dragInProgress && this.instantiationManager.getComponentSlot() == null) {
            return;
        }
        if (this.selectedComponents.isEmpty()) {
            if (point2 != null) {
                this.selectionRect = Utils.createRectangle((Point)point2, (Point)this.previousDragPoint);
            }
            ArrayList arrayList = new ArrayList();
            if (!ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false)) {
                for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
                    ComponentArea componentArea;
                    if (this.isComponentLocked(iDIYComponent) || !this.isComponentVisible(iDIYComponent) || (componentArea = this.drawingManager.getComponentArea(iDIYComponent)) == null || componentArea.getOutlineArea() == null || this.selectionRect == null || !componentArea.getOutlineArea().intersects(this.selectionRect)) continue;
                    arrayList.addAll(this.findAllGroupedComponents(iDIYComponent));
                }
            }
            this.selectionRect = null;
            this.updateSelection(arrayList);
        } else if (this.instantiationManager.getComponentSlot() != null) {
            this.preDragProject = this.currentProject.clone();
            this.addPendingComponentsToProject(point2, this.instantiationManager.getComponentTypeSlot(), null);
        } else {
            this.updateSelection(this.selectedComponents);
        }
        if (!this.preDragProject.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{this.preDragProject, this.currentProject.clone(), "Drag"});
            this.drawingManager.clearContinuityArea();
            this.projectFileManager.notifyFileChange();
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.dragInProgress = false;
    }

    @Override
    public void pasteComponents(Collection<IDIYComponent<?>> collection, boolean bl) {
        LOG.info((Object)String.format("pasteComponents(%s, %s)", collection, bl));
        this.instantiationManager.pasteComponents(collection, this.previousScaledPoint, this.isSnapToGrid(), this.currentProject.getGridSpacing(), bl, this.currentProject);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.messageDispatcher.dispatchMessage((Enum)EventType.SLOT_CHANGED, new Object[]{this.instantiationManager.getComponentTypeSlot(), this.instantiationManager.getFirstControlPoint()});
    }

    @Override
    public void duplicateSelection() {
        LOG.info((Object)"duplicateSelection()");
        if (this.selectedComponents.isEmpty()) {
            LOG.debug((Object)"Nothing to duplicate");
            return;
        }
        Project project = this.currentProject.clone();
        HashSet hashSet = new HashSet();
        int n = (int)this.currentProject.getGridSpacing().convertToPixels();
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            try {
                IDIYComponent<?> iDIYComponent2 = iDIYComponent.clone();
                ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent2.getClass());
                iDIYComponent2.setName(this.instantiationManager.createUniqueName(componentType, this.currentProject.getComponents()));
                hashSet.add(iDIYComponent2);
                for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                    Point point = iDIYComponent.getControlPoint(i);
                    Point point2 = new Point(point.x + n, point.y + n);
                    iDIYComponent2.setControlPoint(point2, i);
                }
                this.currentProject.getComponents().add(iDIYComponent2);
            }
            catch (Exception exception) {}
        }
        this.updateSelection(hashSet);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Duplicate"});
        this.drawingManager.clearContinuityArea();
        this.projectFileManager.notifyFileChange();
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public void deleteSelectedComponents() {
        LOG.info((Object)"deleteSelectedComponents()");
        if (this.selectedComponents.isEmpty()) {
            LOG.debug((Object)"Nothing to delete");
            return;
        }
        Project project = this.currentProject.clone();
        this.ungroupComponents(this.selectedComponents);
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            this.drawingManager.invalidateComponent(iDIYComponent);
        }
        this.currentProject.getComponents().removeAll(this.selectedComponents);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Delete"});
        this.drawingManager.clearContinuityArea();
        this.projectFileManager.notifyFileChange();
        this.updateSelection(EMPTY_SELECTION);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public void setSelectionDefaultPropertyValue(String string, Object object) {
        LOG.info((Object)String.format("setSelectionDefaultPropertyValue(%s, %s)", string, object));
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            String string2 = iDIYComponent.getClass().getName();
            LOG.debug((Object)("Default property value set for " + string2 + ":" + string));
            ConfigurationManager.getInstance().writeValue(DEFAULTS_KEY_PREFIX + string2 + ":" + string, object);
        }
    }

    @Override
    public void setDefaultPropertyValue(Class<?> clazz, String string, Object object) {
        LOG.info((Object)String.format("setProjectDefaultPropertyValue(%s, %s, %s)", clazz.getName(), string, object));
        LOG.debug((Object)("Default property value set for " + Project.class.getName() + ":" + string));
        ConfigurationManager.getInstance().writeValue(DEFAULTS_KEY_PREFIX + clazz.getName() + ":" + string, object);
    }

    @Override
    public void setMetric(boolean bl) {
        ConfigurationManager.getInstance().writeValue("metric", (Object)bl);
    }

    @Override
    public void groupSelectedComponents() {
        LOG.info((Object)"groupSelectedComponents()");
        Project project = this.currentProject.clone();
        this.ungroupComponents(this.selectedComponents);
        this.currentProject.getGroups().add(new HashSet(this.selectedComponents));
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Group"});
            this.projectFileManager.notifyFileChange();
        }
    }

    @Override
    public void ungroupSelectedComponents() {
        LOG.info((Object)"ungroupSelectedComponents()");
        Project project = this.currentProject.clone();
        this.ungroupComponents(this.selectedComponents);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Ungroup"});
            this.projectFileManager.notifyFileChange();
        }
    }

    @Override
    public void setLayerLocked(int n, boolean bl) {
        LOG.info((Object)String.format("setLayerLocked(%s, %s)", n, bl));
        Project project = this.currentProject.clone();
        if (bl) {
            this.currentProject.getLockedLayers().add(n);
        } else {
            this.currentProject.getLockedLayers().remove(n);
        }
        this.updateSelection(EMPTY_SELECTION);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.messageDispatcher.dispatchMessage((Enum)EventType.LAYER_STATE_CHANGED, new Object[]{this.currentProject.getLockedLayers()});
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), bl ? "Lock Layer" : "Unlock Layer"});
            this.projectFileManager.notifyFileChange();
        }
    }

    @Override
    public void setLayerVisibility(int n, boolean bl) {
        LOG.info((Object)String.format("setLayerVisibility(%s, %s)", n, bl));
        Project project = this.currentProject.clone();
        if (bl) {
            this.currentProject.getHiddenLayers().remove(n);
        } else {
            this.currentProject.getHiddenLayers().add(n);
        }
        this.updateSelection(EMPTY_SELECTION);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.messageDispatcher.dispatchMessage((Enum)EventType.LAYER_VISIBILITY_CHANGED, new Object[]{this.currentProject.getHiddenLayers()});
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), bl ? "Show Layer" : "Hide Layer"});
            this.projectFileManager.notifyFileChange();
        }
    }

    @Override
    public void sendSelectionToBack() {
        LOG.info((Object)"sendSelectionToBack()");
        int n = -1;
        Project project = this.currentProject.clone();
        ArrayList arrayList = new ArrayList(this.selectedComponents);
        Collections.sort(arrayList, new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                return new Integer(Presenter.this.currentProject.getComponents().indexOf(iDIYComponent2)).compareTo(Presenter.this.currentProject.getComponents().indexOf(iDIYComponent));
            }
        });
        block0: for (IDIYComponent iDIYComponent : arrayList) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            int n2 = this.currentProject.getComponents().indexOf(iDIYComponent);
            if (n2 < 0) {
                LOG.warn((Object)("Component not found in the project: " + iDIYComponent.getName()));
                continue;
            }
            while (n2 > 0) {
                IDIYComponent<?> iDIYComponent2 = this.currentProject.getComponents().get(n2 - 1);
                if (!this.selectedComponents.contains(iDIYComponent2)) {
                    ComponentType componentType2 = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent2.getClass());
                    if (!componentType.isFlexibleZOrder() && Math.round(componentType2.getZOrder()) < Math.round(componentType.getZOrder()) && n != 0 && (n = this.view.showConfirmDialog("Selected component(s) have reached the bottom of their layer. Do you want to force the selection to the back?", "Send Selection to Back", 0, 3)) != 0) continue block0;
                }
                Collections.swap(this.currentProject.getComponents(), n2, n2 - 1);
                --n2;
            }
        }
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Send to Back"});
            this.projectFileManager.notifyFileChange();
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        }
    }

    @Override
    public void bringSelectionToFront() {
        LOG.info((Object)"bringSelectionToFront()");
        int n = -1;
        Project project = this.currentProject.clone();
        ArrayList arrayList = new ArrayList(this.selectedComponents);
        Collections.sort(arrayList, new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                return new Integer(Presenter.this.currentProject.getComponents().indexOf(iDIYComponent)).compareTo(Presenter.this.currentProject.getComponents().indexOf(iDIYComponent2));
            }
        });
        block0: for (IDIYComponent iDIYComponent : arrayList) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            int n2 = this.currentProject.getComponents().indexOf(iDIYComponent);
            if (n2 < 0) {
                LOG.warn((Object)("Component not found in the project: " + iDIYComponent.getName()));
                continue;
            }
            while (n2 < this.currentProject.getComponents().size() - 1) {
                IDIYComponent<?> iDIYComponent2 = this.currentProject.getComponents().get(n2 + 1);
                if (!this.selectedComponents.contains(iDIYComponent2)) {
                    ComponentType componentType2 = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent2.getClass());
                    if (!componentType.isFlexibleZOrder() && Math.round(componentType2.getZOrder()) > Math.round(componentType.getZOrder()) && n != 0 && (n = this.view.showConfirmDialog("Selected component(s) have reached the top of their layer. Do you want to force the selection to the top?", "Bring Selection to Front", 0, 3)) != 0) continue block0;
                }
                Collections.swap(this.currentProject.getComponents(), n2, n2 + 1);
                ++n2;
            }
        }
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Bring to Front"});
            this.projectFileManager.notifyFileChange();
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        }
    }

    @Override
    public void refresh() {
        LOG.info((Object)"refresh()");
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public Theme getSelectedTheme() {
        return this.drawingManager.getTheme();
    }

    @Override
    public void setSelectedTheme(Theme theme) {
        this.drawingManager.setTheme(theme);
    }

    @Override
    public void renumberSelectedComponents(final boolean bl) {
        LOG.info((Object)("renumberSelectedComponents(" + bl + ")"));
        if (this.getSelectedComponents().isEmpty()) {
            return;
        }
        Project project = this.currentProject.clone();
        ArrayList arrayList = new ArrayList(this.getSelectedComponents());
        Collections.sort(arrayList, new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                int n;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (n = 0; n < iDIYComponent.getControlPointCount(); ++n) {
                    n2 = (int)((double)n2 + iDIYComponent.getControlPoint(n).getX());
                    n3 = (int)((double)n3 + iDIYComponent.getControlPoint(n).getY());
                }
                for (n = 0; n < iDIYComponent2.getControlPointCount(); ++n) {
                    n4 = (int)((double)n4 + iDIYComponent2.getControlPoint(n).getX());
                    n5 = (int)((double)n5 + iDIYComponent2.getControlPoint(n).getY());
                }
                n2 /= iDIYComponent.getControlPointCount();
                n3 /= iDIYComponent.getControlPointCount();
                n4 /= iDIYComponent2.getControlPointCount();
                n5 /= iDIYComponent2.getControlPointCount();
                if (bl) {
                    if (n3 < n5) {
                        return -1;
                    }
                    if (n3 > n5) {
                        return 1;
                    }
                    if (n2 < n4) {
                        return -1;
                    }
                    if (n2 > n4) {
                        return 1;
                    }
                } else {
                    if (n2 < n4) {
                        return -1;
                    }
                    if (n2 > n4) {
                        return 1;
                    }
                    if (n3 < n5) {
                        return -1;
                    }
                    if (n3 > n5) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        for (IDIYComponent iDIYComponent : arrayList) {
            iDIYComponent.setName("");
        }
        for (IDIYComponent iDIYComponent : arrayList) {
            iDIYComponent.setName(this.instantiationManager.createUniqueName(ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()), this.currentProject.getComponents()));
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Renumber selection"});
        this.projectFileManager.notifyFileChange();
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public void updateSelection(Collection<IDIYComponent<?>> collection) {
        this.selectedComponents = new HashSet(collection);
        HashMap hashMap = new HashMap();
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                hashSet.add(i);
            }
            hashMap.put(iDIYComponent, hashSet);
        }
        if (ConfigurationManager.getInstance().readBoolean("stickyPoints", true)) {
            this.includeStuckComponents(hashMap);
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.SELECTION_CHANGED, new Object[]{this.selectedComponents, hashMap.keySet()});
    }

    @Override
    public void expandSelection(ExpansionMode expansionMode) {
        LOG.info((Object)String.format("expandSelection(%s)", new Object[]{expansionMode}));
        ArrayList arrayList = new ArrayList(this.selectedComponents);
        List<Netlist> list = this.extractNetlists(false);
        List<Set<IDIYComponent<?>>> list2 = NetlistAnalyzer.extractComponentGroups(list);
        HashSet<String> hashSet = new HashSet<String>();
        if (expansionMode == ExpansionMode.SAME_TYPE) {
            for (IDIYComponent<?> iDIYComponent : this.getSelectedComponents()) {
                hashSet.add(ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()).getNamePrefix());
            }
        }
        for (IDIYComponent<?> iDIYComponent : this.getCurrentProject().getComponents()) {
            Set<IDIYComponent<?>> set22;
            if (arrayList.contains(iDIYComponent)) continue;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (Set<IDIYComponent<?>> set22 : list2) {
                if (!set22.contains(iDIYComponent)) continue;
                arrayList2.add(set22);
            }
            if (arrayList2.isEmpty()) continue;
            boolean bl = false;
            set22 = this.selectedComponents.iterator();
            block7: while (set22.hasNext()) {
                IDIYComponent iDIYComponent2 = (IDIYComponent)set22.next();
                for (Set set3 : arrayList2) {
                    if (!set3.contains(iDIYComponent2)) continue;
                    bl = true;
                    break block7;
                }
            }
            if (!bl) continue;
            switch (expansionMode) {
                case ALL: 
                case IMMEDIATE: {
                    arrayList.add(iDIYComponent);
                    break;
                }
                case SAME_TYPE: {
                    if (!hashSet.contains(ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()).getNamePrefix())) break;
                    arrayList.add(iDIYComponent);
                }
            }
        }
        int n = this.getSelectedComponents().size();
        this.updateSelection(arrayList);
        if (arrayList.size() > n && expansionMode != ExpansionMode.IMMEDIATE) {
            this.expandSelection(expansionMode);
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    private void ungroupComponents(Collection<IDIYComponent<?>> collection) {
        Iterator<Set<IDIYComponent<?>>> iterator = this.currentProject.getGroups().iterator();
        while (iterator.hasNext()) {
            Set<IDIYComponent<IDIYComponent<?>>> set = iterator.next();
            set.removeAll(collection);
            if (!set.isEmpty()) continue;
            iterator.remove();
        }
    }

    private Set<IDIYComponent<?>> findAllGroupedComponents(IDIYComponent<?> iDIYComponent) {
        HashSet hashSet = new HashSet();
        hashSet.add(iDIYComponent);
        for (Set<IDIYComponent<?>> set : this.currentProject.getGroups()) {
            if (!set.contains(iDIYComponent)) continue;
            hashSet.addAll(set);
            break;
        }
        return hashSet;
    }

    @Override
    public Point2D[] calculateSelectionDimension() {
        if (this.selectedComponents.isEmpty()) {
            return null;
        }
        Rectangle2D rectangle2D = this.getSelectionBounds(false);
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        Point2D.Double double_ = new Point2D.Double(d /= 200.0, d2 /= 200.0);
        Point2D.Double double_2 = new Point2D.Double(d *= SizeUnit.in.getFactor() / SizeUnit.cm.getFactor(), d2 *= SizeUnit.in.getFactor() / SizeUnit.cm.getFactor());
        return new Point2D[]{double_, double_2};
    }

    private void addComponent(IDIYComponent<?> iDIYComponent, boolean bl) {
        int n;
        for (n = this.currentProject.getComponents().size(); n > 0 && ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()).getZOrder() < ComponentProcessor.getInstance().extractComponentTypeFrom(this.currentProject.getComponents().get(n - 1).getClass()).getZOrder(); --n) {
        }
        if (n < this.currentProject.getComponents().size()) {
            this.currentProject.getComponents().add(n, iDIYComponent);
        } else {
            this.currentProject.getComponents().add(iDIYComponent);
        }
        for (IAutoCreator iAutoCreator : this.getAutoCreators()) {
            List<IDIYComponent<?>> list = iAutoCreator.createIfNeeded(iDIYComponent);
            if (list == null) continue;
            for (IDIYComponent<?> iDIYComponent2 : list) {
                this.addComponent(iDIYComponent2, false);
            }
        }
    }

    @Override
    public List<PropertyWrapper> getMutualSelectionProperties() {
        try {
            return ComponentProcessor.getInstance().getMutualSelectionProperties(this.selectedComponents);
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not get mutual selection properties", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPropertiesToSelection(List<PropertyWrapper> list) {
        block7: {
            LOG.debug((Object)String.format("applyPropertiesToSelection(%s)", list));
            Project project = this.currentProject.clone();
            try {
                for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
                    this.drawingManager.invalidateComponent(iDIYComponent);
                    for (PropertyWrapper propertyWrapper : list) {
                        if (!propertyWrapper.isChanged()) continue;
                        propertyWrapper.writeTo(iDIYComponent);
                    }
                }
                if (project.equals(this.currentProject)) break block7;
            }
            catch (Exception exception) {
                block8: {
                    try {
                        LOG.error((Object)"Could not apply selection properties", (Throwable)exception);
                        this.view.showMessage("Could not apply changes to the selection. Check the log for details.", "Error", 0);
                        if (project.equals(this.currentProject)) break block8;
                    }
                    catch (Throwable throwable) {
                        if (!project.equals(this.currentProject)) {
                            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Selection"});
                            this.drawingManager.clearContinuityArea();
                            this.projectFileManager.notifyFileChange();
                        }
                        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                        throw throwable;
                    }
                    this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Selection"});
                    this.drawingManager.clearContinuityArea();
                    this.projectFileManager.notifyFileChange();
                }
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            }
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Selection"});
            this.drawingManager.clearContinuityArea();
            this.projectFileManager.notifyFileChange();
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public List<PropertyWrapper> getProperties(Object object) {
        List<PropertyWrapper> list = ComponentProcessor.getInstance().extractProperties(object.getClass());
        try {
            for (PropertyWrapper propertyWrapper : list) {
                propertyWrapper.readFrom(object);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not get object properties", (Throwable)exception);
            return null;
        }
        Collections.sort(list, ComparatorFactory.getInstance().getDefaultPropertyComparator());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyProperties(Object object, List<PropertyWrapper> list) {
        block6: {
            LOG.debug((Object)String.format("applyProperties(%s, %s)", object, list));
            Project project = this.currentProject.clone();
            try {
                for (PropertyWrapper propertyWrapper : list) {
                    propertyWrapper.writeTo(object);
                }
                if (project.equals(this.currentProject)) break block6;
            }
            catch (Exception exception) {
                block7: {
                    try {
                        LOG.error((Object)"Could not apply properties", (Throwable)exception);
                        this.view.showMessage("Could not apply changes. Check the log for details.", "Error", 0);
                        if (project.equals(this.currentProject)) break block7;
                    }
                    catch (Throwable throwable) {
                        if (!project.equals(this.currentProject)) {
                            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Project"});
                            this.drawingManager.clearContinuityArea();
                            this.projectFileManager.notifyFileChange();
                        }
                        this.drawingManager.fireZoomChanged();
                        throw throwable;
                    }
                    this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Project"});
                    this.drawingManager.clearContinuityArea();
                    this.projectFileManager.notifyFileChange();
                }
                this.drawingManager.fireZoomChanged();
            }
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Project"});
            this.drawingManager.clearContinuityArea();
            this.projectFileManager.notifyFileChange();
        }
        this.drawingManager.fireZoomChanged();
    }

    @Override
    public ComponentType getNewComponentTypeSlot() {
        return this.instantiationManager.getComponentTypeSlot();
    }

    @Override
    public void setNewComponentTypeSlot(ComponentType componentType, Template template, boolean bl) {
        LOG.info((Object)String.format("setNewComponentSlot(%s)", componentType == null ? null : componentType.getName()));
        if (componentType != null && componentType.getInstanceClass() == null) {
            LOG.info((Object)("Cannot set new component type slot for type " + componentType.getName()));
            this.setNewComponentTypeSlot(null, null, false);
            return;
        }
        if (componentType != null && template == null) {
            String string = this.getDefaultVariant(componentType);
            List<Template> list = this.getVariantsFor(componentType);
            if (list != null && string != null) {
                for (Template template2 : list) {
                    if (!template2.getName().equals(string)) continue;
                    template = template2;
                    break;
                }
            }
        }
        try {
            this.instantiationManager.setComponentTypeSlot(componentType, template, this.currentProject, bl);
            if (bl) {
                this.updateSelection(this.instantiationManager.getComponentSlot());
            } else if (componentType != null) {
                this.updateSelection(EMPTY_SELECTION);
            }
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            this.messageDispatcher.dispatchMessage((Enum)EventType.SLOT_CHANGED, new Object[]{this.instantiationManager.getComponentTypeSlot(), this.instantiationManager.getFirstControlPoint(), bl});
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not set component type slot", (Throwable)exception);
            this.view.showMessage("Could not set component type slot. Check log for details.", "Error", 0);
        }
    }

    @Override
    public void saveSelectedComponentAsVariant(String string) {
        int n;
        String string2;
        ArrayList<Object> arrayList;
        LOG.info((Object)String.format("saveSelectedComponentAsVariant(%s)", string));
        if (this.selectedComponents.size() != 1) {
            throw new RuntimeException("Can only save a single component as a variant at once.");
        }
        IDIYComponent<?> iDIYComponent = this.selectedComponents.iterator().next();
        ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
        HashMap hashMap = (HashMap)ConfigurationManager.getInstance().readObject("templates", null);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if ((arrayList = (ArrayList<Object>)hashMap.get(string2 = componentType.getInstanceClass().getCanonicalName())) == null) {
            arrayList = new ArrayList<Object>();
            hashMap.put(string2, arrayList);
        }
        List<PropertyWrapper> list = ComponentProcessor.getInstance().extractProperties(iDIYComponent.getClass());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (PropertyWrapper propertyWrapper : list) {
            if (propertyWrapper.getName().equalsIgnoreCase("name")) continue;
            try {
                propertyWrapper.readFrom(iDIYComponent);
                hashMap2.put(propertyWrapper.getName(), propertyWrapper.getValue());
            }
            catch (Exception exception) {}
        }
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < iDIYComponent.getControlPointCount(); ++n) {
            Point point = new Point(iDIYComponent.getControlPoint(n));
            arrayList2.add(point);
        }
        n = ((Point)arrayList2.iterator().next()).x;
        int n2 = ((Point)arrayList2.iterator().next()).y;
        Object object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            Point point = (Point)object2.next();
            point.translate(-n, -n2);
        }
        object2 = new Template(string, hashMap2, arrayList2);
        boolean bl = false;
        for (Template object3 : arrayList) {
            if (!object3.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            int n3 = this.view.showConfirmDialog("A variant with that name already exists. Overwrite?", "Save as Variant", 0, 2);
            if (n3 != 0) {
                return;
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Template template = (Template)iterator.next();
                if (!template.getName().equalsIgnoreCase(string)) continue;
                iterator.remove();
            }
        }
        arrayList.add(object2);
        if (System.getProperty("org.diylc.WriteStaticVariants", "false").equalsIgnoreCase("true")) {
            if (defaultVariantMap == null) {
                defaultVariantMap = new HashMap<String, List<Template>>();
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                if (defaultVariantMap.containsKey(entry.getKey())) {
                    defaultVariantMap.get(entry.getKey()).addAll((Collection)entry.getValue());
                    continue;
                }
                defaultVariantMap.put((String)entry.getKey(), (List<Template>)entry.getValue());
            }
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream("variants.xml"));
                XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
                xStream.toXML(defaultVariantMap, (OutputStream)bufferedOutputStream);
                bufferedOutputStream.close();
                ConfigurationManager.getInstance().writeValue("templates", null);
                LOG.info((Object)"Saved default variants");
            }
            catch (IOException iOException) {
                LOG.error((Object)"Could not save default variants", (Throwable)iOException);
            }
        } else {
            ConfigurationManager.getInstance().writeValue("templates", hashMap);
        }
    }

    @Override
    public List<Template> getVariantsFor(ComponentType componentType) {
        List<Template> list;
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Map map = (Map)ConfigurationManager.getInstance().readObject("templates", null);
        if (map != null) {
            treeMap.putAll(map);
        }
        String string = componentType.getInstanceClass().getCanonicalName();
        String string2 = componentType.getCategory() + "." + componentType.getName();
        ArrayList<Template> arrayList = new ArrayList<Template>();
        if (map != null) {
            list = (List<Template>)map.get(string);
            if (list != null && !list.isEmpty()) {
                arrayList.addAll((Collection<Template>)list);
            }
            if ((list = (List<Template>)map.get(string2)) != null && !list.isEmpty()) {
                arrayList.addAll(list);
            }
        }
        if (defaultVariantMap != null) {
            list = defaultVariantMap.get(string);
            if (list != null && !list.isEmpty()) {
                arrayList.addAll(list);
            }
            if ((list = defaultVariantMap.get(string2)) != null && !list.isEmpty()) {
                arrayList.addAll(list);
            }
        }
        Collections.sort(arrayList, new Comparator<Template>(){

            @Override
            public int compare(Template template, Template template2) {
                return template.getName().compareTo(template2.getName());
            }
        });
        return arrayList;
    }

    @Override
    public List<Template> getVariantsForSelection() {
        if (this.selectedComponents.isEmpty()) {
            throw new RuntimeException("No components selected");
        }
        ComponentType componentType = null;
        Iterator<IDIYComponent<?>> iterator = this.selectedComponents.iterator();
        while (iterator.hasNext()) {
            ComponentType componentType2 = ComponentProcessor.getInstance().extractComponentTypeFrom(iterator.next().getClass());
            if (componentType == null) {
                componentType = componentType2;
                continue;
            }
            if (componentType.getInstanceClass() == componentType2.getInstanceClass()) continue;
            return null;
        }
        return this.getVariantsFor(componentType);
    }

    @Override
    public void applyVariantToSelection(Template template) {
        LOG.debug((Object)String.format("applyTemplateToSelection(%s)", template.getName()));
        Project project = this.currentProject.clone();
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            try {
                this.drawingManager.invalidateComponent(iDIYComponent);
                this.instantiationManager.fillWithDefaultProperties(iDIYComponent, template);
            }
            catch (Exception exception) {
                LOG.warn((Object)("Could not apply templates to " + iDIYComponent.getName()), (Throwable)exception);
            }
        }
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Selection"});
            this.drawingManager.clearContinuityArea();
            this.projectFileManager.notifyFileChange();
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public void deleteVariant(ComponentType componentType, String string) {
        LOG.debug((Object)String.format("deleteTemplate(%s, %s)", componentType, string));
        Map map = (Map)ConfigurationManager.getInstance().readObject("templates", null);
        if (map != null) {
            Template template;
            Iterator iterator;
            String string2 = componentType.getInstanceClass().getCanonicalName();
            String string3 = componentType.getCategory() + "." + componentType.getName();
            List list = (List)map.get(string2);
            if (list != null) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    template = (Template)iterator.next();
                    if (!template.getName().equalsIgnoreCase(string)) continue;
                    iterator.remove();
                }
            }
            if ((list = (List)map.get(string3)) != null) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    template = (Template)iterator.next();
                    if (!template.getName().equalsIgnoreCase(string)) continue;
                    iterator.remove();
                }
            }
        }
        ConfigurationManager.getInstance().writeValue("templates", (Object)map);
    }

    @Override
    public void setDefaultVariant(ComponentType componentType, String string) {
        LOG.debug((Object)String.format("setTemplateDefault(%s, %s)", componentType, string));
        HashMap<String, String> hashMap = (HashMap<String, String>)ConfigurationManager.getInstance().readObject("defaultTemplates", null);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        String string2 = componentType.getInstanceClass().getCanonicalName();
        String string3 = componentType.getCategory() + "." + componentType.getName();
        if (string.equals(hashMap.get(string2)) || string.equals(hashMap.get(string3))) {
            hashMap.remove(string2);
            hashMap.remove(string3);
        } else {
            hashMap.remove(string3);
            hashMap.put(string2, string);
        }
        ConfigurationManager.getInstance().writeValue("defaultTemplates", hashMap);
    }

    @Override
    public String getDefaultVariant(ComponentType componentType) {
        Map map = (Map)ConfigurationManager.getInstance().readObject("defaultTemplates", null);
        if (map == null) {
            return null;
        }
        String string = componentType.getInstanceClass().getCanonicalName();
        String string2 = componentType.getCategory() + "." + componentType.getName();
        if (map.containsKey(string)) {
            return (String)map.get(string);
        }
        return (String)map.get(string2);
    }

    private Set<IDIYComponent<?>> getLockedComponents() {
        this.lockedComponents.clear();
        for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
            if (!this.isComponentLocked(iDIYComponent)) continue;
            this.lockedComponents.add(iDIYComponent);
        }
        return this.lockedComponents;
    }

    private boolean isComponentLocked(IDIYComponent<?> iDIYComponent) {
        ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
        return this.currentProject.getLockedLayers().contains((int)Math.round(componentType.getZOrder()));
    }

    private Point scalePoint(Point point) {
        Point point2;
        Point point3 = point2 = point == null ? null : new Point((int)((double)point.x / this.drawingManager.getZoomLevel()), (int)((double)point.y / this.drawingManager.getZoomLevel()));
        if (point2 != null && ConfigurationManager.getInstance().readBoolean("extraSpace", true)) {
            double d = this.drawingManager.getExtraSpace(this.currentProject);
            point2.translate((int)(-d), (int)(-d));
        }
        return point2;
    }

    @Override
    public void saveSelectionAsBlock(String string) {
        LOG.debug((Object)String.format("saveSelectionAsBlock(%s)", string));
        HashMap hashMap = (HashMap)ConfigurationManager.getInstance().readObject("buildingBlocks", null);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        ArrayList arrayList = new ArrayList(this.selectedComponents);
        Collections.sort(arrayList, new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                return new Integer(Presenter.this.currentProject.getComponents().indexOf(iDIYComponent)).compareTo(Presenter.this.currentProject.getComponents().indexOf(iDIYComponent2));
            }
        });
        hashMap.put(string, arrayList);
        ConfigurationManager.getInstance().writeValue("buildingBlocks", hashMap);
    }

    @Override
    public void loadBlock(String string) throws IBlockProcessor.InvalidBlockException {
        ArrayList arrayList;
        LOG.debug((Object)String.format("loadBlock(%s)", string));
        Map map = (Map)ConfigurationManager.getInstance().readObject("buildingBlocks", null);
        if (map != null) {
            Collection collection = (Collection)map.get(string);
            if (collection == null) {
                throw new IBlockProcessor.InvalidBlockException();
            }
            this.instantiationManager.setPotentialControlPoint(null);
            arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList(this.currentProject.getComponents());
            for (IDIYComponent iDIYComponent : collection) {
                try {
                    IDIYComponent iDIYComponent2 = iDIYComponent.clone();
                    iDIYComponent2.setName(this.instantiationManager.createUniqueName(ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent2.getClass()), arrayList2));
                    arrayList2.add(iDIYComponent2);
                    arrayList.add(iDIYComponent2);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    LOG.error((Object)("Could not clone component: " + iDIYComponent));
                }
            }
        } else {
            throw new IBlockProcessor.InvalidBlockException();
        }
        this.pasteComponents(arrayList, true);
    }

    @Override
    public void deleteBlock(String string) {
        LOG.debug((Object)String.format("deleteBlock(%s)", string));
        Map map = (Map)ConfigurationManager.getInstance().readObject("buildingBlocks", null);
        if (map != null) {
            map.remove(string);
            ConfigurationManager.getInstance().writeValue("buildingBlocks", (Object)map);
        }
    }

    @Override
    public double getExtraSpace() {
        if (!ConfigurationManager.getInstance().readBoolean("extraSpace", true)) {
            return 0.0;
        }
        double d = this.drawingManager.getExtraSpace(this.currentProject);
        boolean bl = ConfigurationManager.getInstance().readBoolean("metric", true);
        d /= 200.0;
        if (bl) {
            d *= SizeUnit.in.getFactor() / SizeUnit.cm.getFactor();
        }
        return d;
    }

    @Override
    public int importVariants(String string) throws IOException {
        LOG.debug((Object)String.format("importVariants(%s)", string));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        VariantPackage variantPackage = (VariantPackage)xStream.fromXML((InputStream)bufferedInputStream);
        bufferedInputStream.close();
        if (variantPackage == null || variantPackage.getVariants().isEmpty()) {
            return 0;
        }
        HashMap hashMap = (HashMap)ConfigurationManager.getInstance().readObject("templates", null);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        for (Map.Entry<String, List<Template>> entry : variantPackage.getVariants().entrySet()) {
            ArrayList<Template> arrayList = (ArrayList<Template>)hashMap.get(entry.getKey());
            if (arrayList == null) {
                arrayList = new ArrayList<Template>();
                hashMap.put(entry.getKey(), arrayList);
            }
            for (Template template : entry.getValue()) {
                arrayList.add(new Template(template.getName() + " [" + variantPackage.getOwner() + "]", template.getValues(), template.getPoints()));
            }
        }
        ConfigurationManager.getInstance().writeValue("templates", hashMap);
        LOG.info((Object)String.format("Loaded variants for %d components", variantPackage.getVariants().size()));
        return variantPackage.getVariants().size();
    }

    @Override
    public int importBlocks(String string) throws IOException {
        LOG.debug((Object)String.format("importBlocks(%s)", string));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        BuildingBlockPackage buildingBlockPackage = (BuildingBlockPackage)xStream.fromXML((InputStream)bufferedInputStream);
        bufferedInputStream.close();
        if (buildingBlockPackage == null || buildingBlockPackage.getBlocks().isEmpty()) {
            return 0;
        }
        HashMap hashMap = (HashMap)ConfigurationManager.getInstance().readObject("buildingBlocks", null);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        for (Map.Entry<String, List<IDIYComponent<?>>> entry : buildingBlockPackage.getBlocks().entrySet()) {
            hashMap.put(entry.getKey() + " [" + buildingBlockPackage.getOwner() + "]", entry.getValue());
        }
        ConfigurationManager.getInstance().writeValue("buildingBlocks", hashMap);
        LOG.info((Object)String.format("Loaded building blocks for %d components", buildingBlockPackage.getBlocks().size()));
        return buildingBlockPackage.getBlocks().size();
    }

    private synchronized void upgradeVariants() {
        if (upgradedVariants) {
            return;
        }
        upgradedVariants = true;
        LOG.info((Object)"Checking if variants need to be updated");
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Map map = (Map)ConfigurationManager.getInstance().readObject("templates", null);
        if (map == null) {
            return;
        }
        TreeMap<String, ComponentType> treeMap2 = new TreeMap<String, ComponentType>(String.CASE_INSENSITIVE_ORDER);
        Map<String, List<ComponentType>> map2 = this.getComponentTypes();
        for (Map.Entry<String, List<ComponentType>> object : map2.entrySet()) {
            for (ComponentType componentType : object.getValue()) {
                treeMap2.put(componentType.getInstanceClass().getCanonicalName(), componentType);
                treeMap2.put(componentType.getCategory() + "." + componentType.getName(), componentType);
                if (!componentType.getCategory().contains("Electro-Mechanical")) continue;
                treeMap2.put(componentType.getCategory().replace("Electro-Mechanical", "Electromechanical") + "." + componentType.getName(), componentType);
            }
        }
        HashMap hashMap = new HashMap();
        treeMap.putAll(map);
        for (Map.Entry entry : map.entrySet()) {
            if (treeMap2.containsKey(entry.getKey())) {
                hashMap.put(((ComponentType)treeMap2.get(entry.getKey())).getInstanceClass().getCanonicalName(), entry.getValue());
                continue;
            }
            LOG.warn((Object)("Could not upgrade variants for: " + (String)entry.getKey()));
        }
        ConfigurationManager.getInstance().writeValue("templates", (Object)hashMap);
    }

    @Override
    public List<Netlist> extractNetlists(boolean bl) {
        Object object;
        HashMap<Netlist, Netlist> hashMap = new HashMap<Netlist, Netlist>();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<ISwitch> arrayList2 = new ArrayList<ISwitch>();
        for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            if (!(iDIYComponent instanceof IContinuity)) {
                for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                    object = iDIYComponent.getControlPointNodeName(i);
                    if (object == null || bl && ISwitch.class.isAssignableFrom(componentType.getInstanceClass())) continue;
                    arrayList.add(new Node(iDIYComponent, i));
                }
            }
            if (!bl || !ISwitch.class.isAssignableFrom(componentType.getInstanceClass())) continue;
            arrayList2.add((ISwitch)((Object)iDIYComponent));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList2.isEmpty()) {
            arrayList2.add(new ISwitch(){

                @Override
                public String getPositionName(int n) {
                    return "Default";
                }

                @Override
                public int getPositionCount() {
                    return 1;
                }

                @Override
                public boolean arePointsConnected(int n, int n2, int n3) {
                    return false;
                }
            });
        }
        Object object2 = new int[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            object2[i] = false;
        }
        List<Area> list = this.drawingManager.getContinuityAreas(this.currentProject);
        int n = arrayList2.size() - 1;
        while (n >= 0) {
            HashMap<ISwitch, Integer> hashMap2 = new HashMap<ISwitch, Integer>();
            object = new ArrayList();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                hashMap2.put((ISwitch)arrayList2.get(i), (int)object2[i]);
                object.add(new Position((ISwitch)arrayList2.get(i), (int)object2[i]));
            }
            List<Connection> list2 = this.getConnections(hashMap2);
            Netlist netlist = this.constructNetlist(arrayList, list2, list);
            if (hashMap.containsKey(netlist)) {
                ((Netlist)hashMap.get(netlist)).getSwitchSetup().add(new SwitchSetup((List<Position>)object));
            } else {
                netlist.getSwitchSetup().add(new SwitchSetup((List<Position>)object));
                hashMap.put(netlist, netlist);
            }
            if (object2[n] < ((ISwitch)arrayList2.get(n)).getPositionCount() - 1) {
                Object object3 = object2;
                int n2 = n;
                object3[n2] = object3[n2] + true;
                continue;
            }
            while (n >= 0 && object2[n] == ((ISwitch)arrayList2.get(n)).getPositionCount() - 1) {
                --n;
            }
            if (n < 0) continue;
            Object object4 = object2;
            int n3 = n;
            object4[n3] = object4[n3] + true;
            for (int i = n + 1; i < ((Object)object2).length; ++i) {
                object2[i] = false;
            }
            n = arrayList2.size() - 1;
        }
        ArrayList<Netlist> arrayList3 = new ArrayList<Netlist>(hashMap.keySet());
        Collections.sort(arrayList3);
        return arrayList3;
    }

    private Netlist constructNetlist(List<Node> list, List<Connection> list2, List<Area> list3) {
        Comparable<Node> comparable;
        Object object;
        int n;
        Netlist netlist = new Netlist();
        double d = DrawingManager.CONTROL_POINT_SIZE;
        for (n = 0; n < list.size() - 1; ++n) {
            for (int i = n + 1; i < list.size(); ++i) {
                object = list.get(n);
                comparable = list.get(i);
                Point point = ((Node)object).getComponent().getControlPoint(((Node)object).getPointIndex());
                Point object2 = ((Node)comparable).getComponent().getControlPoint(((Node)comparable).getPointIndex());
                String string = ((Node)object).getComponent().getCommonPointName(((Node)object).getPointIndex());
                String string2 = ((Node)comparable).getComponent().getCommonPointName(((Node)comparable).getPointIndex());
                if (!(point.distance(object2) < d) && !this.checkGraphConnection(point, object2, list2, list3, new boolean[list2.size()]) && !this.checkGraphConnection(object2, point, list2, list3, new boolean[list2.size()]) && (string == null || !string.equalsIgnoreCase(string2))) continue;
                boolean bl = false;
                for (Group group : netlist.getGroups()) {
                    if (group.getNodes().contains(object)) {
                        group.getNodes().add((Node)comparable);
                        bl = true;
                        continue;
                    }
                    if (!group.getNodes().contains(comparable)) continue;
                    group.getNodes().add((Node)object);
                    bl = true;
                }
                if (bl) continue;
                netlist.getGroups().add(new Group((Node)object, (Node)comparable));
            }
        }
        n = 1;
        while (n != 0) {
            n = 0;
            List<Group> list4 = netlist.getSortedGroups();
            object = list4.iterator();
            block4: while (object.hasNext()) {
                comparable = (Group)object.next();
                for (Group group : list4) {
                    if (comparable == group || Collections.disjoint(((Group)comparable).getNodes(), group.getNodes())) continue;
                    object.remove();
                    group.getNodes().addAll(((Group)comparable).getNodes());
                    n = 1;
                    continue block4;
                }
            }
            if (n == 0) continue;
            netlist.getGroups().clear();
            netlist.getGroups().addAll(list4);
        }
        Collections.sort(netlist.getSwitchSetup());
        return netlist;
    }

    private boolean checkGraphConnection(Point2D point2D, Point2D point2D2, List<Connection> list, List<Area> list2, boolean[] blArray) {
        double d = DrawingManager.CONTROL_POINT_SIZE;
        if (point2D.distance(point2D2) < d) {
            return true;
        }
        for (Area object : list2) {
            if (!object.contains(point2D) || !object.contains(point2D2)) continue;
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (blArray[i]) continue;
            Connection connection = list.get(i);
            if (point2D.distance(connection.getP1()) < d) {
                blArray[i] = true;
                if (this.checkGraphConnection(connection.getP2(), point2D2, list, list2, blArray)) {
                    return true;
                }
            }
            if (!(point2D.distance(connection.getP2()) < d)) continue;
            blArray[i] = true;
            if (!this.checkGraphConnection(connection.getP1(), point2D2, list, list2, blArray)) continue;
            return true;
        }
        return false;
    }

    private List<Connection> getConnections(Map<ISwitch, Integer> map) {
        HashSet<Connection> hashSet = new HashSet<Connection>();
        for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
            int n;
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            if (iDIYComponent instanceof IContinuity) {
                for (n = 0; n < iDIYComponent.getControlPointCount() - 1; ++n) {
                    for (int i = n + 1; i < iDIYComponent.getControlPointCount(); ++i) {
                        if (!((IContinuity)((Object)iDIYComponent)).arePointsConnected(n, i)) continue;
                        hashSet.add(new Connection(iDIYComponent.getControlPoint(n), iDIYComponent.getControlPoint(i)));
                    }
                }
            }
            if (!ISwitch.class.isAssignableFrom(componentType.getInstanceClass()) || !map.containsKey(iDIYComponent)) continue;
            n = map.get(iDIYComponent);
            ISwitch iSwitch = (ISwitch)((Object)iDIYComponent);
            for (int i = 0; i < iDIYComponent.getControlPointCount() - 1; ++i) {
                for (int j = i + 1; j < iDIYComponent.getControlPointCount(); ++j) {
                    if (!iSwitch.arePointsConnected(i, j, n)) continue;
                    hashSet.add(new Connection(iDIYComponent.getControlPoint(i), iDIYComponent.getControlPoint(j)));
                }
            }
        }
        this.drawingManager.expandConnections(hashSet);
        return new ArrayList<Connection>(hashSet);
    }

    @Override
    public List<INetlistAnalyzer> getNetlistAnalyzers() {
        try {
            Set set = Utils.getClasses((String)"org.diylc.netlist");
            ArrayList<INetlistAnalyzer> arrayList = new ArrayList<INetlistAnalyzer>();
            for (Class clazz : set) {
                if (Modifier.isAbstract(clazz.getModifiers()) || !INetlistAnalyzer.class.isAssignableFrom(clazz)) continue;
                arrayList.add((INetlistAnalyzer)clazz.newInstance());
            }
            Collections.sort(arrayList, new Comparator<INetlistAnalyzer>(){

                @Override
                public int compare(INetlistAnalyzer iNetlistAnalyzer, INetlistAnalyzer iNetlistAnalyzer2) {
                    return iNetlistAnalyzer.getName().compareToIgnoreCase(iNetlistAnalyzer2.getName());
                }
            });
            return arrayList;
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not load INetlistSummarizer implementations", (Throwable)exception);
            return null;
        }
    }

    static {
        Object object;
        XStream xStream;
        BufferedInputStream bufferedInputStream;
        LOG = Logger.getLogger(Presenter.class);
        CURRENT_VERSION = new VersionNumber(3, 0, 0);
        RECENT_VERSIONS = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream("update.xml"));
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            object = (List)xStream.fromXML((InputStream)bufferedInputStream);
            CURRENT_VERSION = ((Version)object.get(object.size() - 1)).getVersionNumber();
            LOG.info((Object)("Current DIYLC version: " + CURRENT_VERSION));
            RECENT_VERSIONS = object.subList(object.size() - 10, object.size());
            Collections.sort(RECENT_VERSIONS, new Comparator<Version>(){

                @Override
                public int compare(Version version, Version version2) {
                    return -version.getVersionNumber().compareTo(version2.getVersionNumber());
                }
            });
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            LOG.error((Object)"Could not find version number, using default", (Throwable)iOException);
        }
        defaultVariantMap = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream("variants.xml"));
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            object = (Map)xStream.fromXML((InputStream)bufferedInputStream);
            defaultVariantMap = new TreeMap<String, List<Template>>(String.CASE_INSENSITIVE_ORDER);
            defaultVariantMap.putAll((Map<String, List<Template>>)object);
            bufferedInputStream.close();
            LOG.info((Object)String.format("Loaded default variants for %d components", defaultVariantMap == null ? 0 : defaultVariantMap.size()));
        }
        catch (IOException iOException) {
            LOG.error((Object)"Could not load default variants", (Throwable)iOException);
        }
        EMPTY_SELECTION = Collections.emptyList();
        upgradedVariants = false;
    }
}

