/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.annotations.DynamicList;
import org.diylc.core.annotations.MultiLineText;
import org.diylc.core.measures.AbstractMeasure;
import org.diylc.swing.gui.editor.BooleanEditor;
import org.diylc.swing.gui.editor.ByteEditor;
import org.diylc.swing.gui.editor.ColorEditor;
import org.diylc.swing.gui.editor.EnumEditor;
import org.diylc.swing.gui.editor.FontEditor;
import org.diylc.swing.gui.editor.ImageEditor;
import org.diylc.swing.gui.editor.IntEditor;
import org.diylc.swing.gui.editor.MeasureArrayEditor;
import org.diylc.swing.gui.editor.MeasureEditor;
import org.diylc.swing.gui.editor.MultiLineStringEditor;
import org.diylc.swing.gui.editor.StringEditor;
import org.diylc.swing.gui.editor.StringListEditor;

public class FieldEditorFactory {
    private static final Logger LOG = Logger.getLogger(FieldEditorFactory.class);

    public static Component createFieldEditor(PropertyWrapper propertyWrapper) {
        Object object;
        try {
            if (propertyWrapper.getType().equals(String.class) && propertyWrapper.getGetter().isAnnotationPresent(DynamicList.class)) {
                StringListEditor stringListEditor = new StringListEditor(propertyWrapper);
                return stringListEditor;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not determine if a function is annotated with DynamicList", (Throwable)exception);
        }
        try {
            if (propertyWrapper.getType().equals(String.class) && propertyWrapper.getGetter().isAnnotationPresent(MultiLineText.class)) {
                MultiLineStringEditor multiLineStringEditor = new MultiLineStringEditor(propertyWrapper);
                return multiLineStringEditor;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not determine if a function is annotated with MultiLineText", (Throwable)exception);
        }
        if (propertyWrapper.getType().equals(String.class)) {
            object = new StringEditor(propertyWrapper);
            return object;
        }
        if (propertyWrapper.getType().equals(Color.class)) {
            object = new ColorEditor(propertyWrapper);
            return object;
        }
        if (AbstractMeasure.class.isAssignableFrom(propertyWrapper.getType())) {
            object = new MeasureEditor(propertyWrapper);
            return object;
        }
        if (AbstractMeasure[].class.isAssignableFrom(propertyWrapper.getType())) {
            object = new MeasureArrayEditor(propertyWrapper);
            return object;
        }
        if (byte[].class.isAssignableFrom(propertyWrapper.getType())) {
            object = new ImageEditor(propertyWrapper);
            return object;
        }
        if (propertyWrapper.getType().isEnum()) {
            object = new EnumEditor(propertyWrapper);
            return object;
        }
        if (Byte.class.isAssignableFrom(propertyWrapper.getType()) || Byte.TYPE.isAssignableFrom(propertyWrapper.getType())) {
            object = new ByteEditor(propertyWrapper);
            return object;
        }
        if (Boolean.class.isAssignableFrom(propertyWrapper.getType()) || Boolean.TYPE.isAssignableFrom(propertyWrapper.getType())) {
            object = new BooleanEditor(propertyWrapper);
            return object;
        }
        if (Font.class.isAssignableFrom(propertyWrapper.getType())) {
            object = new FontEditor(propertyWrapper);
            return object;
        }
        if (Integer.class.isAssignableFrom(propertyWrapper.getType()) || Integer.TYPE.isAssignableFrom(propertyWrapper.getType())) {
            object = new IntEditor(propertyWrapper);
            return object;
        }
        LOG.error((Object)("Unrecognized parameter type: " + propertyWrapper.getType().getName()));
        return new JLabel("Unrecognized");
    }
}

