/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.miscutils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.IConfigListener;
import org.diylc.appframework.miscutils.IconImageConverter;
import org.diylc.appframework.miscutils.Utils;

public class ConfigurationManager {
    private static final Logger LOG = Logger.getLogger(ConfigurationManager.class);
    private static ConfigurationManager instance;
    private static String path;
    private static final String fileName = "config.xml";
    private XStream xStream;
    private Map<String, Object> configuration;
    private Map<String, List<IConfigListener>> listeners = new HashMap<String, List<IConfigListener>>();
    private boolean fileWithErrors = false;

    public static void initialize(String appName) {
        path = Utils.getUserDataDirectory(appName);
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    public ConfigurationManager() {
        this.xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.xStream.registerConverter((Converter)new IconImageConverter());
        this.initializeConfiguration();
    }

    public void addConfigListener(String key, IConfigListener listener) {
        List<Object> listenerList;
        if (this.listeners.containsKey(key)) {
            listenerList = this.listeners.get(key);
        } else {
            listenerList = new ArrayList();
            this.listeners.put(key, listenerList);
        }
        listenerList.add(listener);
    }

    public boolean isFileWithErrors() {
        return this.fileWithErrors;
    }

    private void initializeConfiguration() {
        LOG.info((Object)"Initializing configuration");
        File configFile = new File(path + fileName);
        if (!configFile.exists()) {
            configFile = new File(fileName);
            this.configuration = new HashMap<String, Object>();
        } else {
            try {
                FileInputStream in = new FileInputStream(configFile);
                InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF-8");
                this.configuration = (Map)this.xStream.fromXML((Reader)reader);
                in.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Could not initialize configuration", (Throwable)e);
                this.fileWithErrors = true;
                this.configuration = new HashMap<String, Object>();
                try {
                    File backupFile = new File(path + fileName + "~");
                    while (backupFile.exists()) {
                        backupFile = new File(backupFile.getAbsolutePath() + "~");
                    }
                    ConfigurationManager.copyFileUsingStream(configFile, backupFile);
                }
                catch (Exception e1) {
                    LOG.error((Object)"Could not create configuration backup", (Throwable)e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingStream(File source, File dest) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    private void saveConfigration() {
        LOG.info((Object)"Saving configuration");
        File configFile = new File(path + fileName);
        new File(path).mkdirs();
        try {
            FileOutputStream out = new FileOutputStream(configFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            this.xStream.toXML(this.configuration, (Writer)writer);
            out.close();
        }
        catch (Exception e) {
            LOG.error((Object)("Could not save configuration: " + e.getMessage()));
        }
    }

    public boolean readBoolean(String key, boolean defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (Boolean)this.configuration.get(key);
        }
        return defaultValue;
    }

    public String readString(String key, String defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (String)this.configuration.get(key);
        }
        return defaultValue;
    }

    public int readInt(String key, int defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (Integer)this.configuration.get(key);
        }
        return defaultValue;
    }

    public float readFloat(String key, float defaultValue) {
        if (this.configuration.containsKey(key)) {
            return ((Float)this.configuration.get(key)).floatValue();
        }
        return defaultValue;
    }

    public double readDouble(String key, double defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (Double)this.configuration.get(key);
        }
        return defaultValue;
    }

    public Object readObject(String key, Object defaultValue) {
        if (this.configuration.containsKey(key)) {
            return this.configuration.get(key);
        }
        return defaultValue;
    }

    public void writeValue(String key, Object value) {
        this.configuration.put(key, value);
        this.saveConfigration();
        if (this.listeners.containsKey(key)) {
            for (IConfigListener listener : this.listeners.get(key)) {
                listener.valueChanged(key, value);
            }
        }
    }

    static {
        path = Utils.getUserDataDirectory("generic");
    }
}

