/*
 * Decompiled with CFR 0.152.
 */
package com.diyfever.httpproxy;

import com.diyfever.httpproxy.ClientHttpRequest;
import com.diyfever.httpproxy.IFlatProxy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class PhpFlatProxy
implements IFlatProxy {
    private static final Logger LOG = Logger.getLogger(PhpFlatProxy.class);

    @Override
    public InputStream invoke(String string, String string2, Map<String, Object> map) {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                arrayList.add(entry.getKey());
                arrayList.add(entry.getValue());
            }
            URL uRL = new URL(this.createPhpFileName(string, string2));
            LOG.debug((Object)("Connecting to: " + uRL));
            InputStream inputStream = ClientHttpRequest.post(uRL, arrayList.toArray());
            return inputStream;
        }
        catch (MalformedURLException malformedURLException) {
            LOG.error((Object)malformedURLException);
        }
        catch (IOException iOException) {
            LOG.error((Object)iOException);
        }
        return null;
    }

    @Override
    public Object invokeAndDeserialize(String string, String string2, Map<String, Object> map) {
        InputStream inputStream = this.invoke(string, string2, map);
        if (inputStream == null) {
            return null;
        }
        XStream xStream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xStream.setMode(1001);
        return xStream.fromXML(inputStream);
    }

    private String createPhpFileName(String string, String string2) {
        if (string.endsWith("/")) {
            return string + string2 + ".php";
        }
        return string + "/" + string2 + ".php";
    }
}

