/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.ArrowInfo;
import dialogs.DashInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import graphic.RectangleG;
import graphic.ShapeInterface;
import java.io.IOException;
import java.util.Vector;
import primitives.Arrow;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveBezier
extends GraphicPrimitive {
    static final int N_POINTS = 6;
    private boolean arrowStart;
    private boolean arrowEnd;
    private int arrowLength;
    private int arrowHalfWidth;
    private int arrowStyle;
    private int dashStyle;
    private ShapeInterface shape1;
    private float w;
    private int xmin;
    private int ymin;
    private int width;
    private int height;

    @Override
    public int getControlPointNumber() {
        return 6;
    }

    public PrimitiveBezier(String f, int size) {
        this.initPrimitive(-1, f, size);
    }

    public PrimitiveBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int layer, boolean arrowS, boolean arrowE, int arrowSt, int arrowLe, int arrowWi, int dashSt, String font, int size) {
        this.arrowLength = arrowLe;
        this.arrowHalfWidth = arrowWi;
        this.arrowStart = arrowS;
        this.arrowEnd = arrowE;
        this.arrowStyle = arrowSt;
        this.dashStyle = dashSt;
        this.initPrimitive(-1, font, size);
        this.virtualPoint[0].x = x1;
        this.virtualPoint[0].y = y1;
        this.virtualPoint[1].x = x2;
        this.virtualPoint[1].y = y2;
        this.virtualPoint[2].x = x3;
        this.virtualPoint[2].y = y3;
        this.virtualPoint[3].x = x4;
        this.virtualPoint[3].y = y4;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
        this.setLayer(layer);
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd = new ParameterDescription();
        pd.parameter = this.arrowStart;
        pd.description = Globals.messages.getString("ctrl_arrow_start");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowEnd;
        pd.description = Globals.messages.getString("ctrl_arrow_end");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowLength;
        pd.description = Globals.messages.getString("ctrl_arrow_length");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowHalfWidth;
        pd.description = Globals.messages.getString("ctrl_arrow_half_width");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new ArrowInfo(this.arrowStyle);
        pd.description = Globals.messages.getString("ctrl_arrow_style");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new DashInfo(this.dashStyle);
        pd.description = Globals.messages.getString("ctrl_dash_style");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = super.setControls(v);
        ParameterDescription pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowStart = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 1!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowEnd = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 2!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowLength = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 3!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowHalfWidth = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 4!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof ArrowInfo) {
            this.arrowStyle = ((ArrowInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter 5!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter 6!" + pd);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return i;
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.shape1 = g.createShape();
            this.shape1.createCubicCurve(coordSys.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), coordSys.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), coordSys.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), coordSys.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), coordSys.mapX(this.virtualPoint[2].x, this.virtualPoint[2].y), coordSys.mapY(this.virtualPoint[2].x, this.virtualPoint[2].y), coordSys.mapX(this.virtualPoint[3].x, this.virtualPoint[3].y), coordSys.mapY(this.virtualPoint[3].x, this.virtualPoint[3].y));
            RectangleG r = this.shape1.getBounds();
            this.xmin = r.x;
            this.ymin = r.y;
            this.width = r.width;
            this.height = r.height;
            this.w = (float)(Globals.lineWidth * coordSys.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (!g.hitClip(this.xmin, this.ymin, this.width, this.height)) {
            return;
        }
        g.applyStroke(this.w, this.dashStyle);
        g.draw(this.shape1);
        if (this.arrowStart || this.arrowEnd) {
            int pey;
            int pex;
            int psy;
            int psx;
            int h = coordSys.mapXi(this.arrowHalfWidth, this.arrowHalfWidth, false) - coordSys.mapXi(0.0, 0.0, false);
            int l = coordSys.mapXi(this.arrowLength, this.arrowLength, false) - coordSys.mapXi(0.0, 0.0, false);
            if (this.arrowStart) {
                psx = this.virtualPoint[0].x;
                psy = this.virtualPoint[0].y;
                if (this.virtualPoint[0].x != this.virtualPoint[1].x || this.virtualPoint[0].y != this.virtualPoint[1].y) {
                    pex = this.virtualPoint[1].x;
                    pey = this.virtualPoint[1].y;
                } else if (this.virtualPoint[0].x != this.virtualPoint[2].x || this.virtualPoint[2].y != this.virtualPoint[1].y) {
                    pex = this.virtualPoint[2].x;
                    pey = this.virtualPoint[2].y;
                } else {
                    pex = this.virtualPoint[3].x;
                    pey = this.virtualPoint[3].y;
                }
                Arrow.drawArrow(g, coordSys.mapX(psx, psy), coordSys.mapY(psx, psy), coordSys.mapX(pex, pey), coordSys.mapY(pex, pey), l, h, this.arrowStyle);
            }
            if (this.arrowEnd) {
                psx = this.virtualPoint[3].x;
                psy = this.virtualPoint[3].y;
                if (this.virtualPoint[3].x != this.virtualPoint[2].x || this.virtualPoint[3].y != this.virtualPoint[2].y) {
                    pex = this.virtualPoint[2].x;
                    pey = this.virtualPoint[2].y;
                } else if (this.virtualPoint[3].x != this.virtualPoint[1].x || this.virtualPoint[3].y != this.virtualPoint[1].y) {
                    pex = this.virtualPoint[1].x;
                    pey = this.virtualPoint[1].y;
                } else {
                    pex = this.virtualPoint[0].x;
                    pey = this.virtualPoint[0].y;
                }
                Arrow.drawArrow(g, coordSys.mapX(psx, psy), coordSys.mapY(psx, psy), coordSys.mapX(pex, pey), coordSys.mapY(pex, pey), l, h, this.arrowStyle);
            }
        }
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("BE")) {
            if (N < 9) {
                IOException E = new IOException("bad arguments on BE");
                throw E;
            }
            int x1 = this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            int y1 = this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[1].x = Integer.parseInt(tokens[3]);
            this.virtualPoint[1].y = Integer.parseInt(tokens[4]);
            this.virtualPoint[2].x = Integer.parseInt(tokens[5]);
            this.virtualPoint[2].y = Integer.parseInt(tokens[6]);
            this.virtualPoint[3].x = Integer.parseInt(tokens[7]);
            this.virtualPoint[3].y = Integer.parseInt(tokens[8]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > 9) {
                this.parseLayer(tokens[9]);
            }
            if (N > 10 && tokens[10].equals("FCJ")) {
                int arrows = Integer.parseInt(tokens[11]);
                this.arrowStart = (arrows & 1) != 0;
                this.arrowEnd = (arrows & 2) != 0;
                this.arrowStyle = Integer.parseInt(tokens[12]);
                this.arrowLength = Integer.parseInt(tokens[13]);
                this.arrowHalfWidth = Integer.parseInt(tokens[14]);
                this.dashStyle = Integer.parseInt(tokens[15]);
                if (this.dashStyle >= 5) {
                    this.dashStyle = 4;
                }
                if (this.dashStyle < 0) {
                    this.dashStyle = 0;
                }
            }
        } else {
            IOException E = new IOException("Invalid primitive:  programming error?");
            throw E;
        }
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        return GeometricDistances.pointToBezier(this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, this.virtualPoint[2].x, this.virtualPoint[2].y, this.virtualPoint[3].x, this.virtualPoint[3].y, px, py);
    }

    @Override
    public String toString(boolean extensions) {
        int arrows;
        String s = "BE " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.virtualPoint[2].x + " " + this.virtualPoint[2].y + " " + this.virtualPoint[3].x + " " + this.virtualPoint[3].y + " " + this.getLayer() + "\n";
        if (extensions && ((arrows = (this.arrowStart ? 1 : 0) | (this.arrowEnd ? 2 : 0)) > 0 || this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String text = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                text = "1";
            }
            s = s + "FCJ " + arrows + " " + this.arrowStyle + " " + this.arrowLength + " " + this.arrowHalfWidth + " " + this.dashStyle + " " + text + "\n";
        }
        s = s + this.saveText(false);
        return s;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        exp.exportBezier(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), cs.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), cs.mapX(this.virtualPoint[2].x, this.virtualPoint[2].y), cs.mapY(this.virtualPoint[2].x, this.virtualPoint[2].y), cs.mapX(this.virtualPoint[3].x, this.virtualPoint[3].y), cs.mapY(this.virtualPoint[3].x, this.virtualPoint[3].y), this.getLayer(), this.arrowStart, this.arrowEnd, this.arrowStyle, (int)((double)this.arrowLength * cs.getXMagnitude()), (int)((double)this.arrowHalfWidth * cs.getXMagnitude()), this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 4;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 5;
    }
}

