/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitivePCBLine
extends GraphicPrimitive {
    private float width;
    static final int N_POINTS = 4;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int wi_pix;
    private int xbpap1;
    private int ybpap1;

    @Override
    public int getControlPointNumber() {
        return 4;
    }

    public PrimitivePCBLine(String f, int size) {
        this.width = 0.0f;
        this.initPrimitive(-1, f, size);
    }

    public PrimitivePCBLine(int x1, int y1, int x2, int y2, float w, int layer, String f, int size) {
        this.initPrimitive(-1, f, size);
        this.virtualPoint[0].x = x1;
        this.virtualPoint[0].y = y1;
        this.virtualPoint[1].x = x2;
        this.virtualPoint[1].y = y2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
        this.width = w;
        this.setLayer(layer);
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = coordSys.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.y1 = coordSys.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.x2 = coordSys.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.y2 = coordSys.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.wi_pix = Math.abs(coordSys.mapXi(this.virtualPoint[0].x, this.virtualPoint[0].y, false) - coordSys.mapXi((int)((float)this.virtualPoint[0].x + this.width), (int)((float)this.virtualPoint[0].y + this.width), false));
            this.xa = Math.min(this.x1, this.x2) - this.wi_pix / 2;
            this.ya = Math.min(this.y1, this.y2) - this.wi_pix / 2;
            this.xb = Math.max(this.x1, this.x2) + this.wi_pix / 2;
            this.yb = Math.max(this.y1, this.y2) + this.wi_pix / 2;
            coordSys.trackPoint(this.xa, this.ya);
            coordSys.trackPoint(this.xb, this.yb);
            this.xbpap1 = this.xb - this.xa + 1;
            this.ybpap1 = this.yb - this.ya + 1;
        }
        if (!g.hitClip(this.xa, this.ya, this.xbpap1, this.ybpap1)) {
            return;
        }
        g.applyStroke(this.wi_pix, 0);
        g.drawLine(this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("PL")) {
            if (N < 6) {
                IOException E = new IOException("bad arguments on PL");
                throw E;
            }
            int x1 = this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            int y1 = this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[1].x = Integer.parseInt(tokens[3]);
            this.virtualPoint[1].y = Integer.parseInt(tokens[4]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            this.width = Float.parseFloat(tokens[5]);
            if (N > 6) {
                this.parseLayer(tokens[6]);
            }
        } else {
            IOException E = new IOException("PL: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = Float.valueOf(this.width);
        pd.description = Globals.messages.getString("ctrl_width");
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = super.setControls(v);
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Float) {
            this.width = ((Float)pd.parameter).floatValue();
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        return i;
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int distance = (int)((float)GeometricDistances.pointToSegment(this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, px, py) - this.width / 2.0f);
        return distance < 0 ? 0 : distance;
    }

    @Override
    public String toString(boolean extensions) {
        String s = "PL " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + (int)this.width + " " + this.getLayer() + "\n";
        s = s + this.saveText(extensions);
        return s;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        exp.exportPCBLine(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), cs.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), (int)((double)this.width * cs.getXMagnitude()), this.getLayer());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 2;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 3;
    }
}

