/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JMCADRTSDocument
extends JPanel {
    public String doc_name = "";
    public String doc_autor = "";
    public String doc_info = "";
    private String file_name = null;
    private boolean isCalc = false;
    public long time_from = 0L;
    public long time_to = 0L;
    public long time_sleep = 10L;
    public long time_current = 0L;
    public long time_debug = 500L;
    public int window_x = 0;
    public int window_y = 0;
    public int window_w = 500;
    public int window_h = 400;
    private Thread tsolve;

    public JMCADRTSDocument() {
        try {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        JMCADRTSDocument.this.setConfig();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void Document_Calc_Stop() {
        this.isCalc = false;
    }

    public void Document_Calc() {
        if (this.isCalc) {
            System.out.println("*** Interrupted Calc *** " + (this.file_name == null ? "" : this.file_name));
            this.isCalc = false;
        } else {
            this.isCalc = true;
            this.tsolve = new Thread(){
                Component[] comp;
                Component[] comp_gen;
                int comp_count;
                {
                    this.comp = JMCADRTSDocument.this.getComponents();
                    this.comp_count = 0;
                }

                @Override
                public void run() {
                    int n;
                    for (n = 0; n < this.comp.length; ++n) {
                        if (!((JMCADObject)this.comp[n]).isGeneranor) continue;
                        ++this.comp_count;
                    }
                    this.comp_gen = new Component[this.comp_count];
                    this.comp_count = 0;
                    for (n = 0; n < this.comp.length; ++n) {
                        if (!((JMCADObject)this.comp[n]).isGeneranor) continue;
                        this.comp_gen[this.comp_count] = this.comp[n];
                        ++this.comp_count;
                    }
                    JMCADRTSDocument.this.time_from = System.currentTimeMillis();
                    for (n = 0; n < this.comp.length; ++n) {
                        ((JMCADObject)this.comp[n]).calc_pre();
                    }
                    while (JMCADRTSDocument.this.isCalc) {
                        if (JMCADRTSDocument.this.time_sleep > 0L) {
                            try {
                                Thread.sleep(JMCADRTSDocument.this.time_sleep);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        JMCADRTSDocument.this.time_current = System.currentTimeMillis();
                        for (n = 0; n < this.comp_gen.length && JMCADRTSDocument.this.isCalc; ++n) {
                            ((JMCADObject)this.comp_gen[n]).start(JMCADRTSDocument.this.time_from, JMCADRTSDocument.this.time_current, JMCADRTSDocument.this.time_sleep);
                        }
                    }
                    for (n = 0; n < this.comp.length; ++n) {
                        ((JMCADObject)this.comp[n]).calc_post();
                    }
                    JMCADRTSDocument.this.time_to = System.currentTimeMillis();
                    System.out.println("Stop Time:\t" + JMCADRTSDocument.this.time_to + " ms (" + (JMCADRTSDocument.this.file_name == null ? "" : JMCADRTSDocument.this.file_name) + ")");
                    System.out.println("Calc Time:\t" + (JMCADRTSDocument.this.time_to - JMCADRTSDocument.this.time_from) + " ms (" + (JMCADRTSDocument.this.file_name == null ? "" : JMCADRTSDocument.this.file_name) + ")");
                    System.out.println("*** End Calc *** " + (JMCADRTSDocument.this.file_name == null ? "" : JMCADRTSDocument.this.file_name));
                    JMCADRTSDocument.this.isCalc = false;
                }
            };
            this.tsolve.setPriority(1);
            this.tsolve.start();
            System.out.println("*** Start Calc *** " + (this.file_name == null ? "" : this.file_name));
            System.out.println("Start Time:\t" + this.time_from + " ms (" + (this.file_name == null ? "" : this.file_name) + ")");
        }
    }

    public boolean Document_isCalc() {
        return this.isCalc;
    }

    public JMCADRTS getJMCADRTS() {
        Container container;
        for (container = this; container != null && !(container instanceof JMCADRTS); container = container.getParent()) {
        }
        return (JMCADRTS)container;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.black);
        ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
        Component[] componentArray = this.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Object[] objectArray = ((JMCADObject)componentArray[i]).out_obj;
            int[] nArray = ((JMCADObject)componentArray[i]).out_obj_index;
            for (int j = 0; j < objectArray.length; ++j) {
                try {
                    if (objectArray[j] == null) continue;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    n4 = componentArray[i].getLocation().x;
                    n4 += ((JMCADObject)componentArray[i]).panel_out.getLocation().x;
                    n4 += ((JMCADObject)componentArray[i]).panel_out.getComponent((int)j).getLocation().x + ((JMCADObject)componentArray[i]).panel_out.getComponent(j).getWidth() / 2;
                    n5 = componentArray[i].getLocation().y;
                    n5 += ((JMCADObject)componentArray[i]).panel_out.getLocation().y;
                    n2 = ((JMCADObject)objectArray[j]).getLocation().x;
                    n2 += ((JMCADObject)objectArray[j]).panel_in.getLocation().x;
                    n3 = ((JMCADObject)objectArray[j]).getLocation().y;
                    n3 += ((JMCADObject)objectArray[j]).panel_in.getLocation().y;
                    if (Math.abs(n4 - (n2 += ((JMCADObject)objectArray[j]).panel_in.getComponent((int)nArray[j]).getLocation().x + ((JMCADObject)objectArray[j]).panel_in.getComponent(nArray[j]).getWidth() / 2)) > 40 || Math.abs((n5 += ((JMCADObject)componentArray[i]).panel_out.getComponent((int)j).getLocation().y + ((JMCADObject)componentArray[i]).panel_out.getComponent(j).getHeight() / 2) - (n3 += ((JMCADObject)objectArray[j]).panel_in.getComponent((int)nArray[j]).getLocation().y + ((JMCADObject)objectArray[j]).panel_in.getComponent(nArray[j]).getHeight() / 2)) > 40) {
                        graphics.drawLine(n4, n5, n4 + 12, n5);
                        if (n4 > n2) {
                            n = n5 < n3 ? (n5 + ((JMCADObject)componentArray[i]).getHeight() / 2 + n3 - ((JMCADObject)objectArray[j]).getHeight() / 2) / 2 : (n5 - ((JMCADObject)componentArray[i]).getHeight() / 2 + n3 + ((JMCADObject)objectArray[j]).getHeight() / 2) / 2;
                            graphics.drawLine(n4 + 12, n5, n4 + 12, n);
                            graphics.drawLine(n4 + 12, n, n2 - 12, n);
                            graphics.drawLine(n2 - 12, n3, n2 - 12, n);
                        } else {
                            graphics.drawLine(n4 + 12, n5, n2 - 12, n3);
                        }
                        graphics.drawLine(n2 - 12, n3, n2, n3);
                        continue;
                    }
                    graphics.drawLine(n2, n3, n4, n5);
                    continue;
                }
                catch (Exception exception) {
                    objectArray[j] = null;
                }
            }
        }
    }

    public void error(Object object) {
        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("JMCAD_Internationalize").getString("Error") + ": " + object, ResourceBundle.getBundle("JMCAD_Internationalize").getString("Error") + "!", 0);
        if (object instanceof Exception) {
            ((Exception)object).printStackTrace();
        } else {
            System.out.println(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Error:") + object);
        }
    }

    public void setConfig() {
        try {
            JMCADConfigPanel jMCADConfigPanel = new JMCADConfigPanel();
            jMCADConfigPanel.delay_debug.setEnabled(false);
            jMCADConfigPanel.name.setEnabled(false);
            jMCADConfigPanel.autor.setEnabled(false);
            jMCADConfigPanel.info.setEnabled(false);
            jMCADConfigPanel.delay.setText(this.time_sleep + "");
            jMCADConfigPanel.delay_debug.setText(this.time_debug + "");
            jMCADConfigPanel.delay_debug.setEditable(false);
            jMCADConfigPanel.name.setText(this.doc_name);
            jMCADConfigPanel.autor.setText(this.doc_autor);
            jMCADConfigPanel.info.setText(this.doc_info);
            Object[] objectArray = new Object[]{ResourceBundle.getBundle("JMCAD_Internationalize").getString("Ok"), ResourceBundle.getBundle("JMCAD_Internationalize").getString("Cancel")};
            int n = JOptionPane.showOptionDialog(this, jMCADConfigPanel, ResourceBundle.getBundle("JMCAD_Internationalize").getString("Configuring_model"), 0, -1, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.time_sleep = Integer.parseInt(jMCADConfigPanel.delay.getText());
                this.doc_name = jMCADConfigPanel.name.getText();
                this.doc_autor = jMCADConfigPanel.autor.getText();
                this.doc_info = jMCADConfigPanel.info.getText();
                this.time_debug = Integer.parseInt(jMCADConfigPanel.delay_debug.getText());
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }
}

