/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class _oscillograph_multi
extends JMCADObject {
    private BufferedImage offscreen;
    private BufferedImage offscreen_grid;
    private Graphics2D offgraphics;
    private Graphics2D offgraphics_grid;
    private Vector[] valueY;
    private double sy;
    private double min_y;
    private double max_y;
    private double dy;
    private int w_c;
    private int h_c;
    private boolean isPainted = false;
    private double[] vy;
    String[] st_inputs = new String[]{"2", "3", "4", "5", "6", "7", "8", "9"};
    JComboBox list_inputs = new JComboBox<String>(this.st_inputs);
    private JTextField tfw = new JTextField();
    private JTextField tfh = new JTextField();

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeBytes("inputs = " + this.in.length + "\n");
        randomAccessFile.writeBytes("width = " + this.w_c + "\n");
        randomAccessFile.writeBytes("height = " + this.h_c + "\n");
    }

    @Override
    public void parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken();
                if ((string2 = string2.trim()).length() == 0) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " =,\t");
                String string3 = stringTokenizer2.nextToken();
                if (string3.equalsIgnoreCase("WIDTH")) {
                    string3 = stringTokenizer2.nextToken();
                    try {
                        this.w = Integer.parseInt(string3) + 40;
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    this.w_c = this.w - 40;
                    continue;
                }
                if (string3.equalsIgnoreCase("HEIGHT")) {
                    string3 = stringTokenizer2.nextToken();
                    try {
                        this.h = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    this.h_c = this.h;
                    continue;
                }
                if (!string3.equalsIgnoreCase("INPUTS")) continue;
                string3 = stringTokenizer2.nextToken();
                try {
                    this.in = new double[Integer.parseInt(string3)];
                }
                catch (Exception exception) {
                    this.error(exception);
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
        this.in_text = new String[this.in.length];
        this.out = new double[this.in.length];
        this.out_text = new String[this.in.length];
        this.out_obj = new Object[this.in.length];
        this.out_obj_index = new int[this.in.length];
        for (int i = 0; i < this.in.length; ++i) {
            this.in[i] = Double.NaN;
            this.in_text[i] = "IN" + i;
            this.out[i] = Double.NaN;
            this.out_text[i] = "OUT" + i;
        }
        super.parse(string);
        try {
            this.init();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public _oscillograph_multi() {
        this.isVisual = true;
        this.ToolTipText = ResourceBundle.getBundle("JMCAD_Internationalize").getString("Display_of_data_in_real_time");
        this.in = new double[2];
        this.in[0] = Double.NaN;
        this.in[1] = Double.NaN;
        this.in_text = new String[2];
        this.in_text[0] = "IN0";
        this.in_text[1] = "IN1";
        this.out = new double[2];
        this.out[0] = Double.NaN;
        this.out[1] = Double.NaN;
        this.out_text = new String[2];
        this.out_text[0] = "OUT0";
        this.out_text[1] = "OUT1";
        this.out_obj = new Object[2];
        this.out_obj_index = new int[2];
        this.w = 150;
        this.h = 100;
        this.w_c = 150;
        this.h_c = 100;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void paint_info(Graphics graphics) {
        this.isPainted = true;
        if (this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        } else {
            graphics.drawImage(this.getImageGrid(), 0, 0, this);
        }
        this.isPainted = false;
    }

    private BufferedImage getImageGrid() {
        double d;
        if (this.panel_c.getWidth() != 0) {
            this.w_c = this.panel_c.getWidth();
        }
        if (this.panel_c.getHeight() != 0) {
            this.h_c = this.panel_c.getHeight();
        }
        this.offscreen_grid = new BufferedImage(this.w_c, this.h_c, 5);
        this.offgraphics_grid = (Graphics2D)this.offscreen_grid.getGraphics();
        this.offgraphics_grid.clearRect(0, 0, this.w_c, this.h_c);
        this.offgraphics_grid.setColor(Color.gray);
        this.offgraphics_grid.setStroke(new BasicStroke(1.0f));
        double d2 = (double)this.w_c / 10.0;
        for (d = 0.0; d <= (double)(this.w_c + 1); d += d2) {
            this.offgraphics_grid.draw(new Line2D.Double(d, 0.0, d, this.h_c));
        }
        d = (double)this.h_c / 10.0;
        for (double d3 = 0.0; d3 <= (double)(this.h_c + 1); d3 += d) {
            this.offgraphics_grid.draw(new Line2D.Double(0.0, d3, this.w_c, d3));
        }
        return this.offscreen_grid;
    }

    @Override
    public void calc_pre() {
        int n;
        this.valueY = new Vector[this.in.length];
        for (n = 0; n < this.valueY.length; ++n) {
            this.valueY[n] = new Vector();
        }
        if (this.panel_c.getWidth() != 0) {
            this.w_c = this.panel_c.getWidth();
        }
        if (this.panel_c.getHeight() != 0) {
            this.h_c = this.panel_c.getHeight();
        }
        this.sy = 1.0;
        this.min_y = Double.MAX_VALUE;
        this.max_y = Double.MIN_VALUE;
        for (n = 0; n < this.valueY.length; ++n) {
            this.valueY[n].removeAllElements();
        }
        this.offscreen = new BufferedImage(this.w_c, this.h_c, 5);
        this.offgraphics = (Graphics2D)this.offscreen.getGraphics();
        this.vy = new double[this.w_c];
        this.getImageGrid();
    }

    @Override
    public void calc() {
        int n;
        for (n = 0; n < this.in.length; ++n) {
            if (!Double.isInfinite(this.in[n])) continue;
            return;
        }
        for (n = 0; n < this.in.length; ++n) {
            this.out[n] = this.in[n];
        }
        for (n = 0; n < this.valueY.length; ++n) {
            this.valueY[n].insertElementAt(new Double(this.in[n]), 0);
        }
        if (this.valueY[0].size() > this.w_c) {
            for (n = 0; n < this.in.length; ++n) {
                this.valueY[n].setSize(this.w_c);
                this.valueY[n].trimToSize();
            }
        }
        for (n = 0; n < this.in.length; ++n) {
            this.min_y = Math.min(this.min_y, this.in[n]);
            this.max_y = Math.max(this.max_y, this.in[n]);
        }
        this.sy = (this.max_y - this.min_y) / (double)(this.h_c - 4);
        this.dy = -this.min_y / this.sy + 2.0;
        for (n = 0; n < this.in.length; ++n) {
            this.in[n] = Double.NaN;
        }
        if (this.isPainted) {
            return;
        }
        this.offgraphics.drawImage(this.offscreen_grid, null, 0, 0);
        this.offgraphics.setStroke(new BasicStroke(2.0f));
        for (n = 0; n < this.in.length; ++n) {
            int n2;
            if (n == 0) {
                this.offgraphics.setColor(Color.RED);
            } else if (n == 1) {
                this.offgraphics.setColor(Color.GREEN);
            } else if (n == 2) {
                this.offgraphics.setColor(Color.BLUE);
            } else if (n == 3) {
                this.offgraphics.setColor(Color.CYAN);
            } else if (n == 4) {
                this.offgraphics.setColor(Color.MAGENTA);
            } else if (n == 5) {
                this.offgraphics.setColor(Color.ORANGE);
            } else if (n == 6) {
                this.offgraphics.setColor(Color.PINK);
            } else if (n == 7) {
                this.offgraphics.setColor(Color.WHITE);
            } else if (n == 8) {
                this.offgraphics.setColor(Color.YELLOW);
            }
            for (n2 = 0; n2 < this.valueY[n].size(); ++n2) {
                this.vy[n2] = (double)this.h_c - (Double)this.valueY[n].elementAt(this.valueY[n].size() - 1 - n2) / this.sy - this.dy;
            }
            try {
                for (n2 = 0; n2 < this.valueY[n].size() - 1; ++n2) {
                    this.offgraphics.draw(new Line2D.Double(n2, this.vy[n2], n2 + 1, this.vy[n2 + 1]));
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.offgraphics.setColor(Color.YELLOW);
            this.offgraphics.drawString(this.max_y + "", 3, 10);
            this.offgraphics.drawString(this.min_y + "", 3, this.h_c - 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void calc_post() {
        this.offgraphics.drawImage(this.offscreen_grid, null, 0, 0);
        this.offgraphics.setStroke(new BasicStroke(2.0f));
        for (int i = 0; i < this.in.length; ++i) {
            int n;
            if (i == 0) {
                this.offgraphics.setColor(Color.RED);
            } else if (i == 1) {
                this.offgraphics.setColor(Color.GREEN);
            } else if (i == 2) {
                this.offgraphics.setColor(Color.BLUE);
            } else if (i == 3) {
                this.offgraphics.setColor(Color.CYAN);
            } else if (i == 4) {
                this.offgraphics.setColor(Color.MAGENTA);
            } else if (i == 5) {
                this.offgraphics.setColor(Color.ORANGE);
            } else if (i == 6) {
                this.offgraphics.setColor(Color.PINK);
            } else if (i == 7) {
                this.offgraphics.setColor(Color.WHITE);
            } else if (i == 8) {
                this.offgraphics.setColor(Color.YELLOW);
            }
            for (n = 0; n < this.valueY[i].size(); ++n) {
                this.vy[n] = (double)this.h_c - (Double)this.valueY[i].elementAt(this.valueY[i].size() - 1 - n) / this.sy - this.dy;
            }
            try {
                for (n = 0; n < this.valueY[i].size() - 1; ++n) {
                    this.offgraphics.draw(new Line2D.Double(n, this.vy[n], n + 1, this.vy[n + 1]));
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.offgraphics.setColor(Color.YELLOW);
            this.offgraphics.drawString(this.max_y + "", 3, 10);
            this.offgraphics.drawString(this.min_y + "", 3, this.h_c - 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void edit_pre() {
        this.edit_panel = new JPanel(new VerticalFlowLayout());
        this.tfw.setText("" + this.w_c);
        this.tfh.setText("" + this.h_c);
        this.list_inputs.setSelectedIndex(this.in.length - 2);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Width")), "West");
        jPanel.add((Component)this.tfw, "Center");
        jPanel2.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Height")), "West");
        jPanel2.add((Component)this.tfh, "Center");
        jPanel3.add((Component)new JLabel("Inputs"), "West");
        jPanel3.add((Component)this.list_inputs, "Center");
        this.edit_panel.add(jPanel);
        this.edit_panel.add(jPanel2);
        this.edit_panel.add(jPanel3);
    }

    @Override
    public void edit_post() {
        try {
            this.in = new double[this.list_inputs.getSelectedIndex() + 2];
            this.in_text = new String[this.in.length];
            this.out = new double[this.in.length];
            this.out_text = new String[this.in.length];
            this.out_obj = new Object[this.in.length];
            this.out_obj_index = new int[this.in.length];
            for (int i = 0; i < this.in.length; ++i) {
                this.in[i] = Double.NaN;
                this.in_text[i] = "IN" + i;
                this.out[i] = Double.NaN;
                this.out_text[i] = "OUT" + i;
            }
            try {
                this.init();
            }
            catch (Exception exception) {
                this.error(exception);
            }
            int n = Integer.parseInt(this.tfh.getText());
            n = Math.max(n, this.in.length * 15 + 5);
            this.setSize(Integer.parseInt(this.tfw.getText()) + this.panel_in.getWidth() * 2, n);
            this.validate();
            this.revalidate();
            this.w_c = this.panel_c.getWidth();
            this.h_c = this.panel_c.getHeight();
            this.w = this.w_c;
            this.h = this.h_c;
            this.size_visual_w = this.w_c;
            this.size_visual_h = this.h_c;
            this.sy = (this.max_y - this.min_y) / (double)this.h_c;
            this.dy = -this.min_y / this.sy;
            this.offscreen = null;
            this.calc_pre();
            this.validate();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }
}

