/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.util.ResourceBundle;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class _soundout
extends JMCADObject {
    private final Image img = new ImageIcon(this.getClass().getResource("_soundout.gif")).getImage();
    private float sampleRate = 44100.0f;
    private int sampleSizeInBits = 16;
    private int channels = 1;
    private boolean signed = true;
    private boolean bigEndian = false;
    private SourceDataLine sourceDataLine;
    private AudioFormat audioFormat;
    private byte[] b_one_channel = new byte[2];
    private byte[] b_two_channel = new byte[4];
    private JComboBox cb_sampleRate = new JComboBox<String>(new String[]{"8000.0F", "11025.0F", "16000.0F", "22050.0F", "44100.0F"});
    private JComboBox cb_channels = new JComboBox<String>(new String[]{"1", "2"});
    private JComboBox cb_bigEndian = new JComboBox<String>(new String[]{"true", "false"});

    @Override
    public void edit_pre() {
        this.cb_sampleRate.setSelectedItem(this.sampleRate + "");
        this.cb_channels.setSelectedItem(this.channels + "");
        this.cb_bigEndian.setSelectedItem(this.bigEndian + "");
        this.edit_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Sample_rate") + ": "), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.edit_panel.add((Component)this.cb_sampleRate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Channels") + ": "), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.edit_panel.add((Component)this.cb_channels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.edit_panel.add((Component)new JLabel("Big Endian: "), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.edit_panel.add((Component)this.cb_bigEndian, gridBagConstraints);
    }

    @Override
    public void edit_post() {
        try {
            this.sampleRate = Float.parseFloat(this.cb_sampleRate.getSelectedItem() + "");
            this.channels = Integer.parseInt(this.cb_channels.getSelectedItem() + "");
            this.bigEndian = Boolean.parseBoolean(this.cb_bigEndian.getSelectedItem() + "");
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public _soundout() {
        this.ToolTipText = ResourceBundle.getBundle("JMCAD_Internationalize").getString("Exit_from_the_document_on_the_device") + " SOUND OUT = IN";
        this.in = new double[1];
        this.in_text = new String[1];
        this.in[0] = Double.NaN;
        this.in_text[0] = "IN";
        this.out = new double[0];
        this.out_text = new String[0];
        this.out_obj = new Object[0];
        this.out_obj_index = new int[0];
        this.w = 66;
        this.h = 36;
        this.panel_c.setBackground(Color.YELLOW);
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void paint_info(Graphics graphics) {
        graphics.drawImage(this.img, 0, 0, this);
    }

    @Override
    public void calc_pre() {
        try {
            this.audioFormat = new AudioFormat(this.sampleRate, this.sampleSizeInBits, this.channels, this.signed, this.bigEndian);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceDataLine.open(this.audioFormat);
            this.sourceDataLine.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public synchronized void calc() {
        int n = (int)(this.in[0] > 65535.0 ? 65535.0 : this.in[0]);
        if (!this.bigEndian) {
            if (this.channels == 1) {
                this.b_one_channel[0] = (byte)(n & 0xFF);
                this.b_one_channel[1] = (byte)(n >> 8 & 0xFF);
                this.sourceDataLine.write(this.b_one_channel, 0, 2);
            } else {
                this.b_two_channel[0] = (byte)(n & 0xFF);
                this.b_two_channel[1] = (byte)(n >> 8 & 0xFF);
                this.b_two_channel[2] = (byte)(n & 0xFF);
                this.b_two_channel[3] = (byte)(n >> 8 & 0xFF);
                this.sourceDataLine.write(this.b_two_channel, 0, 4);
            }
        } else if (this.channels == 1) {
            this.b_one_channel[0] = (byte)(n >> 8 & 0xFF);
            this.b_one_channel[1] = (byte)(n & 0xFF);
            this.sourceDataLine.write(this.b_one_channel, 0, 2);
        } else {
            this.b_two_channel[0] = (byte)(n >> 8 & 0xFF);
            this.b_two_channel[1] = (byte)(n & 0xFF);
            this.b_two_channel[2] = (byte)(n >> 8 & 0xFF);
            this.b_two_channel[3] = (byte)(n & 0xFF);
            this.sourceDataLine.write(this.b_two_channel, 0, 4);
        }
        this.in[0] = Double.NaN;
    }

    @Override
    public void calc_post() {
        this.sourceDataLine.drain();
        this.sourceDataLine.stop();
        this.sourceDataLine.close();
    }
}

