/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCompleteTextField;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LevelController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class LevelPanel
extends JPanel
implements DialogView {
    private final LevelController controller;
    private NullableCheckBox viewableCheckBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private JLabel floorThicknessLabel;
    private JSpinner floorThicknessSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JButton increaseElevationIndexButton;
    private JButton decreaseElevationIndexButton;
    private JLabel levelsSummaryLabel;
    private JTable levelsSummaryTable;
    private String dialogTitle;

    public LevelPanel(UserPreferences userPreferences, LevelController levelController) {
        super(new GridBagLayout());
        this.controller = levelController;
        this.createComponents(userPreferences, levelController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences, levelController);
    }

    private void createComponents(final UserPreferences userPreferences, final LevelController levelController) {
        PropertyChangeListener propertyChangeListener;
        String[] stringArray;
        String string = userPreferences.getLengthUnit().getName();
        if (levelController.isPropertyEditable(LevelController.Property.VIEWABLE)) {
            this.viewableCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "viewableCheckBox.text", new Object[0]));
            this.viewableCheckBox.setNullable(levelController.getViewable() == null);
            this.viewableCheckBox.setValue(levelController.getViewable());
            this.viewableCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    levelController.setViewable(LevelPanel.this.viewableCheckBox.getValue());
                }
            });
            levelController.addPropertyChangeListener(LevelController.Property.VIEWABLE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LevelPanel.this.viewableCheckBox.setValue(levelController.getViewable());
                }
            });
        }
        if (levelController.isPropertyEditable(LevelController.Property.NAME)) {
            this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "nameLabel.text", new Object[0]));
            this.nameTextField = new AutoCompleteTextField(levelController.getName(), 15, userPreferences.getAutoCompletionStrings("LevelName"));
            if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
                SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
            }
            final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LevelPanel.this.nameTextField.setText(levelController.getName());
                }
            };
            levelController.addPropertyChangeListener(LevelController.Property.NAME, propertyChangeListener2);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    levelController.removePropertyChangeListener(LevelController.Property.NAME, propertyChangeListener2);
                    String string = LevelPanel.this.nameTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        levelController.setName(null);
                    } else {
                        levelController.setName(string);
                    }
                    levelController.addPropertyChangeListener(LevelController.Property.NAME, propertyChangeListener2);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        float f = userPreferences.getLengthUnit().getMaximumLength();
        if (levelController.isPropertyEditable(LevelController.Property.ELEVATION)) {
            this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "elevationLabel.text", string));
            final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -1000.0f, userPreferences.getLengthUnit().getMaximumElevation());
            this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel);
            nullableSpinnerLengthModel.setNullable(levelController.getElevation() == null);
            nullableSpinnerLengthModel.setLength(levelController.getElevation());
            stringArray = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    nullableSpinnerLengthModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            levelController.addPropertyChangeListener(LevelController.Property.ELEVATION, (PropertyChangeListener)stringArray);
            nullableSpinnerLengthModel.addChangeListener(new ChangeListener((PropertyChangeListener)stringArray, nullableSpinnerLengthModel){
                final /* synthetic */ PropertyChangeListener val$elevationChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$elevationSpinnerModel;
                {
                    this.val$elevationChangeListener = propertyChangeListener;
                    this.val$elevationSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    levelController.removePropertyChangeListener(LevelController.Property.ELEVATION, this.val$elevationChangeListener);
                    levelController.setElevation(this.val$elevationSpinnerModel.getLength());
                    LevelPanel.this.setFloorThicknessEnabled(levelController);
                    LevelPanel.this.setElevationIndexButtonsEnabled(levelController);
                    levelController.addPropertyChangeListener(LevelController.Property.ELEVATION, this.val$elevationChangeListener);
                }
            });
        }
        float f2 = userPreferences.getLengthUnit().getMinimumLength();
        if (levelController.isPropertyEditable(LevelController.Property.FLOOR_THICKNESS)) {
            this.floorThicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "floorThicknessLabel.text", string));
            stringArray = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f / 10.0f);
            this.floorThicknessSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)stringArray);
            propertyChangeListener = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)stringArray){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$floorThicknessSpinnerModel;
                {
                    this.val$floorThicknessSpinnerModel = nullableSpinnerLengthModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = levelController.getFloorThickness();
                    this.val$floorThicknessSpinnerModel.setNullable(f == null);
                    this.val$floorThicknessSpinnerModel.setLength(f);
                }
            };
            propertyChangeListener.propertyChange(null);
            levelController.addPropertyChangeListener(LevelController.Property.FLOOR_THICKNESS, propertyChangeListener);
            stringArray.addChangeListener(new ChangeListener((NullableSpinner.NullableSpinnerLengthModel)stringArray){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$floorThicknessSpinnerModel;
                {
                    this.val$floorThicknessSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    levelController.removePropertyChangeListener(LevelController.Property.FLOOR_THICKNESS, propertyChangeListener);
                    levelController.setFloorThickness(this.val$floorThicknessSpinnerModel.getLength());
                    levelController.addPropertyChangeListener(LevelController.Property.FLOOR_THICKNESS, propertyChangeListener);
                }
            });
            this.setFloorThicknessEnabled(levelController);
        }
        if (levelController.isPropertyEditable(LevelController.Property.HEIGHT)) {
            this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "heightLabel.text", string));
            stringArray = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
            this.heightSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)stringArray);
            propertyChangeListener = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)stringArray){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$heightSpinnerModel;
                {
                    this.val$heightSpinnerModel = nullableSpinnerLengthModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = levelController.getHeight();
                    this.val$heightSpinnerModel.setNullable(f == null);
                    this.val$heightSpinnerModel.setLength(f);
                }
            };
            propertyChangeListener.propertyChange(null);
            levelController.addPropertyChangeListener(LevelController.Property.HEIGHT, propertyChangeListener);
            stringArray.addChangeListener(new ChangeListener((NullableSpinner.NullableSpinnerLengthModel)stringArray){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$heightSpinnerModel;
                {
                    this.val$heightSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    levelController.removePropertyChangeListener(LevelController.Property.HEIGHT, propertyChangeListener);
                    levelController.setHeight(this.val$heightSpinnerModel.getLength());
                    levelController.addPropertyChangeListener(LevelController.Property.HEIGHT, propertyChangeListener);
                }
            });
        }
        if (levelController.isPropertyEditable(LevelController.Property.ELEVATION_INDEX)) {
            this.increaseElevationIndexButton = new JButton(new ResourceAction(userPreferences, LevelPanel.class, "INCREASE_ELEVATION_INDEX"){

                public void actionPerformed(ActionEvent actionEvent) {
                    levelController.setElevationIndex(levelController.getElevationIndex() + 1);
                    LevelPanel.this.setElevationIndexButtonsEnabled(levelController);
                }
            });
            this.decreaseElevationIndexButton = new JButton(new ResourceAction(userPreferences, LevelPanel.class, "DECREASE_ELEVATION_INDEX"){

                public void actionPerformed(ActionEvent actionEvent) {
                    levelController.setElevationIndex(levelController.getElevationIndex() - 1);
                    LevelPanel.this.setElevationIndexButtonsEnabled(levelController);
                }
            });
            this.setElevationIndexButtonsEnabled(levelController);
        }
        this.levelsSummaryLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "levelsSummaryLabel.text", string));
        stringArray = new String[]{SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "nameColumn", new Object[0]), SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "elevationColumn", new Object[0]), SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "floorThicknessColumn", new Object[0]), SwingTools.getLocalizedLabelText(userPreferences, LevelPanel.class, "heightColumn", new Object[0])};
        this.levelsSummaryTable = new JTable(new LevelsTableModel(levelController, stringArray));
        float f3 = SwingTools.getResolutionScale();
        if (f3 != 1.0f) {
            this.levelsSummaryTable.setRowHeight(Math.round((float)this.levelsSummaryTable.getRowHeight() * f3));
        }
        TableColumnModel tableColumnModel = this.levelsSummaryTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setEnabled((Boolean)jTable.getModel().getValueAt(n, 4));
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    object = userPreferences.getLengthUnit().getFormat().format((Float)object);
                    this.setHorizontalAlignment(4);
                }
                this.setEnabled((Boolean)jTable.getModel().getValueAt(n, 4));
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        };
        tableColumnModel.getColumn(1).setCellRenderer(defaultTableCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(defaultTableCellRenderer);
        tableColumnModel.getColumn(3).setCellRenderer(defaultTableCellRenderer);
        this.levelsSummaryTable.setSelectionModel(new DefaultListSelectionModel(){
            {
                levelController.addPropertyChangeListener(LevelController.Property.SELECT_LEVEL_INDEX, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Integer n = levelController.getSelectedLevelIndex();
                        if (n != null) {
                            int n2 = LevelPanel.this.levelsSummaryTable.getRowCount() - n - 1;
                            this.fireValueChanged(n2, n2);
                            LevelPanel.this.scrollToSelectedLevel(levelController);
                        }
                    }
                });
            }

            public void setSelectionInterval(int n, int n2) {
            }

            public void setLeadSelectionIndex(int n) {
            }

            public void setAnchorSelectionIndex(int n) {
            }

            public boolean isSelectionEmpty() {
                return levelController.getSelectedLevelIndex() != null;
            }

            public boolean isSelectedIndex(int n) {
                return levelController.getSelectedLevelIndex() == LevelPanel.this.levelsSummaryTable.getRowCount() - n - 1;
            }

            public void insertIndexInterval(int n, int n2, boolean bl) {
            }
        });
        this.levelsSummaryTable.setFocusable(false);
        this.levelsSummaryTable.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                LevelPanel.this.scrollToSelectedLevel(levelController);
                ancestorEvent.getComponent().removeAncestorListener(this);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.dialogTitle = userPreferences.getLocalizedString(LevelPanel.class, "level.title", new Object[0]);
    }

    private void setFloorThicknessEnabled(LevelController levelController) {
        Integer n = levelController.getSelectedLevelIndex();
        if (this.floorThicknessSpinner != null && n != null) {
            Level[] levelArray = levelController.getLevels();
            this.floorThicknessSpinner.setEnabled(levelArray[n].getElevation() != levelArray[0].getElevation());
        }
    }

    private void scrollToSelectedLevel(LevelController levelController) {
        Integer n = levelController.getSelectedLevelIndex();
        if (n != null) {
            int n2 = this.levelsSummaryTable.getRowCount() - n - 1;
            this.levelsSummaryTable.scrollRectToVisible(this.levelsSummaryTable.getCellRect(n2, 0, true));
        }
    }

    private void setElevationIndexButtonsEnabled(LevelController levelController) {
        Integer n = levelController.getSelectedLevelIndex();
        if (n != null) {
            Level[] levelArray = levelController.getLevels();
            this.increaseElevationIndexButton.setEnabled(n < levelArray.length - 1 && levelArray[n].getElevation() == levelArray[n + 1].getElevation());
            this.decreaseElevationIndexButton.setEnabled(n > 0 && levelArray[n].getElevation() == levelArray[n - 1].getElevation());
        } else {
            this.increaseElevationIndexButton.setEnabled(false);
            this.decreaseElevationIndexButton.setEnabled(false);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.viewableCheckBox != null) {
                this.viewableCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LevelPanel.class, "viewableCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.nameLabel != null) {
                this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LevelPanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
                this.nameLabel.setLabelFor(this.nameTextField);
            }
            if (this.elevationLabel != null) {
                this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LevelPanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
                this.elevationLabel.setLabelFor(this.elevationSpinner);
            }
            if (this.floorThicknessLabel != null) {
                this.floorThicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LevelPanel.class, "floorThicknessLabel.mnemonic", new Object[0])).getKeyCode());
                this.floorThicknessLabel.setLabelFor(this.floorThicknessSpinner);
            }
            if (this.heightLabel != null) {
                this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LevelPanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
                this.heightLabel.setLabelFor(this.heightSpinner);
            }
        }
    }

    private void layoutComponents(UserPreferences userPreferences, LevelController levelController) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        Insets insets = new Insets(0, 0, n2, n2);
        Insets insets2 = new Insets(0, 0, n2, 0);
        if (this.viewableCheckBox != null) {
            this.add((Component)this.viewableCheckBox, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, -4, n2, 0), 0, 0));
        }
        if (this.nameLabel != null) {
            this.add((Component)this.nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.elevationLabel != null) {
            this.add((Component)this.elevationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.elevationSpinner, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 21, 2, insets2, -15, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(2, 2, 1, 1, 0.2, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.floorThicknessLabel != null) {
            this.add((Component)this.floorThicknessLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.floorThicknessSpinner, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 21, 2, insets2, -15, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(2, 3, 1, 1, 0.2, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.heightLabel != null) {
            this.add((Component)this.heightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
            this.add((Component)this.heightSpinner, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 21, 2, new Insets(0, 0, 0, 0), -15, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(2, 4, 1, 1, 0.2, 0.0, 21, 2, insets2, 0, 0));
        }
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 21, 2, new Insets(n2, 0, n2, 0), 0, 0));
        this.add((Component)this.levelsSummaryLabel, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.levelsSummaryTable);
        jScrollPane.setPreferredSize(new Dimension(Math.round(320.0f * SwingTools.getResolutionScale()), this.levelsSummaryTable.getTableHeader().getPreferredSize().height + this.levelsSummaryTable.getRowHeight() * 8 + 1));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 7, 3, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.increaseElevationIndexButton, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.5, 15, 0, new Insets(0, n2, 2, 0), 0, 0));
        this.add((Component)this.decreaseElevationIndexButton, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.5, 11, 0, new Insets(2, n2, 0, 0), 0, 0));
        if (!OperatingSystem.isMacOSX()) {
            Dimension dimension = this.increaseElevationIndexButton.getPreferredSize();
            dimension.width = dimension.height += 4;
            this.increaseElevationIndexButton.setPreferredSize(dimension);
            this.decreaseElevationIndexButton.setPreferredSize(dimension);
        }
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.nameTextField) == 0) {
            this.controller.modifyLevels();
        }
    }

    private static final class LevelsTableModel
    extends AbstractTableModel {
        private Level[] levels;
        private String[] columnNames;

        private LevelsTableModel(final LevelController levelController, String[] stringArray) {
            this.levels = levelController.getLevels();
            this.columnNames = stringArray;
            levelController.addPropertyChangeListener(LevelController.Property.LEVELS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LevelsTableModel.access$802(LevelsTableModel.this, levelController.getLevels());
                    LevelsTableModel.this.fireTableDataChanged();
                }
            });
        }

        public int getRowCount() {
            return this.levels.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public Object getValueAt(int n, int n2) {
            Level level = this.levels[this.levels.length - n - 1];
            switch (n2) {
                case 0: {
                    return level.getName();
                }
                case 1: {
                    return Float.valueOf(level.getElevation());
                }
                case 2: {
                    if (level.getElevation() == this.levels[0].getElevation()) {
                        return null;
                    }
                    return Float.valueOf(level.getFloorThickness());
                }
                case 3: {
                    return Float.valueOf(level.getHeight());
                }
                case 4: {
                    return level.isViewable();
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        static /* synthetic */ Level[] access$802(LevelsTableModel levelsTableModel, Level[] levelArray) {
            levelsTableModel.levels = levelArray;
            return levelArray;
        }
    }
}

