/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.grid;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.jaxodraw.gui.grid.JaxoPaintableGrid;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoPrefs;

public class JaxoDefaultGrid
implements JaxoPaintableGrid,
Cloneable {
    private static final double FACTOR = Math.sqrt(3.0) / 2.0;
    private static Color transparentBackground = new Color(255, 255, 255, 0);
    private EventListenerList listeners;
    private ChangeEvent event;
    private int style;
    private int gridSize;
    private int type;
    private boolean isOddRow = true;
    private Dimension canvasSize;
    private boolean transparent = true;
    private Color gridColor;
    private Color background;
    private int gridDistance;
    private BufferedImage image;
    private boolean imageInvalid;
    private boolean paint = true;
    private boolean snap;

    public JaxoDefaultGrid(int gsize, int gtype) {
        this(gsize, gtype, new Dimension());
    }

    public JaxoDefaultGrid(int gsize, int gtype, int gridStyle, Color color) {
        this(gsize, gtype, gridStyle, color, new Dimension());
    }

    public JaxoDefaultGrid(int gsize, int gtype, Dimension canvasDim) {
        this(gsize, gtype, 0, JaxoColor.GRAYSCALE120, canvasDim);
    }

    public JaxoDefaultGrid(int gsize, int gtype, int gridStyle, Color color, Dimension canvasDim) {
        this.gridSize = gsize;
        if (gtype == 1 && gsize % 2 != 0) {
            ++this.gridSize;
        }
        this.style = gridStyle;
        this.listeners = new EventListenerList();
        this.gridDistance = (int)Math.round((double)this.gridSize * FACTOR);
        this.type = gtype;
        this.gridColor = color;
        this.background = Color.white;
        this.canvasSize = (Dimension)canvasDim.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        JaxoDefaultGrid clone = (JaxoDefaultGrid)super.clone();
        clone.listeners = new EventListenerList();
        clone.image = null;
        clone.imageInvalid = false;
        return clone;
    }

    public void copyFrom(JaxoDefaultGrid g) {
        this.transparent = g.transparent;
        this.setBackground(g.getBackground());
        this.setGridColor(g.getGridColor());
        this.setGridType(g.getGridType());
        this.setGridSize(g.getGridSize());
        this.setGridStyle(g.getGridStyle());
        this.setCanvasSize(g.getCanvasSize());
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] pairs = this.listeners.getListenerList();
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != ChangeListener.class) continue;
            if (this.event == null) {
                this.event = new ChangeEvent(this);
            }
            ((ChangeListener)pairs[i + 1]).stateChanged(this.event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSnapped(Point p) {
        boolean old = this.isOddRow;
        try {
            boolean bl = this.snapY(p.y) == p.y && this.snapX(p.x) == p.x;
            return bl;
        }
        finally {
            this.isOddRow = old;
        }
    }

    public final Point snappedPoint(Point p) {
        Point q = (Point)p.clone();
        this.snapPoint(q);
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void snapPoint(Point p) {
        boolean old = this.isOddRow;
        try {
            p.y = this.snapY(p.y);
            p.x = this.snapX(p.x);
        }
        finally {
            this.isOddRow = old;
        }
    }

    private int snapX(int x) {
        int snappedX = this.gridSize * Math.round((float)x / (float)this.gridSize);
        if (this.type == 1 && this.isOddRow) {
            int snappedX1 = snappedX - this.gridSize / 2;
            int snappedX2 = snappedX + this.gridSize / 2;
            snappedX = Math.abs(x - snappedX1) < Math.abs(x - snappedX2) ? snappedX1 : snappedX2;
        }
        return snappedX;
    }

    private int snapY(int y) {
        int snappedY;
        if (this.type == 1) {
            int row = Math.round((float)y / (float)this.gridDistance);
            snappedY = this.gridDistance * row;
            this.isOddRow = row % 2 != 0;
        } else {
            snappedY = this.gridSize * Math.round((float)y / (float)this.gridSize);
        }
        return snappedY;
    }

    private void ensureValidImage() {
        this.createImage();
        this.paintImage();
    }

    private void createImage() {
        int height;
        int width;
        if (this.image != null) {
            return;
        }
        if (this.type == 1) {
            width = Math.max(1, 70 / this.gridSize) * 3 * this.gridSize;
            height = Math.max(1, 100 / this.gridDistance) * 2 * this.gridDistance;
        } else {
            height = width = Math.max(1, 200 / this.gridSize) * this.gridSize;
        }
        Color b = this.hasBackground() ? this.background : transparentBackground;
        this.image = new BufferedImage(width, height, 13, new IndexColorModel(8, 2, new byte[]{(byte)b.getRed(), (byte)this.gridColor.getRed()}, new byte[]{(byte)b.getGreen(), (byte)this.gridColor.getGreen()}, new byte[]{(byte)b.getBlue(), (byte)this.gridColor.getBlue()}, new byte[]{(byte)b.getAlpha(), (byte)this.gridColor.getAlpha()}));
        this.imageInvalid = true;
    }

    private static BasicStroke newStroke(float[] dash) {
        return new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
    }

    private void paintImage() {
        if (!this.imageInvalid) {
            return;
        }
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        Graphics2D g = this.image.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setColor(this.hasBackground() ? this.background : transparentBackground);
        g.fillRect(0, 0, width, height);
        g.setColor(this.gridColor);
        if (this.type == 1) {
            if (this.style == 2) {
                int x;
                g.setStroke(new BasicStroke(1.0f));
                for (int y = 0; y < height; y += this.gridDistance * 2) {
                    g.drawLine(0, y, width, y);
                    g.drawLine(0, y + this.gridDistance, width, y + this.gridDistance);
                }
                int rows = Math.round((float)height / (float)this.gridDistance) + 1;
                for (x = -(rows + 1) / 2 * this.gridSize; x < width; x += this.gridSize) {
                    g.drawLine(x, 0, x + rows * this.gridSize / 2, rows * this.gridDistance);
                }
                x = this.gridSize;
                while (x - rows * this.gridSize / 2 < width) {
                    g.drawLine(x, 0, x - rows * this.gridSize / 2, rows * this.gridDistance);
                    x += this.gridSize;
                }
            } else if (this.style == 3) {
                int x;
                int y;
                g.setStroke(new BasicStroke(1.0f));
                for (y = 0; y < height; y += this.gridDistance * 2) {
                    for (x = 0; x < width; x += 3 * this.gridSize) {
                        g.drawLine(x, y, x + this.gridSize, y);
                        g.drawLine(x + 3 * this.gridSize / 2, y + this.gridDistance, x + 5 * this.gridSize / 2, y + this.gridDistance);
                    }
                }
                for (y = 0; y < height; y += this.gridDistance * 2) {
                    for (x = -3 * this.gridSize; x < width; x += 3 * this.gridSize) {
                        g.drawLine(x + this.gridSize, y, x + 3 * this.gridSize / 2, y + this.gridDistance);
                        g.drawLine(x + 3 * this.gridSize, y, x + 5 * this.gridSize / 2, y + this.gridDistance);
                        g.drawLine(x + 3 * this.gridSize / 2, y + this.gridDistance, x + this.gridSize, y + 2 * this.gridDistance);
                        g.drawLine(x + 5 * this.gridSize / 2, y + this.gridDistance, x + 3 * this.gridSize, y + 2 * this.gridDistance);
                    }
                }
            } else {
                int y;
                g.setStroke(JaxoDefaultGrid.newStroke(new float[]{1.0f, this.gridSize - 1}));
                boolean cross = this.style == 1;
                int n = y = cross ? -1 : 0;
                while (y < height) {
                    g.drawLine(0, y, width, y);
                    g.drawLine(-this.gridSize / 2, y + this.gridDistance, width, y + this.gridDistance);
                    y += this.gridDistance * 2;
                }
                if (cross) {
                    int n2 = y = this.gridDistance == 1 ? -1 : 1;
                    while (y < height) {
                        g.drawLine(0, y, width, y);
                        g.drawLine(-this.gridSize / 2, y + this.gridDistance, width, y + this.gridDistance);
                        y += this.gridDistance * 2;
                    }
                    if (this.gridSize >= 3) {
                        g.setStroke(JaxoDefaultGrid.newStroke(new float[]{3.0f, this.gridSize - 3}));
                        for (y = 0; y < height; y += this.gridDistance * 2) {
                            g.drawLine(-1, y, width, y);
                            g.drawLine(-this.gridSize / 2 - 1, y + this.gridDistance, width, y + this.gridDistance);
                        }
                    }
                }
            }
        } else if (this.style == 2 || this.style == 3) {
            g.setStroke(new BasicStroke(1.0f));
            for (int y = 0; y < height; y += this.gridSize) {
                g.drawLine(0, y, width, y);
            }
            for (int x = 0; x < width; x += this.gridSize) {
                g.drawLine(x, 0, x, height);
            }
        } else {
            int y;
            g.setStroke(JaxoDefaultGrid.newStroke(new float[]{1.0f, this.gridSize - 1}));
            boolean cross = this.style == 1;
            int n = y = cross ? this.gridSize - 1 : 0;
            while (y < height) {
                g.drawLine(0, y, width, y);
                y += this.gridSize;
            }
            if (cross) {
                int n3 = y = this.gridSize == 1 ? 0 : 1;
                while (y < height) {
                    g.drawLine(0, y, width, y);
                    y += this.gridSize;
                }
                if (this.gridSize >= 3) {
                    g.setStroke(JaxoDefaultGrid.newStroke(new float[]{3.0f, this.gridSize - 3}));
                    for (y = 0; y < height; y += this.gridSize) {
                        g.drawLine(-1, y, width, y);
                    }
                }
            }
        }
        g.dispose();
        this.imageInvalid = false;
    }

    private void disposeImage() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
            this.imageInvalid = false;
        }
    }

    public final int getTransparency() {
        if (this.hasBackground() && this.background.getTransparency() != 2) {
            return this.background.getTransparency();
        }
        return this.gridColor.getTransparency() == 3 ? 3 : 2;
    }

    public final void paint(Graphics2D g) {
        this.ensureValidImage();
        for (int x = 0; x < this.canvasSize.width; x += this.image.getWidth()) {
            for (int y = 0; y < this.canvasSize.height; y += this.image.getHeight()) {
                g.drawImage(this.image, null, x, y);
            }
        }
    }

    public Dimension getCanvasSize() {
        return (Dimension)this.canvasSize.clone();
    }

    public void setCanvasSize(Dimension value) {
        this.canvasSize.setSize(value);
    }

    public final void setGridSize(int value) {
        int newValue = value;
        if (this.type == 1 && value % 2 != 0) {
            ++newValue;
        }
        if (newValue != this.gridSize) {
            this.gridSize = newValue;
            this.gridDistance = (int)Math.round((double)this.gridSize * FACTOR);
            this.disposeImage();
            this.fireStateChanged();
        }
    }

    public final int getGridSize() {
        return this.gridSize;
    }

    public final void setGridType(int value) {
        if (this.type != value) {
            this.type = value;
            if (this.type == 1 && this.gridSize % 2 != 0) {
                ++this.gridSize;
                this.gridDistance = (int)Math.round((double)this.gridSize * FACTOR);
            }
            this.disposeImage();
            this.fireStateChanged();
        }
    }

    public final int getGridType() {
        return this.type;
    }

    public final Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color value) {
        if (!this.gridColor.equals(value)) {
            this.gridColor = value;
            this.disposeImage();
            this.fireStateChanged();
        }
    }

    private boolean hasBackground() {
        return !this.transparent && this.background != null;
    }

    public final Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        if (this.background == null ? value != null : !this.background.equals(value)) {
            this.background = value;
            if (!this.transparent) {
                this.disposeImage();
                this.fireStateChanged();
            }
        }
    }

    public final int getGridStyle() {
        return this.style;
    }

    public void setGridStyle(int value) {
        if (this.style != value) {
            this.style = value;
            this.imageInvalid = true;
            this.fireStateChanged();
        }
    }

    public static final JaxoDefaultGrid newDefaultGrid() {
        return new JaxoDefaultGrid(JaxoPrefs.getIntPref("prefGRIDSIZE"), "rectangular".equals(JaxoPrefs.getStringPref("prefGRIDTYPE")) ? 0 : 1, JaxoPrefs.getIntPref("prefGRIDSTYLE"), JaxoColor.getColor(JaxoPrefs.getStringPref("prefGRIDCOLOR"), 2));
    }

    public boolean isPainted() {
        return this.paint;
    }

    public void setPainted(boolean painted) {
        this.paint = painted;
    }

    public boolean isSnapping() {
        return this.snap;
    }

    public void setSnapping(boolean snapping) {
        this.snap = snapping;
    }
}

