/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.menu.popup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoLooknFeel;

public class JaxoFBoxPopupMenu
extends JPopupMenu
implements ActionListener,
JaxoLocalized {
    public static final int PASTE = 1;
    public static final int UNGROUP = 2;
    public static final int GROUP = 3;
    private static final long serialVersionUID = 7526471155622776147L;
    private final ActionListener alistener;
    private final JMenu editM;
    private final JMenuItem cutMI;
    private final JMenuItem copyMI;
    private final JMenuItem pasteMI;
    private final JMenuItem ungroupMI;
    private final JMenuItem groupMI;
    private final JMenu orderM;
    private final JMenuItem foreMI;
    private final JMenuItem backMI;
    private final JMenu selectionM;
    private final JMenuItem saveasMI;
    private final JMenuItem exportMI;
    private final JMenuItem texpreviewMI;
    private boolean pasteMode;

    public JaxoFBoxPopupMenu() {
        this((ActionListener)null);
    }

    public JaxoFBoxPopupMenu(ActionListener listener) {
        this.alistener = listener;
        this.editM = new JMenu();
        this.cutMI = new JMenuItem();
        this.cutMI.addActionListener(this);
        this.cutMI.setActionCommand(JaxoConstants.getModeAsString(1111));
        this.cutMI.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyMI = new JMenuItem();
        this.copyMI.addActionListener(this);
        this.copyMI.setActionCommand(JaxoConstants.getModeAsString(1112));
        this.copyMI.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteMI = new JMenuItem();
        this.pasteMI.addActionListener(this);
        this.pasteMI.setActionCommand(JaxoConstants.getModeAsString(1105));
        this.pasteMI.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.editM.add(this.cutMI);
        this.editM.add(this.copyMI);
        this.editM.add(this.pasteMI);
        this.groupMI = new JMenuItem();
        this.groupMI.addActionListener(this);
        this.groupMI.setActionCommand(JaxoConstants.getModeAsString(1113));
        this.groupMI.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.ungroupMI = new JMenuItem();
        this.ungroupMI.addActionListener(this);
        this.ungroupMI.setActionCommand(JaxoConstants.getModeAsString(1114));
        this.ungroupMI.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        this.orderM = new JMenu();
        this.foreMI = new JMenuItem();
        this.foreMI.addActionListener(this);
        this.foreMI.setActionCommand(JaxoConstants.getModeAsString(1115));
        this.backMI = new JMenuItem();
        this.backMI.addActionListener(this);
        this.backMI.setActionCommand(JaxoConstants.getModeAsString(1116));
        this.orderM.add(this.foreMI);
        this.orderM.add(this.backMI);
        this.selectionM = new JMenu();
        this.saveasMI = new JMenuItem();
        this.saveasMI.addActionListener(this);
        this.saveasMI.setActionCommand(JaxoConstants.getModeAsString(582));
        this.exportMI = new JMenuItem();
        this.exportMI.addActionListener(this);
        this.exportMI.setActionCommand(JaxoConstants.getModeAsString(583));
        this.texpreviewMI = new JMenuItem();
        this.texpreviewMI.addActionListener(this);
        this.texpreviewMI.setActionCommand(JaxoConstants.getModeAsString(1117));
        this.selectionM.add(this.saveasMI);
        this.selectionM.add(this.exportMI);
        this.selectionM.add(this.texpreviewMI);
        this.add(this.editM);
        this.addSeparator();
        this.add(this.groupMI);
        this.add(this.ungroupMI);
        this.addSeparator();
        this.add(this.orderM);
        this.addSeparator();
        this.add(this.selectionM);
        this.updateLanguage();
        JaxoLooknFeel.registerComponent(this);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(String actionCommand) {
        this.fireActionPerformed(actionCommand, null);
    }

    protected void fireActionPerformed(String actionCommand, ActionEvent e) {
        Object[] pairs = this.listenerList.getListenerList();
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != ActionListener.class) continue;
            if (e == null) {
                ((ActionListener)pairs[i + 1]).actionPerformed(new ActionEvent(this, 1001, actionCommand));
                continue;
            }
            ((ActionListener)pairs[i + 1]).actionPerformed(e);
        }
    }

    public final void setMenuItemEnabled(int mitem, boolean value) {
        if (mitem == 1) {
            this.pasteMI.setEnabled(value);
        } else if (mitem == 2) {
            this.ungroupMI.setEnabled(value);
        } else if (mitem == 3) {
            this.groupMI.setEnabled(value);
        }
    }

    public final void onlyPastePopup() {
        if (!this.pasteMode) {
            this.pasteMode = true;
            for (int j = this.getComponentIndex(this.selectionM); j > -1; --j) {
                this.remove(j);
            }
            this.add(this.pasteMI);
        }
    }

    public final void normalPopup() {
        if (this.pasteMode) {
            this.pasteMode = false;
            this.remove(0);
            this.editM.add(this.pasteMI);
            this.add(this.editM);
            this.addSeparator();
            this.add(this.groupMI);
            this.add(this.ungroupMI);
            this.addSeparator();
            this.add(this.orderM);
            this.addSeparator();
            this.add(this.selectionM);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.alistener != null) {
            this.alistener.actionPerformed(e);
        }
        this.fireActionPerformed("action", e);
    }

    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        this.fireActionPerformed("canceled");
    }

    public void show(Component invoker, int x, int y) {
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        final MenuElement[] path = m.getSelectedPath();
        m.addChangeListener(new ChangeListener(){
            private MenuElement[] oldPath;
            {
                this.oldPath = path;
            }

            public void stateChanged(ChangeEvent e) {
                MenuSelectionManager m = (MenuSelectionManager)e.getSource();
                MenuElement[] path2 = m.getSelectedPath();
                boolean found = false;
                for (int i = path2.length - 1; i >= 0; --i) {
                    if (path2[i] != JaxoFBoxPopupMenu.this) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.oldPath = m.getSelectedPath();
                } else {
                    if (this.oldPath.length > 0 && this.oldPath[this.oldPath.length - 1] instanceof JMenuItem && !((JMenuItem)this.oldPath[this.oldPath.length - 1]).isEnabled()) {
                        JaxoFBoxPopupMenu.this.firePopupMenuCanceled();
                    }
                    m.removeChangeListener(this);
                }
            }
        });
        super.show(invoker, x, y);
    }

    public final void updateLanguage() {
        this.editM.setText(JaxoLanguage.translate("Edit"));
        this.cutMI.setText(JaxoLanguage.translate("Cut"));
        this.copyMI.setText(JaxoLanguage.translate("Copy"));
        this.pasteMI.setText(JaxoLanguage.translate("Paste"));
        this.groupMI.setText(JaxoLanguage.translate("group"));
        this.ungroupMI.setText(JaxoLanguage.translate("Ungroup"));
        this.orderM.setText(JaxoLanguage.translate("Order"));
        this.foreMI.setText(JaxoLanguage.translate("Foreground"));
        this.backMI.setText(JaxoLanguage.translate("Background"));
        this.selectionM.setText(JaxoLanguage.translate("Selection"));
        this.saveasMI.setText(JaxoLanguage.translate("Save_as"));
        this.exportMI.setText(JaxoLanguage.translate("Export"));
        this.texpreviewMI.setText(JaxoLanguage.translate("Latex_Preview"));
    }
}

