/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.gui.JaxoTab;
import net.sf.jaxodraw.gui.grid.JaxoDefaultGrid;
import net.sf.jaxodraw.gui.grid.JaxoPaintableGrid;
import net.sf.jaxodraw.gui.panel.JaxoColorChooser;
import net.sf.jaxodraw.gui.panel.JaxoCommunicator;
import net.sf.jaxodraw.gui.panel.button.JaxoColorButton;
import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;
import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerComboBox;
import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerIntModel;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoGridBar
extends JPanel
implements PropertyChangeListener,
ChangeListener,
JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final List<Integer> GRID_SIZES;
    private static final String RECTANGULAR = "Rectangular";
    private final JComboBox chooseGridType = new JComboBox<String>(JaxoGridBar.getGridCombTypes());
    private final JaxoSpinnerIntModel gridSize = new JaxoSpinnerIntModel(1, 76, 1, 0);
    private final JaxoSpinnerComboBox chooseGridSize = new JaxoSpinnerComboBox(new JaxoFixedJSpinner(this.gridSize), JaxoGridBar.getGridSizeDefaults());
    private final JCheckBox gridCheckBox = new JCheckBox();
    private final JCheckBox snapCheckBox = new JCheckBox();
    private final JaxoCommunicator thePanel;
    private JaxoColorChooser colorChooser;
    private final JaxoColorButton gridColorButton = new JaxoColorButton();
    private final JaxoColorButton canvasBackgroundButton = new JaxoColorButton();
    private final JComboBox chooseGridStyle = new JComboBox<String>(JaxoGridBar.getGridStyles());
    private final JLabel gridTypeLabel = new JLabel("", 11);
    private final JLabel gridStyleLabel = new JLabel("", 11);
    private final JLabel gridSizeLabel = new JLabel("", 11);
    private final JLabel gridColorLabel = new JLabel("", 11);
    private final JLabel canvasBackgroundLabel = new JLabel("", 11);
    private transient boolean setting;

    public JaxoGridBar(JaxoCommunicator panel) {
        super(new GridBagLayout());
        this.thePanel = panel;
        this.initComponents();
        this.updateLanguage();
    }

    public static List<Integer> getGridSizeDefaults() {
        return GRID_SIZES;
    }

    private void initComponents() {
        JPanel gOnOffPanel = this.getGridOnOffPanel();
        JPanel gSnapOnOffPanel = this.getSnapOnOffPanel();
        JPanel gTypePanel = this.getGridTypePanel();
        JPanel gStylePanel = this.getGridStylePanel();
        JPanel gColorPanel = this.getGridColorPanel();
        JPanel gSizePanel = this.getGridSizePanel();
        JPanel canvasBackgroundPanel = this.getCanvasBackgroundPanel();
        this.setBorder(BorderFactory.createEtchedBorder(0));
        GridBagConstraints sc = new GridBagConstraints();
        sc.gridx = 0;
        sc.gridy = 0;
        this.add((Component)gOnOffPanel, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        this.add((Component)gSnapOnOffPanel, sc);
        sc.gridx = 2;
        sc.gridy = 0;
        this.add((Component)gTypePanel, sc);
        sc.gridx = 3;
        sc.gridy = 0;
        this.add((Component)gStylePanel, sc);
        sc.gridx = 4;
        sc.gridy = 0;
        this.add((Component)gColorPanel, sc);
        sc.gridx = 5;
        sc.gridy = 0;
        this.add((Component)gSizePanel, sc);
        sc.gridx = 6;
        sc.gridy = 0;
        this.add((Component)canvasBackgroundPanel, sc);
        Component glue = Box.createHorizontalGlue();
        sc.gridx = 7;
        sc.gridy = 0;
        sc.weightx = 1.0;
        this.add(glue, sc);
    }

    private JPanel getGridOnOffPanel() {
        JPanel gridCheckBoxPanel = new JPanel();
        gridCheckBoxPanel.add(this.gridCheckBox);
        this.gridCheckBox.addActionListener(this.thePanel);
        this.gridCheckBox.setActionCommand(JaxoConstants.getModeAsString(5189));
        return gridCheckBoxPanel;
    }

    private JPanel getSnapOnOffPanel() {
        JPanel snapCheckBoxPanel = new JPanel();
        this.snapCheckBox.setSelected(false);
        snapCheckBoxPanel.add(this.snapCheckBox);
        this.snapCheckBox.addActionListener(this.thePanel);
        this.snapCheckBox.setActionCommand(JaxoConstants.getModeAsString(3161));
        return snapCheckBoxPanel;
    }

    private JPanel getGridTypePanel() {
        this.chooseGridType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (JaxoGridBar.this.chooseGridType.getSelectedItem().equals(JaxoLanguage.translate(JaxoGridBar.RECTANGULAR))) {
                    if (!JaxoGridBar.this.setting) {
                        JaxoGridBar.this.thePanel.actionPerformed(new ActionEvent(JaxoGridBar.this, 3165, JaxoConstants.getModeAsString(3165)));
                    }
                    if (JaxoGridBar.this.chooseGridStyle.getItemCount() == 4) {
                        JaxoGridBar.this.chooseGridStyle.removeItemAt(3);
                    }
                    JaxoGridBar.this.gridSize.setIntStepSize(1);
                } else {
                    if (!JaxoGridBar.this.setting) {
                        JaxoGridBar.this.thePanel.actionPerformed(new ActionEvent(JaxoGridBar.this, 3166, JaxoConstants.getModeAsString(3166)));
                    }
                    if (JaxoGridBar.this.chooseGridStyle.getItemCount() < 4) {
                        JaxoGridBar.this.chooseGridStyle.insertItemAt(JaxoLanguage.translate("Honeycomb"), 3);
                    }
                    JaxoGridBar.this.gridSize.setIntStepSize(2);
                }
            }
        });
        JPanel gridTypePanel = new JPanel();
        gridTypePanel.add(this.gridTypeLabel);
        gridTypePanel.add(this.chooseGridType);
        return gridTypePanel;
    }

    private static String[] getGridCombTypes() {
        String[] gridCombTypes = new String[]{JaxoLanguage.translate(RECTANGULAR), JaxoLanguage.translate("Hexagonal")};
        return gridCombTypes;
    }

    private static String[] getGridStyles() {
        String[] styles = new String[]{JaxoLanguage.translate("Dot"), JaxoLanguage.translate("Cross"), JaxoLanguage.translate("Line"), JaxoLanguage.translate("Honeycomb")};
        return styles;
    }

    private JPanel getGridStylePanel() {
        this.updateGridStyleWidth();
        String type = (String)this.chooseGridType.getSelectedItem();
        if (JaxoLanguage.translate(RECTANGULAR).equals(type)) {
            this.chooseGridStyle.removeItemAt(3);
        }
        this.chooseGridStyle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 || JaxoGridBar.this.setting) {
                    return;
                }
                int style = JaxoGridBar.getStyleFromIndex(JaxoGridBar.this.chooseGridStyle.getSelectedIndex());
                JaxoGridBar.this.thePanel.actionPerformed(new ActionEvent(JaxoGridBar.this, style, JaxoConstants.getModeAsString(style)));
            }
        });
        JPanel gridStylePanel = new JPanel();
        gridStylePanel.add(this.gridStyleLabel);
        gridStylePanel.add(this.chooseGridStyle);
        return gridStylePanel;
    }

    private JPanel getGridColorPanel() {
        JPanel gridColorPanel = new JPanel();
        this.colorChooser = new JaxoColorChooser(gridColorPanel);
        this.gridColorButton.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (JaxoGridBar.this.setting) {
                    return;
                }
                if (e.getPropertyName().equals("color")) {
                    JaxoGridBar.this.thePanel.distributePropertyChange("Jaxo.gridColor", e.getOldValue(), e.getNewValue());
                }
            }
        });
        this.gridColorButton.setChooser(this.colorChooser);
        this.gridColorButton.setChooserMode(2);
        gridColorPanel.add(this.gridColorLabel);
        gridColorPanel.add(this.gridColorButton);
        return gridColorPanel;
    }

    private JPanel getCanvasBackgroundPanel() {
        JPanel result = new JPanel();
        this.canvasBackgroundButton.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (JaxoGridBar.this.setting) {
                    return;
                }
                if (e.getPropertyName().equals("color")) {
                    JaxoGridBar.this.thePanel.distributePropertyChange("Jaxo.canvasBackground", e.getOldValue(), e.getNewValue());
                }
            }
        });
        this.canvasBackgroundButton.setChooser(this.colorChooser);
        this.canvasBackgroundButton.setChooserMode(2);
        result.add(this.canvasBackgroundLabel);
        result.add(this.canvasBackgroundButton);
        this.setCanvasBackground(JaxoColor.getColor(JaxoPrefs.getStringPref("prefCANVASBACKGROUND"), 2));
        return result;
    }

    private JPanel getGridSizePanel() {
        JPanel pgrid = new JPanel();
        pgrid.add(this.gridSizeLabel);
        this.gridSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (JaxoGridBar.this.setting) {
                    return;
                }
                JaxoGridBar.this.thePanel.distributePropertyChange("Jaxo.gridSize", 0, JaxoGridBar.this.gridSize.getIntValue());
            }
        });
        pgrid.add(this.chooseGridSize);
        return pgrid;
    }

    private static int getStyleFromIndex(int selectedIndex) {
        int mode = -1;
        switch (selectedIndex) {
            case 0: {
                mode = 3167;
                break;
            }
            case 1: {
                mode = 3168;
                break;
            }
            case 2: {
                mode = 3169;
                break;
            }
            case 3: {
                mode = 3170;
                break;
            }
        }
        return mode;
    }

    private void enableGridBar(boolean enable) {
        this.snapCheckBox.setEnabled(enable);
        this.chooseGridType.setEnabled(enable);
        this.gridTypeLabel.setEnabled(enable);
        this.chooseGridStyle.setEnabled(enable);
        this.gridStyleLabel.setEnabled(enable);
        this.gridColorButton.setEnabled(enable);
        this.gridColorLabel.setEnabled(enable);
        this.chooseGridSize.setEnabled(enable);
        this.gridSizeLabel.setEnabled(enable);
    }

    private void setGridOnOff(boolean onoff) {
        this.gridCheckBox.setSelected(onoff);
        this.enableGridBar(onoff);
    }

    private void setSnapOnOff(boolean onoff) {
        this.snapCheckBox.setSelected(onoff);
    }

    private void setCanvasBackground(Color value) {
        this.canvasBackgroundButton.setColor(value);
    }

    private void updateTabSettings(JaxoTab t) {
        this.updateGridSettings(t == null ? JaxoDefaultGrid.newDefaultGrid() : t.getGrid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGridSettings(JaxoPaintableGrid tabGrid) {
        this.setting = true;
        try {
            this.chooseGridType.setSelectedIndex(tabGrid.getGridType());
            this.chooseGridStyle.setSelectedIndex(tabGrid.getGridStyle());
            this.gridSize.setIntValue(tabGrid.getGridSize());
            this.gridColorButton.setColor(tabGrid.getGridColor());
            this.setGridOnOff(tabGrid.isPainted());
            this.setSnapOnOff(tabGrid.isSnapping());
        }
        finally {
            this.setting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateLanguage() {
        this.gridTypeLabel.setText(JaxoLanguage.label("JaxoGridBar.type"));
        this.gridSizeLabel.setText(JaxoLanguage.label("JaxoGridBar.size"));
        this.gridStyleLabel.setText(JaxoLanguage.label("JaxoGridBar.style"));
        this.gridColorLabel.setText(JaxoLanguage.label("JaxoGridBar.color"));
        this.canvasBackgroundLabel.setText(JaxoLanguage.label("JaxoGridBar.canvasBackground"));
        this.gridCheckBox.setText(JaxoLanguage.translate("JaxoGridBar.gridOn"));
        this.snapCheckBox.setText(JaxoLanguage.translate("JaxoGridBar.snapOn"));
        this.setting = true;
        try {
            int selectedStyle = this.chooseGridStyle.getSelectedIndex();
            int selectedType = this.chooseGridType.getSelectedIndex();
            this.chooseGridType.removeAllItems();
            String[] gridCombTypes = JaxoGridBar.getGridCombTypes();
            for (int i = 0; i < gridCombTypes.length; ++i) {
                this.chooseGridType.addItem(gridCombTypes[i]);
            }
            this.chooseGridType.setSelectedIndex(selectedType);
            this.chooseGridStyle.removeAllItems();
            String[] gridStyles = JaxoGridBar.getGridStyles();
            for (int i = 0; i < gridStyles.length; ++i) {
                this.chooseGridStyle.addItem(gridStyles[i]);
            }
            String type = (String)this.chooseGridType.getSelectedItem();
            if (JaxoLanguage.translate(RECTANGULAR).equals(type)) {
                this.chooseGridStyle.removeItemAt(3);
            }
            this.chooseGridStyle.setSelectedIndex(selectedStyle);
            this.updateGridStyleWidth();
        }
        finally {
            this.setting = false;
        }
    }

    private void updateGridStyleWidth() {
        int width = -1;
        int widestIndex = -1;
        String[] allGridStyles = JaxoGridBar.getGridStyles();
        for (int i = 0; i < allGridStyles.length; ++i) {
            this.chooseGridStyle.setPrototypeDisplayValue(allGridStyles[i]);
            int currentWidth = this.chooseGridStyle.getPreferredSize().width;
            if (currentWidth <= width) continue;
            width = currentWidth;
            widestIndex = i;
        }
        this.chooseGridStyle.setPrototypeDisplayValue(allGridStyles[widestIndex]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Jaxo.selectedTab")) {
            JaxoTab t;
            JaxoTab old = (JaxoTab)evt.getOldValue();
            if (old != null) {
                old.getGrid().removeChangeListener(this);
            }
            if ((t = (JaxoTab)evt.getNewValue()) != null) {
                t.getGrid().addChangeListener(this);
            }
            this.updateTabSettings(t);
        } else if (evt.getPropertyName().equals("Jaxo.gridOn")) {
            this.setGridOnOff((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("Jaxo.snap")) {
            this.setSnapOnOff((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("Jaxo.canvasBackground")) {
            this.setCanvasBackground((Color)evt.getNewValue());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateGridSettings((JaxoPaintableGrid)e.getSource());
    }

    static {
        ArrayList<Integer> tmp = new ArrayList<Integer>(8);
        tmp.add(6);
        tmp.add(8);
        tmp.add(10);
        tmp.add(12);
        tmp.add(14);
        tmp.add(18);
        tmp.add(24);
        tmp.add(36);
        GRID_SIZES = Collections.unmodifiableList(tmp);
    }
}

