/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import net.sf.jaxodraw.gui.panel.JaxoColorChooser;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.Location;

public class JaxoColorButton
extends JButton {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoColorButton.class);
    private static final Color VOID_COLOR = new Color(0, true);
    private static final long serialVersionUID = 7526471155622776147L;
    private Color color;
    private int chooserMode;
    private String chooserTitle;
    private JaxoColorChooser chooser;
    private boolean optional;

    public JaxoColorButton() {
        this(Color.black);
    }

    public JaxoColorButton(Color c) {
        if (c == null) {
            this.optional = true;
        }
        this.color = c;
        this.setVerticalTextPosition(0);
        this.setHorizontalTextPosition(0);
        this.updateIconText();
    }

    private void updateIconText() {
        this.setIcon(JaxoUtils.getChooserImageIcon(this.color == null ? VOID_COLOR : this.color));
        this.setText(this.color == null ? LANGUAGE.value("noColor") : " ");
    }

    public final boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean value) {
        this.optional = value;
    }

    public final Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        if (value == null ? this.color != null : !value.equals(this.color)) {
            Color old = this.color;
            this.color = value;
            this.updateIconText();
            this.repaint();
            this.firePropertyChange("color", old, this.color);
        }
    }

    public final int getChooserMode() {
        return this.chooserMode;
    }

    public void setChooserMode(int value) {
        this.chooserMode = value;
    }

    public final String getChooserTitle() {
        return this.chooserTitle;
    }

    public void setChooserTitle(String value) {
        this.chooserTitle = value;
    }

    public final JaxoColorChooser getChooser() {
        return this.chooser;
    }

    public void setChooser(JaxoColorChooser value) {
        this.chooser = value;
    }

    public void showChooser() {
        if (this.chooser != null) {
            this.chooser.setMode(this.chooserMode);
            this.chooser.setDialogTitle(this.chooserTitle);
            this.chooser.setColor(this.getColor());
            this.chooser.setOptional(this.optional);
            this.chooser.show(new Location.RelativeTo(this));
            this.setColor(this.chooser.getColor());
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        super.fireActionPerformed(e);
        this.showChooser();
    }
}

